/*
 * JBox2D - A Java Port of Erin Catto's Box2D
 * 
 * JBox2D homepage: http://jbox2d.sourceforge.net/ 
 * Box2D homepage: http://www.box2d.org
 * 
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any damages
 * arising from the use of this software.
 * 
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 * 
 * 1. The origin of this software must not be misrepresented; you must not
 * claim that you wrote the original software. If you use this software
 * in a product, an acknowledgment in the product documentation would be
 * appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 * misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 */

package org.jbox2d.collision;

//Updated to rev 56 of b2Shape.cpp/.h
// -> rev 97 of b2PolygonShape.cpp/.h

import java.util.ArrayList;
import java.util.List;

import org.jbox2d.common.*;

public class PolygonDef extends ShapeDef {

    public List<Vec2> vertices;

    public PolygonDef() {
        type = ShapeType.POLYGON_SHAPE;
        vertices = new ArrayList<Vec2>();
    }
    
    public void setAsBox(float hx, float hy) {
    	vertices.clear();
    	vertices.add(new Vec2(-hx, -hy));
    	vertices.add(new Vec2(hx, -hy));
    	vertices.add(new Vec2(hx, hy));
    	vertices.add(new Vec2(-hx, hy));
    }

    public void setAsBox(float hx, float hy, Vec2 center, float angle) {
    	setAsBox(hx, hy);
    	XForm xf = new XForm();
    	xf.position.set(center);
    	xf.R.set(angle);

    	for (int i = 0; i < vertices.size(); ++i) {
    		vertices.get(i).set(XForm.mul(xf, vertices.get(i)));
    	}
    }

    public int vertexCount() {
        return vertices.size();
    }
}