/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.PolygonDef;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.testbed.AbstractExample;
import org.jbox2d.testbed.TestbedMain;

public class VerticalStack
extends AbstractExample {
    private boolean firstTime = true;

    public VerticalStack(TestbedMain parent) {
        super(parent);
    }

    public String getName() {
        return "Vertical Stack";
    }

    public void create() {
        if (this.firstTime) {
            this.setCamera(0.0f, 10.0f, 10.0f);
            this.firstTime = false;
        }
        PolygonDef sd = new PolygonDef();
        sd.setAsBox(50.0f, 10.0f, new Vec2(0.0f, -10.0f), 0.0f);
        BodyDef bd = new BodyDef();
        bd.position.set(0.0f, 0.0f);
        Body ground = this.m_world.createStaticBody(bd);
        ground.createShape(sd);
        sd.setAsBox(0.1f, 10.0f, new Vec2(20.0f, 10.0f), 0.0f);
        ground.createShape(sd);
        float[] xs = new float[]{0.0f, -10.0f, -5.0f, 5.0f, 10.0f};
        int j = 0;
        while (j < xs.length) {
            PolygonDef sd2 = new PolygonDef();
            sd2.setAsBox(0.5f, 0.5f);
            sd2.density = 1.0f;
            sd2.friction = 0.3f;
            int i = 0;
            while (i < 12) {
                BodyDef bd2 = new BodyDef();
                bd2.isBullet = true;
                bd2.allowSleep = true;
                bd2.position.set(xs[j] + this.parent.random(-0.05f, 0.05f), 0.752f + 1.54f * (float)i);
                Body body = this.m_world.createDynamicBody(bd2);
                body.createShape(sd2);
                body.setMassFromShapes();
                ++i;
            }
            ++j;
        }
    }

    public String getExampleInstructions() {
        return "Press , to shoot sideways bullet\n";
    }

    public void postStep() {
        if (this.newKeyDown[44]) {
            this.launchBomb(new Vec2(-40.0f, this.parent.random(1.0f, 10.0f)), new Vec2(200.0f, this.parent.random(-5.0f, 5.0f)));
        }
    }
}

