/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.CircleDef;
import org.jbox2d.collision.PolygonDef;
import org.jbox2d.collision.ShapeDef;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.testbed.AbstractExample;
import org.jbox2d.testbed.TestbedMain;

public class VaryingRestitution
extends AbstractExample {
    public VaryingRestitution(TestbedMain _parent) {
        super(_parent);
    }

    public void create() {
        ShapeDef sd = new PolygonDef();
        sd.setAsBox(50.0f, 10.0f);
        BodyDef bd = new BodyDef();
        bd.position = new Vec2(0.0f, -10.0f);
        this.m_world.createStaticBody(bd).createShape(sd);
        sd = new CircleDef();
        ((CircleDef)sd).radius = 0.6f;
        ((CircleDef)sd).density = 5.0f;
        bd = new BodyDef();
        float[] restitution = new float[]{0.0f, 0.1f, 0.3f, 0.5f, 0.75f, 0.9f, 1.0f};
        int i = 0;
        while (i < restitution.length) {
            ((CircleDef)sd).restitution = restitution[i];
            bd.position = new Vec2(-10.0f + 3.0f * (float)i, 10.0f);
            Body myBody = this.m_world.createDynamicBody(bd);
            myBody.createShape(sd);
            myBody.setMassFromShapes();
            ++i;
        }
    }

    public String getName() {
        return "Varying Restitution";
    }
}

