/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.PolygonDef;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.testbed.AbstractExample;
import org.jbox2d.testbed.TestbedMain;
import processing.core.PImage;

public class SpriteBinding
extends AbstractExample {
    public Vec2[] localCoords;
    public Vec2[] texCoords;
    public PImage myImage;
    public Body body;

    public SpriteBinding(TestbedMain _parent) {
        super(_parent);
    }

    public String getName() {
        return "Sprite Binding";
    }

    public void create() {
        int numBoxes = 15;
        int numRows = 6;
        Body[] boxes = new Body[numRows * numBoxes];
        PolygonDef groundBoxDef = new PolygonDef();
        groundBoxDef.setAsBox(50.0f, 10.0f);
        groundBoxDef.density = 0.0f;
        BodyDef groundBodyDef = new BodyDef();
        groundBodyDef.position.set(0.0f, -10.0f);
        this.m_world.createStaticBody(groundBodyDef).createShape(groundBoxDef);
        PolygonDef boxDef = new PolygonDef();
        boxDef.setAsBox(1.0f, 1.0f);
        boxDef.density = 1.0f;
        boxDef.friction = 0.3f;
        boxDef.restitution = 0.3f;
        int i = 0;
        while (i < numBoxes) {
            int j = 0;
            while (j < numRows) {
                BodyDef bodyDef = new BodyDef();
                bodyDef.position.set((float)(-numBoxes) - 3.0f + (float)i * 2.5f, 4.0f + (float)j * 5.0f);
                boxes[i + numBoxes * j] = this.m_world.createDynamicBody(bodyDef);
                boxes[i + numBoxes * j].createShape(boxDef);
                boxes[i + numBoxes * j].setMassFromShapes();
                boxes[i + numBoxes * j].setAngularVelocity(this.parent.random(-0.5f, 0.5f));
                ++j;
            }
            ++i;
        }
        this.myImage = this.parent.loadImage("noise.png");
        Vec2 localOffset = new Vec2(0.0f, 0.0f);
        float scale = 1.9f / (float)this.myImage.width;
        float rot = 0.0f;
        i = 0;
        while (i < boxes.length) {
            this.bindImage(this.myImage, localOffset, rot, scale, boxes[i]);
            ++i;
        }
    }
}

