/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.PolygonDef;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.testbed.AbstractExample;
import org.jbox2d.testbed.TestbedMain;

public class Overhang
extends AbstractExample {
    public Overhang(TestbedMain p) {
        super(p);
    }

    public String getName() {
        return "Overhang";
    }

    public void create() {
        PolygonDef sd = new PolygonDef();
        sd.setAsBox(50.0f, 10.0f);
        BodyDef bd = new BodyDef();
        bd.position = new Vec2(0.0f, -10.0f);
        this.m_world.createStaticBody(bd).createShape(sd);
        sd = new PolygonDef();
        float w = 4.0f;
        float h = 0.25f;
        sd.setAsBox(w, h);
        sd.density = 1.0f;
        sd.friction = 0.3f;
        sd.restitution = 0.0f;
        BodyDef bd2 = new BodyDef();
        int numSlats = 8;
        float lastCMX = 0.0f;
        float eps = 0.14f;
        int i = 0;
        while (i < numSlats) {
            float newX = lastCMX + w - eps;
            lastCMX = ((float)i * lastCMX + newX) / (float)(i + 1);
            bd2.position = new Vec2(newX, 0.25f + 2.0f * h * (float)(numSlats - i - 1));
            Body myBody = this.m_world.createDynamicBody(bd2);
            myBody.createShape(sd);
            myBody.setMassFromShapes();
            ++i;
        }
    }
}

