/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.AABB;
import org.jbox2d.collision.CircleDef;
import org.jbox2d.collision.PolygonDef;
import org.jbox2d.collision.ShapeDef;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.World;
import org.jbox2d.testbed.AbstractExample;
import org.jbox2d.testbed.TestbedMain;

public class CompoundShapes
extends AbstractExample {
    private boolean firstTime = true;
    private final int stackHeight = 100;

    public CompoundShapes(TestbedMain _parent) {
        super(_parent);
    }

    public void createWorld() {
        this.m_worldAABB = new AABB();
        this.m_worldAABB.lowerBound = new Vec2(-200.0f, -100.0f);
        this.m_worldAABB.upperBound = new Vec2(200.0f, 500.0f);
        Vec2 gravity = new Vec2(0.0f, -10.0f);
        boolean doSleep = true;
        this.m_world = new World(this.m_worldAABB, gravity, doSleep);
    }

    public void create() {
        Body body;
        BodyDef bd;
        float x;
        if (this.firstTime) {
            this.setCamera(0.0f, 10.0f, 15.0f);
            this.firstTime = false;
        }
        BodyDef bd2 = new BodyDef();
        bd2.position.set(0.0f, -10.0f);
        Body body2 = this.m_world.createStaticBody(bd2);
        PolygonDef sd = new PolygonDef();
        sd.setAsBox(50.0f, 10.0f);
        body2.createShape(sd);
        ShapeDef sd1 = new CircleDef();
        ((CircleDef)sd1).radius = 0.5f;
        ((CircleDef)sd1).localPosition.set(-0.5f, 0.5f);
        ((CircleDef)sd1).density = 2.0f;
        ShapeDef sd2 = new CircleDef();
        ((CircleDef)sd2).radius = 0.5f;
        ((CircleDef)sd2).localPosition.set(0.5f, 0.5f);
        ((CircleDef)sd2).density = 0.0f;
        int i = 0;
        while (i < 100) {
            x = this.parent.random(-0.1f, 0.1f);
            bd = new BodyDef();
            bd.position.set(x + 5.0f, 1.05f + 2.5f * (float)i);
            bd.angle = this.parent.random(-3.1415f, 3.1415f);
            body = this.m_world.createDynamicBody(bd);
            body.createShape(sd1);
            body.createShape(sd2);
            body.setMassFromShapes();
            ++i;
        }
        sd1 = new PolygonDef();
        ((PolygonDef)sd1).setAsBox(0.25f, 0.5f);
        ((PolygonDef)sd1).density = 2.0f;
        sd2 = new PolygonDef();
        ((PolygonDef)sd2).setAsBox(0.25f, 0.5f, new Vec2(0.0f, -0.5f), 1.57075f);
        ((PolygonDef)sd2).density = 2.0f;
        i = 0;
        while (i < 100) {
            x = this.parent.random(-0.1f, 0.1f);
            bd = new BodyDef();
            bd.position.set(x - 5.0f, 1.05f + 2.5f * (float)i);
            bd.angle = this.parent.random(-3.1415f, 3.1415f);
            body = this.m_world.createDynamicBody(bd);
            body.createShape(sd1);
            body.createShape(sd2);
            body.setMassFromShapes();
            ++i;
        }
        XForm xf1 = new XForm();
        xf1.R.set(1.1070646f);
        xf1.position = Mat22.mul(xf1.R, new Vec2(1.0f, 0.0f));
        PolygonDef sd12 = new PolygonDef();
        sd12.vertices.add(XForm.mul(xf1, new Vec2(-1.0f, 0.0f)));
        sd12.vertices.add(XForm.mul(xf1, new Vec2(1.0f, 0.0f)));
        sd12.vertices.add(XForm.mul(xf1, new Vec2(0.0f, 0.5f)));
        sd12.density = 2.0f;
        XForm xf2 = new XForm();
        xf2.R.set(-1.1070646f);
        xf2.position = Mat22.mul(xf2.R, new Vec2(-1.0f, 0.0f));
        PolygonDef sd22 = new PolygonDef();
        sd22.vertices.add(XForm.mul(xf2, new Vec2(-1.0f, 0.0f)));
        sd22.vertices.add(XForm.mul(xf2, new Vec2(1.0f, 0.0f)));
        sd22.vertices.add(XForm.mul(xf2, new Vec2(0.0f, 0.5f)));
        sd22.density = 2.0f;
        int i2 = 0;
        while (i2 < 100) {
            float x2 = this.parent.random(-0.1f, 0.1f);
            BodyDef bd3 = new BodyDef();
            bd3.position.set(x2, 2.05f + 2.5f * (float)i2);
            bd3.angle = 0.0f;
            Body body3 = this.m_world.createDynamicBody(bd3);
            body3.createShape(sd12);
            body3.createShape(sd22);
            body3.setMassFromShapes();
            ++i2;
        }
        PolygonDef sd_bottom = new PolygonDef();
        sd_bottom.setAsBox(1.5f, 0.15f);
        sd_bottom.density = 4.0f;
        PolygonDef sd_left = new PolygonDef();
        sd_left.setAsBox(0.15f, 2.7f, new Vec2(-1.45f, 2.35f), 0.2f);
        sd_left.density = 4.0f;
        PolygonDef sd_right = new PolygonDef();
        sd_right.setAsBox(0.15f, 2.7f, new Vec2(1.45f, 2.35f), -0.2f);
        sd_right.density = 4.0f;
        BodyDef bd4 = new BodyDef();
        bd4.position.set(0.0f, 2.0f);
        Body body4 = this.m_world.createDynamicBody(bd4);
        body4.createShape(sd_bottom);
        body4.createShape(sd_left);
        body4.createShape(sd_right);
        body4.setMassFromShapes();
    }

    public String getName() {
        return "Compound Shapes";
    }
}

