/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.CircleDef;
import org.jbox2d.collision.PolygonDef;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.testbed.AbstractExample;
import org.jbox2d.testbed.TestbedMain;

public class Circles
extends AbstractExample {
    private boolean firstTime = true;

    public Circles(TestbedMain parent) {
        super(parent);
    }

    public void create() {
        if (this.firstTime) {
            this.setCamera(0.0f, 20.0f, 5.0f);
            this.firstTime = false;
        }
        Body ground = this.m_world.getGroundBody();
        Body leftWall = null;
        Body rightWall = null;
        PolygonDef sd = new PolygonDef();
        sd.setAsBox(50.0f, 10.0f);
        sd.friction = 1.0f;
        BodyDef bd = new BodyDef();
        bd.position = new Vec2(0.0f, -10.0f);
        this.m_world.createStaticBody(bd).createShape(sd);
        sd.setAsBox(3.0f, 50.0f);
        bd = new BodyDef();
        bd.position = new Vec2(53.0f, 25.0f);
        rightWall = this.m_world.createStaticBody(bd);
        rightWall.createShape(sd);
        bd.position = new Vec2(-53.0f, 25.0f);
        leftWall = this.m_world.createStaticBody(bd);
        leftWall.createShape(sd);
        bd = new BodyDef();
        sd.setAsBox(20.0f, 3.0f);
        bd.angle = -0.7853982f;
        bd.position = new Vec2(-40.0f, 0.0f);
        Body myBod = this.m_world.createStaticBody(bd);
        myBod.createShape(sd);
        bd.angle = 0.7853982f;
        bd.position = new Vec2(40.0f, 0.0f);
        myBod = this.m_world.createStaticBody(bd);
        myBod.createShape(sd);
        CircleDef cd = new CircleDef();
        bd = new BodyDef();
        int numPieces = 5;
        float radius = 6.0f;
        bd.position = new Vec2(0.0f, 10.0f);
        Body body = this.m_world.createDynamicBody(bd);
        int i = 0;
        while (i < numPieces) {
            cd = new CircleDef();
            cd.radius = 1.2f;
            cd.density = 25.0f;
            cd.friction = 0.1f;
            cd.restitution = 0.9f;
            float xPos = radius * (float)Math.cos(Math.PI * 2 * (double)((float)i / (float)numPieces));
            float yPos = radius * (float)Math.sin(Math.PI * 2 * (double)((float)i / (float)numPieces));
            cd.localPosition = new Vec2(xPos, yPos);
            body.createShape(cd);
            ++i;
        }
        body.setMassFromShapes();
        RevoluteJointDef rjd = new RevoluteJointDef();
        rjd.initialize(body, ground, body.getPosition());
        rjd.motorSpeed = (float)Math.PI;
        rjd.maxMotorTorque = 1000000.0f;
        rjd.enableMotor = true;
        this.m_world.createJoint(rjd);
        int loadSize = 45;
        int j = 0;
        while (j < 10) {
            int i2 = 0;
            while (i2 < loadSize) {
                CircleDef circ = new CircleDef();
                BodyDef bod = new BodyDef();
                circ.radius = 1.0f + (i2 % 2 == 0 ? 1.0f : -1.0f) * 0.5f * ((float)i2 / (float)loadSize);
                circ.density = 5.0f;
                circ.friction = 0.1f;
                circ.restitution = 0.5f;
                float xPos = -45.0f + (float)(2 * i2);
                float yPos = 50.0f + (float)j;
                bod.position = new Vec2(xPos, yPos);
                Body myBody = this.m_world.createDynamicBody(bod);
                myBody.createShape(circ);
                myBody.setMassFromShapes();
                ++i2;
            }
            ++j;
        }
    }

    public String getName() {
        return "Circle Stress Test";
    }
}

