/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.PolygonDef;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.testbed.AbstractExample;
import org.jbox2d.testbed.TestbedMain;

public class Chain
extends AbstractExample {
    private boolean firstTime = true;

    public Chain(TestbedMain _parent) {
        super(_parent);
    }

    public void create() {
        if (this.firstTime) {
            this.setCamera(0.0f, 10.0f, 10.0f);
            this.firstTime = false;
        }
        Body ground = null;
        BodyDef bd = new BodyDef();
        bd.position.set(0.0f, -10.0f);
        ground = this.m_world.createStaticBody(bd);
        PolygonDef sd = new PolygonDef();
        sd.setAsBox(50.0f, 10.0f);
        ground.createShape(sd);
        PolygonDef sd2 = new PolygonDef();
        sd2.setAsBox(0.6f, 0.125f);
        sd2.density = 20.0f;
        sd2.friction = 0.2f;
        RevoluteJointDef jd = new RevoluteJointDef();
        jd.collideConnected = false;
        float y = 25.0f;
        Body prevBody = ground;
        int i = 0;
        while (i < 30) {
            BodyDef bd2 = new BodyDef();
            bd2.position.set(0.5f + (float)i, y);
            Body body = this.m_world.createDynamicBody(bd2);
            body.createShape(sd2);
            body.setMassFromShapes();
            Vec2 anchor = new Vec2(i, y);
            jd.initialize(prevBody, body, anchor);
            this.m_world.createJoint(jd);
            prevBody = body;
            ++i;
        }
    }

    public String getName() {
        return "Chain Test";
    }
}

