/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed;

import java.lang.reflect.Field;
import java.util.ArrayList;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.Vec2;
import org.jbox2d.testbed.AbstractExample;
import org.jbox2d.testbed.ProcessingDebugDraw;
import org.jbox2d.testbed.TestSettings;
import org.jbox2d.testbed.TestbedMain;
import processing.core.PApplet;

public class TestbedOptions {
    public static float checkboxSize = 15.0f;
    public static float padding = 5.0f;
    public static float sliderWidth = 200.0f;
    public float borderWidth = 50.0f;
    public TestbedMain p;
    public ArrayList<Checkbox> checkBoxes;
    public ArrayList<SliderInt> sliderInts;
    public String titleString = "*** TESTBED OPTIONS - press 'o' to return to test ***";
    public TestSettings settings;

    public TestbedOptions(TestbedMain _p) {
        this.p = _p;
        this.checkBoxes = new ArrayList();
        this.sliderInts = new ArrayList();
    }

    public void initialize(AbstractExample test) {
        this.settings = test.settings;
        this.checkBoxes.clear();
        this.sliderInts.clear();
        try {
            Class<?> myClass = this.settings.getClass();
            Field[] fields = myClass.getFields();
            Vec2 pos = new Vec2(this.borderWidth + padding, this.borderWidth + 2.0f * padding + 2.0f * checkboxSize);
            int i = 0;
            while (i < fields.length) {
                int initialV;
                String fieldName;
                if (fields[i].getType().getCanonicalName().equals("boolean")) {
                    fieldName = fields[i].getName();
                    initialV = fields[i].getBoolean(this.settings);
                    Checkbox myCheck = new Checkbox(pos, fieldName, initialV != 0, fields[i]);
                    this.checkBoxes.add(myCheck);
                    pos.y += checkboxSize + padding;
                    if (pos.y + checkboxSize + padding > (float)this.p.height - this.borderWidth) {
                        pos.y = this.borderWidth + 2.0f * padding + 2.0f * checkboxSize;
                        pos.x += ((float)this.p.width - 2.0f * this.borderWidth) * 0.5f;
                    }
                } else if (fields[i].getType().getCanonicalName().equals("int")) {
                    fieldName = fields[i].getName();
                    initialV = fields[i].getInt(this.settings);
                    int maxIntValue = 100;
                    if (fieldName.equals("hz")) {
                        maxIntValue = 200;
                    }
                    SliderInt mySlider = new SliderInt(pos, sliderWidth, fieldName, initialV, 1, maxIntValue, fields[i]);
                    this.sliderInts.add(mySlider);
                    pos.y += 2.0f * (checkboxSize + padding);
                    if (pos.y + checkboxSize + padding > (float)this.p.height - this.borderWidth) {
                        pos.y = this.borderWidth + 2.0f * padding + 2.0f * checkboxSize;
                        pos.x += ((float)this.p.width - 2.0f * this.borderWidth) * 0.5f;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleOptions() {
        this.p.fill(20.0f, 20.0f, 110.0f, 255.0f);
        this.p.stroke(255);
        this.p.rect(this.borderWidth, this.borderWidth, (float)this.p.width - 2.0f * this.borderWidth, (float)this.p.height - 2.0f * this.borderWidth);
        ProcessingDebugDraw g = (ProcessingDebugDraw)this.p.currentTest.m_debugDraw;
        g.drawString(this.borderWidth + padding, this.borderWidth + padding + (float)AbstractExample.textLineHeight, this.titleString, new Color3f(255.0f, 255.0f, 255.0f));
        int i = 0;
        while (i < this.checkBoxes.size()) {
            this.checkBoxes.get(i).process();
            this.checkBoxes.get(i).draw();
            ++i;
        }
        i = 0;
        while (i < this.sliderInts.size()) {
            this.sliderInts.get(i).process();
            this.sliderInts.get(i).draw();
            ++i;
        }
    }

    class Checkbox {
        public String label;
        public boolean value;
        public Vec2 position;
        public Field attachedValue;

        public Checkbox(Vec2 _position, String _label, boolean initialValue, Field _attached) {
            this.position = _position.clone();
            this.label = _label;
            this.value = initialValue;
            this.attachedValue = _attached;
        }

        public void process() {
            if (TestbedOptions.this.p.mousePressed && !TestbedOptions.this.p.pmousePressed && this.isMouseOver()) {
                try {
                    this.value = !this.value;
                    this.attachedValue.setBoolean(TestbedOptions.this.p.currentTest.settings, this.value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private boolean isMouseOver() {
            return (float)TestbedOptions.this.p.mouseX > this.position.x && (float)TestbedOptions.this.p.mouseX < this.position.x + checkboxSize && (float)TestbedOptions.this.p.mouseY > this.position.y && (float)TestbedOptions.this.p.mouseY < this.position.y + checkboxSize;
        }

        public void draw() {
            if (this.isMouseOver()) {
                TestbedOptions.this.p.fill(155.0f, 155.0f, 155.0f, 200.0f);
            } else {
                TestbedOptions.this.p.fill(100.0f, 100.0f, 100.0f, 200.0f);
            }
            TestbedOptions.this.p.stroke(0);
            TestbedOptions.this.p.rect(this.position.x, this.position.y, checkboxSize, checkboxSize);
            if (this.value) {
                TestbedOptions.this.p.fill(0.0f, 0.0f, 0.0f);
                TestbedOptions.this.p.noStroke();
                TestbedOptions.this.p.ellipse(this.position.x + checkboxSize * 0.5f, this.position.y + checkboxSize * 0.5f, checkboxSize * 0.7f, checkboxSize * 0.7f);
            }
            ProcessingDebugDraw g = (ProcessingDebugDraw)TestbedOptions.this.p.currentTest.m_debugDraw;
            int lineHeight = AbstractExample.textLineHeight;
            g.drawString((int)(this.position.x + checkboxSize + padding * 2.0f), (int)(this.position.y + 0.5f * (checkboxSize + (float)lineHeight)), this.label, new Color3f(255.0f, 255.0f, 255.0f));
        }
    }

    class SliderInt {
        public String label;
        public int value;
        public int minValue;
        public int maxValue;
        public float width;
        public Vec2 position;
        public Field attachedValue;

        public SliderInt(Vec2 _position, float _width, String _label, int initialValue, int _minValue, int _maxValue, Field _attached) {
            this.position = _position.clone();
            this.label = _label;
            this.value = initialValue;
            this.minValue = _minValue;
            this.maxValue = _maxValue;
            this.attachedValue = _attached;
            this.width = _width;
        }

        public void process() {
            if (TestbedOptions.this.p.mousePressed && this.isMouseOver()) {
                try {
                    this.value = PApplet.floor((float)PApplet.map((float)TestbedOptions.this.p.mouseX, (float)this.position.x, (float)(this.position.x + this.width), (float)this.minValue, (float)this.maxValue));
                    this.attachedValue.setInt(TestbedOptions.this.p.currentTest.settings, this.value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private boolean isMouseOver() {
            return (float)TestbedOptions.this.p.mouseX > this.position.x && (float)TestbedOptions.this.p.mouseX < this.position.x + this.width && (float)TestbedOptions.this.p.mouseY > this.position.y && (float)TestbedOptions.this.p.mouseY < this.position.y + checkboxSize;
        }

        public void draw() {
            if (this.isMouseOver()) {
                TestbedOptions.this.p.fill(125.0f, 125.0f, 125.0f, 220.0f);
            } else {
                TestbedOptions.this.p.fill(100.0f, 100.0f, 100.0f, 200.0f);
            }
            TestbedOptions.this.p.stroke(0);
            TestbedOptions.this.p.rect(this.position.x, this.position.y, this.width, checkboxSize);
            TestbedOptions.this.p.ellipse(PApplet.map((float)this.value, (float)this.minValue, (float)this.maxValue, (float)this.position.x, (float)(this.position.x + this.width)), this.position.y + checkboxSize * 0.5f, 0.7f * checkboxSize, 0.7f * checkboxSize);
            ProcessingDebugDraw g = (ProcessingDebugDraw)TestbedOptions.this.p.currentTest.m_debugDraw;
            int lineHeight = AbstractExample.textLineHeight;
            g.drawString(this.position.x + padding, this.position.y + (checkboxSize + (float)lineHeight), String.valueOf(this.label) + ": " + this.value, new Color3f(255.0f, 255.0f, 255.0f));
        }
    }
}

