/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed;

import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.DebugDraw;
import org.jbox2d.testbed.AbstractExample;
import org.jbox2d.testbed.ProcessingDebugDraw;
import org.jbox2d.testbed.TestSettings;
import org.jbox2d.testbed.TestbedOptions;
import org.jbox2d.testbed.tests.BipedTest;
import org.jbox2d.testbed.tests.Bridge;
import org.jbox2d.testbed.tests.CCDTest;
import org.jbox2d.testbed.tests.Chain;
import org.jbox2d.testbed.tests.Circles;
import org.jbox2d.testbed.tests.CompoundShapes;
import org.jbox2d.testbed.tests.DistanceTest;
import org.jbox2d.testbed.tests.Domino;
import org.jbox2d.testbed.tests.DominoTower;
import org.jbox2d.testbed.tests.Gears;
import org.jbox2d.testbed.tests.MotorsAndLimits;
import org.jbox2d.testbed.tests.Overhang;
import org.jbox2d.testbed.tests.Pulleys;
import org.jbox2d.testbed.tests.Pyramid;
import org.jbox2d.testbed.tests.ShapeDrawing;
import org.jbox2d.testbed.tests.SpriteBinding;
import org.jbox2d.testbed.tests.VaryingFriction;
import org.jbox2d.testbed.tests.VaryingRestitution;
import org.jbox2d.testbed.tests.VerticalStack;
import processing.core.PApplet;

public class TestbedMain
extends PApplet {
    private static final long serialVersionUID = 1712524774634907635L;
    protected ArrayList<AbstractExample> tests = new ArrayList(0);
    protected AbstractExample currentTest = null;
    protected int currentTestIndex = 0;
    protected boolean handleOptions = false;
    public boolean shiftKey = false;
    boolean pmousePressed = false;
    public TestbedOptions options;
    static final float targetFPS = 60.0f;
    final int fpsAverageCount = 100;
    long[] nanos;
    long nanoStart;
    long frameCount = 0L;
    public DebugDraw g;

    public void setup() {
        this.size(640, 480, "processing.core.PGraphics3D");
        this.frameRate(60.0f);
        this.g = new ProcessingDebugDraw(this);
        int i = 0;
        while (i < 100) {
            this.requestFocus();
            ++i;
        }
        this.registerExample(new BipedTest(this));
        this.registerExample(new SpriteBinding(this));
        this.registerExample(new Pulleys(this));
        this.registerExample(new Overhang(this));
        this.registerExample(new VaryingRestitution(this));
        this.registerExample(new VaryingFriction(this));
        this.registerExample(new MotorsAndLimits(this));
        this.registerExample(new VerticalStack(this));
        this.registerExample(new Domino(this));
        this.registerExample(new CompoundShapes(this));
        this.registerExample(new Chain(this));
        this.registerExample(new Bridge(this));
        this.registerExample(new Gears(this));
        this.registerExample(new ShapeDrawing(this));
        this.registerExample(new Pyramid(this));
        this.registerExample(new DominoTower(this));
        this.registerExample(new Circles(this));
        this.registerExample(new CCDTest(this));
        this.registerExample(new DistanceTest(this));
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                if (TestbedMain.this.currentTest != null) {
                    ProcessingDebugDraw d = (ProcessingDebugDraw)TestbedMain.this.currentTest.m_debugDraw;
                    int notches = e.getWheelRotation();
                    Vec2 oldCenter = d.screenToWorld((float)TestbedMain.this.width / 2.0f, (float)TestbedMain.this.height / 2.0f);
                    if (notches < 0) {
                        d.scaleFactor = TestbedMain.min((float)300.0f, (float)(d.scaleFactor * 1.05f));
                    } else if (notches > 0) {
                        d.scaleFactor = TestbedMain.max((float)0.02f, (float)(d.scaleFactor / 1.05f));
                    }
                    Vec2 newCenter = d.screenToWorld((float)TestbedMain.this.width / 2.0f, (float)TestbedMain.this.height / 2.0f);
                    d.transX -= (oldCenter.x - newCenter.x) * d.scaleFactor;
                    d.transY -= (oldCenter.y - newCenter.y) * d.scaleFactor;
                    TestbedMain.this.currentTest.cachedCamScale = d.scaleFactor;
                }
            }
        });
        this.nanos = new long[100];
        long nanosPerFrameGuess = 16666666L;
        this.nanos[99] = System.nanoTime();
        int i2 = 98;
        while (i2 >= 0) {
            this.nanos[i2] = this.nanos[i2 + 1] - nanosPerFrameGuess;
            --i2;
        }
        this.nanoStart = System.nanoTime();
        this.options = new TestbedOptions(this);
    }

    public void draw() {
        if (this.handleOptions) {
            this.options.handleOptions();
        } else {
            this.background(0);
            Vec2.creationCount = 0;
            if (this.currentTest == null) {
                this.currentTestIndex = 0;
                this.currentTest = this.tests.get(this.currentTestIndex);
                this.nanoStart = System.nanoTime();
                this.frameCount = 0L;
            }
            if (this.currentTest.needsReset) {
                TestSettings s = this.currentTest.settings;
                this.currentTest.initialize();
                if (s != null) {
                    this.currentTest.settings = s;
                }
                this.nanoStart = System.nanoTime();
                this.frameCount = 0L;
            }
            this.currentTest.m_textLine = AbstractExample.textLineHeight;
            this.g.drawString(5.0f, this.currentTest.m_textLine, this.currentTest.getName(), AbstractExample.white);
            this.currentTest.m_textLine += 2 * AbstractExample.textLineHeight;
            this.currentTest.step();
            this.handleCanvasDrag();
            if (this.currentTest.settings.drawStats) {
                this.g.drawString(5.0f, this.currentTest.m_textLine, "Vec2 creations/frame: " + Vec2.creationCount, AbstractExample.white);
                this.currentTest.m_textLine += AbstractExample.textLineHeight;
            }
            int i = 0;
            while (i < 99) {
                this.nanos[i] = this.nanos[i + 1];
                ++i;
            }
            this.nanos[99] = System.nanoTime();
            float averagedFPS = (float)(9.9E10 / (double)(this.nanos[99] - this.nanos[0]));
            ++this.frameCount;
            float totalFPS = (float)((double)(this.frameCount * 1000000000L) / (1.0 * (double)(System.nanoTime() - this.nanoStart)));
            if (this.currentTest.settings.drawStats) {
                this.g.drawString(5.0f, this.currentTest.m_textLine, "Average FPS (100 frames): " + averagedFPS, AbstractExample.white);
                this.currentTest.m_textLine += AbstractExample.textLineHeight;
                this.g.drawString(5.0f, this.currentTest.m_textLine, "Average FPS (entire test): " + totalFPS, AbstractExample.white);
                this.currentTest.m_textLine += AbstractExample.textLineHeight;
            }
        }
        this.pmousePressed = this.mousePressed;
    }

    public void handleCanvasDrag() {
        ProcessingDebugDraw d = (ProcessingDebugDraw)this.currentTest.m_debugDraw;
        if (this.mouseButton == 39 && this.mousePressed) {
            d.transX += (float)(this.mouseX - this.pmouseX);
            d.transY -= (float)(this.mouseY - this.pmouseY);
            Vec2 v = d.screenToWorld((float)this.width * 0.5f, (float)this.height * 0.5f);
            this.currentTest.cachedCamX = v.x;
            this.currentTest.cachedCamY = v.y;
        }
    }

    public void mousePressed() {
        if (this.currentTest == null || this.handleOptions) {
            return;
        }
        this.currentTest.mouseDown(new Vec2(this.mouseX, this.mouseY));
    }

    public void mouseReleased() {
        if (this.currentTest == null || this.handleOptions) {
            return;
        }
        this.currentTest.mouseUp();
    }

    public void mouseMoved() {
        if (this.currentTest == null || this.handleOptions) {
            return;
        }
        this.currentTest.mouseMove(new Vec2(this.mouseX, this.mouseY));
    }

    public void mouseDragged() {
        this.mouseMoved();
    }

    public void keyPressed() {
        if (this.key == 'o') {
            boolean bl = this.handleOptions = !this.handleOptions;
            if (this.handleOptions) {
                this.options.initialize(this.currentTest);
            }
        }
        if (this.keyCode == 16) {
            this.shiftKey = true;
        }
        if (this.handleOptions) {
            return;
        }
        if (this.keyCode == 39) {
            ++this.currentTestIndex;
            if (this.currentTestIndex >= this.tests.size()) {
                this.currentTestIndex = 0;
            }
            this.currentTest = this.tests.get(this.currentTestIndex);
            this.currentTest.needsReset = true;
            return;
        }
        if (this.keyCode == 37) {
            --this.currentTestIndex;
            if (this.currentTestIndex < 0) {
                this.currentTestIndex = this.tests.size() - 1;
            }
            this.currentTest = this.tests.get(this.currentTestIndex);
            this.currentTest.needsReset = true;
            return;
        }
        if (this.currentTest == null) {
            return;
        }
        if (this.key == 'r') {
            this.currentTest.needsReset = true;
        }
        if (this.key == ' ') {
            this.currentTest.launchBomb();
        }
        if (this.key == 'p') {
            boolean bl = this.currentTest.settings.pause = !this.currentTest.settings.pause;
        }
        if (this.key == '+' && this.currentTest.settings.pause) {
            this.currentTest.settings.singleStep = true;
        }
        if (this.key == 's') {
            boolean bl = this.currentTest.settings.drawStats = !this.currentTest.settings.drawStats;
        }
        if (this.key == 'c') {
            boolean bl = this.currentTest.settings.drawContactPoints = !this.currentTest.settings.drawContactPoints;
        }
        if (this.key == 'b') {
            this.currentTest.settings.drawAABBs = !this.currentTest.settings.drawAABBs;
        }
        this.currentTest.keyPressed(this.key);
    }

    public void keyReleased() {
        if (this.keyCode == 16) {
            this.shiftKey = false;
        }
        if (this.currentTest == null) {
            return;
        }
        this.currentTest.keyReleased(this.key);
    }

    public void registerExample(AbstractExample test) {
        this.tests.add(test);
    }

    public static void main(String[] args) {
        PApplet.main((String[])new String[]{"org.jbox2d.testbed.TestbedMain"});
    }
}

