/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed;

import org.jbox2d.common.Color3f;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;
import org.jbox2d.dynamics.DebugDraw;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics3D;
import processing.core.PImage;

public class ProcessingDebugDraw
extends DebugDraw {
    public static ProcessingDebugDraw screen;
    private boolean firstTime = true;
    public PApplet g;
    public PFont m_font;
    public float fontHeight;
    public float transX = 320.0f;
    public float transY = 240.0f;
    public float scaleFactor = 20.0f;
    public float yFlip = -1.0f;

    public void setCamera(float x, float y, float scale) {
        this.transX = PApplet.map((float)x, (float)0.0f, (float)-1.0f, (float)((float)this.g.width * 0.5f), (float)((float)this.g.width * 0.5f + scale));
        this.transY = PApplet.map((float)y, (float)0.0f, (float)(this.yFlip * 1.0f), (float)((float)this.g.height * 0.5f), (float)((float)this.g.height * 0.5f + scale));
        this.scaleFactor = scale;
    }

    public ProcessingDebugDraw(PApplet pApplet) {
        screen = this;
        this.g = pApplet;
        this.m_font = this.g.createFont("LucidaGrande-Bold", 12.0f);
        this.fontHeight = 14.0f;
    }

    public Vec2 worldToScreen(Vec2 world) {
        float x = PApplet.map((float)world.x, (float)0.0f, (float)1.0f, (float)this.transX, (float)(this.transX + this.scaleFactor));
        float y = PApplet.map((float)world.y, (float)0.0f, (float)1.0f, (float)this.transY, (float)(this.transY + this.scaleFactor));
        if (this.yFlip == -1.0f) {
            y = PApplet.map((float)y, (float)0.0f, (float)this.g.height, (float)this.g.height, (float)0.0f);
        }
        return new Vec2(x, y);
    }

    public Vec2 worldToScreen(float x, float y) {
        return this.worldToScreen(new Vec2(x, y));
    }

    public Vec2 screenToWorld(Vec2 screen) {
        float x = PApplet.map((float)screen.x, (float)this.transX, (float)(this.transX + this.scaleFactor), (float)0.0f, (float)1.0f);
        float y = screen.y;
        if (this.yFlip == -1.0f) {
            y = PApplet.map((float)y, (float)this.g.height, (float)0.0f, (float)0.0f, (float)this.g.height);
        }
        y = PApplet.map((float)y, (float)this.transY, (float)(this.transY + this.scaleFactor), (float)0.0f, (float)1.0f);
        return new Vec2(x, y);
    }

    public Vec2 screenToWorld(float x, float y) {
        return this.screenToWorld(new Vec2(x, y));
    }

    public void drawCircle(Vec2 center, float radius, Color3f color) {
        center = this.worldToScreen(center);
        radius *= this.scaleFactor;
        this.g.noFill();
        float k_segments = 16.0f;
        float k_increment = (float)Math.PI * 2 / k_segments;
        float theta = 0.0f;
        this.g.stroke(color.x, color.y, color.z);
        this.g.noFill();
        this.g.beginShape(256);
        int i = 0;
        while ((float)i < k_segments) {
            float vx = center.x + radius * (float)Math.cos(theta);
            float vy = center.y + radius * (float)Math.sin(theta);
            this.g.vertex(vx, vy);
            theta += k_increment;
            ++i;
        }
        this.g.vertex(center.x + radius, center.y);
        this.g.endShape();
    }

    public void drawSolidCircle(Vec2 center, float radius, Vec2 axis, Color3f color) {
        center = this.worldToScreen(center);
        radius *= this.scaleFactor;
        axis = new Vec2(axis.x, axis.y * this.yFlip);
        float k_segments = 16.0f;
        float k_increment = (float)Math.PI * 2 / k_segments;
        float theta = 0.0f;
        this.g.fill(0.5f * color.x, 0.5f * color.y, 0.5f * color.z, 127.5f);
        this.g.stroke(color.x, color.y, color.z, 255.0f);
        this.g.beginShape(256);
        int i = 0;
        while ((float)i < k_segments) {
            float vx = center.x + radius * (float)Math.cos(theta);
            float vy = center.y + radius * (float)Math.sin(theta);
            this.g.vertex(vx, vy);
            theta += k_increment;
            ++i;
        }
        this.g.vertex(center.x + radius, center.y);
        this.g.endShape();
        Vec2 p = new Vec2(center.x + radius * axis.x, center.y + radius * axis.y);
        this.g.beginShape(32);
        this.g.vertex(center.x, center.y);
        this.g.vertex(p.x, p.y);
        this.g.endShape();
    }

    public void drawPolygon(Vec2[] vertices, int vertexCount, Color3f color) {
        this.g.stroke(color.x, color.y, color.z);
        this.g.noFill();
        int i = 0;
        while (i < vertexCount) {
            int ind = i + 1 < vertexCount ? i + 1 : i + 1 - vertexCount;
            Vec2 v1 = this.worldToScreen(vertices[i]);
            Vec2 v2 = this.worldToScreen(vertices[ind]);
            this.g.line(v1.x, v1.y, v2.x, v2.y);
            ++i;
        }
    }

    public void drawSolidPolygon(Vec2[] vertices, int vertexCount, Color3f color) {
        this.g.noStroke();
        this.g.fill(0.5f * color.x, 0.5f * color.y, 0.5f * color.z, 127.5f);
        this.g.beginShape(256);
        int i = 0;
        while (i < vertexCount) {
            Vec2 v = this.worldToScreen(vertices[i]);
            this.g.vertex(v.x, v.y);
            ++i;
        }
        this.g.endShape();
        this.g.stroke(color.x, color.y, color.z, 255.0f);
        i = 0;
        while (i < vertexCount) {
            int ind = i + 1 < vertexCount ? i + 1 : i + 1 - vertexCount;
            Vec2 v1 = this.worldToScreen(vertices[i]);
            Vec2 v2 = this.worldToScreen(vertices[ind]);
            this.g.line(v1.x, v1.y, v2.x, v2.y);
            ++i;
        }
    }

    public void drawSegment(Vec2 p1, Vec2 p2, Color3f color) {
        p1 = this.worldToScreen(p1);
        p2 = this.worldToScreen(p2);
        this.g.stroke(color.x, color.y, color.z);
        this.g.beginShape(32);
        this.g.vertex(p1.x, p1.y);
        this.g.vertex(p2.x, p2.y);
        this.g.endShape();
    }

    public void drawXForm(XForm xf) {
        Vec2 p1 = xf.position.clone();
        Vec2 p2 = new Vec2();
        float k_axisScale = 0.4f;
        this.g.beginShape(32);
        Vec2 p1world = this.worldToScreen(p1);
        this.g.stroke(1.0f, 0.0f, 0.0f);
        this.g.vertex(p1world.x, p1world.y);
        p2.x = p1.x + k_axisScale * xf.R.col1.x;
        p2.y = p1.y + k_axisScale * xf.R.col1.y;
        Vec2 p2world = this.worldToScreen(p2);
        this.g.vertex(p2world.x, p2world.y);
        this.g.stroke(0.0f, 1.0f, 0.0f);
        this.g.vertex(p1world.x, p1world.y);
        p2.x = p1.x + k_axisScale * xf.R.col2.x;
        p2.y = p1.x + k_axisScale * xf.R.col2.y;
        p2world = this.worldToScreen(p2);
        this.g.vertex(p2.x, p2.y);
        this.g.endShape();
    }

    public void drawString(float x, float y, String s, Color3f color) {
        if (this.firstTime) {
            this.g.textFont(this.m_font);
            if (this.g.g instanceof PGraphics3D) {
                this.g.textMode(256);
            }
            this.firstTime = false;
        }
        this.g.fill(color.x, color.y, color.z);
        this.g.text(s, x, y);
    }

    public void drawPoint(Vec2 position, float f, Color3f color) {
        position = this.worldToScreen(position);
        float k_segments = 5.0f;
        float k_increment = (float)Math.PI * 2 / k_segments;
        float k_radius = 3.0f;
        float theta = 0.0f;
        this.g.fill(color.x, color.y, color.z);
        this.g.noStroke();
        this.g.beginShape(256);
        int i = 0;
        while ((float)i < k_segments) {
            float vx = position.x + k_radius * (float)Math.cos(theta);
            float vy = position.y + k_radius * (float)Math.sin(theta);
            this.g.vertex(vx, vy);
            theta += k_increment;
            ++i;
        }
        this.g.endShape();
    }

    public void drawImage(PImage image, Vec2 position, float rotation, float localScale, Vec2 localOffset, float halfImageWidth, float halfImageHeight) {
        position = this.worldToScreen(position);
        localOffset = this.worldToScreenVector(localOffset);
        this.g.pushMatrix();
        this.g.translate(position.x, position.y);
        this.g.rotate(-rotation);
        this.g.translate(localOffset.x, localOffset.y);
        this.g.scale(localScale *= this.scaleFactor);
        this.g.image(image, -halfImageWidth, -halfImageHeight);
        this.g.popMatrix();
    }

    public Vec2 worldToScreenVector(Vec2 world) {
        return world.mul(this.scaleFactor);
    }

    public Vec2 worldToScreenVector(float x, float y) {
        return this.worldToScreenVector(new Vec2(x, y));
    }
}

