/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed;

import java.util.ArrayList;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.CircleDef;
import org.jbox2d.collision.Shape;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BoundaryListener;
import org.jbox2d.dynamics.ContactListener;
import org.jbox2d.dynamics.DebugDraw;
import org.jbox2d.dynamics.DestructionListener;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.MouseJoint;
import org.jbox2d.dynamics.joints.MouseJointDef;
import org.jbox2d.testbed.ProcessingDebugDraw;
import org.jbox2d.testbed.TestSettings;
import org.jbox2d.testbed.TestbedMain;
import processing.core.PImage;

public abstract class AbstractExample {
    public TestbedMain parent;
    public DebugDraw m_debugDraw;
    public boolean[] keyDown = new boolean[255];
    public boolean[] newKeyDown = new boolean[255];
    public static String instructionString = "Press left/right to change test\nUse the mouse to drag objects\nShift+drag to slingshot bomb\nPress 'o' to toggle options panel\n";
    public Vec2 mouseScreen = new Vec2();
    public Vec2 mouseWorld = new Vec2();
    public Vec2 pmouseScreen = new Vec2();
    public boolean pmousePressed;
    protected boolean needsReset = true;
    protected Vec2 bombSpawnPoint;
    protected boolean bombSpawning;
    protected int m_textLine;
    protected int m_pointCount;
    protected ContactPoint[] m_points;
    protected World m_world;
    protected Body m_bomb;
    protected MouseJoint m_mouseJoint;
    protected TestSettings settings;
    protected AABB m_worldAABB;
    public float memFree = 0.0f;
    protected DestructionListener m_destructionListener;
    protected BoundaryListener m_boundaryListener;
    protected ContactListener m_contactListener;
    public static Color3f white = new Color3f(255.0f, 255.0f, 255.0f);
    public static Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
    public static Color3f gray = new Color3f(127.5f, 127.5f, 127.5f);
    public static Color3f red = new Color3f(255.0f, 0.0f, 0.0f);
    public static Color3f green = new Color3f(0.0f, 255.0f, 0.0f);
    public static Color3f blue = new Color3f(0.0f, 0.0f, 255.0f);
    public float cachedCamX;
    public float cachedCamY;
    public float cachedCamScale;
    public boolean hasCachedCamera = false;
    public static int textLineHeight = 12;
    protected ArrayList<BoundImage> boundImages = new ArrayList();
    static final int k_maxContactPoints = 2048;

    public void printInstructions() {
        String fullString = String.valueOf(instructionString) + this.getExampleInstructions();
        String[] instructionLines = fullString.split("\n");
        int currentLine = this.parent.height - instructionLines.length * textLineHeight;
        int i = 0;
        while (i < instructionLines.length) {
            this.m_debugDraw.drawString(5.0f, currentLine, instructionLines[i], white);
            currentLine += textLineHeight;
            ++i;
        }
    }

    public String getExampleInstructions() {
        return "";
    }

    public abstract String getName();

    public abstract void create();

    public AbstractExample(TestbedMain _parent) {
        this.parent = _parent;
        this.m_debugDraw = this.parent.g;
        this.needsReset = true;
    }

    public void createWorld() {
        this.m_worldAABB = new AABB();
        this.m_worldAABB.lowerBound = new Vec2(-200.0f, -100.0f);
        this.m_worldAABB.upperBound = new Vec2(200.0f, 200.0f);
        Vec2 gravity = new Vec2(0.0f, -10.0f);
        boolean doSleep = true;
        this.m_world = new World(this.m_worldAABB, gravity, doSleep);
    }

    public void initialize() {
        this.needsReset = false;
        this.m_textLine = 15;
        int i = 0;
        while (i < 255) {
            this.keyDown[i] = false;
            this.newKeyDown[i] = false;
            ++i;
        }
        this.settings = new TestSettings();
        this.mouseScreen = new Vec2(this.parent.mouseX, this.parent.mouseY);
        this.mouseWorld = new Vec2();
        this.pmouseScreen = new Vec2(this.mouseScreen.x, this.mouseScreen.y);
        this.pmousePressed = false;
        this.createWorld();
        this.m_bomb = null;
        this.m_mouseJoint = null;
        this.bombSpawnPoint = null;
        this.bombSpawning = false;
        this.m_points = new ContactPoint[2048];
        i = 0;
        while (i < this.m_points.length) {
            this.m_points[i] = new ContactPoint();
            ++i;
        }
        this.m_destructionListener = new ConcreteDestructionListener();
        this.m_boundaryListener = new ConcreteBoundaryListener();
        this.m_contactListener = new ConcreteContactListener();
        ((ConcreteDestructionListener)this.m_destructionListener).test = this;
        ((ConcreteBoundaryListener)this.m_boundaryListener).test = this;
        ((ConcreteContactListener)this.m_contactListener).test = this;
        this.m_world.setListener(this.m_destructionListener);
        this.m_world.setListener(this.m_boundaryListener);
        this.m_world.setListener(this.m_contactListener);
        this.m_world.setDebugDraw(this.parent.g);
        if (this.hasCachedCamera) {
            this.m_debugDraw.setCamera(this.cachedCamX, this.cachedCamY, this.cachedCamScale);
        } else {
            this.m_debugDraw.setCamera(0.0f, 10.0f, 10.0f);
            this.hasCachedCamera = true;
            this.cachedCamX = 0.0f;
            this.cachedCamY = 10.0f;
            this.cachedCamScale = 10.0f;
        }
        this.boundImages.clear();
        this.create();
    }

    public void step() {
        float timeStep;
        this.preStep();
        this.mouseWorld.set(this.m_debugDraw.screenToWorld(this.mouseScreen));
        float f = timeStep = (float)this.settings.hz > 0.0f ? 1.0f / (float)this.settings.hz : 0.0f;
        if (this.settings.pause) {
            if (this.settings.singleStep) {
                this.settings.singleStep = false;
            } else {
                timeStep = 0.0f;
            }
            this.m_debugDraw.drawString(5.0f, this.m_textLine, "****PAUSED - press '+' to take a single step, 'p' to unpause****", white);
            this.m_textLine += textLineHeight;
        }
        this.m_debugDraw.setFlags(0);
        if (this.settings.drawShapes) {
            this.m_debugDraw.appendFlags(1);
        }
        if (this.settings.drawJoints) {
            this.m_debugDraw.appendFlags(2);
        }
        if (this.settings.drawCoreShapes) {
            this.m_debugDraw.appendFlags(4);
        }
        if (this.settings.drawAABBs) {
            this.m_debugDraw.appendFlags(8);
        }
        if (this.settings.drawOBBs) {
            this.m_debugDraw.appendFlags(16);
        }
        if (this.settings.drawPairs) {
            this.m_debugDraw.appendFlags(32);
        }
        if (this.settings.drawCOMs) {
            this.m_debugDraw.appendFlags(64);
        }
        World.ENABLE_WARM_STARTING = this.settings.enableWarmStarting;
        World.ENABLE_POSITION_CORRECTION = this.settings.enablePositionCorrection;
        World.ENABLE_TOI = this.settings.enableTOI;
        this.m_pointCount = 0;
        this.m_world.step(timeStep, this.settings.iterationCount);
        if (this.m_bomb != null && this.m_bomb.isFrozen()) {
            this.m_world.destroyBody(this.m_bomb);
            this.m_bomb = null;
        }
        if (this.settings.drawStats) {
            this.m_debugDraw.drawString(5.0f, this.m_textLine, "proxies(max) = " + this.m_world.m_broadPhase.m_proxyCount + "(" + 2048 + "), pairs(max) = " + this.m_world.m_broadPhase.m_pairManager.m_pairCount + "(" + 16384 + ")", white);
            this.m_textLine += textLineHeight;
            this.m_debugDraw.drawString(5.0f, this.m_textLine, "bodies/contacts/joints = " + this.m_world.m_bodyCount + "/" + this.m_world.m_contactCount + "/" + this.m_world.m_jointCount, white);
            this.m_textLine += textLineHeight;
            this.m_debugDraw.drawString(5.0f, this.m_textLine, "position iterations = " + this.m_world.m_positionIterationCount, white);
            this.m_textLine += textLineHeight;
            long memTot = Runtime.getRuntime().totalMemory();
            this.memFree = this.memFree * 0.9f + 0.1f * (float)Runtime.getRuntime().freeMemory();
            this.m_debugDraw.drawString(5.0f, this.m_textLine, "total memory: " + memTot, white);
            this.m_textLine += textLineHeight;
            this.m_debugDraw.drawString(5.0f, this.m_textLine, "Average free memory: " + (long)this.memFree, white);
            this.m_textLine += textLineHeight;
        }
        if (this.m_mouseJoint != null) {
            Body body = this.m_mouseJoint.m_body2;
            Vec2 p1 = body.getWorldPoint(this.m_mouseJoint.m_localAnchor);
            Vec2 p2 = this.m_mouseJoint.m_target;
            this.m_debugDraw.drawSegment(p1, p2, new Color3f(255.0f, 255.0f, 255.0f));
        }
        if (this.bombSpawning) {
            this.m_debugDraw.drawSolidCircle(this.bombSpawnPoint, 0.3f, new Vec2(1.0f, 0.0f), new Color3f(127.5f, 127.5f, 127.5f));
            this.m_debugDraw.drawSegment(this.bombSpawnPoint, this.mouseWorld, new Color3f(27.5f, 27.5f, 127.5f));
        }
        if (this.settings.drawContactPoints) {
            float k_forceScale = 0.01f;
            float k_axisScale = 0.3f;
            int i = 0;
            while (i < this.m_pointCount) {
                Vec2 p2;
                Vec2 p1;
                ContactPoint point = this.m_points[i];
                if (point.state == 0) {
                    this.m_debugDraw.drawPoint(point.position, 0.3f, new Color3f(255.0f, 150.0f, 150.0f));
                } else if (point.state == 1) {
                    this.m_debugDraw.drawPoint(point.position, 0.1f, new Color3f(255.0f, 0.0f, 0.0f));
                } else {
                    this.m_debugDraw.drawPoint(point.position, 0.5f, new Color3f(0.0f, 155.0f, 155.0f));
                }
                if (this.settings.drawContactNormals) {
                    p1 = point.position;
                    p2 = new Vec2(p1.x + k_axisScale * point.normal.x, p1.y + k_axisScale * point.normal.y);
                    this.m_debugDraw.drawSegment(p1, p2, new Color3f(102.0f, 229.5f, 102.0f));
                } else if (this.settings.drawContactForces) {
                    p1 = point.position;
                    p2 = new Vec2(p1.x + k_forceScale * point.normalForce * point.normal.x, p1.y + k_forceScale * point.normalForce * point.normal.y);
                    this.m_debugDraw.drawSegment(p1, p2, new Color3f(229.5f, 229.5f, 76.5f));
                }
                if (this.settings.drawFrictionForces) {
                    Vec2 tangent = Vec2.cross(point.normal, 1.0f);
                    Vec2 p12 = point.position;
                    Vec2 p22 = new Vec2(p12.x + k_forceScale * point.tangentForce * tangent.x, p12.y + k_forceScale * point.tangentForce * tangent.y);
                    this.m_debugDraw.drawSegment(p12, p22, new Color3f(229.5f, 229.5f, 76.5f));
                }
                ++i;
            }
        }
        for (BoundImage b : this.boundImages) {
            b.draw();
        }
        this.printInstructions();
        this.pmouseScreen.set(this.mouseScreen);
        this.postStep();
        int i = 0;
        while (i < this.newKeyDown.length) {
            this.newKeyDown[i] = false;
            ++i;
        }
    }

    public void preStep() {
    }

    public void postStep() {
    }

    public void launchBomb() {
        Vec2 pos = new Vec2(this.parent.random(-15.0f, 15.0f), 30.0f);
        Vec2 vel = pos.mul(-5.0f);
        this.launchBomb(pos, vel);
    }

    public void launchBomb(Vec2 position, Vec2 velocity) {
        if (this.m_bomb != null) {
            this.m_world.destroyBody(this.m_bomb);
            this.m_bomb = null;
        }
        BodyDef bd = new BodyDef();
        bd.allowSleep = true;
        bd.position = position.clone();
        bd.isBullet = true;
        this.m_bomb = this.m_world.createDynamicBody(bd);
        this.m_bomb.setLinearVelocity(velocity);
        CircleDef sd = new CircleDef();
        sd.radius = 0.3f;
        sd.density = 20.0f;
        sd.restitution = 0.1f;
        Vec2 minV = position.sub(new Vec2(0.3f, 0.3f));
        Vec2 maxV = position.add(new Vec2(0.3f, 0.3f));
        AABB aabb = new AABB(minV, maxV);
        boolean inRange = this.m_world.m_broadPhase.inRange(aabb);
        if (inRange) {
            this.m_bomb.createShape(sd);
            this.m_bomb.setMassFromShapes();
        } else {
            System.out.println("Bomb not created - out of world AABB");
        }
    }

    public void spawnBomb(Vec2 worldPt) {
        this.bombSpawnPoint = worldPt.clone();
        this.bombSpawning = true;
    }

    public void completeBombSpawn() {
        if (!this.bombSpawning) {
            return;
        }
        float multiplier = 30.0f;
        Vec2 mouseW = this.m_debugDraw.screenToWorld(this.mouseScreen);
        Vec2 vel = this.bombSpawnPoint.sub(mouseW);
        vel.mulLocal(30.0f);
        this.launchBomb(this.bombSpawnPoint, vel);
        this.bombSpawning = false;
    }

    public void bindImage(PImage p, Vec2 localOffset, float localRotation, float localScale, Body b) {
        this.boundImages.add(new BoundImage(p, localOffset, localRotation, localScale, b));
    }

    public void keyPressed(int key) {
        if (key >= 0 && key < 255) {
            if (!this.keyDown[key]) {
                this.newKeyDown[key] = true;
            }
            this.keyDown[key] = true;
        }
    }

    public void keyReleased(int key) {
        if (key >= 0 && key < 255) {
            this.keyDown[key] = false;
        }
    }

    public void mouseDown(Vec2 p) {
        if (this.parent.shiftKey) {
            this.spawnBomb(this.m_debugDraw.screenToWorld(p));
            return;
        }
        p = this.m_debugDraw.screenToWorld(p);
        assert (this.m_mouseJoint == null);
        Vec2 d = new Vec2(0.001f, 0.001f);
        AABB aabb = new AABB(p.sub(d), p.add(d));
        int k_maxCount = 10;
        Shape[] shapes = this.m_world.query(aabb, k_maxCount);
        Body body = null;
        int j = 0;
        while (j < shapes.length) {
            boolean inside;
            Body shapeBody = shapes[j].getBody();
            if (!shapeBody.isStatic() && (inside = shapes[j].testPoint(shapeBody.getXForm(), p))) {
                body = shapes[j].m_body;
                break;
            }
            ++j;
        }
        if (body != null) {
            MouseJointDef md = new MouseJointDef();
            md.body1 = this.m_world.m_groundBody;
            md.body2 = body;
            md.target.set(p);
            md.maxForce = 1000.0f * body.m_mass;
            this.m_mouseJoint = (MouseJoint)this.m_world.createJoint(md);
            body.wakeUp();
        }
    }

    public void mouseUp() {
        if (this.m_mouseJoint != null) {
            this.m_world.destroyJoint(this.m_mouseJoint);
            this.m_mouseJoint = null;
        }
        if (this.bombSpawning) {
            this.completeBombSpawn();
        }
    }

    public void mouseMove(Vec2 p) {
        this.mouseScreen.set(p);
        if (this.m_mouseJoint != null) {
            this.m_mouseJoint.setTarget(this.m_debugDraw.screenToWorld(p));
        }
    }

    public void setCamera(float x, float y, float scale) {
        this.m_debugDraw.setCamera(x, y, scale);
        this.hasCachedCamera = true;
        this.cachedCamX = x;
        this.cachedCamY = y;
        this.cachedCamScale = scale;
    }

    public void jointDestroyed(Joint joint) {
    }

    public void boundaryViolated(Body body) {
    }

    class BoundImage {
        private PImage image;
        private float halfImageWidth;
        private float halfImageHeight;
        private Body body;
        private Vec2 localOffset;
        private float localRotation;
        private float localScale;
        private ProcessingDebugDraw p;

        public BoundImage(PImage _image, Vec2 _localOffset, float _localRotation, float _localScale, Body _body) {
            this.image = _image;
            this.localOffset = _localOffset.clone();
            this.localRotation = _localRotation;
            this.localScale = _localScale;
            this.body = _body;
            this.halfImageWidth = (float)this.image.width / 2.0f;
            this.halfImageHeight = (float)this.image.height / 2.0f;
            this.p = (ProcessingDebugDraw)AbstractExample.this.m_debugDraw;
        }

        public void draw() {
            this.p.drawImage(this.image, this.body.getPosition(), this.body.getAngle() + this.localRotation, this.localScale, this.localOffset, this.halfImageWidth, this.halfImageHeight);
        }
    }

    class ConcreteBoundaryListener
    implements BoundaryListener {
        public AbstractExample test;

        ConcreteBoundaryListener() {
        }

        public void violation(Body body) {
            if (this.test.m_bomb != body) {
                this.test.boundaryViolated(body);
            }
        }
    }

    class ConcreteContactListener
    implements ContactListener {
        public AbstractExample test;

        ConcreteContactListener() {
        }

        public void add(org.jbox2d.dynamics.contacts.ContactPoint point) {
            if (this.test.m_pointCount == 2048) {
                return;
            }
            ContactPoint cp = this.test.m_points[this.test.m_pointCount];
            cp.shape1 = point.shape1;
            cp.shape2 = point.shape2;
            cp.position = point.position.clone();
            cp.normal = point.normal.clone();
            cp.normalForce = point.normalForce;
            cp.tangentForce = point.tangentForce;
            cp.state = 0;
            ++this.test.m_pointCount;
        }

        public void persist(org.jbox2d.dynamics.contacts.ContactPoint point) {
            if (this.test.m_pointCount == 2048) {
                return;
            }
            ContactPoint cp = this.test.m_points[this.test.m_pointCount];
            cp.shape1 = point.shape1;
            cp.shape2 = point.shape2;
            cp.position = point.position.clone();
            cp.normal = point.normal.clone();
            cp.normalForce = point.normalForce;
            cp.tangentForce = point.tangentForce;
            cp.state = 1;
            ++this.test.m_pointCount;
        }

        public void remove(org.jbox2d.dynamics.contacts.ContactPoint point) {
            if (this.test.m_pointCount == 2048) {
                return;
            }
            ContactPoint cp = this.test.m_points[this.test.m_pointCount];
            cp.shape1 = point.shape1;
            cp.shape2 = point.shape2;
            cp.position = point.position.clone();
            cp.normal = point.normal.clone();
            cp.normalForce = point.normalForce;
            cp.tangentForce = point.tangentForce;
            cp.state = 2;
            ++this.test.m_pointCount;
        }
    }

    class ConcreteDestructionListener
    implements DestructionListener {
        public AbstractExample test;

        ConcreteDestructionListener() {
        }

        public void sayGoodbye(Shape shape) {
        }

        public void sayGoodbye(Joint joint) {
            if (this.test.m_mouseJoint == joint) {
                this.test.m_mouseJoint = null;
            } else {
                this.test.jointDestroyed(joint);
            }
        }
    }

    class ContactPoint {
        public Shape shape1;
        public Shape shape2;
        public Vec2 normal;
        public Vec2 position;
        public float normalForce;
        public float tangentForce;
        public int state;

        ContactPoint() {
        }
    }
}

