/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.contacts;

import java.util.ArrayList;
import java.util.List;
import org.jbox2d.collision.CollidePoly;
import org.jbox2d.collision.ContactID;
import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.ManifoldPoint;
import org.jbox2d.collision.PolygonShape;
import org.jbox2d.collision.Shape;
import org.jbox2d.collision.ShapeType;
import org.jbox2d.common.XForm;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.ContactListener;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactCreateFcn;
import org.jbox2d.dynamics.contacts.ContactPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolyContact
extends Contact
implements ContactCreateFcn {
    Manifold m_manifold;

    public PolyContact(Shape s1, Shape s2) {
        super(s1, s2);
        assert (this.m_shape1.m_type == ShapeType.POLYGON_SHAPE);
        assert (this.m_shape2.m_type == ShapeType.POLYGON_SHAPE);
        this.m_manifold = new Manifold();
        this.m_manifoldCount = 0;
    }

    public PolyContact() {
        this.m_manifold = new Manifold();
        this.m_manifoldCount = 0;
    }

    @Override
    public Contact clone() {
        PolyContact newC = new PolyContact(this.m_shape1, this.m_shape2);
        if (this.m_manifold != null) {
            newC.m_manifold = new Manifold(this.m_manifold);
        }
        newC.m_manifoldCount = this.m_manifoldCount;
        newC.m_world = this.m_world;
        newC.m_toi = this.m_toi;
        newC.m_prev = this.m_prev;
        newC.m_next = this.m_next;
        newC.m_node1 = this.m_node1;
        newC.m_node2 = this.m_node2;
        newC.m_friction = this.m_friction;
        newC.m_restitution = this.m_restitution;
        newC.m_flags = this.m_flags;
        return newC;
    }

    @Override
    public List<Manifold> getManifolds() {
        ArrayList<Manifold> ret = new ArrayList<Manifold>();
        if (this.m_manifold != null) {
            ret.add(this.m_manifold);
        }
        return ret;
    }

    @Override
    public Contact create(Shape shape1, Shape shape2) {
        return new PolyContact(shape1, shape2);
    }

    public void dumpManifoldPoints() {
        int i = 0;
        while (i < this.m_manifold.pointCount) {
            ManifoldPoint mp = this.m_manifold.points[i];
            System.out.println("Manifold point dump: " + mp.normalForce + " " + mp.tangentForce);
            ++i;
        }
    }

    @Override
    public void evaluate(ContactListener listener) {
        Body b1 = this.m_shape1.getBody();
        Body b2 = this.m_shape2.getBody();
        Manifold m0 = new Manifold(this.m_manifold);
        int k = 0;
        while (k < this.m_manifold.pointCount) {
            m0.points[k] = new ManifoldPoint(this.m_manifold.points[k]);
            m0.points[k].normalForce = this.m_manifold.points[k].normalForce;
            m0.points[k].tangentForce = this.m_manifold.points[k].tangentForce;
            m0.points[k].separation = this.m_manifold.points[k].separation;
            m0.points[k].id.features.set(this.m_manifold.points[k].id.features);
            ++k;
        }
        m0.pointCount = this.m_manifold.pointCount;
        CollidePoly.collidePoly(this.m_manifold, (PolygonShape)this.m_shape1, b1.m_xf, (PolygonShape)this.m_shape2, b2.m_xf);
        boolean[] match = new boolean[2];
        if (this.m_manifold.pointCount > 0) {
            int i = 0;
            while (i < this.m_manifold.pointCount) {
                ManifoldPoint cp = this.m_manifold.points[i];
                cp.normalForce = 0.0f;
                cp.tangentForce = 0.0f;
                boolean matched = false;
                ContactID id = new ContactID(cp.id);
                int j = 0;
                while (j < m0.pointCount) {
                    if (!match[j]) {
                        ManifoldPoint cp0 = m0.points[j];
                        ContactID id0 = new ContactID(cp0.id);
                        id0.features.flip &= 0xFFFFFFFD;
                        if (id0.features.isEqual(id.features)) {
                            match[j] = true;
                            cp.normalForce = cp0.normalForce;
                            cp.tangentForce = cp0.tangentForce;
                            matched = true;
                            break;
                        }
                    }
                    ++j;
                }
                if (!matched) {
                    cp.id.features.flip |= 2;
                }
                ++i;
            }
            this.m_manifoldCount = 1;
        } else {
            this.m_manifoldCount = 0;
        }
        if (listener != null && m0.pointCount > 0) {
            ContactPoint cp = new ContactPoint();
            cp.shape1 = this.m_shape1;
            cp.shape2 = this.m_shape2;
            cp.normal = m0.normal.clone();
            int i = 0;
            while (i < m0.pointCount) {
                if (!match[i]) {
                    ManifoldPoint mp0 = m0.points[i];
                    cp.position = XForm.mul(b1.m_xf, mp0.localPoint1);
                    cp.separation = mp0.separation;
                    cp.normalForce = mp0.normalForce;
                    cp.tangentForce = mp0.tangentForce;
                    cp.id = new ContactID(mp0.id);
                    listener.remove(cp);
                }
                ++i;
            }
        }
    }
}

