/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.contacts;

import java.util.ArrayList;
import java.util.List;
import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.ManifoldPoint;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactConstraint;
import org.jbox2d.dynamics.contacts.ContactConstraintPoint;

public class ContactSolver {
    public TimeStep m_step;
    public List<ContactConstraint> m_constraints;
    public int m_constraintCount;

    public ContactSolver(TimeStep step, Contact[] contacts, int contactCount) {
        this.m_step = step;
        this.m_constraintCount = 0;
        int i = 0;
        while (i < contactCount) {
            assert (contacts[i].isSolid());
            this.m_constraintCount += contacts[i].getManifoldCount();
            ++i;
        }
        this.m_constraints = new ArrayList<ContactConstraint>();
        i = 0;
        while (i < this.m_constraintCount) {
            this.m_constraints.add(new ContactConstraint());
            ++i;
        }
        int count = 0;
        int i2 = 0;
        while (i2 < contactCount) {
            Contact contact = contacts[i2];
            Body b1 = contact.m_shape1.m_body;
            Body b2 = contact.m_shape2.m_body;
            int manifoldCount = contact.getManifoldCount();
            List<Manifold> manifolds = contact.getManifolds();
            float friction = contact.m_friction;
            float restitution = contact.m_restitution;
            Vec2 v1 = b1.m_linearVelocity.clone();
            Vec2 v2 = b2.m_linearVelocity.clone();
            float w1 = b1.m_angularVelocity;
            float w2 = b2.m_angularVelocity;
            int j = 0;
            while (j < manifoldCount) {
                Manifold manifold = manifolds.get(j);
                assert (manifold.pointCount > 0) : "Manifold " + j + " has length 0";
                Vec2 normal = manifold.normal.clone();
                assert (count < this.m_constraintCount);
                ContactConstraint c = this.m_constraints.get(count);
                c.body1 = b1;
                c.body2 = b2;
                c.manifold = manifold;
                c.normal = normal.clone();
                c.pointCount = manifold.pointCount;
                c.friction = friction;
                c.restitution = restitution;
                int k = 0;
                while (k < c.pointCount) {
                    Vec2 buffer;
                    float vRel;
                    ManifoldPoint cp = manifold.points[k];
                    ContactConstraintPoint ccp = c.points[k];
                    ccp.normalForce = cp.normalForce;
                    ccp.tangentForce = cp.tangentForce;
                    ccp.separation = cp.separation;
                    ccp.positionImpulse = 0.0f;
                    ccp.localAnchor1.set(cp.localPoint1);
                    ccp.localAnchor2.set(cp.localPoint2);
                    ccp.r1 = Mat22.mul(b1.m_xf.R, cp.localPoint1.sub(b1.getLocalCenter()));
                    ccp.r2 = Mat22.mul(b2.m_xf.R, cp.localPoint2.sub(b2.getLocalCenter()));
                    float r1Sqr = ccp.r1.x * ccp.r1.x + ccp.r1.y * ccp.r1.y;
                    float r2Sqr = ccp.r2.x * ccp.r2.x + ccp.r2.y * ccp.r2.y;
                    float rn1 = Vec2.dot(ccp.r1, normal);
                    float rn2 = Vec2.dot(ccp.r2, normal);
                    float kNormal = b1.m_invMass + b2.m_invMass;
                    assert ((kNormal += b1.m_invI * (r1Sqr - rn1 * rn1) + b2.m_invI * (r2Sqr - rn2 * rn2)) > 1.1920929E-7f);
                    ccp.normalMass = 1.0f / kNormal;
                    float kEqualized = b1.m_mass * b1.m_invMass + b2.m_mass * b2.m_invMass;
                    assert ((kEqualized += b1.m_mass * b1.m_invI * (r1Sqr - rn1 * rn1) + b2.m_mass * b2.m_invI * (r2Sqr - rn2 * rn2)) > 1.1920929E-7f);
                    ccp.equalizedMass = 1.0f / kEqualized;
                    Vec2 tangent = Vec2.cross(normal, 1.0f);
                    float rt1 = Vec2.dot(ccp.r1, tangent);
                    float rt2 = Vec2.dot(ccp.r2, tangent);
                    float kTangent = b1.m_invMass + b2.m_invMass;
                    assert ((kTangent += b1.m_invI * (r1Sqr - rt1 * rt1) + b2.m_invI * (r2Sqr - rt2 * rt2)) > 1.1920929E-7f);
                    ccp.tangentMass = 1.0f / kTangent;
                    ccp.velocityBias = 0.0f;
                    if (ccp.separation > 0.0f) {
                        ccp.velocityBias = -60.0f * ccp.separation;
                    }
                    if ((vRel = Vec2.dot(c.normal, buffer = Vec2.cross(w2, ccp.r2).subLocal(Vec2.cross(w1, ccp.r1)).addLocal(v2).subLocal(v1))) < -1.0f) {
                        ccp.velocityBias += -c.restitution * vRel;
                    }
                    ++k;
                }
                ++count;
                ++j;
            }
            ++i2;
        }
        assert (count == this.m_constraintCount);
    }

    public void initVelocityConstraints() {
        int i = 0;
        while (i < this.m_constraintCount) {
            ContactConstraintPoint ccp;
            int j;
            ContactConstraint c = this.m_constraints.get(i);
            Body b1 = c.body1;
            Body b2 = c.body2;
            float invMass1 = b1.m_invMass;
            float invI1 = b1.m_invI;
            float invMass2 = b2.m_invMass;
            float invI2 = b2.m_invI;
            Vec2 normal = c.normal;
            Vec2 tangent = Vec2.cross(normal, 1.0f);
            if (World.ENABLE_WARM_STARTING) {
                j = 0;
                while (j < c.pointCount) {
                    ccp = c.points[j];
                    float px = this.m_step.dt * (ccp.normalForce * normal.x + ccp.tangentForce * tangent.x);
                    float py = this.m_step.dt * (ccp.normalForce * normal.y + ccp.tangentForce * tangent.y);
                    b1.m_angularVelocity -= invI1 * (ccp.r1.x * py - ccp.r1.y * px);
                    b1.m_linearVelocity.x -= px * invMass1;
                    b1.m_linearVelocity.y -= py * invMass1;
                    b2.m_angularVelocity += invI2 * (ccp.r2.x * py - ccp.r2.y * px);
                    b2.m_linearVelocity.x += px * invMass2;
                    b2.m_linearVelocity.y += py * invMass2;
                    ++j;
                }
            } else {
                j = 0;
                while (j < c.pointCount) {
                    ccp = c.points[j];
                    ccp.normalForce = 0.0f;
                    ccp.tangentForce = 0.0f;
                    ++j;
                }
            }
            ++i;
        }
    }

    public void solveVelocityConstraints() {
        int i = 0;
        while (i < this.m_constraintCount) {
            float lambda;
            Vec2 dv;
            ContactConstraintPoint ccp;
            ContactConstraint c = this.m_constraints.get(i);
            Body b1 = c.body1;
            Body b2 = c.body2;
            float w1 = b1.m_angularVelocity;
            float w2 = b2.m_angularVelocity;
            Vec2 v1 = b1.m_linearVelocity.clone();
            Vec2 v2 = b2.m_linearVelocity.clone();
            float invMass1 = b1.m_invMass;
            float invI1 = b1.m_invI;
            float invMass2 = b2.m_invMass;
            float invI2 = b2.m_invI;
            Vec2 normal = c.normal.clone();
            Vec2 tangent = Vec2.cross(normal, 1.0f);
            float friction = c.friction;
            int j = 0;
            while (j < c.pointCount) {
                ccp = c.points[j];
                dv = v2.add(Vec2.cross(w2, ccp.r2));
                dv.subLocal(v1);
                dv.subLocal(Vec2.cross(w1, ccp.r1));
                float vn = dv.x * normal.x + dv.y * normal.y;
                lambda = -this.m_step.inv_dt * ccp.normalMass * (vn - ccp.velocityBias);
                float newForce = Math.max(ccp.normalForce + lambda, 0.0f);
                lambda = newForce - ccp.normalForce;
                Vec2 P = new Vec2(this.m_step.dt * lambda * normal.x, this.m_step.dt * lambda * normal.y);
                v1.x -= invMass1 * P.x;
                v1.y -= invMass1 * P.y;
                w1 -= invI1 * Vec2.cross(ccp.r1, P);
                v2.x += invMass2 * P.x;
                v2.y += invMass2 * P.y;
                w2 += invI2 * Vec2.cross(ccp.r2, P);
                ccp.normalForce = newForce;
                ++j;
            }
            j = 0;
            while (j < c.pointCount) {
                ccp = c.points[j];
                dv = v2.add(Vec2.cross(w2, ccp.r2));
                dv.subLocal(v1);
                dv.subLocal(Vec2.cross(w1, ccp.r1));
                float vt = dv.x * tangent.x + dv.y * tangent.y;
                lambda = this.m_step.inv_dt * ccp.tangentMass * -vt;
                float maxFriction = friction * ccp.normalForce;
                float newForce = MathUtils.clamp(ccp.tangentForce + lambda, -maxFriction, maxFriction);
                lambda = newForce - ccp.tangentForce;
                float px = tangent.x * (lambda *= this.m_step.dt);
                float py = tangent.y * lambda;
                v1.x -= px * invMass1;
                v1.y -= py * invMass1;
                w1 -= invI1 * (ccp.r1.x * py - ccp.r1.y * px);
                v2.x += px * invMass2;
                v2.y += py * invMass2;
                w2 += invI2 * (ccp.r2.x * py - ccp.r2.y * px);
                ccp.tangentForce = newForce;
                ++j;
            }
            b1.m_linearVelocity.set(v1);
            b1.m_angularVelocity = w1;
            b2.m_linearVelocity.set(v2);
            b2.m_angularVelocity = w2;
            ++i;
        }
    }

    public void finalizeVelocityConstraints() {
        int i = 0;
        while (i < this.m_constraintCount) {
            ContactConstraint c = this.m_constraints.get(i);
            Manifold m = c.manifold;
            int j = 0;
            while (j < c.pointCount) {
                m.points[j].normalForce = c.points[j].normalForce;
                m.points[j].tangentForce = c.points[j].tangentForce;
                ++j;
            }
            ++i;
        }
    }

    public boolean solvePositionConstraints(float baumgarte) {
        float minSeparation = 0.0f;
        int i = 0;
        while (i < this.m_constraintCount) {
            ContactConstraint c = this.m_constraints.get(i);
            Body b1 = c.body1;
            Body b2 = c.body2;
            float invMass1 = b1.m_mass * b1.m_invMass;
            float invI1 = b1.m_mass * b1.m_invI;
            float invMass2 = b2.m_mass * b2.m_invMass;
            float invI2 = b2.m_mass * b2.m_invI;
            Vec2 normal = c.normal;
            int j = 0;
            while (j < c.pointCount) {
                ContactConstraintPoint ccp = c.points[j];
                Vec2 r1 = Mat22.mul(b1.m_xf.R, ccp.localAnchor1.sub(b1.getLocalCenter()));
                Vec2 r2 = Mat22.mul(b2.m_xf.R, ccp.localAnchor2.sub(b2.getLocalCenter()));
                float dpx = b2.m_sweep.c.x + r2.x - b1.m_sweep.c.x - r1.x;
                float dpy = b2.m_sweep.c.y + r2.y - b1.m_sweep.c.y - r1.y;
                float separation = dpx * normal.x + dpy * normal.y + ccp.separation;
                minSeparation = Math.min(minSeparation, separation);
                float C = baumgarte * MathUtils.clamp(separation + 0.005f, -0.2f, 0.0f);
                float dImpulse = -ccp.equalizedMass * C;
                float impulse0 = ccp.positionImpulse;
                ccp.positionImpulse = Math.max(impulse0 + dImpulse, 0.0f);
                dImpulse = ccp.positionImpulse - impulse0;
                float impulsex = dImpulse * normal.x;
                float impulsey = dImpulse * normal.y;
                b1.m_sweep.c.x -= invMass1 * impulsex;
                b1.m_sweep.c.y -= invMass1 * impulsey;
                b1.m_sweep.a -= invI1 * (r1.x * impulsey - r1.y * impulsex);
                b1.synchronizeTransform();
                b2.m_sweep.c.x += invMass2 * impulsex;
                b2.m_sweep.c.y += invMass2 * impulsey;
                b2.m_sweep.a += invI2 * (r2.x * impulsey - r2.y * impulsex);
                b2.synchronizeTransform();
                ++j;
            }
            ++i;
        }
        return minSeparation >= -0.0075f;
    }
}

