/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.contacts;

import java.util.ArrayList;
import java.util.List;
import org.jbox2d.collision.CircleShape;
import org.jbox2d.collision.CollideCircle;
import org.jbox2d.collision.ContactID;
import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.ManifoldPoint;
import org.jbox2d.collision.Shape;
import org.jbox2d.collision.ShapeType;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.ContactListener;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactCreateFcn;
import org.jbox2d.dynamics.contacts.ContactPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircleContact
extends Contact
implements ContactCreateFcn {
    Manifold m_manifold = new Manifold();

    @Override
    public Contact create(Shape shape1, Shape shape2) {
        return new CircleContact(shape1, shape2);
    }

    public static void Destroy(Contact contact) {
        ((CircleContact)contact).Destructor();
    }

    @Override
    public CircleContact clone() {
        return this;
    }

    public CircleContact() {
        this.m_manifoldCount = 0;
    }

    public CircleContact(Shape shape1, Shape shape2) {
        super(shape1, shape2);
        assert (this.m_shape1.m_type == ShapeType.CIRCLE_SHAPE);
        assert (this.m_shape2.m_type == ShapeType.CIRCLE_SHAPE);
        this.m_manifold.pointCount = 0;
        this.m_manifold.points[0].normalForce = 0.0f;
        this.m_manifold.points[0].tangentForce = 0.0f;
        this.m_manifold.points[0].localPoint1 = new Vec2();
        this.m_manifold.points[0].localPoint2 = new Vec2();
    }

    public void Destructor() {
    }

    @Override
    public void evaluate(ContactListener listener) {
        Body b1 = this.m_shape1.m_body;
        Body b2 = this.m_shape2.m_body;
        Manifold m0 = new Manifold(this.m_manifold);
        int k = 0;
        while (k < this.m_manifold.pointCount) {
            m0.points[k] = new ManifoldPoint(this.m_manifold.points[k]);
            m0.points[k].normalForce = this.m_manifold.points[k].normalForce;
            m0.points[k].tangentForce = this.m_manifold.points[k].tangentForce;
            m0.points[k].separation = this.m_manifold.points[k].separation;
            m0.points[k].id.features.set(this.m_manifold.points[k].id.features);
            ++k;
        }
        m0.pointCount = this.m_manifold.pointCount;
        CollideCircle.collideCircle(this.m_manifold, (CircleShape)this.m_shape1, b1.m_xf, (CircleShape)this.m_shape2, b2.m_xf);
        if (this.m_manifold.pointCount > 0) {
            this.m_manifoldCount = 1;
            this.m_manifold.points[0].id.features.flip = m0.pointCount == 0 ? (this.m_manifold.points[0].id.features.flip |= 2) : (this.m_manifold.points[0].id.features.flip &= 0xFFFFFFFD);
        } else {
            this.m_manifoldCount = 0;
            if (m0.pointCount > 0 && listener != null) {
                ContactPoint cp = new ContactPoint();
                cp.shape1 = this.m_shape1;
                cp.shape2 = this.m_shape2;
                cp.normal.set(m0.normal);
                cp.position = XForm.mul(b1.m_xf, m0.points[0].localPoint1);
                cp.separation = m0.points[0].separation;
                cp.normalForce = m0.points[0].normalForce;
                cp.tangentForce = m0.points[0].tangentForce;
                cp.id = new ContactID(m0.points[0].id);
                listener.remove(cp);
            }
        }
    }

    @Override
    public List<Manifold> getManifolds() {
        ArrayList<Manifold> ret = new ArrayList<Manifold>(1);
        if (this.m_manifold != null) {
            ret.add(this.m_manifold);
        }
        return ret;
    }
}

