/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics;

import org.jbox2d.collision.AABB;
import org.jbox2d.collision.BroadPhase;
import org.jbox2d.collision.CircleShape;
import org.jbox2d.collision.OBB;
import org.jbox2d.collision.Pair;
import org.jbox2d.collision.PolygonShape;
import org.jbox2d.collision.Proxy;
import org.jbox2d.collision.Shape;
import org.jbox2d.collision.ShapeType;
import org.jbox2d.collision.TOI;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BoundaryListener;
import org.jbox2d.dynamics.ContactFilter;
import org.jbox2d.dynamics.ContactListener;
import org.jbox2d.dynamics.ContactManager;
import org.jbox2d.dynamics.DebugDraw;
import org.jbox2d.dynamics.DestructionListener;
import org.jbox2d.dynamics.Island;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactEdge;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.JointEdge;
import org.jbox2d.dynamics.joints.JointType;
import org.jbox2d.dynamics.joints.PulleyJoint;

public class World {
    public boolean m_lock = false;
    public BroadPhase m_broadPhase;
    ContactManager m_contactManager;
    public Body m_bodyList = null;
    public Contact m_contactList = null;
    public Joint m_jointList = null;
    public int m_bodyCount = 0;
    public int m_contactCount = 0;
    public int m_jointCount = 0;
    public Vec2 m_gravity;
    public boolean m_allowSleep;
    public Body m_groundBody;
    public int m_positionIterationCount;
    public static boolean ENABLE_POSITION_CORRECTION;
    public static boolean ENABLE_WARM_STARTING;
    public static boolean ENABLE_TOI;
    public DestructionListener m_destructionListener = null;
    public BoundaryListener m_boundaryListener = null;
    public ContactFilter m_contactFilter = ContactFilter.DEFAULT_FILTER;
    public ContactListener m_contactListener = null;
    public DebugDraw m_debugDraw = null;

    public Body getGroundBody() {
        return this.m_groundBody;
    }

    public Body getBodyList() {
        return this.m_bodyList;
    }

    public Joint getJointList() {
        return this.m_jointList;
    }

    public World(AABB worldAABB, Vec2 gravity, boolean doSleep) {
        this.m_allowSleep = doSleep;
        this.m_gravity = gravity;
        this.m_contactManager = new ContactManager();
        this.m_contactManager.m_world = this;
        this.m_broadPhase = new BroadPhase(worldAABB, this.m_contactManager);
        BodyDef bd = new BodyDef();
        this.m_groundBody = this.createStaticBody(bd);
    }

    public void setListener(DestructionListener listener) {
        this.m_destructionListener = listener;
    }

    public void setListener(BoundaryListener listener) {
        this.m_boundaryListener = listener;
    }

    public void setFilter(ContactFilter filter) {
        this.m_contactFilter = filter;
    }

    public void setListener(ContactListener listener) {
        this.m_contactListener = listener;
    }

    public void setDebugDraw(DebugDraw debugDraw) {
        this.m_debugDraw = debugDraw;
    }

    public Body createStaticBody(BodyDef def) {
        assert (!this.m_lock);
        if (this.m_lock) {
            return null;
        }
        Body b = new Body(def, 0, this);
        b.m_prev = null;
        b.m_next = this.m_bodyList;
        if (this.m_bodyList != null) {
            this.m_bodyList.m_prev = b;
        }
        this.m_bodyList = b;
        ++this.m_bodyCount;
        return b;
    }

    public Body createDynamicBody(BodyDef def) {
        assert (!this.m_lock);
        if (this.m_lock) {
            return null;
        }
        Body b = new Body(def, 1, this);
        b.m_prev = null;
        b.m_next = this.m_bodyList;
        if (this.m_bodyList != null) {
            this.m_bodyList.m_prev = b;
        }
        this.m_bodyList = b;
        ++this.m_bodyCount;
        return b;
    }

    public void destroyBody(Body b) {
        assert (this.m_bodyCount > 0);
        assert (!this.m_lock);
        if (this.m_lock) {
            return;
        }
        JointEdge jn = b.m_jointList;
        while (jn != null) {
            JointEdge jn0 = jn;
            jn = jn.next;
            if (this.m_destructionListener != null) {
                this.m_destructionListener.sayGoodbye(jn0.joint);
            }
            this.destroyJoint(jn0.joint);
        }
        Shape s = b.m_shapeList;
        while (s != null) {
            Shape s0 = s;
            s = s.m_next;
            if (this.m_destructionListener != null) {
                this.m_destructionListener.sayGoodbye(s0);
            }
            s0.destroyProxy(this.m_broadPhase);
            Shape.destroy(s0);
        }
        if (b.m_prev != null) {
            b.m_prev.m_next = b.m_next;
        }
        if (b.m_next != null) {
            b.m_next.m_prev = b.m_prev;
        }
        if (b == this.m_bodyList) {
            this.m_bodyList = b.m_next;
        }
        --this.m_bodyCount;
    }

    public Joint createJoint(JointDef def) {
        assert (!this.m_lock);
        Joint j = Joint.create(def);
        j.m_prev = null;
        j.m_next = this.m_jointList;
        if (this.m_jointList != null) {
            this.m_jointList.m_prev = j;
        }
        this.m_jointList = j;
        ++this.m_jointCount;
        j.m_node1.joint = j;
        j.m_node1.other = j.m_body2;
        j.m_node1.prev = null;
        j.m_node1.next = j.m_body1.m_jointList;
        if (j.m_body1.m_jointList != null) {
            j.m_body1.m_jointList.prev = j.m_node1;
        }
        j.m_body1.m_jointList = j.m_node1;
        j.m_node2.joint = j;
        j.m_node2.other = j.m_body1;
        j.m_node2.prev = null;
        j.m_node2.next = j.m_body2.m_jointList;
        if (j.m_body2.m_jointList != null) {
            j.m_body2.m_jointList.prev = j.m_node2;
        }
        j.m_body2.m_jointList = j.m_node2;
        if (!def.collideConnected) {
            Body b = def.body1.m_shapeCount < def.body2.m_shapeCount ? def.body1 : def.body2;
            Shape s = b.m_shapeList;
            while (s != null) {
                s.resetProxy(this.m_broadPhase, b.m_xf);
                s = s.m_next;
            }
        }
        return j;
    }

    public void destroyJoint(Joint j) {
        assert (!this.m_lock);
        boolean collideConnected = j.m_collideConnected;
        if (j.m_prev != null) {
            j.m_prev.m_next = j.m_next;
        }
        if (j.m_next != null) {
            j.m_next.m_prev = j.m_prev;
        }
        if (j == this.m_jointList) {
            this.m_jointList = j.m_next;
        }
        Body body1 = j.m_body1;
        Body body2 = j.m_body2;
        body1.wakeUp();
        body2.wakeUp();
        if (j.m_node1.prev != null) {
            j.m_node1.prev.next = j.m_node1.next;
        }
        if (j.m_node1.next != null) {
            j.m_node1.next.prev = j.m_node1.prev;
        }
        if (j.m_node1 == body1.m_jointList) {
            body1.m_jointList = j.m_node1.next;
        }
        j.m_node1.prev = null;
        j.m_node1.next = null;
        if (j.m_node2.prev != null) {
            j.m_node2.prev.next = j.m_node2.next;
        }
        if (j.m_node2.next != null) {
            j.m_node2.next.prev = j.m_node2.prev;
        }
        if (j.m_node2 == body2.m_jointList) {
            body2.m_jointList = j.m_node2.next;
        }
        j.m_node2.prev = null;
        j.m_node2.next = null;
        Joint.destroy(j);
        assert (this.m_jointCount > 0);
        --this.m_jointCount;
        if (!collideConnected) {
            Body b = body1.m_shapeCount < body2.m_shapeCount ? body1 : body2;
            Shape s = b.m_shapeList;
            while (s != null) {
                s.resetProxy(this.m_broadPhase, b.m_xf);
                s = s.m_next;
            }
        }
    }

    public void step(float dt, int iterations) {
        this.m_lock = true;
        TimeStep step = new TimeStep();
        step.dt = dt;
        step.maxIterations = iterations;
        step.inv_dt = dt > 0.0f ? 1.0f / dt : 0.0f;
        this.m_contactManager.collide();
        if (step.dt > 0.0f) {
            this.solve(step);
        }
        if (ENABLE_TOI && step.dt > 0.0f) {
            this.solveTOI(step);
        }
        this.drawDebugData();
        this.m_lock = false;
    }

    public Shape[] query(AABB aabb, int maxCount) {
        Object[] objs = this.m_broadPhase.query(aabb, maxCount);
        Shape[] ret = new Shape[objs.length];
        System.arraycopy(objs, 0, ret, 0, objs.length);
        return ret;
    }

    public void solve(TimeStep step) {
        this.m_positionIterationCount = 0;
        Island island = new Island(this.m_bodyCount, this.m_contactCount, this.m_jointCount, this.m_contactListener);
        Body b = this.m_bodyList;
        while (b != null) {
            b.m_flags &= 0xFFFFFFFB;
            b = b.m_next;
        }
        Contact c = this.m_contactList;
        while (c != null) {
            c.m_flags &= 0xFFFFFFFB;
            c = c.m_next;
        }
        Joint j = this.m_jointList;
        while (j != null) {
            j.m_islandFlag = false;
            j = j.m_next;
        }
        int stackSize = this.m_bodyCount;
        Body[] stack = new Body[stackSize];
        Body seed = this.m_bodyList;
        while (seed != null) {
            if ((seed.m_flags & 0xE) <= 0 && !seed.isStatic()) {
                island.clear();
                int stackCount = 0;
                stack[stackCount++] = seed;
                seed.m_flags |= 4;
                while (stackCount > 0) {
                    Body other;
                    Body b2 = stack[--stackCount];
                    island.add(b2);
                    b2.m_flags &= 0xFFFFFFF7;
                    if (b2.isStatic()) continue;
                    ContactEdge cn = b2.m_contactList;
                    while (cn != null) {
                        if ((cn.contact.m_flags & 5) <= 0 && cn.contact.getManifoldCount() != 0) {
                            island.add(cn.contact);
                            cn.contact.m_flags |= 4;
                            other = cn.other;
                            if ((other.m_flags & 4) <= 0) {
                                assert (stackCount < stackSize);
                                stack[stackCount++] = other;
                                other.m_flags |= 4;
                            }
                        }
                        cn = cn.next;
                    }
                    JointEdge jn = b2.m_jointList;
                    while (jn != null) {
                        if (!jn.joint.m_islandFlag) {
                            island.add(jn.joint);
                            jn.joint.m_islandFlag = true;
                            other = jn.other;
                            if ((other.m_flags & 4) <= 0) {
                                assert (stackCount < stackSize);
                                stack[stackCount++] = other;
                                other.m_flags |= 4;
                            }
                        }
                        jn = jn.next;
                    }
                }
                island.solve(step, this.m_gravity, ENABLE_POSITION_CORRECTION, this.m_allowSleep);
                this.m_positionIterationCount = Math.max(this.m_positionIterationCount, Island.m_positionIterationCount);
                int i = 0;
                while (i < island.m_bodyCount) {
                    Body b3 = island.m_bodies[i];
                    if (b3.isStatic()) {
                        b3.m_flags &= 0xFFFFFFFB;
                    }
                    ++i;
                }
            }
            seed = seed.m_next;
        }
        Body b4 = this.m_bodyList;
        while (b4 != null) {
            boolean inRange;
            if ((b4.m_flags & 0xA) == 0 && !b4.isStatic() && !(inRange = b4.synchronizeShapes()) && this.m_boundaryListener != null) {
                this.m_boundaryListener.violation(b4);
            }
            b4 = b4.getNext();
        }
        this.m_broadPhase.commit();
    }

    public void solveTOI(TimeStep step) {
        Island island = new Island(this.m_bodyCount, Settings.maxTOIContactsPerIsland, 0, this.m_contactListener);
        int stackSize = this.m_bodyCount;
        Body[] stack = new Body[stackSize];
        Body b = this.m_bodyList;
        while (b != null) {
            b.m_flags &= 0xFFFFFFFB;
            b.m_sweep.t0 = 0.0f;
            b = b.m_next;
        }
        Contact c = this.m_contactList;
        while (c != null) {
            c.m_flags &= 0xFFFFFFF3;
            c = c.m_next;
        }
        while (true) {
            Contact minContact = null;
            float minTOI = 1.0f;
            Contact c2 = this.m_contactList;
            while (c2 != null) {
                block27: {
                    float toi;
                    block29: {
                        block28: {
                            if ((c2.m_flags & 3) != 0) break block27;
                            toi = 1.0f;
                            if ((c2.m_flags & 8) == 0) break block28;
                            toi = c2.m_toi;
                            break block29;
                        }
                        Shape s1 = c2.getShape1();
                        Shape s2 = c2.getShape2();
                        Body b1 = s1.getBody();
                        Body b2 = s2.getBody();
                        if (!(!b1.isStatic() && !b1.isSleeping() || !b2.isStatic() && !b2.isSleeping())) break block27;
                        float t0 = b1.m_sweep.t0;
                        if (b1.m_sweep.t0 < b2.m_sweep.t0) {
                            t0 = b2.m_sweep.t0;
                            b1.m_sweep.advance(t0);
                        } else if (b2.m_sweep.t0 < b1.m_sweep.t0) {
                            t0 = b1.m_sweep.t0;
                            b2.m_sweep.advance(t0);
                        }
                        assert (t0 < 1.0f);
                        toi = TOI.timeOfImpact(c2.m_shape1, b1.m_sweep, c2.m_shape2, b2.m_sweep);
                        assert (0.0f <= toi && toi <= 1.0f);
                        if (toi > 0.0f && toi < 1.0f) {
                            toi = Math.min((1.0f - toi) * t0 + toi, 1.0f);
                        }
                        c2.m_toi = toi;
                        c2.m_flags |= 8;
                    }
                    if (1.1920929E-7f < toi && toi < minTOI) {
                        minContact = c2;
                        minTOI = toi;
                    }
                }
                c2 = c2.m_next;
            }
            if (minContact == null || 0.9999881f < minTOI) break;
            Shape s1 = minContact.getShape1();
            Shape s2 = minContact.getShape2();
            Body b1 = s1.getBody();
            Body b2 = s2.getBody();
            b1.advance(minTOI);
            b2.advance(minTOI);
            minContact.update(this.m_contactListener);
            minContact.m_flags &= 0xFFFFFFF7;
            if (minContact.getManifoldCount() == 0) continue;
            Body seed = b1;
            if (seed.isStatic()) {
                seed = b2;
            }
            island.clear();
            int stackCount = 0;
            stack[stackCount++] = seed;
            seed.m_flags |= 4;
            while (stackCount > 0) {
                Body b3 = stack[--stackCount];
                island.add(b3);
                b3.m_flags &= 0xFFFFFFF7;
                if (b3.isStatic()) continue;
                ContactEdge cn = b3.m_contactList;
                while (cn != null) {
                    if (island.m_contactCount != island.m_contactCapacity && (cn.contact.m_flags & 7) == 0 && cn.contact.getManifoldCount() != 0) {
                        island.add(cn.contact);
                        cn.contact.m_flags |= 4;
                        Body other = cn.other;
                        if ((other.m_flags & 4) == 0) {
                            if (!other.isStatic()) {
                                other.advance(minTOI);
                                other.wakeUp();
                            }
                            assert (stackCount < stackSize);
                            stack[stackCount++] = other;
                            other.m_flags |= 4;
                        }
                    }
                    cn = cn.next;
                }
            }
            TimeStep subStep = new TimeStep();
            subStep.dt = (1.0f - minTOI) * step.dt;
            assert (subStep.dt > 1.1920929E-7f);
            subStep.inv_dt = 1.0f / subStep.dt;
            subStep.maxIterations = step.maxIterations;
            island.solveTOI(subStep);
            int i = 0;
            while (i < island.m_bodyCount) {
                Body b4 = island.m_bodies[i];
                b4.m_flags &= 0xFFFFFFFB;
                if ((b4.m_flags & 0xA) == 0 && !b4.isStatic()) {
                    boolean inRange = b4.synchronizeShapes();
                    if (!inRange && this.m_boundaryListener != null) {
                        this.m_boundaryListener.violation(b4);
                    }
                    ContactEdge cn = b4.m_contactList;
                    while (cn != null) {
                        cn.contact.m_flags &= 0xFFFFFFF7;
                        cn = cn.next;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < island.m_contactCount) {
                Contact c3 = island.m_contacts[i];
                c3.m_flags &= 0xFFFFFFF3;
                ++i;
            }
            this.m_broadPhase.commit();
        }
    }

    public void drawShape(Shape shape, XForm xf, Color3f color, boolean core) {
        Color3f coreColor = new Color3f(229.5f, 153.0f, 153.0f);
        if (shape.m_type == ShapeType.CIRCLE_SHAPE) {
            CircleShape circle = (CircleShape)shape;
            Vec2 center = XForm.mul(xf, circle.getLocalPosition());
            float radius = circle.getRadius();
            Vec2 axis = xf.R.col1;
            this.m_debugDraw.drawSolidCircle(center, radius, axis, color);
            if (core) {
                this.m_debugDraw.drawCircle(center, radius - 0.04f, coreColor);
            }
        } else if (shape.m_type == ShapeType.POLYGON_SHAPE) {
            PolygonShape poly = (PolygonShape)shape;
            int vertexCount = poly.getVertexCount();
            Vec2[] localVertices = poly.getVertices();
            assert (vertexCount <= 8);
            Vec2[] vertices = new Vec2[8];
            int i = 0;
            while (i < vertexCount) {
                vertices[i] = XForm.mul(xf, localVertices[i]);
                ++i;
            }
            this.m_debugDraw.drawSolidPolygon(vertices, vertexCount, color);
            if (core) {
                Vec2[] localCoreVertices = poly.getCoreVertices();
                int i2 = 0;
                while (i2 < vertexCount) {
                    vertices[i2] = XForm.mul(xf, localCoreVertices[i2]);
                    ++i2;
                }
                this.m_debugDraw.drawPolygon(vertices, vertexCount, coreColor);
            }
        }
    }

    public void drawJoint(Joint joint) {
        Body b1 = joint.getBody1();
        Body b2 = joint.getBody2();
        XForm xf1 = b1.getXForm();
        XForm xf2 = b2.getXForm();
        Vec2 x1 = xf1.position;
        Vec2 x2 = xf2.position;
        Vec2 p1 = joint.getAnchor1();
        Vec2 p2 = joint.getAnchor2();
        Color3f color = new Color3f(127.5f, 204.0f, 204.0f);
        JointType type = joint.getType();
        if (type == JointType.DISTANCE_JOINT) {
            this.m_debugDraw.drawSegment(p1, p2, color);
        } else if (type == JointType.PULLEY_JOINT) {
            PulleyJoint pulley = (PulleyJoint)joint;
            Vec2 s1 = pulley.getGroundAnchor1();
            Vec2 s2 = pulley.getGroundAnchor2();
            this.m_debugDraw.drawSegment(s1, p1, color);
            this.m_debugDraw.drawSegment(s2, p2, color);
            this.m_debugDraw.drawSegment(s1, s2, color);
        } else if (type != JointType.MOUSE_JOINT) {
            this.m_debugDraw.drawSegment(x1, p1, color);
            this.m_debugDraw.drawSegment(p1, p2, color);
            this.m_debugDraw.drawSegment(x2, p2, color);
        }
    }

    public void drawDebugData() {
        if (this.m_debugDraw == null) {
            return;
        }
        int flags = this.m_debugDraw.getFlags();
        if ((flags & 1) != 0) {
            boolean core = (flags & 4) == 4;
            Body b = this.m_bodyList;
            while (b != null) {
                XForm xf = b.getXForm();
                Shape s = b.getShapeList();
                while (s != null) {
                    if (b.isStatic()) {
                        this.drawShape(s, xf, new Color3f(127.5f, 229.5f, 127.5f), core);
                    } else if (b.isSleeping()) {
                        this.drawShape(s, xf, new Color3f(127.5f, 127.5f, 229.5f), core);
                    } else {
                        this.drawShape(s, xf, new Color3f(229.5f, 229.5f, 229.5f), core);
                    }
                    s = s.getNext();
                }
                b = b.getNext();
            }
        }
        if ((flags & 2) != 0) {
            Joint j = this.m_jointList;
            while (j != null) {
                if (j.getType() != JointType.MOUSE_JOINT) {
                    this.drawJoint(j);
                }
                j = j.getNext();
            }
        }
        if ((flags & 0x20) != 0) {
            BroadPhase bp = this.m_broadPhase;
            Vec2 invQ = new Vec2(0.0f, 0.0f);
            invQ.set(1.0f / bp.m_quantizationFactor.x, 1.0f / bp.m_quantizationFactor.y);
            Color3f color = new Color3f(229.5f, 229.5f, 76.5f);
            int i = 0;
            while (i < 16384) {
                int index = bp.m_pairManager.m_hashTable[i];
                while (index != Integer.MAX_VALUE) {
                    Pair pair = bp.m_pairManager.m_pairs[index];
                    Proxy p1 = bp.m_proxyPool[pair.proxyId1];
                    Proxy p2 = bp.m_proxyPool[pair.proxyId2];
                    AABB b1 = new AABB();
                    AABB b2 = new AABB();
                    b1.lowerBound.x = bp.m_worldAABB.lowerBound.x + invQ.x * (float)bp.m_bounds[0][p1.lowerBounds[0]].value;
                    b1.lowerBound.y = bp.m_worldAABB.lowerBound.y + invQ.y * (float)bp.m_bounds[1][p1.lowerBounds[1]].value;
                    b1.upperBound.x = bp.m_worldAABB.lowerBound.x + invQ.x * (float)bp.m_bounds[0][p1.upperBounds[0]].value;
                    b1.upperBound.y = bp.m_worldAABB.lowerBound.y + invQ.y * (float)bp.m_bounds[1][p1.upperBounds[1]].value;
                    b2.lowerBound.x = bp.m_worldAABB.lowerBound.x + invQ.x * (float)bp.m_bounds[0][p2.lowerBounds[0]].value;
                    b2.lowerBound.y = bp.m_worldAABB.lowerBound.y + invQ.y * (float)bp.m_bounds[1][p2.lowerBounds[1]].value;
                    b2.upperBound.x = bp.m_worldAABB.lowerBound.x + invQ.x * (float)bp.m_bounds[0][p2.upperBounds[0]].value;
                    b2.upperBound.y = bp.m_worldAABB.lowerBound.y + invQ.y * (float)bp.m_bounds[1][p2.upperBounds[1]].value;
                    Vec2 x1 = new Vec2(0.5f * (b1.lowerBound.x + b1.upperBound.x), 0.5f * (b1.lowerBound.y + b1.upperBound.y));
                    Vec2 x2 = new Vec2(0.5f * (b2.lowerBound.x + b2.upperBound.x), 0.5f * (b2.lowerBound.y + b2.upperBound.y));
                    this.m_debugDraw.drawSegment(x1, x2, color);
                    index = pair.next;
                }
                ++i;
            }
        }
        BroadPhase bp = this.m_broadPhase;
        Vec2 worldLower = bp.m_worldAABB.lowerBound;
        Vec2 worldUpper = bp.m_worldAABB.upperBound;
        if ((flags & 8) != 0) {
            Vec2 invQ = new Vec2();
            invQ.set(1.0f / bp.m_quantizationFactor.x, 1.0f / bp.m_quantizationFactor.y);
            Color3f color = new Color3f(229.5f, 76.5f, 229.5f);
            int i = 0;
            while (i < 2048) {
                Proxy p = bp.m_proxyPool[i];
                if (p.isValid()) {
                    AABB b = new AABB();
                    b.lowerBound.x = worldLower.x + invQ.x * (float)bp.m_bounds[0][p.lowerBounds[0]].value;
                    b.lowerBound.y = worldLower.y + invQ.y * (float)bp.m_bounds[1][p.lowerBounds[1]].value;
                    b.upperBound.x = worldLower.x + invQ.x * (float)bp.m_bounds[0][p.upperBounds[0]].value;
                    b.upperBound.y = worldLower.y + invQ.y * (float)bp.m_bounds[1][p.upperBounds[1]].value;
                    Vec2[] vs = new Vec2[]{new Vec2(b.lowerBound.x, b.lowerBound.y), new Vec2(b.upperBound.x, b.lowerBound.y), new Vec2(b.upperBound.x, b.upperBound.y), new Vec2(b.lowerBound.x, b.upperBound.y)};
                    this.m_debugDraw.drawPolygon(vs, 4, color);
                }
                ++i;
            }
        }
        Vec2[] vsw = new Vec2[]{new Vec2(worldLower.x, worldLower.y), new Vec2(worldUpper.x, worldLower.y), new Vec2(worldUpper.x, worldUpper.y), new Vec2(worldLower.x, worldUpper.y)};
        this.m_debugDraw.drawPolygon(vsw, 4, new Color3f(76.5f, 229.5f, 229.5f));
        if ((flags & 0x10) != 0) {
            Color3f color = new Color3f(0.5f, 0.3f, 0.5f);
            Body b = this.m_bodyList;
            while (b != null) {
                XForm xf = b.getXForm();
                Shape s = b.getShapeList();
                while (s != null) {
                    if (s.getType() == ShapeType.POLYGON_SHAPE) {
                        PolygonShape poly = (PolygonShape)s;
                        OBB obb = poly.getOBB();
                        Vec2 h = obb.extents;
                        Vec2[] vs = new Vec2[]{new Vec2(-h.x, -h.y), new Vec2(h.x, -h.y), new Vec2(h.x, h.y), new Vec2(-h.x, h.y)};
                        int i = 0;
                        while (i < 4) {
                            vs[i] = obb.center.add(Mat22.mul(obb.R, vs[i]));
                            vs[i] = XForm.mul(xf, vs[i]);
                            ++i;
                        }
                        this.m_debugDraw.drawPolygon(vs, 4, color);
                    }
                    s = s.getNext();
                }
                b = b.getNext();
            }
        }
        if ((flags & 0x40) != 0) {
            Body b = this.m_bodyList;
            while (b != null) {
                XForm xf = b.getXForm();
                xf.position = b.getWorldCenter();
                this.m_debugDraw.drawXForm(xf);
                b = b.getNext();
            }
        }
    }
}

