/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.common;

import org.jbox2d.common.Mat22;
import org.jbox2d.common.Vec2;

public class XForm {
    public Vec2 position;
    public Mat22 R;
    public static XForm identity = new XForm();

    static {
        identity.setIdentity();
    }

    public XForm() {
        this.position = new Vec2();
        this.R = new Mat22();
    }

    public XForm(XForm xf) {
        this.position = xf.position.clone();
        this.R = xf.R.clone();
    }

    public XForm(Vec2 _position, Mat22 _R) {
        this.position = _position.clone();
        this.R = _R.clone();
    }

    public void set(XForm xf) {
        this.position.set(xf.position);
        this.R.set(xf.R);
    }

    public void setIdentity() {
        this.position.setZero();
        this.R.setIdentity();
    }

    public static Vec2 mul(XForm T, Vec2 v) {
        return T.position.add(T.R.mul(v));
    }

    public static Vec2 mulT(XForm T, Vec2 v) {
        return T.R.mulT(v.sub(T.position));
    }

    public String toString() {
        String s = "XForm:\n";
        s = String.valueOf(s) + "Position: " + this.position + "\n";
        s = String.valueOf(s) + "R: \n" + this.R + "\n";
        return s;
    }
}

