/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import org.jbox2d.collision.AABB;
import org.jbox2d.collision.BroadPhase;
import org.jbox2d.collision.CircleShape;
import org.jbox2d.collision.MassData;
import org.jbox2d.collision.PolygonShape;
import org.jbox2d.collision.ShapeDef;
import org.jbox2d.collision.ShapeType;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;
import org.jbox2d.dynamics.Body;

public abstract class Shape {
    public int uid = uidcount++;
    private static int uidcount = 0;
    public ShapeType m_type;
    public Shape m_next;
    public Body m_body;
    public float m_sweepRadius;
    public float m_density;
    public float m_friction;
    public float m_restitution;
    public int m_proxyId;
    public int m_categoryBits;
    public int m_maskBits;
    public int m_groupIndex;
    public boolean m_isSensor;
    public Object m_userData;

    public Shape(ShapeDef def) {
        this.m_userData = def.userData;
        this.m_friction = def.friction;
        this.m_restitution = def.restitution;
        this.m_density = def.density;
        this.m_body = null;
        this.m_sweepRadius = 0.0f;
        this.m_next = null;
        this.m_proxyId = Integer.MAX_VALUE;
        this.m_categoryBits = def.categoryBits;
        this.m_maskBits = def.maskBits;
        this.m_groupIndex = def.groupIndex;
        this.m_isSensor = def.isSensor;
    }

    public ShapeType getType() {
        return this.m_type;
    }

    public boolean isSensor() {
        return this.m_isSensor;
    }

    public Object getUserData() {
        return this.m_userData;
    }

    public Body getBody() {
        return this.m_body;
    }

    public Shape getNext() {
        return this.m_next;
    }

    public float getSweepRadius() {
        return this.m_sweepRadius;
    }

    public abstract boolean testPoint(XForm var1, Vec2 var2);

    public abstract void computeAABB(AABB var1, XForm var2);

    public abstract void computeSweptAABB(AABB var1, XForm var2, XForm var3);

    public abstract void computeMass(MassData var1);

    public abstract void updateSweepRadius(Vec2 var1);

    public boolean synchronize(BroadPhase broadPhase, XForm transform1, XForm transform2) {
        if (this.m_proxyId == Integer.MAX_VALUE) {
            return false;
        }
        AABB aabb = new AABB();
        this.computeSweptAABB(aabb, transform1, transform2);
        if (broadPhase.inRange(aabb)) {
            broadPhase.moveProxy(this.m_proxyId, aabb);
            return true;
        }
        return false;
    }

    public void resetProxy(BroadPhase broadPhase, XForm transform) {
        if (this.m_proxyId != Integer.MAX_VALUE) {
            broadPhase.destroyProxy(this.m_proxyId);
        }
        AABB aabb = new AABB();
        this.computeAABB(aabb, transform);
        boolean inRange = broadPhase.inRange(aabb);
        assert (inRange);
        this.m_proxyId = inRange ? broadPhase.createProxy(aabb, this) : Integer.MAX_VALUE;
    }

    public static Shape create(ShapeDef def) {
        if (def.type == ShapeType.CIRCLE_SHAPE) {
            return new CircleShape(def);
        }
        if (def.type == ShapeType.BOX_SHAPE || def.type == ShapeType.POLYGON_SHAPE) {
            return new PolygonShape(def);
        }
        assert (false);
        return null;
    }

    public static void destroy(Shape s) {
        s.destructor();
    }

    public void destructor() {
        assert (this.m_proxyId == Integer.MAX_VALUE);
    }

    public void createProxy(BroadPhase broadPhase, XForm transform) {
        assert (this.m_proxyId == Integer.MAX_VALUE);
        AABB aabb = new AABB();
        this.computeAABB(aabb, transform);
        boolean inRange = broadPhase.inRange(aabb);
        assert (inRange);
        this.m_proxyId = inRange ? broadPhase.createProxy(aabb, this) : Integer.MAX_VALUE;
    }

    public void destroyProxy(BroadPhase broadPhase) {
        if (this.m_proxyId != Integer.MAX_VALUE) {
            broadPhase.destroyProxy(this.m_proxyId);
            this.m_proxyId = Integer.MAX_VALUE;
        }
    }
}

