/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import java.util.List;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.MassData;
import org.jbox2d.collision.OBB;
import org.jbox2d.collision.PolygonDef;
import org.jbox2d.collision.Shape;
import org.jbox2d.collision.ShapeDef;
import org.jbox2d.collision.ShapeType;
import org.jbox2d.collision.SupportsGenericDistance;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolygonShape
extends Shape
implements SupportsGenericDistance {
    private static boolean m_debug = true;
    public Vec2 m_centroid;
    public OBB m_obb;
    public Vec2[] m_vertices;
    public Vec2[] m_normals;
    public Vec2[] m_coreVertices;
    public int m_vertexCount;

    public PolygonShape(ShapeDef def) {
        super(def);
        int i2;
        int i1;
        assert (def.type == ShapeType.POLYGON_SHAPE);
        this.m_type = ShapeType.POLYGON_SHAPE;
        PolygonDef poly = (PolygonDef)def;
        this.m_vertexCount = poly.vertexCount();
        this.m_vertices = new Vec2[this.m_vertexCount];
        this.m_normals = new Vec2[this.m_vertexCount];
        this.m_coreVertices = new Vec2[this.m_vertexCount];
        this.m_obb = new OBB();
        assert (3 <= this.m_vertexCount && this.m_vertexCount <= 8);
        int i = 0;
        while (i < this.m_vertexCount) {
            this.m_vertices[i] = poly.vertices.get(i).clone();
            ++i;
        }
        i = 0;
        while (i < this.m_vertexCount) {
            i1 = i;
            i2 = i + 1 < this.m_vertexCount ? i + 1 : 0;
            Vec2 edge = this.m_vertices[i2].sub(this.m_vertices[i1]);
            assert (edge.lengthSquared() > 1.4210855E-14f);
            this.m_normals[i] = Vec2.cross(edge, 1.0f);
            this.m_normals[i].normalize();
            ++i;
        }
        if (m_debug) {
            i = 0;
            while (i < this.m_vertexCount) {
                int j = 0;
                while (j < this.m_vertexCount) {
                    if (j != i && j != (i + 1) % this.m_vertexCount) {
                        float s = Vec2.dot(this.m_normals[i], this.m_vertices[j].sub(this.m_vertices[i]));
                        assert (s < -0.005f);
                    }
                    ++j;
                }
                ++i;
            }
            i = 1;
            while (i < this.m_vertexCount) {
                float cross = Vec2.cross(this.m_normals[i - 1], this.m_normals[i]);
                cross = MathUtils.clamp(cross, -1.0f, 1.0f);
                float angle = (float)Math.asin(cross);
                assert (angle > 0.03490659f);
                ++i;
            }
        }
        this.m_centroid = PolygonShape.computeCentroid(poly.vertices);
        PolygonShape.computeOBB(this.m_obb, this.m_vertices);
        i = 0;
        while (i < this.m_vertexCount) {
            i1 = i - 1 >= 0 ? i - 1 : this.m_vertexCount - 1;
            i2 = i;
            Vec2 n1 = this.m_normals[i1];
            Vec2 n2 = this.m_normals[i2];
            Vec2 v = this.m_vertices[i].sub(this.m_centroid);
            Vec2 d = new Vec2();
            d.x = Vec2.dot(n1, v) - 0.04f;
            d.y = Vec2.dot(n2, v) - 0.04f;
            if (m_debug && (d.x < 0.0f || d.y < 0.0f)) {
                System.out.println("Error, dumping details: ");
                System.out.println("d.x: " + d.x + "d.y: " + d.y);
                System.out.println("n1: " + n1 + "; n2: " + n2);
                System.out.println("v: " + v);
            }
            assert (d.x >= 0.0f);
            assert (d.y >= 0.0f);
            Mat22 A = new Mat22();
            A.col1.x = n1.x;
            A.col2.x = n1.y;
            A.col1.y = n2.x;
            A.col2.y = n2.y;
            this.m_coreVertices[i] = A.solve(d).addLocal(this.m_centroid);
            ++i;
        }
        if (m_debug) {
            System.out.println("\nDumping polygon shape...");
            System.out.println("Vertices: ");
            i = 0;
            while (i < this.m_vertexCount) {
                System.out.println(this.m_vertices[i]);
                ++i;
            }
            System.out.println("Core Vertices: ");
            i = 0;
            while (i < this.m_vertexCount) {
                System.out.println(this.m_coreVertices[i]);
                ++i;
            }
            System.out.println("Normals: ");
            i = 0;
            while (i < this.m_vertexCount) {
                System.out.println(this.m_normals[i]);
                ++i;
            }
            System.out.println("Centroid: " + this.m_centroid);
        }
    }

    @Override
    public void updateSweepRadius(Vec2 center) {
        this.m_sweepRadius = 0.0f;
        int i = 0;
        while (i < this.m_vertexCount) {
            Vec2 d = this.m_coreVertices[i].sub(center);
            this.m_sweepRadius = Math.max(this.m_sweepRadius, d.length());
            ++i;
        }
    }

    @Override
    public boolean testPoint(XForm xf, Vec2 p) {
        int i;
        Vec2 pLocal = Mat22.mulT(xf.R, p.sub(xf.position));
        if (m_debug) {
            System.out.println("--testPoint debug--");
            System.out.println("Vertices: ");
            i = 0;
            while (i < this.m_vertexCount) {
                System.out.println(this.m_vertices[i]);
                ++i;
            }
            System.out.println("pLocal: " + pLocal);
        }
        i = 0;
        while (i < this.m_vertexCount) {
            float dot = Vec2.dot(this.m_normals[i], pLocal.sub(this.m_vertices[i]));
            if (dot > 0.0f) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Vec2 centroid(XForm xf) {
        return XForm.mul(xf, this.m_centroid);
    }

    @Override
    public Vec2 support(XForm xf, Vec2 d) {
        Vec2 dLocal = Mat22.mulT(xf.R, d);
        int bestIndex = 0;
        float bestValue = Vec2.dot(this.m_coreVertices[0], dLocal);
        int i = 1;
        while (i < this.m_vertexCount) {
            float value = Vec2.dot(this.m_coreVertices[i], dLocal);
            if (value > bestValue) {
                bestIndex = i;
                bestValue = value;
            }
            ++i;
        }
        return XForm.mul(xf, this.m_coreVertices[bestIndex]);
    }

    public static Vec2 computeCentroid(List<Vec2> vs) {
        int count = vs.size();
        assert (count >= 3);
        Vec2 c = new Vec2();
        float area = 0.0f;
        Vec2 pRef = new Vec2();
        float inv3 = 0.33333334f;
        int i = 0;
        while (i < count) {
            Vec2 p1 = pRef;
            Vec2 p2 = vs.get(i);
            Vec2 p3 = i + 1 < count ? vs.get(i + 1) : vs.get(0);
            Vec2 e1 = p2.sub(p1);
            Vec2 e2 = p3.sub(p1);
            float D = Vec2.cross(e1, e2);
            float triangleArea = 0.5f * D;
            area += triangleArea;
            c.x += triangleArea * 0.33333334f * (p1.x + p2.x + p3.x);
            c.y += triangleArea * 0.33333334f * (p1.y + p2.y + p3.y);
            ++i;
        }
        assert (area > 1.1920929E-7f);
        c.mulLocal(1.0f / area);
        return c;
    }

    public static void computeOBB(OBB obb, Vec2[] vs) {
        int count = vs.length;
        assert (count <= 8);
        Vec2[] p = new Vec2[9];
        int i = 0;
        while (i < count) {
            p[i] = vs[i];
            ++i;
        }
        p[count] = p[0];
        float minArea = Float.MAX_VALUE;
        int i2 = 1;
        while (i2 <= count) {
            Vec2 root = p[i2 - 1];
            Vec2 ux = p[i2].sub(root);
            float length = ux.normalize();
            assert (length > 1.1920929E-7f);
            Vec2 uy = new Vec2(-ux.y, ux.x);
            Vec2 lower = new Vec2(Float.MAX_VALUE, Float.MAX_VALUE);
            Vec2 upper = new Vec2(-3.4028235E38f, -3.4028235E38f);
            int j = 0;
            while (j < count) {
                Vec2 d = p[j].sub(root);
                Vec2 r = new Vec2();
                r.x = Vec2.dot(ux, d);
                r.y = Vec2.dot(uy, d);
                lower = Vec2.min(lower, r);
                upper = Vec2.max(upper, r);
                ++j;
            }
            float area = (upper.x - lower.x) * (upper.y - lower.y);
            if (area < 0.95f * minArea) {
                minArea = area;
                obb.R.col1.set(ux);
                obb.R.col2.set(uy);
                Vec2 center = new Vec2(0.5f * (lower.x + upper.x), 0.5f * (lower.y + upper.y));
                obb.center = root.add(Mat22.mul(obb.R, center));
                obb.extents = new Vec2(0.5f * (upper.x - lower.x), 0.5f * (upper.y - lower.y));
            }
            ++i2;
        }
        assert (minArea < Float.MAX_VALUE);
    }

    @Override
    public void computeAABB(AABB aabb, XForm xf) {
        Mat22 R = Mat22.mul(xf.R, this.m_obb.R);
        Mat22 absR = Mat22.abs(R);
        Vec2 h = Mat22.mul(absR, this.m_obb.extents);
        Vec2 position = xf.position.add(Mat22.mul(xf.R, this.m_obb.center));
        aabb.lowerBound = position.sub(h);
        aabb.upperBound = position.add(h);
    }

    @Override
    public void computeSweptAABB(AABB aabb, XForm transform1, XForm transform2) {
        AABB aabb1 = new AABB();
        AABB aabb2 = new AABB();
        this.computeAABB(aabb1, transform1);
        this.computeAABB(aabb2, transform2);
        aabb.lowerBound = Vec2.min(aabb1.lowerBound, aabb2.lowerBound);
        aabb.upperBound = Vec2.max(aabb1.upperBound, aabb2.upperBound);
    }

    @Override
    public void computeMass(MassData massData) {
        assert (this.m_vertexCount >= 3);
        Vec2 center = new Vec2(0.0f, 0.0f);
        float area = 0.0f;
        float I = 0.0f;
        Vec2 pRef = new Vec2(0.0f, 0.0f);
        float k_inv3 = 0.33333334f;
        int i = 0;
        while (i < this.m_vertexCount) {
            Vec2 p1 = pRef;
            Vec2 p2 = this.m_vertices[i];
            Vec2 p3 = i + 1 < this.m_vertexCount ? this.m_vertices[i + 1] : this.m_vertices[0];
            Vec2 e1 = p2.sub(p1);
            Vec2 e2 = p3.sub(p1);
            float D = Vec2.cross(e1, e2);
            float triangleArea = 0.5f * D;
            area += triangleArea;
            center.x += triangleArea * k_inv3 * (p1.x + p2.x + p3.x);
            center.y += triangleArea * k_inv3 * (p1.y + p2.y + p3.y);
            float px = p1.x;
            float py = p1.y;
            float ex1 = e1.x;
            float ey1 = e1.y;
            float ex2 = e2.x;
            float ey2 = e2.y;
            float intx2 = k_inv3 * (0.25f * (ex1 * ex1 + ex2 * ex1 + ex2 * ex2) + (px * ex1 + px * ex2)) + 0.5f * px * px;
            float inty2 = k_inv3 * (0.25f * (ey1 * ey1 + ey2 * ey1 + ey2 * ey2) + (py * ey1 + py * ey2)) + 0.5f * py * py;
            I += D * (intx2 + inty2);
            ++i;
        }
        massData.mass = this.m_density * area;
        assert (area > 1.1920929E-7f);
        center.mulLocal(1.0f / area);
        massData.center = center.clone();
        massData.I = I * this.m_density;
    }

    @Override
    public Vec2 getFirstVertex(XForm xf) {
        return XForm.mul(xf, this.m_coreVertices[0]);
    }

    public OBB getOBB() {
        return this.m_obb.clone();
    }

    public Vec2 getCentroid() {
        return this.m_centroid.clone();
    }

    public int getVertexCount() {
        return this.m_vertexCount;
    }

    public Vec2[] getVertices() {
        return this.m_vertices;
    }

    public Vec2[] getCoreVertices() {
        return this.m_coreVertices;
    }
}

