/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import java.util.ArrayList;
import java.util.List;
import org.jbox2d.collision.ShapeDef;
import org.jbox2d.collision.ShapeType;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;

public class PolygonDef
extends ShapeDef {
    public List<Vec2> vertices;

    public PolygonDef() {
        this.type = ShapeType.POLYGON_SHAPE;
        this.vertices = new ArrayList<Vec2>();
    }

    public void setAsBox(float hx, float hy) {
        this.vertices.clear();
        this.vertices.add(new Vec2(-hx, -hy));
        this.vertices.add(new Vec2(hx, -hy));
        this.vertices.add(new Vec2(hx, hy));
        this.vertices.add(new Vec2(-hx, hy));
    }

    public void setAsBox(float hx, float hy, Vec2 center, float angle) {
        this.setAsBox(hx, hy);
        XForm xf = new XForm();
        xf.position.set(center);
        xf.R.set(angle);
        int i = 0;
        while (i < this.vertices.size()) {
            this.vertices.get(i).set(XForm.mul(xf, this.vertices.get(i)));
            ++i;
        }
    }

    public int vertexCount() {
        return this.vertices.size();
    }
}

