/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import org.jbox2d.collision.ContactID;
import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.ManifoldPoint;
import org.jbox2d.collision.MaxSeparation;
import org.jbox2d.collision.PolygonShape;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;

public class CollidePoly {
    static int clipSegmentToLine(ClipVertex[] vOut, ClipVertex[] vIn, Vec2 normal, float offset) {
        int numOut = 0;
        float distance0 = Vec2.dot(normal, vIn[0].v) - offset;
        float distance1 = Vec2.dot(normal, vIn[1].v) - offset;
        if (distance0 <= 0.0f) {
            vOut[numOut] = new ClipVertex();
            vOut[numOut].id = new ContactID(vIn[0].id);
            vOut[numOut++].v = vIn[0].v.clone();
        }
        if (distance1 <= 0.0f) {
            vOut[numOut] = new ClipVertex();
            vOut[numOut].id = new ContactID(vIn[1].id);
            vOut[numOut++].v = vIn[1].v.clone();
        }
        if (distance0 * distance1 < 0.0f) {
            float interp = distance0 / (distance0 - distance1);
            vOut[numOut] = new ClipVertex();
            vOut[numOut].v.x = vIn[0].v.x + interp * (vIn[1].v.x - vIn[0].v.x);
            vOut[numOut].v.y = vIn[0].v.y + interp * (vIn[1].v.y - vIn[0].v.y);
            vOut[numOut].id = distance0 > 0.0f ? new ContactID(vIn[0].id) : new ContactID(vIn[1].id);
            ++numOut;
        }
        return numOut;
    }

    static float edgeSeparation(PolygonShape poly1, XForm xf1, int edge1, PolygonShape poly2, XForm xf2) {
        assert (edge1 >= 0 && edge1 < poly1.m_vertexCount);
        Vec2 normal1World = Mat22.mul(xf1.R, poly1.m_normals[edge1]);
        Vec2 normal1 = Mat22.mulT(xf2.R, normal1World);
        int index = 0;
        float minDot = Float.MAX_VALUE;
        int i = 0;
        while (i < poly2.m_vertexCount) {
            float dot = Vec2.dot(poly2.m_vertices[i], normal1);
            if (dot < minDot) {
                minDot = dot;
                index = i;
            }
            ++i;
        }
        Vec2 v1 = XForm.mul(xf1, poly1.m_vertices[edge1]);
        Vec2 v2 = XForm.mul(xf2, poly2.m_vertices[index]);
        float separation = Vec2.dot(v2.sub(v1), normal1World);
        return separation;
    }

    static MaxSeparation findMaxSeparation(PolygonShape poly1, XForm xf1, PolygonShape poly2, XForm xf2) {
        float bestSeparation;
        int bestEdge;
        int increment;
        MaxSeparation separation = new MaxSeparation();
        int count1 = poly1.m_vertexCount;
        Vec2 d = XForm.mul(xf2, poly2.m_centroid).subLocal(XForm.mul(xf1, poly1.m_centroid));
        Vec2 dLocal1 = Mat22.mulT(xf1.R, d);
        int edge = 0;
        float maxDot = -3.4028235E38f;
        int i = 0;
        while (i < count1) {
            float dot = Vec2.dot(poly1.m_normals[i], dLocal1);
            if (dot > maxDot) {
                maxDot = dot;
                edge = i;
            }
            ++i;
        }
        float s = CollidePoly.edgeSeparation(poly1, xf1, edge, poly2, xf2);
        if (s > 0.0f) {
            separation.bestSeparation = s;
            return separation;
        }
        int prevEdge = edge - 1 >= 0 ? edge - 1 : count1 - 1;
        float sPrev = CollidePoly.edgeSeparation(poly1, xf1, prevEdge, poly2, xf2);
        if (sPrev > 0.0f) {
            separation.bestSeparation = sPrev;
            return separation;
        }
        int nextEdge = edge + 1 < count1 ? edge + 1 : 0;
        float sNext = CollidePoly.edgeSeparation(poly1, xf1, nextEdge, poly2, xf2);
        if (sNext > 0.0f) {
            separation.bestSeparation = sNext;
            return separation;
        }
        if (sPrev > s && sPrev > sNext) {
            increment = -1;
            bestEdge = prevEdge;
            bestSeparation = sPrev;
        } else if (sNext > s) {
            increment = 1;
            bestEdge = nextEdge;
            bestSeparation = sNext;
        } else {
            separation.bestFaceIndex = edge;
            separation.bestSeparation = s;
            return separation;
        }
        while (true) {
            if ((s = CollidePoly.edgeSeparation(poly1, xf1, edge = increment == -1 ? (bestEdge - 1 >= 0 ? bestEdge - 1 : count1 - 1) : (bestEdge + 1 < count1 ? bestEdge + 1 : 0), poly2, xf2)) > 0.0f) {
                separation.bestSeparation = s;
                return separation;
            }
            if (!(s > bestSeparation)) break;
            bestEdge = edge;
            bestSeparation = s;
        }
        separation.bestFaceIndex = bestEdge;
        separation.bestSeparation = bestSeparation;
        return separation;
    }

    static void findIncidentEdge(ClipVertex[] c, PolygonShape poly1, XForm xf1, int edge1, PolygonShape poly2, XForm xf2) {
        assert (edge1 >= 0 && edge1 < poly1.m_vertexCount);
        Vec2 normal1 = Mat22.mulT(xf2.R, Mat22.mul(xf1.R, poly1.m_normals[edge1]));
        int index = 0;
        float minDot = Float.MAX_VALUE;
        int i = 0;
        while (i < poly2.m_vertexCount) {
            float dot = Vec2.dot(normal1, poly2.m_normals[i]);
            if (dot < minDot) {
                minDot = dot;
                index = i;
            }
            ++i;
        }
        int i1 = index;
        int i2 = i1 + 1 < poly2.m_vertexCount ? i1 + 1 : 0;
        c[0] = new ClipVertex();
        c[1] = new ClipVertex();
        c[0].v = XForm.mul(xf2, poly2.m_vertices[i1]);
        c[0].id.features.referenceFace = edge1;
        c[0].id.features.incidentEdge = i1;
        c[0].id.features.incidentVertex = 0;
        c[1].v = XForm.mul(xf2, poly2.m_vertices[i2]);
        c[1].id.features.referenceFace = edge1;
        c[1].id.features.incidentEdge = i2;
        c[1].id.features.incidentVertex = 1;
    }

    public static void collidePoly(Manifold manif, PolygonShape polyA, XForm xfA, PolygonShape polyB, XForm xfB) {
        int flip;
        int edge1;
        PolygonShape poly2;
        PolygonShape poly1;
        manif.pointCount = 0;
        MaxSeparation sepA = CollidePoly.findMaxSeparation(polyA, xfA, polyB, xfB);
        if (sepA.bestSeparation > 0.0f) {
            return;
        }
        MaxSeparation sepB = CollidePoly.findMaxSeparation(polyB, xfB, polyA, xfA);
        if (sepB.bestSeparation > 0.0f) {
            return;
        }
        XForm xf1 = new XForm();
        XForm xf2 = new XForm();
        float k_relativeTol = 0.98f;
        float k_absoluteTol = 0.001f;
        if (sepB.bestSeparation > k_relativeTol * sepA.bestSeparation + k_absoluteTol) {
            poly1 = polyB;
            poly2 = polyA;
            xf1.set(xfB);
            xf2.set(xfA);
            edge1 = sepB.bestFaceIndex;
            flip = 1;
        } else {
            poly1 = polyA;
            poly2 = polyB;
            xf1.set(xfA);
            xf2.set(xfB);
            edge1 = sepA.bestFaceIndex;
            flip = 0;
        }
        ClipVertex[] incidentEdge = new ClipVertex[2];
        CollidePoly.findIncidentEdge(incidentEdge, poly1, xf1, edge1, poly2, xf2);
        int count1 = poly1.m_vertexCount;
        Vec2[] vert1s = poly1.m_vertices;
        Vec2 v11 = vert1s[edge1];
        Vec2 v12 = edge1 + 1 < count1 ? vert1s[edge1 + 1] : vert1s[0];
        Vec2 sideNormal = Mat22.mul(xf1.R, v12.sub(v11));
        sideNormal.normalize();
        Vec2 frontNormal = Vec2.cross(sideNormal, 1.0f);
        v11 = XForm.mul(xf1, v11);
        v12 = XForm.mul(xf1, v12);
        float frontOffset = Vec2.dot(frontNormal, v11);
        float sideOffset1 = -Vec2.dot(sideNormal, v11);
        float sideOffset2 = Vec2.dot(sideNormal, v12);
        ClipVertex[] clipPoints1 = new ClipVertex[2];
        ClipVertex[] clipPoints2 = new ClipVertex[2];
        int np = CollidePoly.clipSegmentToLine(clipPoints1, incidentEdge, sideNormal.negate(), sideOffset1);
        if (np < 2) {
            return;
        }
        np = CollidePoly.clipSegmentToLine(clipPoints2, clipPoints1, sideNormal, sideOffset2);
        if (np < 2) {
            return;
        }
        manif.normal = flip != 0 ? frontNormal.negate() : frontNormal.clone();
        int pointCount = 0;
        int i = 0;
        while (i < 2) {
            float separation = Vec2.dot(frontNormal, clipPoints2[i].v) - frontOffset;
            if (separation <= 0.0f) {
                ManifoldPoint cp = manif.points[pointCount];
                cp.separation = separation;
                cp.localPoint1 = XForm.mulT(xfA, clipPoints2[i].v);
                cp.localPoint2 = XForm.mulT(xfB, clipPoints2[i].v);
                cp.id = new ContactID(clipPoints2[i].id);
                cp.id.features.flip = flip;
                ++pointCount;
            }
            ++i;
        }
        manif.pointCount = pointCount;
    }

    static class ClipVertex {
        Vec2 v = new Vec2();
        ContactID id = new ContactID();
    }
}

