/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import processing.core.PGraphics;
import processing.core.PGraphics3D;
import processing.core.PMatrix;

public class PShape {
    int kind;
    PMatrix matrix;
    int[] opcode;
    int opcodeCount;
    float[][] data;
    int childCount;
    PShape[] children;
    static final int PATH = 1;
    static final int GROUP = 2;
    static final int RECT = 3;
    static final int ELLIPSE = 4;
    static final int VERTEX = 7;
    static final int CURVE = 5;
    static final int BEZIER = 6;
    public float x;
    public float y;
    public float px;
    public float py;

    public PShape() {
    }

    public PShape(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void draw(PGraphics g) {
        boolean flat = g instanceof PGraphics3D;
        if (this.matrix != null) {
            g.pushMatrix();
            if (flat) {
                g.applyMatrix(this.matrix.m00, this.matrix.m01, this.matrix.m02, this.matrix.m10, this.matrix.m11, this.matrix.m12);
            } else {
                g.applyMatrix(this.matrix.m00, this.matrix.m01, this.matrix.m02, this.matrix.m03, this.matrix.m10, this.matrix.m11, this.matrix.m12, this.matrix.m13, this.matrix.m20, this.matrix.m21, this.matrix.m22, this.matrix.m23, this.matrix.m30, this.matrix.m31, this.matrix.m32, this.matrix.m33);
            }
        }
        switch (this.kind) {
            case 1: {
                int i = 0;
                while (i < this.opcodeCount) {
                    switch (this.opcode[i]) {
                        default: 
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                break;
            }
        }
        if (this.matrix != null) {
            g.popMatrix();
        }
    }

    public void addChild(PShape who) {
    }

    public PShape createGroup() {
        PShape group = new PShape();
        group.kind = 2;
        this.addChild(group);
        return group;
    }

    public void translate(float tx, float ty) {
        this.translate(tx, ty, 0.0f);
    }

    public void translate(float tx, float ty, float tz) {
        this.checkMatrix();
        this.matrix.translate(tx, ty, 0.0f);
    }

    public void rotateX(float angle) {
        this.rotate(angle, 1.0f, 0.0f, 0.0f);
    }

    public void rotateY(float angle) {
        this.rotate(angle, 0.0f, 1.0f, 0.0f);
    }

    public void rotateZ(float angle) {
        this.rotate(angle, 0.0f, 0.0f, 1.0f);
    }

    public void rotate(float angle) {
        this.rotateZ(angle);
    }

    public void rotate(float angle, float v0, float v1, float v2) {
        this.checkMatrix();
        this.matrix.rotate(angle, v0, v1, v2);
    }

    public void scale(float s) {
        this.scale(s, s, s);
    }

    public void scale(float sx, float sy) {
        this.scale(sx, sy, 1.0f);
    }

    public void scale(float x, float y, float z) {
        this.checkMatrix();
        this.matrix.scale(x, y, z);
    }

    public void applyMatrix(float n00, float n01, float n02, float n10, float n11, float n12) {
        this.checkMatrix();
        this.matrix.apply(n00, n01, n02, 0.0f, n10, n11, n12, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void applyMatrix(float n00, float n01, float n02, float n03, float n10, float n11, float n12, float n13, float n20, float n21, float n22, float n23, float n30, float n31, float n32, float n33) {
        this.checkMatrix();
        this.matrix.apply(n00, n01, n02, n03, n10, n11, n12, n13, n20, n21, n22, n23, n30, n31, n32, n33);
    }

    protected void checkMatrix() {
        if (this.matrix == null) {
            this.matrix = new PMatrix();
        }
    }

    public void center() {
    }

    public void pivot(float x, float y) {
        this.px = x;
        this.py = y;
    }
}

