/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import processing.core.PApplet;
import processing.core.PConstants;

public final class PMatrix
implements PConstants {
    public float m00;
    public float m01;
    public float m02;
    public float m03;
    public float m10;
    public float m11;
    public float m12;
    public float m13;
    public float m20;
    public float m21;
    public float m22;
    public float m23;
    public float m30;
    public float m31;
    public float m32;
    public float m33;
    static final int DEFAULT_STACK_DEPTH = 0;
    int maxStackDepth;
    int stackPointer = 0;
    float[][] stack;
    protected static PMatrix inverseCopy;

    public PMatrix() {
        this.set(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        this.maxStackDepth = 0;
    }

    public PMatrix(int stackDepth) {
        this.set(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        this.stack = new float[stackDepth][16];
        this.maxStackDepth = stackDepth;
    }

    public PMatrix(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23, float m30, float m31, float m32, float m33) {
        this.set(m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33);
        this.maxStackDepth = 0;
    }

    public PMatrix(PMatrix src) {
        this.set(src);
        this.maxStackDepth = src.maxStackDepth;
        this.stack = new float[this.maxStackDepth][16];
    }

    public void reset() {
        this.set(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void clearStack() {
        this.stackPointer = 0;
    }

    public boolean push() {
        if (this.stackPointer == this.maxStackDepth) {
            return false;
        }
        this.stack[this.stackPointer][0] = this.m00;
        this.stack[this.stackPointer][1] = this.m01;
        this.stack[this.stackPointer][2] = this.m02;
        this.stack[this.stackPointer][3] = this.m03;
        this.stack[this.stackPointer][4] = this.m10;
        this.stack[this.stackPointer][5] = this.m11;
        this.stack[this.stackPointer][6] = this.m12;
        this.stack[this.stackPointer][7] = this.m13;
        this.stack[this.stackPointer][8] = this.m20;
        this.stack[this.stackPointer][9] = this.m21;
        this.stack[this.stackPointer][10] = this.m22;
        this.stack[this.stackPointer][11] = this.m23;
        this.stack[this.stackPointer][12] = this.m30;
        this.stack[this.stackPointer][13] = this.m31;
        this.stack[this.stackPointer][14] = this.m32;
        this.stack[this.stackPointer][15] = this.m33;
        ++this.stackPointer;
        return true;
    }

    public boolean pop() {
        if (this.stackPointer == 0) {
            return false;
        }
        --this.stackPointer;
        this.m00 = this.stack[this.stackPointer][0];
        this.m01 = this.stack[this.stackPointer][1];
        this.m02 = this.stack[this.stackPointer][2];
        this.m03 = this.stack[this.stackPointer][3];
        this.m10 = this.stack[this.stackPointer][4];
        this.m11 = this.stack[this.stackPointer][5];
        this.m12 = this.stack[this.stackPointer][6];
        this.m13 = this.stack[this.stackPointer][7];
        this.m20 = this.stack[this.stackPointer][8];
        this.m21 = this.stack[this.stackPointer][9];
        this.m22 = this.stack[this.stackPointer][10];
        this.m23 = this.stack[this.stackPointer][11];
        this.m30 = this.stack[this.stackPointer][12];
        this.m31 = this.stack[this.stackPointer][13];
        this.m32 = this.stack[this.stackPointer][14];
        this.m33 = this.stack[this.stackPointer][15];
        return true;
    }

    public void set(PMatrix src) {
        this.set(src.m00, src.m01, src.m02, src.m03, src.m10, src.m11, src.m12, src.m13, src.m20, src.m21, src.m22, src.m23, src.m30, src.m31, src.m32, src.m33);
    }

    public void set(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23, float m30, float m31, float m32, float m33) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m03 = m03;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
        this.m30 = m30;
        this.m31 = m31;
        this.m32 = m32;
        this.m33 = m33;
    }

    public void translate(float tx, float ty) {
        this.translate(tx, ty, 0.0f);
    }

    public void invTranslate(float tx, float ty) {
        this.invTranslate(tx, ty, 0.0f);
    }

    public void translate(float tx, float ty, float tz) {
        this.m03 += tx * this.m00 + ty * this.m01 + tz * this.m02;
        this.m13 += tx * this.m10 + ty * this.m11 + tz * this.m12;
        this.m23 += tx * this.m20 + ty * this.m21 + tz * this.m22;
        this.m33 += tx * this.m30 + ty * this.m31 + tz * this.m32;
    }

    public void invTranslate(float tx, float ty, float tz) {
        this.preApply(1.0f, 0.0f, 0.0f, -tx, 0.0f, 1.0f, 0.0f, -ty, 0.0f, 0.0f, 1.0f, -tz, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void rotateX(float angle) {
        float c = this.cos(angle);
        float s = this.sin(angle);
        this.apply(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, c, -s, 0.0f, 0.0f, s, c, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void invRotateX(float angle) {
        float c = this.cos(-angle);
        float s = this.sin(-angle);
        this.preApply(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, c, -s, 0.0f, 0.0f, s, c, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void rotateY(float angle) {
        float c = this.cos(angle);
        float s = this.sin(angle);
        this.apply(c, 0.0f, s, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -s, 0.0f, c, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void invRotateY(float angle) {
        float c = this.cos(-angle);
        float s = this.sin(-angle);
        this.preApply(c, 0.0f, s, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -s, 0.0f, c, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void rotate(float angle) {
        this.rotateZ(angle);
    }

    public void invRotate(float angle) {
        this.invRotateZ(angle);
    }

    public void rotateZ(float angle) {
        float c = this.cos(angle);
        float s = this.sin(angle);
        this.apply(c, -s, 0.0f, 0.0f, s, c, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void invRotateZ(float angle) {
        float c = this.cos(-angle);
        float s = this.sin(-angle);
        this.preApply(c, -s, 0.0f, 0.0f, s, c, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void rotate(float angle, float v0, float v1, float v2) {
        float c = this.cos(angle);
        float s = this.sin(angle);
        float t = 1.0f - c;
        this.apply(t * v0 * v0 + c, t * v0 * v1 - s * v2, t * v0 * v2 + s * v1, 0.0f, t * v0 * v1 + s * v2, t * v1 * v1 + c, t * v1 * v2 - s * v0, 0.0f, t * v0 * v2 - s * v1, t * v1 * v2 + s * v0, t * v2 * v2 + c, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void invRotate(float angle, float v0, float v1, float v2) {
        float c = this.cos(-angle);
        float s = this.sin(-angle);
        float t = 1.0f - c;
        this.preApply(t * v0 * v0 + c, t * v0 * v1 - s * v2, t * v0 * v2 + s * v1, 0.0f, t * v0 * v1 + s * v2, t * v1 * v1 + c, t * v1 * v2 - s * v0, 0.0f, t * v0 * v2 - s * v1, t * v1 * v2 + s * v0, t * v2 * v2 + c, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void scale(float s) {
        this.apply(s, 0.0f, 0.0f, 0.0f, 0.0f, s, 0.0f, 0.0f, 0.0f, 0.0f, s, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void invScale(float s) {
        this.preApply(1.0f / s, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f / s, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f / s, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void scale(float sx, float sy) {
        this.apply(sx, 0.0f, 0.0f, 0.0f, 0.0f, sy, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void invScale(float sx, float sy) {
        this.preApply(1.0f / sx, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f / sy, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void scale(float x, float y, float z) {
        this.apply(x, 0.0f, 0.0f, 0.0f, 0.0f, y, 0.0f, 0.0f, 0.0f, 0.0f, z, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void invScale(float x, float y, float z) {
        this.preApply(1.0f / x, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f / y, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f / z, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void preApply(PMatrix lhs) {
        this.preApply(lhs.m00, lhs.m01, lhs.m02, lhs.m03, lhs.m10, lhs.m11, lhs.m12, lhs.m13, lhs.m20, lhs.m21, lhs.m22, lhs.m23, lhs.m30, lhs.m31, lhs.m32, lhs.m33);
    }

    public void preApply(float n00, float n01, float n02, float n03, float n10, float n11, float n12, float n13, float n20, float n21, float n22, float n23, float n30, float n31, float n32, float n33) {
        float r00 = n00 * this.m00 + n01 * this.m10 + n02 * this.m20 + n03 * this.m30;
        float r01 = n00 * this.m01 + n01 * this.m11 + n02 * this.m21 + n03 * this.m31;
        float r02 = n00 * this.m02 + n01 * this.m12 + n02 * this.m22 + n03 * this.m32;
        float r03 = n00 * this.m03 + n01 * this.m13 + n02 * this.m23 + n03 * this.m33;
        float r10 = n10 * this.m00 + n11 * this.m10 + n12 * this.m20 + n13 * this.m30;
        float r11 = n10 * this.m01 + n11 * this.m11 + n12 * this.m21 + n13 * this.m31;
        float r12 = n10 * this.m02 + n11 * this.m12 + n12 * this.m22 + n13 * this.m32;
        float r13 = n10 * this.m03 + n11 * this.m13 + n12 * this.m23 + n13 * this.m33;
        float r20 = n20 * this.m00 + n21 * this.m10 + n22 * this.m20 + n23 * this.m30;
        float r21 = n20 * this.m01 + n21 * this.m11 + n22 * this.m21 + n23 * this.m31;
        float r22 = n20 * this.m02 + n21 * this.m12 + n22 * this.m22 + n23 * this.m32;
        float r23 = n20 * this.m03 + n21 * this.m13 + n22 * this.m23 + n23 * this.m33;
        float r30 = n30 * this.m00 + n31 * this.m10 + n32 * this.m20 + n33 * this.m30;
        float r31 = n30 * this.m01 + n31 * this.m11 + n32 * this.m21 + n33 * this.m31;
        float r32 = n30 * this.m02 + n31 * this.m12 + n32 * this.m22 + n33 * this.m32;
        float r33 = n30 * this.m03 + n31 * this.m13 + n32 * this.m23 + n33 * this.m33;
        this.m00 = r00;
        this.m01 = r01;
        this.m02 = r02;
        this.m03 = r03;
        this.m10 = r10;
        this.m11 = r11;
        this.m12 = r12;
        this.m13 = r13;
        this.m20 = r20;
        this.m21 = r21;
        this.m22 = r22;
        this.m23 = r23;
        this.m30 = r30;
        this.m31 = r31;
        this.m32 = r32;
        this.m33 = r33;
    }

    public boolean invApply(PMatrix rhs) {
        PMatrix copy = new PMatrix(rhs);
        PMatrix inverse = copy.invert();
        if (inverse == null) {
            return false;
        }
        this.preApply(inverse);
        return true;
    }

    public boolean invApply(float n00, float n01, float n02, float n03, float n10, float n11, float n12, float n13, float n20, float n21, float n22, float n23, float n30, float n31, float n32, float n33) {
        if (inverseCopy == null) {
            inverseCopy = new PMatrix();
        }
        inverseCopy.set(n00, n01, n02, n03, n10, n11, n12, n13, n20, n21, n22, n23, n30, n31, n32, n33);
        PMatrix inverse = inverseCopy.invert();
        if (inverse == null) {
            return false;
        }
        this.preApply(inverse);
        return true;
    }

    public void apply(PMatrix rhs) {
        this.apply(rhs.m00, rhs.m01, rhs.m02, rhs.m03, rhs.m10, rhs.m11, rhs.m12, rhs.m13, rhs.m20, rhs.m21, rhs.m22, rhs.m23, rhs.m30, rhs.m31, rhs.m32, rhs.m33);
    }

    public void apply(float n00, float n01, float n02, float n03, float n10, float n11, float n12, float n13, float n20, float n21, float n22, float n23, float n30, float n31, float n32, float n33) {
        float r00 = this.m00 * n00 + this.m01 * n10 + this.m02 * n20 + this.m03 * n30;
        float r01 = this.m00 * n01 + this.m01 * n11 + this.m02 * n21 + this.m03 * n31;
        float r02 = this.m00 * n02 + this.m01 * n12 + this.m02 * n22 + this.m03 * n32;
        float r03 = this.m00 * n03 + this.m01 * n13 + this.m02 * n23 + this.m03 * n33;
        float r10 = this.m10 * n00 + this.m11 * n10 + this.m12 * n20 + this.m13 * n30;
        float r11 = this.m10 * n01 + this.m11 * n11 + this.m12 * n21 + this.m13 * n31;
        float r12 = this.m10 * n02 + this.m11 * n12 + this.m12 * n22 + this.m13 * n32;
        float r13 = this.m10 * n03 + this.m11 * n13 + this.m12 * n23 + this.m13 * n33;
        float r20 = this.m20 * n00 + this.m21 * n10 + this.m22 * n20 + this.m23 * n30;
        float r21 = this.m20 * n01 + this.m21 * n11 + this.m22 * n21 + this.m23 * n31;
        float r22 = this.m20 * n02 + this.m21 * n12 + this.m22 * n22 + this.m23 * n32;
        float r23 = this.m20 * n03 + this.m21 * n13 + this.m22 * n23 + this.m23 * n33;
        float r30 = this.m30 * n00 + this.m31 * n10 + this.m32 * n20 + this.m33 * n30;
        float r31 = this.m30 * n01 + this.m31 * n11 + this.m32 * n21 + this.m33 * n31;
        float r32 = this.m30 * n02 + this.m31 * n12 + this.m32 * n22 + this.m33 * n32;
        float r33 = this.m30 * n03 + this.m31 * n13 + this.m32 * n23 + this.m33 * n33;
        this.m00 = r00;
        this.m01 = r01;
        this.m02 = r02;
        this.m03 = r03;
        this.m10 = r10;
        this.m11 = r11;
        this.m12 = r12;
        this.m13 = r13;
        this.m20 = r20;
        this.m21 = r21;
        this.m22 = r22;
        this.m23 = r23;
        this.m30 = r30;
        this.m31 = r31;
        this.m32 = r32;
        this.m33 = r33;
    }

    public void mult3(float[] vec, float[] out) {
        float tmpx = this.m00 * vec[0] + this.m01 * vec[1] + this.m02 * vec[2] + this.m03;
        float tmpy = this.m10 * vec[0] + this.m11 * vec[1] + this.m12 * vec[2] + this.m13;
        float tmpz = this.m20 * vec[0] + this.m21 * vec[1] + this.m22 * vec[2] + this.m23;
        out[0] = tmpx;
        out[1] = tmpy;
        out[2] = tmpz;
    }

    public void mult(float[] vec, float[] out) {
        float tmpx = this.m00 * vec[0] + this.m01 * vec[1] + this.m02 * vec[2] + this.m03 * vec[3];
        float tmpy = this.m10 * vec[0] + this.m11 * vec[1] + this.m12 * vec[2] + this.m13 * vec[3];
        float tmpz = this.m20 * vec[0] + this.m21 * vec[1] + this.m22 * vec[2] + this.m23 * vec[3];
        float tmpw = this.m30 * vec[0] + this.m31 * vec[1] + this.m32 * vec[2] + this.m33 * vec[3];
        out[0] = tmpx;
        out[1] = tmpy;
        out[2] = tmpz;
        out[3] = tmpw;
    }

    public float determinant() {
        float f = this.m00 * (this.m11 * this.m22 * this.m33 + this.m12 * this.m23 * this.m31 + this.m13 * this.m21 * this.m32 - this.m13 * this.m22 * this.m31 - this.m11 * this.m23 * this.m32 - this.m12 * this.m21 * this.m33);
        f -= this.m01 * (this.m10 * this.m22 * this.m33 + this.m12 * this.m23 * this.m30 + this.m13 * this.m20 * this.m32 - this.m13 * this.m22 * this.m30 - this.m10 * this.m23 * this.m32 - this.m12 * this.m20 * this.m33);
        f += this.m02 * (this.m10 * this.m21 * this.m33 + this.m11 * this.m23 * this.m30 + this.m13 * this.m20 * this.m31 - this.m13 * this.m21 * this.m30 - this.m10 * this.m23 * this.m31 - this.m11 * this.m20 * this.m33);
        return f -= this.m03 * (this.m10 * this.m21 * this.m32 + this.m11 * this.m22 * this.m30 + this.m12 * this.m20 * this.m31 - this.m12 * this.m21 * this.m30 - this.m10 * this.m22 * this.m31 - this.m11 * this.m20 * this.m32);
    }

    private float determinant3x3(float t00, float t01, float t02, float t10, float t11, float t12, float t20, float t21, float t22) {
        return t00 * (t11 * t22 - t12 * t21) + t01 * (t12 * t20 - t10 * t22) + t02 * (t10 * t21 - t11 * t20);
    }

    public PMatrix transpose() {
        float temp = this.m01;
        this.m01 = this.m10;
        this.m10 = temp;
        temp = this.m02;
        this.m02 = this.m20;
        this.m20 = temp;
        temp = this.m03;
        this.m03 = this.m30;
        this.m30 = temp;
        temp = this.m12;
        this.m12 = this.m21;
        this.m21 = temp;
        temp = this.m13;
        this.m13 = this.m31;
        this.m31 = temp;
        temp = this.m23;
        this.m23 = this.m32;
        this.m32 = temp;
        return this;
    }

    public PMatrix invert() {
        float determinant = this.determinant();
        if (determinant != 0.0f) {
            float determinant_inv = 1.0f / determinant;
            float t00 = this.determinant3x3(this.m11, this.m12, this.m13, this.m21, this.m22, this.m23, this.m31, this.m32, this.m33);
            float t01 = -this.determinant3x3(this.m10, this.m12, this.m13, this.m20, this.m22, this.m23, this.m30, this.m32, this.m33);
            float t02 = this.determinant3x3(this.m10, this.m11, this.m13, this.m20, this.m21, this.m23, this.m30, this.m31, this.m33);
            float t03 = -this.determinant3x3(this.m10, this.m11, this.m12, this.m20, this.m21, this.m22, this.m30, this.m31, this.m32);
            float t10 = -this.determinant3x3(this.m01, this.m02, this.m03, this.m21, this.m22, this.m23, this.m31, this.m32, this.m33);
            float t11 = this.determinant3x3(this.m00, this.m02, this.m03, this.m20, this.m22, this.m23, this.m30, this.m32, this.m33);
            float t12 = -this.determinant3x3(this.m00, this.m01, this.m03, this.m20, this.m21, this.m23, this.m30, this.m31, this.m33);
            float t13 = this.determinant3x3(this.m00, this.m01, this.m02, this.m20, this.m21, this.m22, this.m30, this.m31, this.m32);
            float t20 = this.determinant3x3(this.m01, this.m02, this.m03, this.m11, this.m12, this.m13, this.m31, this.m32, this.m33);
            float t21 = -this.determinant3x3(this.m00, this.m02, this.m03, this.m10, this.m12, this.m13, this.m30, this.m32, this.m33);
            float t22 = this.determinant3x3(this.m00, this.m01, this.m03, this.m10, this.m11, this.m13, this.m30, this.m31, this.m33);
            float t23 = -this.determinant3x3(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m30, this.m31, this.m32);
            float t30 = -this.determinant3x3(this.m01, this.m02, this.m03, this.m11, this.m12, this.m13, this.m21, this.m22, this.m23);
            float t31 = this.determinant3x3(this.m00, this.m02, this.m03, this.m10, this.m12, this.m13, this.m20, this.m22, this.m23);
            float t32 = -this.determinant3x3(this.m00, this.m01, this.m03, this.m10, this.m11, this.m13, this.m20, this.m21, this.m23);
            float t33 = this.determinant3x3(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
            this.m00 = t00 * determinant_inv;
            this.m11 = t11 * determinant_inv;
            this.m22 = t22 * determinant_inv;
            this.m33 = t33 * determinant_inv;
            this.m01 = t10 * determinant_inv;
            this.m10 = t01 * determinant_inv;
            this.m20 = t02 * determinant_inv;
            this.m02 = t20 * determinant_inv;
            this.m12 = t21 * determinant_inv;
            this.m21 = t12 * determinant_inv;
            this.m03 = t30 * determinant_inv;
            this.m30 = t03 * determinant_inv;
            this.m13 = t31 * determinant_inv;
            this.m31 = t13 * determinant_inv;
            this.m32 = t23 * determinant_inv;
            this.m23 = t32 * determinant_inv;
            return this;
        }
        return null;
    }

    public void print() {
        int big = (int)Math.abs(this.max(this.max(this.max(this.max(this.abs(this.m00), this.abs(this.m01)), this.max(this.abs(this.m02), this.abs(this.m03))), this.max(this.max(this.abs(this.m10), this.abs(this.m11)), this.max(this.abs(this.m12), this.abs(this.m13)))), this.max(this.max(this.max(this.abs(this.m20), this.abs(this.m21)), this.max(this.abs(this.m22), this.abs(this.m23))), this.max(this.max(this.abs(this.m30), this.abs(this.m31)), this.max(this.abs(this.m32), this.abs(this.m33))))));
        if (Float.isNaN(big) || Float.isInfinite(big)) {
            big = 1000000;
        }
        int d = 1;
        while ((big /= 10) != 0) {
            ++d;
        }
        System.out.println(String.valueOf(PApplet.nfs(this.m00, d, 4)) + " " + PApplet.nfs(this.m01, d, 4) + " " + PApplet.nfs(this.m02, d, 4) + " " + PApplet.nfs(this.m03, d, 4));
        System.out.println(String.valueOf(PApplet.nfs(this.m10, d, 4)) + " " + PApplet.nfs(this.m11, d, 4) + " " + PApplet.nfs(this.m12, d, 4) + " " + PApplet.nfs(this.m13, d, 4));
        System.out.println(String.valueOf(PApplet.nfs(this.m20, d, 4)) + " " + PApplet.nfs(this.m21, d, 4) + " " + PApplet.nfs(this.m22, d, 4) + " " + PApplet.nfs(this.m23, d, 4));
        System.out.println(String.valueOf(PApplet.nfs(this.m30, d, 4)) + " " + PApplet.nfs(this.m31, d, 4) + " " + PApplet.nfs(this.m32, d, 4) + " " + PApplet.nfs(this.m33, d, 4));
        System.out.println();
    }

    private final float max(float a, float b) {
        return a > b ? a : b;
    }

    private final float abs(float a) {
        return a < 0.0f ? -a : a;
    }

    private final float sin(float angle) {
        return (float)Math.sin(angle);
    }

    private final float cos(float angle) {
        return (float)Math.cos(angle);
    }
}

