/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;

public class PGraphicsJava2D
extends PGraphics {
    public Graphics2D g2;
    GeneralPath gpath;
    int transformCount;
    AffineTransform[] transformStack = new AffineTransform[32];
    double[] transform = new double[6];
    Line2D.Float line = new Line2D.Float();
    Ellipse2D.Float ellipse = new Ellipse2D.Float();
    Rectangle2D.Float rect = new Rectangle2D.Float();
    Arc2D.Float arc = new Arc2D.Float();
    protected Color tintColorObject;
    protected Color fillColorObject;
    public boolean fillGradient;
    public Paint fillGradientObject;
    protected Color strokeColorObject;
    public boolean strokeGradient;
    public Paint strokeGradientObject;
    float[] curveX = new float[4];
    float[] curveY = new float[4];
    boolean breakShape;
    int[] clearPixels;
    static int[] getset = new int[1];

    public PGraphicsJava2D(int iwidth, int iheight, PApplet parent) {
        super(iwidth, iheight, parent);
    }

    public void resize(int iwidth, int iheight) {
        this.insideDrawWait();
        this.insideResize = true;
        this.width = iwidth;
        this.height = iheight;
        this.width1 = this.width - 1;
        this.height1 = this.height - 1;
        this.allocate();
        this.insideResize = false;
    }

    protected void allocate() {
        this.image = new BufferedImage(this.width, this.height, 2);
        this.g2 = (Graphics2D)this.image.getGraphics();
    }

    public void beginDraw() {
        this.insideResizeWait();
        this.insideDraw = true;
        if (!this.defaultsInited) {
            this.defaults();
        }
        this.resetMatrix();
        this.vertexCount = 0;
    }

    public void endDraw() {
        if (!this.mainDrawingSurface) {
            this.loadPixels();
        }
        this.modified = true;
        this.insideDraw = false;
    }

    public void beginShape(int kind) {
        this.shape = kind;
        this.vertexCount = 0;
        this.splineVertexCount = 0;
        this.gpath = null;
    }

    public void textureMode(int mode) {
        this.unavailableError("textureMode(mode)");
    }

    public void texture(PImage image) {
        this.unavailableError("texture(image)");
    }

    public void vertex(float x, float y) {
        this.splineVertexCount = 0;
        if (this.vertexCount == this.vertices.length) {
            float[][] temp = new float[this.vertexCount << 1][36];
            System.arraycopy(this.vertices, 0, temp, 0, this.vertexCount);
            this.vertices = temp;
        }
        this.vertices[this.vertexCount][9] = x;
        this.vertices[this.vertexCount][10] = y;
        ++this.vertexCount;
        switch (this.shape) {
            case 16: {
                this.point(x, y);
                break;
            }
            case 32: {
                if (this.vertexCount % 2 != 0) break;
                this.line(this.vertices[this.vertexCount - 2][9], this.vertices[this.vertexCount - 2][10], x, y);
                break;
            }
            case 64: {
                if (this.vertexCount % 3 != 0) break;
                this.triangle(this.vertices[this.vertexCount - 3][9], this.vertices[this.vertexCount - 3][10], this.vertices[this.vertexCount - 2][9], this.vertices[this.vertexCount - 2][10], x, y);
                break;
            }
            case 65: {
                if (this.vertexCount < 3) break;
                this.triangle(this.vertices[this.vertexCount - 2][9], this.vertices[this.vertexCount - 2][10], this.vertices[this.vertexCount - 1][9], this.vertices[this.vertexCount - 1][10], this.vertices[this.vertexCount - 3][9], this.vertices[this.vertexCount - 3][10]);
                break;
            }
            case 66: {
                if (this.vertexCount == 3) {
                    this.triangle(this.vertices[0][9], this.vertices[0][10], this.vertices[1][9], this.vertices[1][10], x, y);
                    break;
                }
                if (this.vertexCount <= 3) break;
                this.gpath = new GeneralPath();
                this.gpath.moveTo(this.vertices[0][9], this.vertices[0][10]);
                this.gpath.lineTo(this.vertices[this.vertexCount - 2][9], this.vertices[this.vertexCount - 2][10]);
                this.gpath.lineTo(x, y);
                this.draw_shape(this.gpath);
                break;
            }
            case 128: {
                if (this.vertexCount % 4 != 0) break;
                this.quad(this.vertices[this.vertexCount - 4][9], this.vertices[this.vertexCount - 4][10], this.vertices[this.vertexCount - 3][9], this.vertices[this.vertexCount - 3][10], this.vertices[this.vertexCount - 2][9], this.vertices[this.vertexCount - 2][10], x, y);
                break;
            }
            case 129: {
                if (this.vertexCount < 4 || this.vertexCount % 2 != 0) break;
                this.quad(this.vertices[this.vertexCount - 4][9], this.vertices[this.vertexCount - 4][10], this.vertices[this.vertexCount - 2][9], this.vertices[this.vertexCount - 2][10], x, y, this.vertices[this.vertexCount - 3][9], this.vertices[this.vertexCount - 3][10]);
                break;
            }
            case 256: {
                if (this.gpath == null) {
                    this.gpath = new GeneralPath();
                    this.gpath.moveTo(x, y);
                    break;
                }
                if (this.breakShape) {
                    this.gpath.moveTo(x, y);
                    this.breakShape = false;
                    break;
                }
                this.gpath.lineTo(x, y);
            }
        }
    }

    public void vertex(float x, float y, float u, float v) {
        this.unavailableError("vertex(x, y, u, v");
    }

    public void vertex(float x, float y, float z) {
        this.depthErrorXYZ("vertex");
    }

    public void vertex(float x, float y, float z, float u, float v) {
        this.depthErrorXYZ("vertex");
    }

    public void bezierVertex(float x1, float y1, float x2, float y2, float x3, float y3) {
        if (this.gpath == null) {
            throw new RuntimeException("Must call vertex() at least once before using bezierVertex()");
        }
        switch (this.shape) {
            case 256: {
                this.gpath.curveTo(x1, y1, x2, y2, x3, y3);
                break;
            }
            default: {
                throw new RuntimeException("bezierVertex() can only be used with LINE_STRIP, LINE_LOOP, or POLYGON");
            }
        }
    }

    public void curveVertex(float x, float y) {
        if (this.shape != 256) {
            throw new RuntimeException("curveVertex() can only be used with POLYGON shapes");
        }
        if (!this.curve_inited) {
            this.curve_init();
        }
        this.vertexCount = 0;
        if (this.splineVertices == null) {
            this.splineVertices = new float[128][36];
        }
        if (this.splineVertexCount == 128) {
            System.arraycopy(this.splineVertices[125], 0, this.splineVertices[0], 0, 36);
            System.arraycopy(this.splineVertices[126], 0, this.splineVertices[1], 0, 36);
            System.arraycopy(this.splineVertices[127], 0, this.splineVertices[2], 0, 36);
            this.splineVertexCount = 3;
        }
        if (this.splineVertexCount >= 3) {
            this.curveX[0] = this.splineVertices[this.splineVertexCount - 3][9];
            this.curveY[0] = this.splineVertices[this.splineVertexCount - 3][10];
            this.curveX[1] = this.splineVertices[this.splineVertexCount - 2][9];
            this.curveY[1] = this.splineVertices[this.splineVertexCount - 2][10];
            this.curveX[2] = this.splineVertices[this.splineVertexCount - 1][9];
            this.curveY[2] = this.splineVertices[this.splineVertexCount - 1][10];
            this.curveX[3] = x;
            this.curveY[3] = y;
            this.curveToBezierMatrix.mult(this.curveX, this.curveX);
            this.curveToBezierMatrix.mult(this.curveY, this.curveY);
            if (this.gpath == null) {
                this.gpath = new GeneralPath();
                this.gpath.moveTo(this.curveX[0], this.curveY[0]);
            }
            this.gpath.curveTo(this.curveX[1], this.curveY[1], this.curveX[2], this.curveY[2], this.curveX[3], this.curveY[3]);
        }
        this.splineVertices[this.splineVertexCount][9] = x;
        this.splineVertices[this.splineVertexCount][10] = y;
        ++this.splineVertexCount;
    }

    public void breakShape() {
        this.breakShape = true;
    }

    public void endShape(int mode) {
        if (this.gpath != null && this.shape == 256) {
            if (mode == 2) {
                this.gpath.closePath();
            }
            this.draw_shape(this.gpath);
        }
        this.shape = 0;
    }

    protected void fill_shape(Shape s) {
        if (this.fillGradient) {
            this.g2.setPaint(this.fillGradientObject);
            this.g2.fill(s);
        } else if (this.fill) {
            this.g2.setColor(this.fillColorObject);
            this.g2.fill(s);
        }
    }

    protected void stroke_shape(Shape s) {
        if (this.strokeGradient) {
            this.g2.setPaint(this.strokeGradientObject);
            this.g2.draw(s);
        } else if (this.stroke) {
            this.g2.setColor(this.strokeColorObject);
            this.g2.draw(s);
        }
    }

    protected void draw_shape(Shape s) {
        if (this.fillGradient) {
            this.g2.setPaint(this.fillGradientObject);
            this.g2.fill(s);
        } else if (this.fill) {
            this.g2.setColor(this.fillColorObject);
            this.g2.fill(s);
        }
        if (this.strokeGradient) {
            this.g2.setPaint(this.strokeGradientObject);
            this.g2.draw(s);
        } else if (this.stroke) {
            this.g2.setColor(this.strokeColorObject);
            this.g2.draw(s);
        }
    }

    public void point(float x, float y) {
        this.line(x, y, x, y);
    }

    public void line(float x1, float y1, float x2, float y2) {
        this.line.setLine(x1, y1, x2, y2);
        this.stroke_shape(this.line);
    }

    public void triangle(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.gpath = new GeneralPath();
        this.gpath.moveTo(x1, y1);
        this.gpath.lineTo(x2, y2);
        this.gpath.lineTo(x3, y3);
        this.gpath.closePath();
        this.draw_shape(this.gpath);
    }

    public void quad(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        GeneralPath gp = new GeneralPath();
        gp.moveTo(x1, y1);
        gp.lineTo(x2, y2);
        gp.lineTo(x3, y3);
        gp.lineTo(x4, y4);
        gp.closePath();
        this.draw_shape(gp);
    }

    protected void rectImpl(float x1, float y1, float x2, float y2) {
        this.rect.setFrame(x1, y1, x2 - x1, y2 - y1);
        this.draw_shape(this.rect);
    }

    protected void ellipseImpl(float x, float y, float w, float h) {
        this.ellipse.setFrame(x, y, w, h);
        this.draw_shape(this.ellipse);
    }

    protected void arcImpl(float x, float y, float w, float h, float start, float stop) {
        if (stop - start >= (float)Math.PI * 2) {
            start = 0.0f;
            stop = 360.0f;
        } else {
            start = -start * 57.295776f;
            stop = -stop * 57.295776f;
            while (start < 0.0f) {
                start += 360.0f;
                stop += 360.0f;
            }
            if (start > stop) {
                float temp = start;
                start = stop;
                stop = temp;
            }
        }
        float span = stop - start;
        if (this.fill) {
            this.arc.setArc(x, y, w, h, start, span, 2);
            this.fill_shape(this.arc);
        }
        if (this.stroke) {
            this.arc.setArc(x, y, w, h, start, span, 0);
            this.stroke_shape(this.arc);
        }
    }

    public void bezierDetail(int detail) {
    }

    public void curveDetail(int detail) {
    }

    protected void imageImpl(PImage who, float x1, float y1, float x2, float y2, int u1, int v1, int u2, int v2) {
        if (who.cache != null) {
            boolean cfr_ignored_0 = who.cache instanceof ImageCache;
        }
        if (who.cache == null) {
            who.cache = new ImageCache(who);
            who.updatePixels();
            who.modified = true;
        }
        ImageCache cash = (ImageCache)who.cache;
        if (this.tint && !cash.tinted || this.tint && cash.tintedColor != this.tintColor || !this.tint && cash.tinted) {
            who.updatePixels();
        }
        if (who.modified) {
            cash.update(this.tint, this.tintColor);
            who.modified = false;
        }
        this.g2.drawImage(((ImageCache)who.cache).image, (int)x1, (int)y1, (int)x2, (int)y2, u1, v1, u2, v2, null);
    }

    public float textAscent() {
        if (this.textFontNative == null) {
            return super.textAscent();
        }
        return this.textFontNativeMetrics.getAscent();
    }

    public float textDescent() {
        if (this.textFontNative == null) {
            return super.textDescent();
        }
        return this.textFontNativeMetrics.getDescent();
    }

    public void textSize(float size) {
        if (this.textFontNative != null) {
            this.textFontNative = this.textFontNative.deriveFont(size);
            this.g2.setFont(this.textFontNative);
            this.textFontNativeMetrics = this.g2.getFontMetrics(this.textFontNative);
        }
        super.textSize(size);
    }

    protected float textWidthImpl(char[] buffer, int start, int stop) {
        if (this.textFontNative == null) {
            return super.textWidthImpl(buffer, start, stop);
        }
        int length = stop - start;
        return this.textFontNativeMetrics.charsWidth(buffer, start, length);
    }

    protected void textLinePlacedImpl(char[] buffer, int start, int stop, float x, float y) {
        if (this.textFontNative == null) {
            super.textLinePlacedImpl(buffer, start, stop, x, y);
            return;
        }
        Object antialias = this.g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (antialias == null) {
            antialias = RenderingHints.VALUE_ANTIALIAS_DEFAULT;
        }
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.textFont.smooth ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        this.g2.setColor(this.fillColorObject);
        int length = stop - start;
        this.g2.drawChars(buffer, start, length, (int)(x + 0.5f), (int)(y + 0.5f));
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialias);
        this.textX = x + this.textWidthImpl(buffer, start, stop);
        this.textY = y;
        this.textZ = 0.0f;
    }

    public void translate(float tx, float ty) {
        this.g2.translate(tx, ty);
    }

    public void rotate(float angle) {
        this.g2.rotate(angle);
    }

    public void scale(float s) {
        this.g2.scale(s, s);
    }

    public void scale(float sx, float sy) {
        this.g2.scale(sx, sy);
    }

    public void pushMatrix() {
        if (this.transformCount == this.transformStack.length) {
            throw new RuntimeException("pushMatrix() cannot use push more than " + this.transformStack.length + " times");
        }
        this.transformStack[this.transformCount] = this.g2.getTransform();
        ++this.transformCount;
    }

    public void popMatrix() {
        if (this.transformCount == 0) {
            throw new RuntimeException("missing a popMatrix() to go with that pushMatrix()");
        }
        --this.transformCount;
        this.g2.setTransform(this.transformStack[this.transformCount]);
    }

    public void resetMatrix() {
        this.g2.setTransform(new AffineTransform());
    }

    public void applyMatrix(float n00, float n01, float n02, float n10, float n11, float n12) {
        this.g2.transform(new AffineTransform(n00, n10, n01, n11, n02, n12));
    }

    public void loadMatrix() {
        this.g2.getTransform().getMatrix(this.transform);
        this.m00 = (float)this.transform[0];
        this.m01 = (float)this.transform[2];
        this.m02 = (float)this.transform[4];
        this.m10 = (float)this.transform[1];
        this.m11 = (float)this.transform[3];
        this.m12 = (float)this.transform[5];
    }

    public float screenX(float x, float y) {
        this.loadMatrix();
        return super.screenX(x, y);
    }

    public float screenY(float x, float y) {
        this.loadMatrix();
        return super.screenY(x, y);
    }

    protected void tintFromCalc() {
        super.tintFromCalc();
        this.tintColorObject = new Color(this.tintColor, true);
    }

    protected void fillFromCalc() {
        super.fillFromCalc();
        this.fillColorObject = new Color(this.fillColor, true);
        this.fillGradient = false;
    }

    protected void strokeFromCalc() {
        super.strokeFromCalc();
        this.strokeColorObject = new Color(this.strokeColor, true);
        this.strokeGradient = false;
    }

    public void strokeWeight(float weight) {
        super.strokeWeight(weight);
        this.set_stroke();
    }

    public void strokeJoin(int join) {
        super.strokeJoin(join);
        this.set_stroke();
    }

    public void strokeCap(int cap) {
        super.strokeCap(cap);
        this.set_stroke();
    }

    protected void set_stroke() {
        int cap = 0;
        if (this.strokeCap == 2) {
            cap = 1;
        } else if (this.strokeCap == 4) {
            cap = 2;
        }
        int join = 2;
        if (this.strokeJoin == 8) {
            join = 0;
        } else if (this.strokeJoin == 2) {
            join = 1;
        }
        this.g2.setStroke(new BasicStroke(this.strokeWeight, cap, join));
    }

    public void background(PImage image) {
        if (image.width != this.width || image.height != this.height) {
            throw new RuntimeException("background image must be the same size as your application");
        }
        if (image.format != 1 && image.format != 2) {
            throw new RuntimeException("background images should be RGB or ARGB");
        }
        this.set(0, 0, image);
    }

    public void clear() {
        if (this.backgroundAlpha) {
            WritableRaster raster = ((BufferedImage)this.image).getRaster();
            if (this.clearPixels == null || this.clearPixels.length < this.width) {
                this.clearPixels = new int[this.width];
            }
            int i = 0;
            while (i < this.width) {
                this.clearPixels[i] = this.backgroundColor;
                ++i;
            }
            i = 0;
            while (i < this.height) {
                raster.setDataElements(0, i, this.width, 1, this.clearPixels);
                ++i;
            }
        } else {
            this.pushMatrix();
            this.resetMatrix();
            this.g2.setColor(new Color(this.backgroundColor, this.backgroundAlpha));
            this.g2.fillRect(0, 0, this.width, this.height);
            this.popMatrix();
        }
    }

    public void smooth() {
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
    }

    public void noSmooth() {
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
    }

    public void beginRaw(PGraphics recorderRaw) {
        throw new RuntimeException("beginRaw() not available with this renderer");
    }

    public void endRaw() {
    }

    public void loadPixels() {
        if (this.pixels == null || this.pixels.length != this.width * this.height) {
            this.pixels = new int[this.width * this.height];
        }
        WritableRaster raster = ((BufferedImage)this.image).getRaster();
        raster.getDataElements(0, 0, this.width, this.height, this.pixels);
    }

    public void updatePixels() {
        WritableRaster raster = ((BufferedImage)this.image).getRaster();
        raster.setDataElements(0, 0, this.width, this.height, this.pixels);
    }

    public void updatePixels(int x, int y, int c, int d) {
        if (x != 0 || y != 0 || c != this.width || d != this.height) {
            throw new RuntimeException("updatePixels(x, y, c, d) not implemented");
        }
        this.updatePixels();
    }

    public int get(int x, int y) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return 0;
        }
        WritableRaster raster = ((BufferedImage)this.image).getRaster();
        raster.getDataElements(x, y, getset);
        return getset[0];
    }

    public PImage get(int x, int y, int w, int h) {
        if (this.imageMode == 1) {
            w -= x;
            h -= x;
        }
        if (x < 0) {
            w += x;
            x = 0;
        }
        if (y < 0) {
            h += y;
            y = 0;
        }
        if (x + w > this.width) {
            w = this.width - x;
        }
        if (y + h > this.height) {
            h = this.height - y;
        }
        PImage output = new PImage(w, h);
        output.parent = this.parent;
        WritableRaster raster = ((BufferedImage)this.image).getRaster();
        raster.getDataElements(x, y, w, h, output.pixels);
        return output;
    }

    public PImage get() {
        return this.get(0, 0, this.width, this.height);
    }

    public void set(int x, int y, int argb) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return;
        }
        PGraphicsJava2D.getset[0] = argb;
        WritableRaster raster = ((BufferedImage)this.image).getRaster();
        raster.setDataElements(x, y, getset);
    }

    protected void setImpl(int dx, int dy, int sx, int sy, int sw, int sh, PImage src) {
        WritableRaster raster = ((BufferedImage)this.image).getRaster();
        if (sx == 0 && sy == 0 && sw == src.width && sh == src.height) {
            raster.setDataElements(dx, dy, src.width, src.height, src.pixels);
        } else {
            int mode = src.imageMode;
            src.imageMode = 0;
            PImage temp = src.get(sx, sy, sw, sh);
            src.imageMode = mode;
            raster.setDataElements(dx, dy, temp.width, temp.height, temp.pixels);
        }
    }

    public void mask(int[] alpha) {
        throw new RuntimeException("mask() cannot be used with JAVA2D");
    }

    public void mask(PImage alpha) {
        throw new RuntimeException("mask() cannot be used with JAVA2D");
    }

    public void filter(int kind) {
        this.loadPixels();
        super.filter(kind);
        this.updatePixels();
    }

    public void filter(int kind, float param) {
        this.loadPixels();
        super.filter(kind, param);
        this.updatePixels();
    }

    public void copy(int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
        if (sw != dw || sh != dh) {
            this.copy(this, sx, sy, sw, sh, dx, dy, dw, dh);
        } else {
            if (this.imageMode == 1) {
                sw -= sx;
                sh -= sy;
            }
            this.g2.copyArea(sx, sy, sw, sh, dx -= sx, dy -= sy);
        }
    }

    public void copy(PImage src, int sx1, int sy1, int sx2, int sy2, int dx1, int dy1, int dx2, int dy2) {
        this.loadPixels();
        super.copy(src, sx1, sy1, sx2, sy2, dx1, dy1, dx2, dy2);
        this.updatePixels();
    }

    public void blend(int sx1, int sy1, int sx2, int sy2, int dx1, int dy1, int dx2, int dy2, int mode) {
        this.loadPixels();
        super.blend(sx1, sy1, sx2, sy2, dx1, dy1, dx2, dy2, mode);
        this.updatePixels();
    }

    public void blend(PImage src, int sx1, int sy1, int sx2, int sy2, int dx1, int dy1, int dx2, int dy2, int mode) {
        this.loadPixels();
        super.blend(src, sx1, sy1, sx2, sy2, dx1, dy1, dx2, dy2, mode);
        this.updatePixels();
    }

    public void save(String filename) {
        this.loadPixels();
        super.save(filename);
    }

    class ImageCache {
        PImage source;
        boolean tinted;
        int tintedColor;
        int[] tintedPixels;
        BufferedImage image;

        public ImageCache(PImage source) {
            this.source = source;
            int type = 2;
            this.image = new BufferedImage(source.width, source.height, type);
        }

        public void update(boolean tint, int tintColor) {
            if (this.tintedPixels == null) {
                this.tintedPixels = new int[this.source.width * this.source.height];
            }
            if (this.source.format == 2 || this.source.format == 1) {
                if (tint) {
                    int a2 = tintColor >> 24 & 0xFF;
                    int r2 = tintColor >> 16 & 0xFF;
                    int g2 = tintColor >> 8 & 0xFF;
                    int b2 = tintColor & 0xFF;
                    if (this.source.format == 1) {
                        int alpha = a2 << 24;
                        int i = 0;
                        while (i < this.tintedPixels.length) {
                            int argb1 = this.source.pixels[i];
                            int r1 = argb1 >> 16 & 0xFF;
                            int g1 = argb1 >> 8 & 0xFF;
                            int b1 = argb1 & 0xFF;
                            this.tintedPixels[i] = alpha | (r2 * r1 & 0xFF00) << 8 | g2 * g1 & 0xFF00 | (b2 * b1 & 0xFF00) >> 8;
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while (i < this.tintedPixels.length) {
                            int argb1 = this.source.pixels[i];
                            int a1 = argb1 >> 24 & 0xFF;
                            int r1 = argb1 >> 16 & 0xFF;
                            int g1 = argb1 >> 8 & 0xFF;
                            int b1 = argb1 & 0xFF;
                            this.tintedPixels[i] = (a2 * a1 & 0xFF00) << 16 | (r2 * r1 & 0xFF00) << 8 | g2 * g1 & 0xFF00 | (b2 * b1 & 0xFF00) >> 8;
                            ++i;
                        }
                    }
                    this.tinted = true;
                    this.tintedColor = tintColor;
                    WritableRaster raster = this.image.getRaster();
                    raster.setDataElements(0, 0, this.source.width, this.source.height, this.tintedPixels);
                } else {
                    WritableRaster raster = this.image.getRaster();
                    raster.setDataElements(0, 0, this.source.width, this.source.height, this.source.pixels);
                }
            } else if (this.source.format == 4) {
                int lowbits = tintColor & 0xFFFFFF;
                if ((tintColor >> 24 & 0xFF) >= 254) {
                    int i = 0;
                    while (i < this.tintedPixels.length) {
                        this.tintedPixels[i] = this.source.pixels[i] == 0 ? 0 : this.source.pixels[i] << 24 | lowbits;
                        ++i;
                    }
                } else {
                    int alphabits = tintColor >> 24 & 0xFF;
                    int i = 0;
                    while (i < this.tintedPixels.length) {
                        this.tintedPixels[i] = this.source.pixels[i] == 0 ? 0 : (alphabits * this.source.pixels[i] & 0xFF00) << 16 | lowbits;
                        ++i;
                    }
                }
                this.tinted = true;
                this.tintedColor = tintColor;
                WritableRaster raster = this.image.getRaster();
                raster.setDataElements(0, 0, this.source.width, this.source.height, this.tintedPixels);
            }
        }
    }
}

