/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PLine;
import processing.core.PMatrix;
import processing.core.PTriangle;

public class PGraphics3D
extends PGraphics {
    private boolean lightingDependsOnVertexPosition;
    static final int LIGHT_AMBIENT_R = 0;
    static final int LIGHT_AMBIENT_G = 1;
    static final int LIGHT_AMBIENT_B = 2;
    static final int LIGHT_DIFFUSE_R = 3;
    static final int LIGHT_DIFFUSE_G = 4;
    static final int LIGHT_DIFFUSE_B = 5;
    static final int LIGHT_SPECULAR_R = 6;
    static final int LIGHT_SPECULAR_G = 7;
    static final int LIGHT_SPECULAR_B = 8;
    static final int LIGHT_COLOR_COUNT = 9;
    protected float[] tempLightingContribution = new float[9];
    protected float[] worldNormal = new float[4];
    protected float[] dv1 = new float[3];
    protected float[] dv2 = new float[3];
    protected float[] norm = new float[3];
    protected boolean manipulatingCamera;
    protected PMatrix forwardTransform;
    protected PMatrix reverseTransform;
    protected float leftScreen;
    protected float rightScreen;
    protected float topScreen;
    protected float bottomScreen;
    protected float nearPlane;
    protected int vertex_start;
    protected int vertex_end;
    protected int vertex_end_including_clip_verts;
    protected int[] vertex_order = new int[512];
    protected int pathCount;
    protected int[] pathOffset = new int[64];
    protected int[] pathLength = new int[64];
    static final int DEFAULT_LINES = 512;
    public PLine line;
    protected int[][] lines = new int[512][5];
    protected int lineCount;
    static final int DEFAULT_TRIANGLES = 256;
    public PTriangle triangle;
    protected int[][] triangles = new int[256][5];
    protected float[][][] triangleColors = new float[256][3][8];
    protected int triangleCount;
    public int shape_index;
    static final int DEFAULT_TEXTURES = 3;
    protected PImage[] textures = new PImage[3];
    int texture_index;
    float[] sphereX;
    float[] sphereY;
    float[] sphereZ;

    public PGraphics3D(int iwidth, int iheight, PApplet parent) {
        super(iwidth, iheight, parent);
        this.forwardTransform = this.modelview;
        this.reverseTransform = this.modelviewInv;
    }

    public void resize(int iwidth, int iheight) {
        this.insideDrawWait();
        this.insideResize = true;
        this.width = iwidth;
        this.height = iheight;
        this.width1 = this.width - 1;
        this.height1 = this.height - 1;
        this.allocate();
        this.cameraFOV = 1.0471976f;
        this.cameraX = (float)this.width / 2.0f;
        this.cameraY = (float)this.height / 2.0f;
        this.cameraZ = this.cameraY / this.tan(this.cameraFOV / 2.0f);
        this.cameraNear = this.cameraZ / 10.0f;
        this.cameraFar = this.cameraZ * 10.0f;
        this.cameraAspect = (float)this.width / (float)this.height;
        this.lightType = new int[8];
        this.lightPosition = new float[8][3];
        this.lightDiffuse = new float[8][3];
        this.lightNormal = new float[8][3];
        this.lightSpecular = new float[8][3];
        this.lightFalloffConstant = new float[8];
        this.lightFalloffLinear = new float[8];
        this.lightFalloffQuadratic = new float[8];
        this.lightSpotAngle = new float[8];
        this.lightSpotAngleCos = new float[8];
        this.lightSpotConcentration = new float[8];
        this.currentLightSpecular = new float[3];
        this.projection = new PMatrix();
        this.modelview = new PMatrix(32);
        this.modelviewInv = new PMatrix(32);
        this.forwardTransform = this.modelview;
        this.reverseTransform = this.modelviewInv;
        this.camera = new PMatrix();
        this.cameraInv = new PMatrix();
        this.camera();
        this.perspective();
        this.insideResize = false;
    }

    protected void allocate() {
        this.pixelCount = this.width * this.height;
        this.pixels = new int[this.pixelCount];
        this.zbuffer = new float[this.pixelCount];
        if (this.mainDrawingSurface) {
            int i = 0;
            while (i < this.pixelCount) {
                this.pixels[i] = this.backgroundColor;
                ++i;
            }
            this.cm = new DirectColorModel(32, 0xFF0000, 65280, 255);
            this.mis = new MemoryImageSource(this.width, this.height, this.pixels, 0, this.width);
            this.mis.setFullBufferUpdates(true);
            this.mis.setAnimated(true);
            this.image = Toolkit.getDefaultToolkit().createImage(this.mis);
        } else {
            int i = 0;
            while (i < this.pixelCount) {
                this.zbuffer[i] = Float.MAX_VALUE;
                ++i;
            }
        }
        this.stencil = new int[this.pixelCount];
        this.line = new PLine(this);
        this.triangle = new PTriangle(this);
    }

    public void beginDraw() {
        this.insideResizeWait();
        this.insideDraw = true;
        if (!this.defaultsInited) {
            this.defaults();
        }
        this.resetMatrix();
        this.vertexCount = 0;
        this.modelview.set(this.camera);
        this.modelviewInv.set(this.cameraInv);
        this.lightCount = 0;
        this.lightingDependsOnVertexPosition = false;
        this.lightFalloff(1.0f, 0.0f, 0.0f);
        this.lightSpecular(0.0f, 0.0f, 0.0f);
        this.lineCount = 0;
        if (this.line != null) {
            this.line.reset();
        }
        this.pathCount = 0;
        this.triangleCount = 0;
        if (this.triangle != null) {
            this.triangle.reset();
        }
        this.vertex_start = 0;
        this.texture_index = 0;
        this.normal(0.0f, 0.0f, 1.0f);
    }

    public void endDraw() {
        if (this.hints[7]) {
            this.flush();
        }
        if (this.mis != null) {
            this.mis.newPixels(this.pixels, (ColorModel)this.cm, 0, this.width);
        }
        this.updatePixels();
        this.insideDraw = false;
    }

    protected void flush() {
        if (this.triangleCount > 0) {
            if (this.hints[7]) {
                this.depth_sort_triangles();
            }
            this.render_triangles();
        }
        if (this.lineCount > 0) {
            if (this.hints[7]) {
                this.depth_sort_lines();
            }
            this.render_lines();
        }
    }

    public void defaults() {
        super.defaults();
        this.manipulatingCamera = false;
        this.forwardTransform = this.modelview;
        this.reverseTransform = this.modelviewInv;
        this.perspective();
        this.textureMode(2);
        this.emissive(0.0f);
        this.specular(0.5f);
        this.shininess(1.0f);
    }

    public void beginShape(int kind) {
        this.shape = kind;
        ++this.shape_index;
        if (this.shape_index == -1) {
            this.shape_index = 0;
        }
        if (this.hints[7]) {
            this.vertex_start = this.vertexCount;
            this.vertex_end = 0;
        } else {
            this.vertexCount = 0;
            if (this.line != null) {
                this.line.reset();
            }
            this.lineCount = 0;
            this.pathCount = 0;
            if (this.triangle != null) {
                this.triangle.reset();
            }
            this.triangleCount = 0;
        }
        this.textureImage = null;
        this.splineVertexCount = 0;
        this.normalMode = 0;
        this.normalCount = 0;
    }

    public void normal(float nx, float ny, float nz) {
        this.normalX = nx;
        this.normalY = ny;
        this.normalZ = nz;
        if (this.shape != 0) {
            if (this.normalCount == 0) {
                int i = this.vertex_start;
                while (i < this.vertexCount) {
                    this.vertices[i][17] = this.normalX;
                    this.vertices[i][18] = this.normalY;
                    this.vertices[i][19] = this.normalZ;
                    ++i;
                }
            }
            ++this.normalCount;
            this.normalMode = this.normalCount == 1 ? 1 : 2;
        }
    }

    public void texture(PImage image) {
        this.textureImage = image;
        if (this.texture_index == this.textures.length - 1) {
            PImage[] temp = new PImage[this.texture_index << 1];
            System.arraycopy(this.textures, 0, temp, 0, this.texture_index);
            this.textures = temp;
        }
        if (this.textures[this.texture_index] != null) {
            ++this.texture_index;
        }
        this.textures[this.texture_index] = image;
    }

    public void vertex(float x, float y) {
        this.setup_vertex(x, y, 0.0f);
    }

    public void vertex(float x, float y, float u, float v) {
        this.textureVertex(u, v);
        this.setup_vertex(x, y, 0.0f);
    }

    public void vertex(float x, float y, float z) {
        this.setup_vertex(x, y, z);
    }

    public void vertex(float x, float y, float z, float u, float v) {
        this.textureVertex(u, v);
        this.setup_vertex(x, y, z);
    }

    protected void setup_vertex(float x, float y, float z) {
        float[] pvertex;
        if (this.vertexCount == this.vertices.length) {
            float[][] temp = new float[this.vertexCount << 1][36];
            System.arraycopy(this.vertices, 0, temp, 0, this.vertexCount);
            this.vertices = temp;
            int[] temp2 = new int[this.vertexCount << 1];
            System.arraycopy(this.vertex_order, 0, temp2, 0, this.vertexCount);
            this.vertex_order = temp2;
        }
        float[] vertex = this.vertices[this.vertexCount];
        if (this.shape == 256 && this.vertexCount > 0 && this.abs((pvertex = this.vertices[this.vertexCount - 1])[9] - x) < 1.0E-4f && this.abs(pvertex[10] - y) < 1.0E-4f && this.abs(pvertex[11] - z) < 1.0E-4f) {
            return;
        }
        this.splineVertexCount = 0;
        vertex[9] = x;
        vertex[10] = y;
        vertex[11] = z;
        if (this.fill) {
            vertex[3] = this.fillR;
            vertex[4] = this.fillG;
            vertex[5] = this.fillB;
            vertex[6] = this.fillA;
            vertex[24] = this.ambientR;
            vertex[25] = this.ambientG;
            vertex[26] = this.ambientB;
            vertex[27] = this.specularR;
            vertex[28] = this.specularG;
            vertex[29] = this.specularB;
            vertex[30] = this.specularA;
            vertex[31] = this.shininess;
            vertex[32] = this.emissiveR;
            vertex[33] = this.emissiveG;
            vertex[34] = this.emissiveB;
        }
        if (this.stroke) {
            vertex[12] = this.strokeR;
            vertex[13] = this.strokeG;
            vertex[14] = this.strokeB;
            vertex[15] = this.strokeA;
            vertex[16] = this.strokeWeight;
        }
        if (this.textureImage != null) {
            vertex[7] = this.textureU;
            vertex[8] = this.textureV;
        }
        vertex[17] = this.normalX;
        vertex[18] = this.normalY;
        vertex[19] = this.normalZ;
        vertex[35] = 0.0f;
        ++this.vertexCount;
    }

    public void bezierVertex(float x2, float y2, float x3, float y3, float x4, float y4) {
        this.bezierVertex(x2, y2, 0.0f, x3, y3, 0.0f, x4, y4, 0.0f);
    }

    public void bezierVertex(float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        if (this.splineVertexCount > 0) {
            float[] vertex = this.splineVertices[this.splineVertexCount - 1];
            this.splineVertex(vertex[9], vertex[10], vertex[11], true);
        } else if (this.vertexCount > 0) {
            float[] vertex = this.vertices[this.vertexCount - 1];
            this.splineVertex(vertex[9], vertex[10], vertex[11], true);
        } else {
            throw new RuntimeException("A call to vertex() must be used before bezierVertex()");
        }
        this.splineVertex(x2, y2, z2, true);
        this.splineVertex(x3, y3, z3, true);
        this.splineVertex(x4, y4, z4, true);
    }

    public void endShape(int mode) {
        int i;
        this.vertex_end_including_clip_verts = this.vertex_end = this.vertexCount;
        if (this.vertexCount == 0) {
            this.shape = 0;
            return;
        }
        int i2 = this.vertex_start;
        while (i2 < this.vertex_end) {
            float[] vertex = this.vertices[i2];
            vertex[20] = this.modelview.m00 * vertex[9] + this.modelview.m01 * vertex[10] + this.modelview.m02 * vertex[11] + this.modelview.m03;
            vertex[21] = this.modelview.m10 * vertex[9] + this.modelview.m11 * vertex[10] + this.modelview.m12 * vertex[11] + this.modelview.m13;
            vertex[22] = this.modelview.m20 * vertex[9] + this.modelview.m21 * vertex[10] + this.modelview.m22 * vertex[11] + this.modelview.m23;
            vertex[23] = this.modelview.m30 * vertex[9] + this.modelview.m31 * vertex[10] + this.modelview.m32 * vertex[11] + this.modelview.m33;
            if (vertex[23] != 0.0f && vertex[23] != 1.0f) {
                vertex[20] = vertex[20] / vertex[23];
                vertex[21] = vertex[21] / vertex[23];
                vertex[22] = vertex[22] / vertex[23];
            }
            vertex[23] = 1.0f;
            ++i2;
        }
        int increment = 1;
        int stop = 0;
        if (this.stroke) {
            switch (this.shape) {
                case 16: {
                    stop = this.vertex_end;
                    i = this.vertex_start;
                    while (i < stop) {
                        this.add_path();
                        this.add_line(i, i);
                        ++i;
                    }
                    break;
                }
                case 32: {
                    int first = this.lineCount;
                    stop = this.vertex_end - 1;
                    int n = increment = this.shape == 32 ? 2 : 1;
                    if (this.shape != 32) {
                        this.add_path();
                    }
                    int i3 = this.vertex_start;
                    while (i3 < stop) {
                        if (this.shape == 32) {
                            this.add_path();
                        }
                        this.add_line(i3, i3 + 1);
                        i3 += increment;
                    }
                    if (mode != 2) break;
                    this.add_line(stop, this.lines[first][1]);
                    break;
                }
                case 64: {
                    i = this.vertex_start;
                    while (i < this.vertex_end - 2) {
                        this.add_path();
                        this.add_line(i + 0, i + 1);
                        this.add_line(i + 1, i + 2);
                        this.add_line(i + 2, i + 0);
                        i += 3;
                    }
                    break;
                }
                case 65: {
                    stop = this.vertex_end - 1;
                    this.add_path();
                    i = this.vertex_start;
                    while (i < stop) {
                        this.add_line(i, i + 1);
                        ++i;
                    }
                    stop = this.vertex_end - 2;
                    i = this.vertex_start;
                    while (i < stop) {
                        this.add_path();
                        this.add_line(i, i + 2);
                        ++i;
                    }
                    break;
                }
                case 66: {
                    i = this.vertex_start + 1;
                    while (i < this.vertex_end) {
                        this.add_path();
                        this.add_line(this.vertex_start, i);
                        ++i;
                    }
                    this.add_path();
                    i = this.vertex_start + 1;
                    while (i < this.vertex_end - 1) {
                        this.add_line(i, i + 1);
                        ++i;
                    }
                    this.add_line(this.vertex_end - 1, this.vertex_start + 1);
                    break;
                }
                case 128: {
                    i = this.vertex_start;
                    while (i < this.vertex_end) {
                        this.add_path();
                        this.add_line(i + 0, i + 1);
                        this.add_line(i + 1, i + 2);
                        this.add_line(i + 2, i + 3);
                        this.add_line(i + 3, i + 0);
                        i += 4;
                    }
                    break;
                }
                case 129: {
                    i = this.vertex_start;
                    while (i < this.vertex_end - 3) {
                        this.add_path();
                        this.add_line(i + 0, i + 2);
                        this.add_line(i + 2, i + 3);
                        this.add_line(i + 3, i + 1);
                        this.add_line(i + 1, i + 0);
                        i += 2;
                    }
                    break;
                }
                case 256: {
                    stop = this.vertex_end - 1;
                    this.add_path();
                    i = this.vertex_start;
                    while (i < stop) {
                        this.add_line(i, i + 1);
                        ++i;
                    }
                    if (mode != 2) break;
                    this.add_line(stop, this.vertex_start);
                }
            }
        }
        if (this.fill) {
            switch (this.shape) {
                case 66: {
                    stop = this.vertex_end - 1;
                    i = this.vertex_start + 1;
                    while (i < stop) {
                        this.add_triangle(this.vertex_start, i, i + 1);
                        ++i;
                    }
                    break;
                }
                case 64: 
                case 65: {
                    stop = this.vertex_end - 2;
                    increment = this.shape == 64 ? 3 : 1;
                    i = this.vertex_start;
                    while (i < stop) {
                        if (i % 2 == 0) {
                            this.add_triangle(i, i + 2, i + 1);
                        } else {
                            this.add_triangle(i, i + 1, i + 2);
                        }
                        i += increment;
                    }
                    break;
                }
                case 128: {
                    stop = this.vertexCount - 3;
                    i = this.vertex_start;
                    while (i < stop) {
                        this.add_triangle(i, i + 1, i + 2);
                        this.add_triangle(i, i + 2, i + 3);
                        i += 4;
                    }
                    break;
                }
                case 129: {
                    stop = this.vertexCount - 3;
                    i = this.vertex_start;
                    while (i < stop) {
                        this.add_triangle(i + 0, i + 2, i + 1);
                        this.add_triangle(i + 2, i + 3, i + 1);
                        i += 2;
                    }
                    break;
                }
                case 256: {
                    this.triangulate_polygon();
                }
            }
        }
        if (this.lightCount > 0 && this.fill) {
            this.handle_lighting();
        } else {
            this.handle_no_lighting();
        }
        i = this.vertex_start;
        while (i < this.vertex_end_including_clip_verts) {
            float[] vx = this.vertices[i];
            float ox = this.projection.m00 * vx[20] + this.projection.m01 * vx[21] + this.projection.m02 * vx[22] + this.projection.m03 * vx[23];
            float oy = this.projection.m10 * vx[20] + this.projection.m11 * vx[21] + this.projection.m12 * vx[22] + this.projection.m13 * vx[23];
            float oz = this.projection.m20 * vx[20] + this.projection.m21 * vx[21] + this.projection.m22 * vx[22] + this.projection.m23 * vx[23];
            float ow = this.projection.m30 * vx[20] + this.projection.m31 * vx[21] + this.projection.m32 * vx[22] + this.projection.m33 * vx[23];
            if (ow != 0.0f && ow != 1.0f) {
                ox /= ow;
                oy /= ow;
                oz /= ow;
            }
            vx[0] = (float)this.width * (1.0f + ox) / 2.0f;
            vx[1] = (float)this.height * (1.0f + oy) / 2.0f;
            vx[2] = (oz + 1.0f) / 2.0f;
            ++i;
        }
        if (!this.hints[7]) {
            if (this.fill) {
                this.render_triangles();
            }
            if (this.stroke) {
                this.render_lines();
            }
        }
        this.shape = 0;
    }

    protected final void add_path() {
        if (this.pathCount == this.pathOffset.length) {
            int[] temp1 = new int[this.pathCount << 1];
            System.arraycopy(this.pathOffset, 0, temp1, 0, this.pathCount);
            this.pathOffset = temp1;
            int[] temp2 = new int[this.pathCount << 1];
            System.arraycopy(this.pathLength, 0, temp2, 0, this.pathCount);
            this.pathLength = temp2;
        }
        this.pathOffset[this.pathCount] = this.lineCount;
        this.pathLength[this.pathCount] = 0;
        ++this.pathCount;
    }

    protected void add_line(int a, int b) {
        this.add_line_with_clip(a, b);
    }

    protected final void add_line_with_clip(int a, int b) {
        float az = this.vertices[a][22];
        float bz = this.vertices[b][22];
        if (az > this.cameraNear) {
            if (bz > this.cameraNear) {
                return;
            }
            int cb = this.interpolate_clip_vertex(a, b);
            this.add_line_no_clip(cb, b);
            return;
        }
        if (bz <= this.cameraNear) {
            this.add_line_no_clip(a, b);
            return;
        }
        int cb = this.interpolate_clip_vertex(a, b);
        this.add_line_no_clip(a, cb);
    }

    protected final void add_line_no_clip(int a, int b) {
        if (this.lineCount == this.lines.length) {
            int[][] temp = new int[this.lineCount << 1][5];
            System.arraycopy(this.lines, 0, temp, 0, this.lineCount);
            this.lines = temp;
        }
        this.lines[this.lineCount][1] = a;
        this.lines[this.lineCount][2] = b;
        this.lines[this.lineCount][0] = -1;
        this.lines[this.lineCount][3] = this.strokeCap | this.strokeJoin;
        this.lines[this.lineCount][4] = (int)(this.strokeWeight + 0.5f);
        ++this.lineCount;
        int n = this.pathCount - 1;
        this.pathLength[n] = this.pathLength[n] + 1;
    }

    protected void add_triangle(int a, int b, int c) {
        this.add_triangle_with_clip(a, b, c);
    }

    protected final void add_triangle_with_clip(int a, int b, int c) {
        int cc;
        int cb;
        int ca;
        boolean aClipped = false;
        boolean bClipped = false;
        int clippedCount = 0;
        this.cameraNear = -8.0f;
        if (this.vertices[a][22] > this.cameraNear) {
            aClipped = true;
            ++clippedCount;
        }
        if (this.vertices[b][22] > this.cameraNear) {
            bClipped = true;
            ++clippedCount;
        }
        if (this.vertices[c][22] > this.cameraNear) {
            ++clippedCount;
        }
        if (clippedCount == 0) {
            this.add_triangle_no_clip(a, b, c);
            return;
        }
        if (clippedCount == 3) {
            return;
        }
        if (clippedCount == 2) {
            int cc2;
            int cb2;
            int ca2;
            if (!aClipped) {
                ca2 = a;
                cb2 = b;
                cc2 = c;
            } else if (!bClipped) {
                ca2 = b;
                cb2 = a;
                cc2 = c;
            } else {
                ca2 = c;
                cb2 = b;
                cc2 = a;
            }
            int cd = this.interpolate_clip_vertex(ca2, cb2);
            int ce = this.interpolate_clip_vertex(ca2, cc2);
            this.add_triangle_no_clip(ca2, cd, ce);
            return;
        }
        if (aClipped) {
            ca = c;
            cb = b;
            cc = a;
        } else if (bClipped) {
            ca = a;
            cb = c;
            cc = b;
        } else {
            ca = a;
            cb = b;
            cc = c;
        }
        int cd = this.interpolate_clip_vertex(ca, cc);
        int ce = this.interpolate_clip_vertex(cb, cc);
        this.add_triangle_no_clip(ca, cd, cb);
        this.add_triangle_no_clip(cb, cd, ce);
    }

    private final int interpolate_clip_vertex(int a, int b) {
        float[] vb;
        float[] va;
        if (this.vertices[a][22] < this.vertices[b][22]) {
            va = this.vertices[b];
            vb = this.vertices[a];
        } else {
            va = this.vertices[a];
            vb = this.vertices[b];
        }
        float az = va[22];
        float bz = vb[22];
        float dz = az - bz;
        if (dz == 0.0f) {
            return a;
        }
        float pa = (this.cameraNear - bz) / dz;
        float pb = 1.0f - pa;
        this.vertex(pa * va[9] + pb * vb[9], pa * va[10] + pb * vb[10], pa * va[11] + pb * vb[11]);
        int irv = this.vertexCount - 1;
        ++this.vertex_end_including_clip_verts;
        float[] rv = this.vertices[irv];
        rv[0] = pa * va[0] + pb * vb[0];
        rv[1] = pa * va[1] + pb * vb[1];
        rv[2] = pa * va[2] + pb * vb[2];
        rv[20] = pa * va[20] + pb * vb[20];
        rv[21] = pa * va[21] + pb * vb[21];
        rv[22] = pa * va[22] + pb * vb[22];
        rv[23] = pa * va[23] + pb * vb[23];
        rv[3] = pa * va[3] + pb * vb[3];
        rv[4] = pa * va[4] + pb * vb[4];
        rv[5] = pa * va[5] + pb * vb[5];
        rv[6] = pa * va[6] + pb * vb[6];
        rv[7] = pa * va[7] + pb * vb[7];
        rv[8] = pa * va[8] + pb * vb[8];
        rv[12] = pa * va[12] + pb * vb[12];
        rv[13] = pa * va[13] + pb * vb[13];
        rv[14] = pa * va[14] + pb * vb[14];
        rv[15] = pa * va[15] + pb * vb[15];
        rv[17] = pa * va[17] + pb * vb[17];
        rv[18] = pa * va[18] + pb * vb[18];
        rv[19] = pa * va[19] + pb * vb[19];
        rv[16] = pa * va[16] + pb * vb[16];
        rv[24] = pa * va[24] + pb * vb[24];
        rv[25] = pa * va[25] + pb * vb[25];
        rv[26] = pa * va[26] + pb * vb[26];
        rv[27] = pa * va[27] + pb * vb[27];
        rv[28] = pa * va[28] + pb * vb[28];
        rv[29] = pa * va[29] + pb * vb[29];
        rv[30] = pa * va[30] + pb * vb[30];
        rv[32] = pa * va[32] + pb * vb[32];
        rv[33] = pa * va[33] + pb * vb[33];
        rv[34] = pa * va[34] + pb * vb[34];
        rv[31] = pa * va[31] + pb * vb[31];
        rv[35] = 0.0f;
        return irv;
    }

    protected final void add_triangle_no_clip(int a, int b, int c) {
        if (this.triangleCount == this.triangles.length) {
            int[][] temp = new int[this.triangleCount << 1][5];
            System.arraycopy(this.triangles, 0, temp, 0, this.triangleCount);
            this.triangles = temp;
            float[][][] ftemp = new float[this.triangleCount << 1][3][8];
            System.arraycopy(this.triangleColors, 0, ftemp, 0, this.triangleCount);
            this.triangleColors = ftemp;
        }
        this.triangles[this.triangleCount][1] = a;
        this.triangles[this.triangleCount][2] = b;
        this.triangles[this.triangleCount][3] = c;
        this.triangles[this.triangleCount][4] = this.textureImage == null ? -1 : this.texture_index;
        this.triangles[this.triangleCount][0] = this.shape_index;
        ++this.triangleCount;
    }

    protected void depth_sort_triangles() {
        this.depth_sort_triangles_internal(0, this.triangleCount - 1);
    }

    protected void depth_sort_triangles_internal(int i, int j) {
        int pivotIndex = (i + j) / 2;
        this.depth_sort_triangles_swap(pivotIndex, j);
        int k = this.depth_sort_triangles_partition(i - 1, j);
        this.depth_sort_triangles_swap(k, j);
        if (k - i > 1) {
            this.depth_sort_triangles_internal(i, k - 1);
        }
        if (j - k > 1) {
            this.depth_sort_triangles_internal(k + 1, j);
        }
    }

    protected int depth_sort_triangles_partition(int left, int right) {
        int pivot = right;
        while (true) {
            if (this.depth_sort_triangles_compare(++left, pivot) < 0.0f) {
                continue;
            }
            while (right != 0 && this.depth_sort_triangles_compare(--right, pivot) > 0.0f) {
            }
            this.depth_sort_triangles_swap(left, right);
            if (left >= right) break;
        }
        this.depth_sort_triangles_swap(left, right);
        return left;
    }

    protected void depth_sort_triangles_swap(int a, int b) {
        int[] tempi = this.triangles[a];
        this.triangles[a] = this.triangles[b];
        this.triangles[b] = tempi;
        float[][] tempf = this.triangleColors[a];
        this.triangleColors[a] = this.triangleColors[b];
        this.triangleColors[b] = tempf;
    }

    protected float depth_sort_triangles_compare(int a, int b) {
        if (Float.isNaN(this.vertices[this.triangles[a][1]][2]) || Float.isNaN(this.vertices[this.triangles[a][2]][2]) || Float.isNaN(this.vertices[this.triangles[a][3]][2]) || Float.isNaN(this.vertices[this.triangles[b][1]][2]) || Float.isNaN(this.vertices[this.triangles[b][2]][2]) || Float.isNaN(this.vertices[this.triangles[b][3]][2])) {
            throw new RuntimeException("nan triangle");
        }
        return this.vertices[this.triangles[b][1]][2] + this.vertices[this.triangles[b][2]][2] + this.vertices[this.triangles[b][3]][2] - (this.vertices[this.triangles[a][1]][2] + this.vertices[this.triangles[a][2]][2] + this.vertices[this.triangles[a][3]][2]);
    }

    protected void render_triangles() {
        if (this.raw != null) {
            this.raw.colorMode(1, 1.0f);
            this.raw.noStroke();
            this.raw.beginShape(64);
        }
        int i = 0;
        while (i < this.triangleCount) {
            float[] a = this.vertices[this.triangles[i][1]];
            float[] b = this.vertices[this.triangles[i][2]];
            float[] c = this.vertices[this.triangles[i][3]];
            int tex = this.triangles[i][4];
            int index = this.triangles[i][0];
            float shift = 0.15f;
            boolean shifted = false;
            if (this.drawing2D() && a[11] == 0.0f) {
                shifted = true;
                a[0] = a[0] + shift;
                a[1] = a[1] + shift;
                a[20] = a[20] + shift * a[23];
                a[21] = a[21] + shift * a[23];
                b[0] = b[0] + shift;
                b[1] = b[1] + shift;
                b[20] = b[20] + shift * b[23];
                b[21] = b[21] + shift * b[23];
                c[0] = c[0] + shift;
                c[1] = c[1] + shift;
                c[20] = c[20] + shift * c[23];
                c[21] = c[21] + shift * c[23];
            }
            this.triangle.reset();
            float ar = this.min(1.0f, this.triangleColors[i][0][0] + this.triangleColors[i][0][4]);
            float ag = this.min(1.0f, this.triangleColors[i][0][1] + this.triangleColors[i][0][5]);
            float ab = this.min(1.0f, this.triangleColors[i][0][2] + this.triangleColors[i][0][6]);
            float br = this.min(1.0f, this.triangleColors[i][1][0] + this.triangleColors[i][1][4]);
            float bg = this.min(1.0f, this.triangleColors[i][1][1] + this.triangleColors[i][1][5]);
            float bb = this.min(1.0f, this.triangleColors[i][1][2] + this.triangleColors[i][1][6]);
            float cr = this.min(1.0f, this.triangleColors[i][2][0] + this.triangleColors[i][2][4]);
            float cg = this.min(1.0f, this.triangleColors[i][2][1] + this.triangleColors[i][2][5]);
            float cb = this.min(1.0f, this.triangleColors[i][2][2] + this.triangleColors[i][2][6]);
            if (tex > -1 && this.textures[tex] != null) {
                this.triangle.setTexture(this.textures[tex]);
                this.triangle.setUV(a[7], a[8], b[7], b[8], c[7], c[8]);
            }
            this.triangle.setIntensities(ar, ag, ab, a[6], br, bg, bb, b[6], cr, cg, cb, c[6]);
            this.triangle.setVertices(a[0], a[1], a[2], b[0], b[1], b[2], c[0], c[1], c[2]);
            if (this.hints[9]) {
                this.triangle.setCamVertices(a[20], a[21], a[22], b[20], b[21], b[22], c[20], c[21], c[22]);
            }
            this.triangle.setIndex(index);
            this.triangle.render();
            if (this.raw != null) {
                if (this.raw instanceof PGraphics3D) {
                    if (a[23] != 0.0f && b[23] != 0.0f && c[23] != 0.0f) {
                        this.raw.fill(ar, ag, ab, a[6]);
                        this.raw.vertex(a[20] / a[23], a[21] / a[23], a[22] / a[23]);
                        this.raw.fill(br, bg, bb, b[6]);
                        this.raw.vertex(b[20] / b[23], b[21] / b[23], b[22] / b[23]);
                        this.raw.fill(cr, cg, cb, c[6]);
                        this.raw.vertex(c[20] / c[23], c[21] / c[23], c[22] / c[23]);
                    }
                } else {
                    this.raw.fill(ar, ag, ab, a[6]);
                    this.raw.vertex(a[0], a[1]);
                    this.raw.fill(br, bg, bb, b[6]);
                    this.raw.vertex(b[0], b[1]);
                    this.raw.fill(cr, cg, cb, c[6]);
                    this.raw.vertex(c[0], c[1]);
                }
            }
            if (this.drawing2D() && shifted) {
                a[0] = a[0] - shift;
                a[1] = a[1] - shift;
                a[20] = a[20] - shift * a[23];
                a[21] = a[21] - shift * a[23];
                b[0] = b[0] - shift;
                b[1] = b[1] - shift;
                b[20] = b[20] - shift * b[23];
                b[21] = b[21] - shift * b[23];
                c[0] = c[0] - shift;
                c[1] = c[1] - shift;
                c[20] = c[20] - shift * c[23];
                c[21] = c[21] - shift * c[23];
            }
            ++i;
        }
        if (this.raw != null) {
            this.raw.endShape();
        }
    }

    protected void depth_sort_lines() {
    }

    protected void render_lines() {
        if (this.raw != null) {
            this.raw.colorMode(1, 1.0f);
            this.raw.noFill();
            this.raw.beginShape(32);
        }
        int i = 0;
        while (i < this.lineCount) {
            float[] a = this.vertices[this.lines[i][1]];
            float[] b = this.vertices[this.lines[i][2]];
            int index = this.lines[i][0];
            if (this.drawing2D() && a[11] == 0.0f) {
                a[0] = (float)((double)a[0] + 0.01);
                a[1] = (float)((double)a[1] + 0.01);
                a[20] = (float)((double)a[20] + 0.01 * (double)a[23]);
                a[21] = (float)((double)a[21] + 0.01 * (double)a[23]);
                b[0] = (float)((double)b[0] + 0.01);
                b[1] = (float)((double)b[1] + 0.01);
                b[20] = (float)((double)b[20] + 0.01 * (double)b[23]);
                b[21] = (float)((double)b[21] + 0.01 * (double)b[23]);
            }
            this.line.reset();
            this.line.setIntensities(a[12], a[13], a[14], a[15], b[12], b[13], b[14], b[15]);
            this.line.setVertices(a[0], a[1], a[2], b[0], b[1], b[2]);
            if (this.raw != null) {
                if (this.raw instanceof PGraphics3D) {
                    if (a[23] != 0.0f && b[23] != 0.0f) {
                        this.raw.stroke(a[12], a[13], a[14], a[15]);
                        this.raw.vertex(a[20] / a[23], a[21] / a[23], a[22] / a[23]);
                        this.raw.stroke(b[12], b[13], b[14], b[15]);
                        this.raw.vertex(b[20] / b[23], b[21] / b[23], b[22] / b[23]);
                    }
                } else {
                    this.raw.stroke(a[12], a[13], a[14], a[15]);
                    this.raw.vertex(a[0], a[1]);
                    this.raw.stroke(b[12], b[13], b[14], b[15]);
                    this.raw.vertex(b[0], b[1]);
                }
            }
            this.line.setIndex(index);
            this.line.draw();
            ++i;
        }
        if (this.raw != null) {
            this.raw.endShape();
        }
    }

    private void triangulate_polygon() {
        int i;
        float[] vlast;
        float[] vfirst;
        int d1 = 9;
        int d2 = 10;
        float area = 0.0f;
        int p = this.vertex_end - 1;
        int q = this.vertex_start;
        while (q < this.vertex_end) {
            area += this.vertices[q][d1] * this.vertices[p][d2] - this.vertices[p][d1] * this.vertices[q][d2];
            p = q++;
        }
        if (area == 0.0f) {
            boolean foundValidX = false;
            boolean foundValidY = false;
            int i2 = this.vertex_start;
            while (i2 < this.vertex_end) {
                int j = i2;
                while (j < this.vertex_end) {
                    if (this.vertices[i2][9] != this.vertices[j][9]) {
                        foundValidX = true;
                    }
                    if (this.vertices[i2][10] != this.vertices[j][10]) {
                        foundValidY = true;
                    }
                    ++j;
                }
                ++i2;
            }
            if (foundValidX) {
                d2 = 11;
            } else if (foundValidY) {
                d1 = 10;
                d2 = 11;
            } else {
                return;
            }
            int p2 = this.vertex_end - 1;
            int q2 = this.vertex_start;
            while (q2 < this.vertex_end) {
                area += this.vertices[q2][d1] * this.vertices[p2][d2] - this.vertices[p2][d1] * this.vertices[q2][d2];
                p2 = q2++;
            }
        }
        if (this.abs((vfirst = this.vertices[this.vertex_start])[9] - (vlast = this.vertices[this.vertex_end - 1])[9]) < 1.0E-4f && this.abs(vfirst[10] - vlast[10]) < 1.0E-4f && this.abs(vfirst[11] - vlast[11]) < 1.0E-4f) {
            --this.vertex_end;
        }
        int j = 0;
        if (area > 0.0f) {
            i = this.vertex_start;
            while (i < this.vertex_end) {
                j = i - this.vertex_start;
                this.vertex_order[j] = i++;
            }
        } else {
            i = this.vertex_start;
            while (i < this.vertex_end) {
                j = i - this.vertex_start;
                this.vertex_order[j] = this.vertex_end - 1 - j;
                ++i;
            }
        }
        int vc = this.vertex_end - this.vertex_start;
        int count = 2 * vc;
        int m = 0;
        int v = vc - 1;
        while (vc > 2) {
            float Cx;
            float By;
            float Ay;
            float Cy;
            float Ax;
            float Bx;
            int w;
            boolean snip = true;
            if (count-- <= 0) break;
            int u = v;
            if (vc <= u) {
                u = 0;
            }
            if (vc <= (v = u + 1)) {
                v = 0;
            }
            if (vc <= (w = v + 1)) {
                w = 0;
            }
            if (1.0E-4f > ((Bx = -this.vertices[this.vertex_order[v]][d1]) - (Ax = -this.vertices[this.vertex_order[u]][d1])) * ((Cy = this.vertices[this.vertex_order[w]][d2]) - (Ay = this.vertices[this.vertex_order[u]][d2])) - ((By = this.vertices[this.vertex_order[v]][d2]) - Ay) * ((Cx = -this.vertices[this.vertex_order[w]][d1]) - Ax)) continue;
            int p3 = 0;
            while (p3 < vc) {
                if (p3 != u && p3 != v && p3 != w) {
                    float Px = -this.vertices[this.vertex_order[p3]][d1];
                    float Py = this.vertices[this.vertex_order[p3]][d2];
                    float ax = Cx - Bx;
                    float ay = Cy - By;
                    float bx = Ax - Cx;
                    float by = Ay - Cy;
                    float cx = Bx - Ax;
                    float cy = By - Ay;
                    float apx = Px - Ax;
                    float apy = Py - Ay;
                    float bpx = Px - Bx;
                    float bpy = Py - By;
                    float cpx = Px - Cx;
                    float cpy = Py - Cy;
                    float aCROSSbp = ax * bpy - ay * bpx;
                    float cCROSSap = cx * apy - cy * apx;
                    float bCROSScp = bx * cpy - by * cpx;
                    if (aCROSSbp >= 0.0f && bCROSScp >= 0.0f && cCROSSap >= 0.0f) {
                        snip = false;
                    }
                }
                ++p3;
            }
            if (!snip) continue;
            this.add_triangle(this.vertex_order[u], this.vertex_order[v], this.vertex_order[w]);
            ++m;
            int s = v;
            int t = v + 1;
            while (t < vc) {
                this.vertex_order[s] = this.vertex_order[t];
                ++s;
                ++t;
            }
            count = 2 * --vc;
        }
    }

    private void toWorldNormal(float nx, float ny, float nz, float[] out) {
        out[0] = this.modelviewInv.m00 * nx + this.modelviewInv.m10 * ny + this.modelviewInv.m20 * nz + this.modelviewInv.m30;
        out[1] = this.modelviewInv.m01 * nx + this.modelviewInv.m11 * ny + this.modelviewInv.m21 * nz + this.modelviewInv.m31;
        out[2] = this.modelviewInv.m02 * nx + this.modelviewInv.m12 * ny + this.modelviewInv.m22 * nz + this.modelviewInv.m32;
        out[3] = this.modelviewInv.m03 * nx + this.modelviewInv.m13 * ny + this.modelviewInv.m23 * nz + this.modelviewInv.m33;
        if (out[3] != 0.0f && out[3] != 1.0f) {
            out[0] = out[0] / out[3];
            out[1] = out[1] / out[3];
            out[2] = out[2] / out[3];
        }
        out[3] = 1.0f;
        float nlen = this.mag(out[0], out[1], out[2]);
        if (nlen != 0.0f && nlen != 1.0f) {
            out[0] = out[0] / nlen;
            out[1] = out[1] / nlen;
            out[2] = out[2] / nlen;
        }
    }

    private void calc_lighting_contribution(int vIndex, float[] contribution) {
        this.calc_lighting_contribution(vIndex, contribution, false);
    }

    private void calc_lighting_contribution(int vIndex, float[] contribution, boolean normalIsWorld) {
        float nz;
        float ny;
        float nx;
        float[] v = this.vertices[vIndex];
        float sr = v[27];
        float sg = v[28];
        float sb = v[29];
        float wx = v[20];
        float wy = v[21];
        float wz = v[22];
        float shine = v[31];
        if (!normalIsWorld) {
            this.toWorldNormal(v[17], v[18], v[19], this.worldNormal);
            nx = this.worldNormal[0];
            ny = this.worldNormal[1];
            nz = this.worldNormal[2];
        } else {
            nx = v[17];
            ny = v[18];
            nz = v[19];
        }
        float dir = this.dot(nx, ny, nz, -wx, -wy, -wz);
        if (dir < 0.0f) {
            nx = -nx;
            ny = -ny;
            nz = -nz;
        }
        contribution[0] = 0.0f;
        contribution[1] = 0.0f;
        contribution[2] = 0.0f;
        contribution[3] = 0.0f;
        contribution[4] = 0.0f;
        contribution[5] = 0.0f;
        contribution[6] = 0.0f;
        contribution[7] = 0.0f;
        contribution[8] = 0.0f;
        int i = 0;
        while (i < this.lightCount) {
            block17: {
                float liz;
                float liy;
                float lix;
                float n_dot_li;
                float spotTerm;
                float denom;
                block19: {
                    float distSq;
                    block20: {
                        float lightDir_dot_li;
                        block18: {
                            block16: {
                                denom = this.lightFalloffConstant[i];
                                spotTerm = 1.0f;
                                if (this.lightType[i] != 0) break block16;
                                if (this.lightFalloffQuadratic[i] != 0.0f || this.lightFalloffLinear[i] != 0.0f) {
                                    float distSq2 = this.mag(this.lightPosition[i][0] - wx, this.lightPosition[i][1] - wy, this.lightPosition[i][2] - wz);
                                    denom += this.lightFalloffQuadratic[i] * distSq2 + this.lightFalloffLinear[i] * PGraphics3D.sqrt(distSq2);
                                }
                                if (denom == 0.0f) {
                                    denom = 1.0f;
                                }
                                contribution[0] = contribution[0] + this.lightDiffuse[i][0] / denom;
                                contribution[1] = contribution[1] + this.lightDiffuse[i][1] / denom;
                                contribution[2] = contribution[2] + this.lightDiffuse[i][2] / denom;
                                break block17;
                            }
                            lightDir_dot_li = 0.0f;
                            n_dot_li = 0.0f;
                            if (this.lightType[i] != 1) break block18;
                            lix = -this.lightNormal[i][0];
                            liy = -this.lightNormal[i][1];
                            liz = -this.lightNormal[i][2];
                            denom = 1.0f;
                            n_dot_li = nx * lix + ny * liy + nz * liz;
                            if (!(n_dot_li <= 0.0f)) break block19;
                            break block17;
                        }
                        lix = this.lightPosition[i][0] - wx;
                        liy = this.lightPosition[i][1] - wy;
                        liz = this.lightPosition[i][2] - wz;
                        distSq = this.mag(lix, liy, liz);
                        if (distSq != 0.0f) {
                            lix /= distSq;
                            liy /= distSq;
                            liz /= distSq;
                        }
                        if ((n_dot_li = nx * lix + ny * liy + nz * liz) <= 0.0f) break block17;
                        if (this.lightType[i] != 3) break block20;
                        lightDir_dot_li = -(this.lightNormal[i][0] * lix + this.lightNormal[i][1] * liy + this.lightNormal[i][2] * liz);
                        if (lightDir_dot_li <= this.lightSpotAngleCos[i]) break block17;
                        spotTerm = this.pow(lightDir_dot_li, this.lightSpotConcentration[i]);
                    }
                    if (this.lightFalloffQuadratic[i] != 0.0f || this.lightFalloffLinear[i] != 0.0f) {
                        denom += this.lightFalloffQuadratic[i] * distSq + this.lightFalloffLinear[i] * PGraphics3D.sqrt(distSq);
                    }
                }
                if (denom == 0.0f) {
                    denom = 1.0f;
                }
                float mul = n_dot_li * spotTerm / denom;
                contribution[3] = contribution[3] + this.lightDiffuse[i][0] * mul;
                contribution[4] = contribution[4] + this.lightDiffuse[i][1] * mul;
                contribution[5] = contribution[5] + this.lightDiffuse[i][2] * mul;
                if ((sr > 0.0f || sg > 0.0f || sb > 0.0f) && (this.lightSpecular[i][0] > 0.0f || this.lightSpecular[i][1] > 0.0f || this.lightSpecular[i][2] > 0.0f)) {
                    float s_dot_n;
                    float sz;
                    float sy;
                    float sx;
                    float vmag = this.mag(wx, wy, wz);
                    if (vmag != 0.0f) {
                        wx /= vmag;
                        wy /= vmag;
                        wz /= vmag;
                    }
                    if ((vmag = this.mag(sx = lix - wx, sy = liy - wy, sz = liz - wz)) != 0.0f) {
                        sx /= vmag;
                        sy /= vmag;
                        sz /= vmag;
                    }
                    if ((s_dot_n = sx * nx + sy * ny + sz * nz) > 0.0f) {
                        s_dot_n = this.pow(s_dot_n, shine);
                        mul = s_dot_n * spotTerm / denom;
                        contribution[6] = contribution[6] + this.lightSpecular[i][0] * mul;
                        contribution[7] = contribution[7] + this.lightSpecular[i][1] * mul;
                        contribution[8] = contribution[8] + this.lightSpecular[i][2] * mul;
                    }
                }
            }
            ++i;
        }
    }

    private void apply_lighting_contribution(int vIndex, float[] contribution) {
        float[] v = this.vertices[vIndex];
        v[3] = this.min(1.0f, v[32] + v[24] * contribution[0] + v[3] * contribution[3]);
        v[4] = this.min(1.0f, v[33] + v[25] * contribution[1] + v[4] * contribution[4]);
        v[5] = this.min(1.0f, v[34] + v[26] * contribution[2] + v[5] * contribution[5]);
        v[6] = this.min(1.0f, v[6]);
        v[27] = this.min(1.0f, v[27] * contribution[6]);
        v[28] = this.min(1.0f, v[28] * contribution[7]);
        v[29] = this.min(1.0f, v[29] * contribution[8]);
        v[30] = this.min(1.0f, v[30]);
        v[35] = 1.0f;
    }

    private void light_vertex_always(int vIndex, float[] contribution) {
        this.calc_lighting_contribution(vIndex, contribution);
        this.apply_lighting_contribution(vIndex, contribution);
    }

    private void light_vertex_if_not_already_lit(int vIndex, float[] contribution) {
        if (this.vertices[vIndex][35] == 0.0f) {
            this.light_vertex_always(vIndex, contribution);
        }
    }

    private void copy_prelit_vertex_color_to_triangle(int triIndex, int vIndex, int colorIndex) {
        float[] triColor = this.triangleColors[triIndex][colorIndex];
        float[] v = this.vertices[vIndex];
        triColor[0] = v[3];
        triColor[1] = v[4];
        triColor[2] = v[5];
        triColor[3] = v[6];
        triColor[4] = v[27];
        triColor[5] = v[28];
        triColor[6] = v[29];
        triColor[7] = v[30];
    }

    private void copy_vertex_color_to_triangle(int triIndex, int vIndex, int colorIndex, float[] lightContribution) {
        float[] triColor = this.triangleColors[triIndex][colorIndex];
        float[] v = this.vertices[vIndex];
        triColor[0] = this.min(1.0f, v[32] + v[24] * lightContribution[0] + v[3] * lightContribution[3]);
        triColor[1] = this.min(1.0f, v[33] + v[25] * lightContribution[1] + v[4] * lightContribution[4]);
        triColor[2] = this.min(1.0f, v[34] + v[26] * lightContribution[2] + v[5] * lightContribution[5]);
        triColor[3] = this.min(1.0f, v[6]);
        triColor[4] = this.min(1.0f, v[27] * lightContribution[6]);
        triColor[5] = this.min(1.0f, v[28] * lightContribution[7]);
        triColor[6] = this.min(1.0f, v[29] * lightContribution[8]);
        triColor[7] = this.min(1.0f, v[30]);
    }

    private void light_triangle(int triIndex, float[] lightContribution) {
        int vIndex = this.triangles[triIndex][1];
        this.copy_vertex_color_to_triangle(triIndex, vIndex, 0, lightContribution);
        vIndex = this.triangles[triIndex][2];
        this.copy_vertex_color_to_triangle(triIndex, vIndex, 1, lightContribution);
        vIndex = this.triangles[triIndex][3];
        this.copy_vertex_color_to_triangle(triIndex, vIndex, 2, lightContribution);
    }

    private void crossProduct(float[] u, float[] v, float[] out) {
        out[0] = u[1] * v[2] - u[2] * v[1];
        out[1] = u[2] * v[0] - u[0] * v[2];
        out[2] = u[0] * v[1] - u[1] * v[0];
    }

    private void light_triangle(int triIndex) {
        if (this.normalMode == 2) {
            int vIndex = this.triangles[triIndex][1];
            this.light_vertex_if_not_already_lit(vIndex, this.tempLightingContribution);
            this.copy_prelit_vertex_color_to_triangle(triIndex, vIndex, 0);
            vIndex = this.triangles[triIndex][2];
            this.light_vertex_if_not_already_lit(vIndex, this.tempLightingContribution);
            this.copy_prelit_vertex_color_to_triangle(triIndex, vIndex, 1);
            vIndex = this.triangles[triIndex][3];
            this.light_vertex_if_not_already_lit(vIndex, this.tempLightingContribution);
            this.copy_prelit_vertex_color_to_triangle(triIndex, vIndex, 2);
        } else if (!this.lightingDependsOnVertexPosition) {
            int vIndex = this.triangles[triIndex][1];
            int vIndex2 = this.triangles[triIndex][2];
            int vIndex3 = this.triangles[triIndex][3];
            this.dv1[0] = this.vertices[vIndex2][20] - this.vertices[vIndex][20];
            this.dv1[1] = this.vertices[vIndex2][21] - this.vertices[vIndex][21];
            this.dv1[2] = this.vertices[vIndex2][22] - this.vertices[vIndex][22];
            this.dv2[0] = this.vertices[vIndex3][20] - this.vertices[vIndex][20];
            this.dv2[1] = this.vertices[vIndex3][21] - this.vertices[vIndex][21];
            this.dv2[2] = this.vertices[vIndex3][22] - this.vertices[vIndex][22];
            this.crossProduct(this.dv1, this.dv2, this.norm);
            float nMag = this.mag(this.norm[0], this.norm[1], this.norm[2]);
            if (nMag != 0.0f && nMag != 1.0f) {
                this.norm[0] = this.norm[0] / nMag;
                this.norm[1] = this.norm[1] / nMag;
                this.norm[2] = this.norm[2] / nMag;
            }
            this.vertices[vIndex][17] = this.norm[0];
            this.vertices[vIndex][18] = this.norm[1];
            this.vertices[vIndex][19] = this.norm[2];
            this.calc_lighting_contribution(vIndex, this.tempLightingContribution, true);
            this.copy_vertex_color_to_triangle(triIndex, vIndex, 0, this.tempLightingContribution);
            this.copy_vertex_color_to_triangle(triIndex, vIndex2, 1, this.tempLightingContribution);
            this.copy_vertex_color_to_triangle(triIndex, vIndex3, 2, this.tempLightingContribution);
        } else if (this.normalMode == 1) {
            int vIndex = this.triangles[triIndex][1];
            this.vertices[vIndex][17] = this.vertices[this.vertex_start][17];
            this.vertices[vIndex][18] = this.vertices[this.vertex_start][18];
            this.vertices[vIndex][19] = this.vertices[this.vertex_start][19];
            this.calc_lighting_contribution(vIndex, this.tempLightingContribution);
            this.copy_vertex_color_to_triangle(triIndex, vIndex, 0, this.tempLightingContribution);
            vIndex = this.triangles[triIndex][2];
            this.vertices[vIndex][17] = this.vertices[this.vertex_start][17];
            this.vertices[vIndex][18] = this.vertices[this.vertex_start][18];
            this.vertices[vIndex][19] = this.vertices[this.vertex_start][19];
            this.calc_lighting_contribution(vIndex, this.tempLightingContribution);
            this.copy_vertex_color_to_triangle(triIndex, vIndex, 1, this.tempLightingContribution);
            vIndex = this.triangles[triIndex][3];
            this.vertices[vIndex][17] = this.vertices[this.vertex_start][17];
            this.vertices[vIndex][18] = this.vertices[this.vertex_start][18];
            this.vertices[vIndex][19] = this.vertices[this.vertex_start][19];
            this.calc_lighting_contribution(vIndex, this.tempLightingContribution);
            this.copy_vertex_color_to_triangle(triIndex, vIndex, 2, this.tempLightingContribution);
        } else {
            int vIndex = this.triangles[triIndex][1];
            int vIndex2 = this.triangles[triIndex][2];
            int vIndex3 = this.triangles[triIndex][3];
            this.dv1[0] = this.vertices[vIndex2][20] - this.vertices[vIndex][20];
            this.dv1[1] = this.vertices[vIndex2][21] - this.vertices[vIndex][21];
            this.dv1[2] = this.vertices[vIndex2][22] - this.vertices[vIndex][22];
            this.dv2[0] = this.vertices[vIndex3][20] - this.vertices[vIndex][20];
            this.dv2[1] = this.vertices[vIndex3][21] - this.vertices[vIndex][21];
            this.dv2[2] = this.vertices[vIndex3][22] - this.vertices[vIndex][22];
            this.crossProduct(this.dv1, this.dv2, this.norm);
            float nMag = this.mag(this.norm[0], this.norm[1], this.norm[2]);
            if (nMag != 0.0f && nMag != 1.0f) {
                this.norm[0] = this.norm[0] / nMag;
                this.norm[1] = this.norm[1] / nMag;
                this.norm[2] = this.norm[2] / nMag;
            }
            this.vertices[vIndex][17] = this.norm[0];
            this.vertices[vIndex][18] = this.norm[1];
            this.vertices[vIndex][19] = this.norm[2];
            this.calc_lighting_contribution(vIndex, this.tempLightingContribution, true);
            this.copy_vertex_color_to_triangle(triIndex, vIndex, 0, this.tempLightingContribution);
            this.vertices[vIndex2][17] = this.norm[0];
            this.vertices[vIndex2][18] = this.norm[1];
            this.vertices[vIndex2][19] = this.norm[2];
            this.calc_lighting_contribution(vIndex2, this.tempLightingContribution, true);
            this.copy_vertex_color_to_triangle(triIndex, vIndex2, 1, this.tempLightingContribution);
            this.vertices[vIndex3][17] = this.norm[0];
            this.vertices[vIndex3][18] = this.norm[1];
            this.vertices[vIndex3][19] = this.norm[2];
            this.calc_lighting_contribution(vIndex3, this.tempLightingContribution, true);
            this.copy_vertex_color_to_triangle(triIndex, vIndex3, 2, this.tempLightingContribution);
        }
    }

    protected void handle_lighting() {
        if (!this.lightingDependsOnVertexPosition && this.normalMode == 1) {
            this.calc_lighting_contribution(this.vertex_start, this.tempLightingContribution);
            int tri = 0;
            while (tri < this.triangleCount) {
                this.light_triangle(tri, this.tempLightingContribution);
                ++tri;
            }
        } else {
            int tri = 0;
            while (tri < this.triangleCount) {
                this.light_triangle(tri);
                ++tri;
            }
        }
    }

    protected void handle_no_lighting() {
        int tri = 0;
        while (tri < this.triangleCount) {
            int vIndex = this.triangles[tri][1];
            this.copy_prelit_vertex_color_to_triangle(tri, vIndex, 0);
            vIndex = this.triangles[tri][2];
            this.copy_prelit_vertex_color_to_triangle(tri, vIndex, 1);
            vIndex = this.triangles[tri][3];
            this.copy_prelit_vertex_color_to_triangle(tri, vIndex, 2);
            ++tri;
        }
    }

    public void point(float x, float y) {
        this.point(x, y, 0.0f);
    }

    public void point(float x, float y, float z) {
        this.beginShape(32);
        this.vertex(x, y, z);
        this.vertex(x + 1.0E-4f, y + 1.0E-4f, z);
        this.endShape();
    }

    public void triangle(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.beginShape(64);
        this.normal(0.0f, 0.0f, 1.0f);
        this.vertex(x1, y1);
        this.vertex(x2, y2);
        this.vertex(x3, y3);
        this.endShape();
    }

    public void quad(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        this.beginShape(128);
        this.normal(0.0f, 0.0f, 1.0f);
        this.vertex(x1, y1);
        this.vertex(x2, y2);
        this.vertex(x3, y3);
        this.vertex(x4, y4);
        this.endShape();
    }

    public void box(float size) {
        this.box(size, size, size);
    }

    public void box(float w, float h, float d) {
        float x1 = -w / 2.0f;
        float x2 = w / 2.0f;
        float y1 = -h / 2.0f;
        float y2 = h / 2.0f;
        float z1 = -d / 2.0f;
        float z2 = d / 2.0f;
        if (this.triangle != null) {
            this.triangle.setCulling(true);
        }
        this.beginShape(128);
        this.normal(0.0f, 0.0f, 1.0f);
        this.vertex(x1, y1, z1);
        this.vertex(x2, y1, z1);
        this.vertex(x2, y2, z1);
        this.vertex(x1, y2, z1);
        this.normal(1.0f, 0.0f, 0.0f);
        this.vertex(x2, y1, z1);
        this.vertex(x2, y1, z2);
        this.vertex(x2, y2, z2);
        this.vertex(x2, y2, z1);
        this.normal(0.0f, 0.0f, -1.0f);
        this.vertex(x2, y1, z2);
        this.vertex(x1, y1, z2);
        this.vertex(x1, y2, z2);
        this.vertex(x2, y2, z2);
        this.normal(-1.0f, 0.0f, 0.0f);
        this.vertex(x1, y1, z2);
        this.vertex(x1, y1, z1);
        this.vertex(x1, y2, z1);
        this.vertex(x1, y2, z2);
        this.normal(0.0f, 1.0f, 0.0f);
        this.vertex(x1, y1, z2);
        this.vertex(x2, y1, z2);
        this.vertex(x2, y1, z1);
        this.vertex(x1, y1, z1);
        this.normal(0.0f, -1.0f, 0.0f);
        this.vertex(x1, y2, z1);
        this.vertex(x2, y2, z1);
        this.vertex(x2, y2, z2);
        this.vertex(x1, y2, z2);
        this.endShape();
        if (this.triangle != null) {
            this.triangle.setCulling(false);
        }
    }

    public void sphereDetail(int res) {
        float angle_step;
        if (res < 3) {
            res = 3;
        }
        if (res == this.sphereDetail) {
            return;
        }
        float delta = 720.0f / (float)res;
        float[] cx = new float[res];
        float[] cz = new float[res];
        int i = 0;
        while (i < res) {
            cx[i] = cosLUT[(int)((float)i * delta) % 720];
            cz[i] = sinLUT[(int)((float)i * delta) % 720];
            ++i;
        }
        int vertCount = res * (res - 1) + 2;
        int currVert = 0;
        this.sphereX = new float[vertCount];
        this.sphereY = new float[vertCount];
        this.sphereZ = new float[vertCount];
        float angle = angle_step = 360.0f / (float)res;
        int i2 = 1;
        while (i2 < res) {
            float curradius = sinLUT[(int)angle % 720];
            float currY = -cosLUT[(int)angle % 720];
            int j = 0;
            while (j < res) {
                this.sphereX[currVert] = cx[j] * curradius;
                this.sphereY[currVert] = currY;
                this.sphereZ[currVert++] = cz[j] * curradius;
                ++j;
            }
            angle += angle_step;
            ++i2;
        }
        this.sphereDetail = res;
    }

    public void sphere(float r) {
        int v2;
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        if (this.sphereDetail == 0) {
            this.sphereDetail(30);
        }
        this.pushMatrix();
        if (x != 0.0f && y != 0.0f && z != 0.0f) {
            this.translate(x, y, z);
        }
        this.scale(r);
        if (this.triangle != null) {
            this.triangle.setCulling(true);
        }
        this.beginShape(65);
        int i = 0;
        while (i < this.sphereDetail) {
            this.normal(0.0f, -1.0f, 0.0f);
            this.vertex(0.0f, -1.0f, 0.0f);
            this.normal(this.sphereX[i], this.sphereY[i], this.sphereZ[i]);
            this.vertex(this.sphereX[i], this.sphereY[i], this.sphereZ[i]);
            ++i;
        }
        this.vertex(0.0f, -1.0f, 0.0f);
        this.normal(this.sphereX[0], this.sphereY[0], this.sphereZ[0]);
        this.vertex(this.sphereX[0], this.sphereY[0], this.sphereZ[0]);
        this.endShape();
        int voff = 0;
        int i2 = 2;
        while (i2 < this.sphereDetail) {
            int v11;
            int v1 = v11 = voff;
            v2 = voff += this.sphereDetail;
            this.beginShape(65);
            int j = 0;
            while (j < this.sphereDetail) {
                this.normal(this.sphereX[v1], this.sphereY[v1], this.sphereZ[v1]);
                this.vertex(this.sphereX[v1], this.sphereY[v1], this.sphereZ[v1++]);
                this.normal(this.sphereX[v2], this.sphereY[v2], this.sphereZ[v2]);
                this.vertex(this.sphereX[v2], this.sphereY[v2], this.sphereZ[v2++]);
                ++j;
            }
            v1 = v11;
            v2 = voff;
            this.normal(this.sphereX[v1], this.sphereY[v1], this.sphereZ[v1]);
            this.vertex(this.sphereX[v1], this.sphereY[v1], this.sphereZ[v1]);
            this.normal(this.sphereX[v2], this.sphereY[v2], this.sphereZ[v2]);
            this.vertex(this.sphereX[v2], this.sphereY[v2], this.sphereZ[v2]);
            this.endShape();
            ++i2;
        }
        this.beginShape(65);
        i2 = 0;
        while (i2 < this.sphereDetail) {
            v2 = voff + i2;
            this.normal(this.sphereX[v2], this.sphereY[v2], this.sphereZ[v2]);
            this.vertex(this.sphereX[v2], this.sphereY[v2], this.sphereZ[v2]);
            this.normal(0.0f, 1.0f, 0.0f);
            this.vertex(0.0f, 1.0f, 0.0f);
            ++i2;
        }
        this.normal(this.sphereX[voff], this.sphereY[voff], this.sphereZ[voff]);
        this.vertex(this.sphereX[voff], this.sphereY[voff], this.sphereZ[voff]);
        this.normal(0.0f, 1.0f, 0.0f);
        this.vertex(0.0f, 1.0f, 0.0f);
        this.endShape();
        this.popMatrix();
        if (this.triangle != null) {
            this.triangle.setCulling(false);
        }
    }

    public void translate(float tx, float ty) {
        this.translate(tx, ty, 0.0f);
    }

    public void translate(float tx, float ty, float tz) {
        this.forwardTransform.translate(tx, ty, tz);
        this.reverseTransform.invTranslate(tx, ty, tz);
    }

    public void rotate(float angle) {
        this.rotateZ(angle);
    }

    public void rotateX(float angle) {
        this.forwardTransform.rotateX(angle);
        this.reverseTransform.invRotateX(angle);
    }

    public void rotateY(float angle) {
        this.forwardTransform.rotateY(angle);
        this.reverseTransform.invRotateY(angle);
    }

    public void rotateZ(float angle) {
        this.forwardTransform.rotateZ(angle);
        this.reverseTransform.invRotateZ(angle);
    }

    public void rotate(float angle, float v0, float v1, float v2) {
        this.forwardTransform.rotate(angle, v0, v1, v2);
        this.reverseTransform.invRotate(angle, v0, v1, v2);
    }

    public void scale(float s) {
        this.scale(s, s, s);
    }

    public void scale(float sx, float sy) {
        this.scale(sx, sy, 1.0f);
    }

    public void scale(float x, float y, float z) {
        this.forwardTransform.scale(x, y, z);
        this.reverseTransform.invScale(x, y, z);
    }

    public void pushMatrix() {
        if (!this.modelview.push()) {
            throw new RuntimeException("Too many calls to pushMatrix()");
        }
        this.modelviewInv.push();
    }

    public void popMatrix() {
        if (!this.modelview.pop()) {
            throw new RuntimeException("Too many calls to popMatrix() (and not enough to pushMatrix)");
        }
        this.modelviewInv.pop();
    }

    public void resetMatrix() {
        this.forwardTransform.reset();
        this.reverseTransform.reset();
    }

    public void applyMatrix(float n00, float n01, float n02, float n10, float n11, float n12) {
        throw new RuntimeException("Use applyMatrix() with a 4x4 matrix when using OPENGL or P3D");
    }

    public void applyMatrix(float n00, float n01, float n02, float n03, float n10, float n11, float n12, float n13, float n20, float n21, float n22, float n23, float n30, float n31, float n32, float n33) {
        this.forwardTransform.apply(n00, n01, n02, n03, n10, n11, n12, n13, n20, n21, n22, n23, n30, n31, n32, n33);
        this.reverseTransform.invApply(n00, n01, n02, n03, n10, n11, n12, n13, n20, n21, n22, n23, n30, n31, n32, n33);
    }

    public void loadMatrix() {
        this.m00 = this.modelview.m00;
        this.m01 = this.modelview.m01;
        this.m02 = this.modelview.m02;
        this.m03 = this.modelview.m03;
        this.m10 = this.modelview.m10;
        this.m11 = this.modelview.m11;
        this.m12 = this.modelview.m12;
        this.m13 = this.modelview.m13;
        this.m20 = this.modelview.m20;
        this.m21 = this.modelview.m21;
        this.m22 = this.modelview.m22;
        this.m23 = this.modelview.m23;
        this.m30 = this.modelview.m30;
        this.m31 = this.modelview.m31;
        this.m32 = this.modelview.m32;
        this.m33 = this.modelview.m33;
    }

    public void printMatrix() {
        this.modelview.print();
    }

    public void beginCamera() {
        if (this.manipulatingCamera) {
            throw new RuntimeException("beginCamera() cannot be called again before endCamera()");
        }
        this.manipulatingCamera = true;
        this.forwardTransform = this.cameraInv;
        this.reverseTransform = this.camera;
    }

    public void endCamera() {
        if (!this.manipulatingCamera) {
            throw new RuntimeException("Cannot call endCamera() without first calling beginCamera()");
        }
        this.modelview.set(this.camera);
        this.modelviewInv.set(this.cameraInv);
        this.forwardTransform = this.modelview;
        this.reverseTransform = this.modelviewInv;
        this.manipulatingCamera = false;
    }

    public void camera() {
        this.camera(this.cameraX, this.cameraY, this.cameraZ, this.cameraX, this.cameraY, 0.0f, 0.0f, 1.0f, 0.0f);
    }

    public void camera(float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ) {
        float z0 = eyeX - centerX;
        float z1 = eyeY - centerY;
        float z2 = eyeZ - centerZ;
        float mag = PGraphics3D.sqrt(z0 * z0 + z1 * z1 + z2 * z2);
        if (mag != 0.0f) {
            z0 /= mag;
            z1 /= mag;
            z2 /= mag;
        }
        float y0 = upX;
        float y1 = upY;
        float y2 = upZ;
        float x0 = y1 * z2 - y2 * z1;
        float x1 = -y0 * z2 + y2 * z0;
        float x2 = y0 * z1 - y1 * z0;
        y0 = z1 * x2 - z2 * x1;
        y1 = -z0 * x2 + z2 * x0;
        y2 = z0 * x1 - z1 * x0;
        mag = PGraphics3D.sqrt(x0 * x0 + x1 * x1 + x2 * x2);
        if (mag != 0.0f) {
            x0 /= mag;
            x1 /= mag;
            x2 /= mag;
        }
        if ((mag = PGraphics3D.sqrt(y0 * y0 + y1 * y1 + y2 * y2)) != 0.0f) {
            y0 /= mag;
            y1 /= mag;
            y2 /= mag;
        }
        this.camera.set(x0, x1, x2, 0.0f, y0, y1, y2, 0.0f, z0, z1, z2, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        this.camera.translate(-eyeX, -eyeY, -eyeZ);
        this.cameraInv.reset();
        this.cameraInv.invApply(x0, x1, x2, 0.0f, y0, y1, y2, 0.0f, z0, z1, z2, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        this.cameraInv.invTranslate(-eyeX, -eyeY, -eyeZ);
        this.modelview.set(this.camera);
        this.modelviewInv.set(this.cameraInv);
    }

    public void printCamera() {
        this.camera.print();
    }

    public void ortho() {
        this.ortho(0.0f, this.width, 0.0f, this.height, -10.0f, 10.0f);
    }

    public void ortho(float left, float right, float bottom, float top, float near, float far) {
        float x = 2.0f / (right - left);
        float y = 2.0f / (top - bottom);
        float z = -2.0f / (far - near);
        float tx = -(right + left) / (right - left);
        float ty = -(top + bottom) / (top - bottom);
        float tz = -(far + near) / (far - near);
        this.projection.set(x, 0.0f, 0.0f, tx, 0.0f, y, 0.0f, ty, 0.0f, 0.0f, z, tz, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void perspective() {
        this.perspective(this.cameraFOV, this.cameraAspect, this.cameraNear, this.cameraFar);
    }

    public void perspective(float fov, float aspect, float zNear, float zFar) {
        float ymax = zNear * this.tan(fov / 2.0f);
        float ymin = -ymax;
        float xmin = ymin * aspect;
        float xmax = ymax * aspect;
        this.frustum(xmin, xmax, ymin, ymax, zNear, zFar);
    }

    public void frustum(float left, float right, float bottom, float top, float znear, float zfar) {
        this.leftScreen = left;
        this.rightScreen = right;
        this.bottomScreen = bottom;
        this.topScreen = top;
        this.nearPlane = znear;
        this.projection.set(2.0f * znear / (right - left), 0.0f, (right + left) / (right - left), 0.0f, 0.0f, 2.0f * znear / (top - bottom), (top + bottom) / (top - bottom), 0.0f, 0.0f, 0.0f, -(zfar + znear) / (zfar - znear), -(2.0f * zfar * znear) / (zfar - znear), 0.0f, 0.0f, -1.0f, 0.0f);
    }

    public void printProjection() {
        this.projection.print();
    }

    private boolean drawing2D() {
        return this.modelview.m00 == 1.0f && this.modelview.m11 == 1.0f && this.modelview.m22 == 1.0f && this.modelview.m01 == 0.0f && this.modelview.m02 == 0.0f && this.modelview.m10 == 0.0f && this.modelview.m12 == 0.0f && this.modelview.m20 == 0.0f && this.modelview.m21 == 0.0f && this.camera.m23 - this.modelview.m23 <= 1.0E-4f && this.camera.m23 - this.modelview.m23 >= -1.0E-4f;
    }

    public float screenX(float x, float y) {
        return this.screenX(x, y, 0.0f);
    }

    public float screenY(float x, float y) {
        return this.screenY(x, y, 0.0f);
    }

    public float screenX(float x, float y, float z) {
        float ax = this.modelview.m00 * x + this.modelview.m01 * y + this.modelview.m02 * z + this.modelview.m03;
        float ay = this.modelview.m10 * x + this.modelview.m11 * y + this.modelview.m12 * z + this.modelview.m13;
        float az = this.modelview.m20 * x + this.modelview.m21 * y + this.modelview.m22 * z + this.modelview.m23;
        float aw = this.modelview.m30 * x + this.modelview.m31 * y + this.modelview.m32 * z + this.modelview.m33;
        float ox = this.projection.m00 * ax + this.projection.m01 * ay + this.projection.m02 * az + this.projection.m03 * aw;
        float ow = this.projection.m30 * ax + this.projection.m31 * ay + this.projection.m32 * az + this.projection.m33 * aw;
        if (ow != 0.0f) {
            ox /= ow;
        }
        return (float)this.width * (1.0f + ox) / 2.0f;
    }

    public float screenY(float x, float y, float z) {
        float ax = this.modelview.m00 * x + this.modelview.m01 * y + this.modelview.m02 * z + this.modelview.m03;
        float ay = this.modelview.m10 * x + this.modelview.m11 * y + this.modelview.m12 * z + this.modelview.m13;
        float az = this.modelview.m20 * x + this.modelview.m21 * y + this.modelview.m22 * z + this.modelview.m23;
        float aw = this.modelview.m30 * x + this.modelview.m31 * y + this.modelview.m32 * z + this.modelview.m33;
        float oy = this.projection.m10 * ax + this.projection.m11 * ay + this.projection.m12 * az + this.projection.m13 * aw;
        float ow = this.projection.m30 * ax + this.projection.m31 * ay + this.projection.m32 * az + this.projection.m33 * aw;
        if (ow != 0.0f) {
            oy /= ow;
        }
        return (float)this.height * (1.0f + oy) / 2.0f;
    }

    public float screenZ(float x, float y, float z) {
        float ax = this.modelview.m00 * x + this.modelview.m01 * y + this.modelview.m02 * z + this.modelview.m03;
        float ay = this.modelview.m10 * x + this.modelview.m11 * y + this.modelview.m12 * z + this.modelview.m13;
        float az = this.modelview.m20 * x + this.modelview.m21 * y + this.modelview.m22 * z + this.modelview.m23;
        float aw = this.modelview.m30 * x + this.modelview.m31 * y + this.modelview.m32 * z + this.modelview.m33;
        float oz = this.projection.m20 * ax + this.projection.m21 * ay + this.projection.m22 * az + this.projection.m23 * aw;
        float ow = this.projection.m30 * ax + this.projection.m31 * ay + this.projection.m32 * az + this.projection.m33 * aw;
        if (ow != 0.0f) {
            oz /= ow;
        }
        return (oz + 1.0f) / 2.0f;
    }

    public float modelX(float x, float y, float z) {
        float ax = this.cameraInv.m00 * x + this.cameraInv.m01 * y + this.cameraInv.m02 * z + this.cameraInv.m03;
        float ay = this.cameraInv.m10 * x + this.cameraInv.m11 * y + this.cameraInv.m12 * z + this.cameraInv.m13;
        float az = this.cameraInv.m20 * x + this.cameraInv.m21 * y + this.cameraInv.m22 * z + this.cameraInv.m23;
        float aw = this.cameraInv.m30 * x + this.cameraInv.m31 * y + this.cameraInv.m32 * z + this.cameraInv.m33;
        float ox = this.modelview.m00 * ax + this.modelview.m01 * ay + this.modelview.m02 * az + this.modelview.m03 * aw;
        float ow = this.modelview.m30 * ax + this.modelview.m31 * ay + this.modelview.m32 * az + this.modelview.m33 * aw;
        return ow != 0.0f ? ox / ow : ox;
    }

    public float modelY(float x, float y, float z) {
        float ax = this.cameraInv.m00 * x + this.cameraInv.m01 * y + this.cameraInv.m02 * z + this.cameraInv.m03;
        float ay = this.cameraInv.m10 * x + this.cameraInv.m11 * y + this.cameraInv.m12 * z + this.cameraInv.m13;
        float az = this.cameraInv.m20 * x + this.cameraInv.m21 * y + this.cameraInv.m22 * z + this.cameraInv.m23;
        float aw = this.cameraInv.m30 * x + this.cameraInv.m31 * y + this.cameraInv.m32 * z + this.cameraInv.m33;
        float oy = this.modelview.m10 * ax + this.modelview.m11 * ay + this.modelview.m12 * az + this.modelview.m13 * aw;
        float ow = this.modelview.m30 * ax + this.modelview.m31 * ay + this.modelview.m32 * az + this.modelview.m33 * aw;
        return ow != 0.0f ? oy / ow : oy;
    }

    public float modelZ(float x, float y, float z) {
        float ax = this.cameraInv.m00 * x + this.cameraInv.m01 * y + this.cameraInv.m02 * z + this.cameraInv.m03;
        float ay = this.cameraInv.m10 * x + this.cameraInv.m11 * y + this.cameraInv.m12 * z + this.cameraInv.m13;
        float az = this.cameraInv.m20 * x + this.cameraInv.m21 * y + this.cameraInv.m22 * z + this.cameraInv.m23;
        float aw = this.cameraInv.m30 * x + this.cameraInv.m31 * y + this.cameraInv.m32 * z + this.cameraInv.m33;
        float oz = this.modelview.m20 * ax + this.modelview.m21 * ay + this.modelview.m22 * az + this.modelview.m23 * aw;
        float ow = this.modelview.m30 * ax + this.modelview.m31 * ay + this.modelview.m32 * az + this.modelview.m33 * aw;
        return ow != 0.0f ? oz / ow : oz;
    }

    public void strokeJoin(int join) {
        String msg = "strokeJoin() not available with P3D";
        throw new RuntimeException(msg);
    }

    public void strokeCap(int cap) {
        String msg = "strokeCap() not available with P3D";
        throw new RuntimeException(msg);
    }

    protected void fillFromCalc() {
        super.fillFromCalc();
        this.ambientFromCalc();
    }

    public void ambient(int rgb) {
        if ((rgb & 0xFF000000) == 0 && (float)rgb <= this.colorModeX) {
            this.ambient((float)rgb);
        } else {
            this.colorCalcARGB(rgb, this.colorModeA);
            this.ambientFromCalc();
        }
    }

    public void ambient(float gray) {
        this.colorCalc(gray);
        this.ambientFromCalc();
    }

    public void ambient(float x, float y, float z) {
        this.colorCalc(x, y, z);
        this.ambientFromCalc();
    }

    protected void ambientFromCalc() {
        this.ambientR = this.calcR;
        this.ambientG = this.calcG;
        this.ambientB = this.calcB;
    }

    public void specular(int rgb) {
        if ((rgb & 0xFF000000) == 0 && (float)rgb <= this.colorModeX) {
            this.specular((float)rgb);
        } else {
            this.colorCalcARGB(rgb, this.colorModeA);
            this.specularFromCalc();
        }
    }

    public void specular(float gray) {
        this.colorCalc(gray);
        this.specularFromCalc();
    }

    public void specular(float gray, float alpha) {
        this.colorCalc(gray, alpha);
        this.specularFromCalc();
    }

    public void specular(float x, float y, float z) {
        this.colorCalc(x, y, z);
        this.specularFromCalc();
    }

    public void specular(float x, float y, float z, float a) {
        this.colorCalc(x, y, z, a);
        this.specularFromCalc();
    }

    protected void specularFromCalc() {
        this.specularR = this.calcR;
        this.specularG = this.calcG;
        this.specularB = this.calcB;
        this.specularA = this.calcA;
    }

    public void shininess(float shine) {
        this.shininess = shine;
    }

    public void emissive(int rgb) {
        if ((rgb & 0xFF000000) == 0 && (float)rgb <= this.colorModeX) {
            this.emissive((float)rgb);
        } else {
            this.colorCalcARGB(rgb, this.colorModeA);
            this.emissiveFromCalc();
        }
    }

    public void emissive(float gray) {
        this.colorCalc(gray);
        this.emissiveFromCalc();
    }

    public void emissive(float x, float y, float z) {
        this.colorCalc(x, y, z);
        this.emissiveFromCalc();
    }

    protected void emissiveFromCalc() {
        this.emissiveR = this.calcR;
        this.emissiveG = this.calcG;
        this.emissiveB = this.calcB;
    }

    public void lights() {
        int colorModeSaved = this.colorMode;
        this.colorMode = 1;
        this.lightFalloff(1.0f, 0.0f, 0.0f);
        this.lightSpecular(0.0f, 0.0f, 0.0f);
        this.ambientLight(this.colorModeX * 0.5f, this.colorModeY * 0.5f, this.colorModeZ * 0.5f);
        this.directionalLight(this.colorModeX * 0.5f, this.colorModeY * 0.5f, this.colorModeZ * 0.5f, 0.0f, 0.0f, -1.0f);
        this.colorMode = colorModeSaved;
        this.lightingDependsOnVertexPosition = false;
    }

    public void ambientLight(float r, float g, float b) {
        this.ambientLight(r, g, b, 0.0f, 0.0f, 0.0f);
    }

    public void ambientLight(float r, float g, float b, float x, float y, float z) {
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.colorCalc(r, g, b);
        this.lightDiffuse[this.lightCount][0] = this.calcR;
        this.lightDiffuse[this.lightCount][1] = this.calcG;
        this.lightDiffuse[this.lightCount][2] = this.calcB;
        this.lightType[this.lightCount] = 0;
        this.lightFalloffConstant[this.lightCount] = this.currentLightFalloffConstant;
        this.lightFalloffLinear[this.lightCount] = this.currentLightFalloffLinear;
        this.lightFalloffQuadratic[this.lightCount] = this.currentLightFalloffQuadratic;
        this.lightPosition(this.lightCount, x, y, z);
        ++this.lightCount;
    }

    public void directionalLight(float r, float g, float b, float nx, float ny, float nz) {
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.colorCalc(r, g, b);
        this.lightDiffuse[this.lightCount][0] = this.calcR;
        this.lightDiffuse[this.lightCount][1] = this.calcG;
        this.lightDiffuse[this.lightCount][2] = this.calcB;
        this.lightType[this.lightCount] = 1;
        this.lightFalloffConstant[this.lightCount] = this.currentLightFalloffConstant;
        this.lightFalloffLinear[this.lightCount] = this.currentLightFalloffLinear;
        this.lightFalloffQuadratic[this.lightCount] = this.currentLightFalloffQuadratic;
        this.lightSpecular[this.lightCount][0] = this.currentLightSpecular[0];
        this.lightSpecular[this.lightCount][1] = this.currentLightSpecular[1];
        this.lightSpecular[this.lightCount][2] = this.currentLightSpecular[2];
        this.lightDirection(this.lightCount, nx, ny, nz);
        ++this.lightCount;
    }

    public void pointLight(float r, float g, float b, float x, float y, float z) {
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.colorCalc(r, g, b);
        this.lightDiffuse[this.lightCount][0] = this.calcR;
        this.lightDiffuse[this.lightCount][1] = this.calcG;
        this.lightDiffuse[this.lightCount][2] = this.calcB;
        this.lightType[this.lightCount] = 2;
        this.lightFalloffConstant[this.lightCount] = this.currentLightFalloffConstant;
        this.lightFalloffLinear[this.lightCount] = this.currentLightFalloffLinear;
        this.lightFalloffQuadratic[this.lightCount] = this.currentLightFalloffQuadratic;
        this.lightSpecular[this.lightCount][0] = this.currentLightSpecular[0];
        this.lightSpecular[this.lightCount][1] = this.currentLightSpecular[1];
        this.lightSpecular[this.lightCount][2] = this.currentLightSpecular[2];
        this.lightPosition(this.lightCount, x, y, z);
        ++this.lightCount;
        this.lightingDependsOnVertexPosition = true;
    }

    public void spotLight(float r, float g, float b, float x, float y, float z, float nx, float ny, float nz, float angle, float concentration) {
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.colorCalc(r, g, b);
        this.lightDiffuse[this.lightCount][0] = this.calcR;
        this.lightDiffuse[this.lightCount][1] = this.calcG;
        this.lightDiffuse[this.lightCount][2] = this.calcB;
        this.lightType[this.lightCount] = 3;
        this.lightFalloffConstant[this.lightCount] = this.currentLightFalloffConstant;
        this.lightFalloffLinear[this.lightCount] = this.currentLightFalloffLinear;
        this.lightFalloffQuadratic[this.lightCount] = this.currentLightFalloffQuadratic;
        this.lightSpecular[this.lightCount][0] = this.currentLightSpecular[0];
        this.lightSpecular[this.lightCount][1] = this.currentLightSpecular[1];
        this.lightSpecular[this.lightCount][2] = this.currentLightSpecular[2];
        this.lightPosition(this.lightCount, x, y, z);
        this.lightDirection(this.lightCount, nx, ny, nz);
        this.lightSpotAngle[this.lightCount] = angle;
        this.lightSpotAngleCos[this.lightCount] = this.max(0.0f, this.cos(angle));
        this.lightSpotConcentration[this.lightCount] = concentration;
        ++this.lightCount;
        this.lightingDependsOnVertexPosition = true;
    }

    public void lightFalloff(float constant, float linear, float quadratic) {
        this.currentLightFalloffConstant = constant;
        this.currentLightFalloffLinear = linear;
        this.currentLightFalloffQuadratic = quadratic;
        this.lightingDependsOnVertexPosition = true;
    }

    public void lightSpecular(float x, float y, float z) {
        this.colorCalc(x, y, z);
        this.currentLightSpecular[0] = this.calcR;
        this.currentLightSpecular[1] = this.calcG;
        this.currentLightSpecular[2] = this.calcB;
        this.lightingDependsOnVertexPosition = true;
    }

    protected void lightPosition(int num, float x, float y, float z) {
        this.lightPosition[num][0] = this.modelview.m00 * x + this.modelview.m01 * y + this.modelview.m02 * z + this.modelview.m03;
        this.lightPosition[num][1] = this.modelview.m10 * x + this.modelview.m11 * y + this.modelview.m12 * z + this.modelview.m13;
        this.lightPosition[num][2] = this.modelview.m20 * x + this.modelview.m21 * y + this.modelview.m22 * z + this.modelview.m23;
    }

    protected void lightDirection(int num, float x, float y, float z) {
        this.lightNormal[num][0] = this.modelviewInv.m00 * x + this.modelviewInv.m10 * y + this.modelviewInv.m20 * z + this.modelviewInv.m30;
        this.lightNormal[num][1] = this.modelviewInv.m01 * x + this.modelviewInv.m11 * y + this.modelviewInv.m21 * z + this.modelviewInv.m31;
        this.lightNormal[num][2] = this.modelviewInv.m02 * x + this.modelviewInv.m12 * y + this.modelviewInv.m22 * z + this.modelviewInv.m32;
        float n = this.mag(this.lightNormal[num]);
        if (n == 0.0f || n == 1.0f) {
            return;
        }
        float[] fArray = this.lightNormal[num];
        fArray[0] = fArray[0] / n;
        float[] fArray2 = this.lightNormal[num];
        fArray2[1] = fArray2[1] / n;
        float[] fArray3 = this.lightNormal[num];
        fArray3[2] = fArray3[2] / n;
    }

    public void background(PImage image) {
        super.background(image);
        int i = 0;
        while (i < this.pixelCount) {
            this.zbuffer[i] = Float.MAX_VALUE;
            ++i;
        }
    }

    protected void clear() {
        int i = 0;
        while (i < this.pixelCount) {
            this.pixels[i] = this.backgroundColor;
            this.zbuffer[i] = Float.MAX_VALUE;
            ++i;
        }
    }

    public void smooth() {
        String msg = "smooth() not available with P3D";
        throw new RuntimeException(msg);
    }

    public void noSmooth() {
        String msg = "noSmooth() not available with P3D";
        throw new RuntimeException(msg);
    }

    private final float mag(float a, float b, float c) {
        return (float)Math.sqrt(a * a + b * b + c * c);
    }

    private final float mag(float[] abc) {
        return (float)Math.sqrt(abc[0] * abc[0] + abc[1] * abc[1] + abc[2] * abc[2]);
    }

    private final float min(float a, float b) {
        return a < b ? a : b;
    }

    private final float max(float a, float b) {
        return a > b ? a : b;
    }

    private final float pow(float a, float b) {
        return (float)Math.pow(a, b);
    }

    private final float abs(float a) {
        return a < 0.0f ? -a : a;
    }

    private final float cos(float angle) {
        return (float)Math.cos(angle);
    }

    private final float tan(float angle) {
        return (float)Math.tan(angle);
    }

    private float dot(float ax, float ay, float az, float bx, float by, float bz) {
        return ax * bx + ay * by + az * bz;
    }
}

