/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PLine;
import processing.core.PPolygon;

public class PGraphics2D
extends PGraphics {
    PPolygon polygon;
    PPolygon fpolygon;
    PPolygon spolygon;
    float[][] svertices;
    private PPolygon tpolygon;
    private int TPOLYGON_MAX_VERTICES = 512;
    private int[] tpolygon_vertex_order;
    PLine line;
    boolean strokeChanged = true;
    boolean fillChanged = true;
    static final int CVERTEX_ALLOC = 128;
    float[][] cvertex = new float[128][36];
    int cvertexIndex;

    public PGraphics2D(int iwidth, int iheight, PApplet applet) {
        super(iwidth, iheight, applet);
    }

    protected void allocate() {
        this.pixelCount = this.width * this.height;
        this.pixels = new int[this.pixelCount];
        this.backgroundColor |= 0xFF000000;
        int i = 0;
        while (i < this.pixelCount) {
            this.pixels[i] = this.backgroundColor;
            ++i;
        }
        if (this.mainDrawingSurface) {
            this.cm = new DirectColorModel(32, 0xFF0000, 65280, 255);
            this.mis = new MemoryImageSource(this.width, this.height, this.pixels, 0, this.width);
            this.mis.setFullBufferUpdates(true);
            this.mis.setAnimated(true);
            this.image = Toolkit.getDefaultToolkit().createImage(this.mis);
        }
    }

    public void beginDraw() {
        this.insideResizeWait();
        this.insideDraw = true;
        if (!this.defaultsInited) {
            this.defaults();
            this.polygon = new PPolygon(this);
            this.fpolygon = new PPolygon(this);
            this.spolygon = new PPolygon(this);
            this.spolygon.vertexCount = 4;
            this.svertices = new float[2][];
        }
        this.resetMatrix();
        this.vertexCount = 0;
    }

    public void endDraw() {
        if (this.mis != null) {
            this.mis.newPixels(this.pixels, (ColorModel)this.cm, 0, this.width);
        }
        this.updatePixels();
        this.insideDraw = false;
    }

    public void beginShape(int kind) {
        this.shape = kind;
        this.vertexCount = 0;
        this.splineVertexCount = 0;
        this.polygon.reset(0);
        this.fpolygon.reset(4);
        this.spolygon.reset(4);
        this.polygon.interpUV = false;
    }

    public void vertex(float x, float y) {
        float[] vertex = this.polygon.nextVertex();
        this.cvertexIndex = 0;
        vertex[9] = x;
        vertex[10] = y;
        if (this.fill) {
            vertex[3] = this.fillR;
            vertex[4] = this.fillG;
            vertex[5] = this.fillB;
            vertex[6] = this.fillA;
        }
        if (this.stroke) {
            vertex[12] = this.strokeR;
            vertex[13] = this.strokeG;
            vertex[14] = this.strokeB;
            vertex[15] = this.strokeA;
            vertex[16] = this.strokeWeight;
        }
        if (this.textureImage != null) {
            vertex[7] = this.textureU;
            vertex[8] = this.textureV;
        }
    }

    public void vertex(float x, float y, float u, float v) {
        this.textureVertex(u, v);
        this.vertex(x, y);
    }

    public void vertex(float x, float y, float z) {
        this.depthErrorXYZ("vertex");
    }

    public void vertex(float x, float y, float z, float u, float v) {
        this.depthErrorXYZ("vertex");
    }

    public void endShape(int mode) {
        int i;
        int polyVertexCount = this.polygon.vertexCount;
        float[][] polyVertices = this.polygon.vertices;
        if (this.untransformed()) {
            i = 0;
            while (i < polyVertexCount) {
                polyVertices[i][0] = polyVertices[i][9];
                polyVertices[i][1] = polyVertices[i][10];
                ++i;
            }
        } else {
            i = 0;
            while (i < polyVertexCount) {
                polyVertices[i][0] = this.m00 * polyVertices[i][9] + this.m01 * polyVertices[i][10] + this.m03;
                polyVertices[i][1] = this.m10 * polyVertices[i][9] + this.m11 * polyVertices[i][10] + this.m13;
                ++i;
            }
        }
        if (this.polygon.interpUV) {
            this.fpolygon.texture(this.textureImage);
        }
        this.spolygon.interpARGB = this.strokeChanged;
        this.fpolygon.interpARGB = this.fillChanged;
        switch (this.shape) {
            case 16: {
                if (this.untransformed() && this.strokeWeight == 1.0f) {
                    if (!this.strokeChanged) {
                        int i2 = 0;
                        while (i2 < polyVertexCount) {
                            this.thin_point((int)polyVertices[i2][0], (int)polyVertices[i2][1], 0.0f, this.strokeColor);
                            ++i2;
                        }
                    } else {
                        int i3 = 0;
                        while (i3 < polyVertexCount) {
                            this.thin_point((int)polyVertices[i3][0], (int)polyVertices[i3][1], 0.0f, PGraphics2D.float_color(polyVertices[i3][12], polyVertices[i3][13], polyVertices[i3][14]));
                            ++i3;
                        }
                    }
                } else {
                    float[] f = polyVertices[0];
                    int i4 = 0;
                    while (i4 < polyVertexCount) {
                        float[] v = polyVertices[i4];
                        if (i4 == 0 || this.strokeChanged) {
                            this.calc_lighting(v[12], v[13], v[14], v[0], v[1], v[2], v[17], v[18], v[19], f, 3);
                        }
                        this.thick_point(v[0], v[1], v[2], f[3], f[4], f[5], f[15]);
                        ++i4;
                    }
                }
                break;
            }
            case 32: {
                if (!this.stroke) {
                    return;
                }
                if (mode == 2) {
                    float[] v0 = this.polygon.vertices[0];
                    float[] v1 = this.polygon.nextVertex();
                    ++polyVertexCount;
                    v1[0] = v0[0];
                    v1[1] = v0[1];
                    v1[2] = v0[2];
                    v1[12] = v0[12];
                    v1[13] = v0[13];
                    v1[14] = v0[14];
                }
                int increment = this.shape == 32 ? 2 : 1;
                this.draw_lines(polyVertices, polyVertexCount - 1, 1, increment, 0);
                break;
            }
            case 64: 
            case 65: {
                int increment;
                int n = increment = this.shape == 64 ? 3 : 1;
                if (this.fill) {
                    this.fpolygon.vertexCount = 3;
                    int i5 = 0;
                    while (i5 < polyVertexCount - 2) {
                        int j = 0;
                        while (j < 3) {
                            this.fpolygon.vertices[j][3] = polyVertices[i5 + j][3];
                            this.fpolygon.vertices[j][4] = polyVertices[i5 + j][4];
                            this.fpolygon.vertices[j][5] = polyVertices[i5 + j][5];
                            this.fpolygon.vertices[j][6] = polyVertices[i5 + j][6];
                            this.fpolygon.vertices[j][0] = polyVertices[i5 + j][0];
                            this.fpolygon.vertices[j][1] = polyVertices[i5 + j][1];
                            this.fpolygon.vertices[j][2] = polyVertices[i5 + j][2];
                            if (this.polygon.interpUV) {
                                this.fpolygon.vertices[j][7] = polyVertices[i5 + j][7];
                                this.fpolygon.vertices[j][8] = polyVertices[i5 + j][8];
                            }
                            ++j;
                        }
                        this.fpolygon.render();
                        i5 += increment;
                    }
                }
                if (!this.stroke) break;
                if (this.shape == 65) {
                    this.draw_lines(polyVertices, polyVertexCount - 1, 1, 1, 0);
                } else {
                    this.draw_lines(polyVertices, polyVertexCount - 1, 1, 1, 3);
                }
                this.draw_lines(polyVertices, polyVertexCount - 2, 2, increment, 0);
                break;
            }
            case 128: 
            case 129: {
                int increment;
                int n = increment = this.shape == 128 ? 4 : 2;
                if (this.fill) {
                    this.fpolygon.vertexCount = 4;
                    int i6 = 0;
                    while (i6 < polyVertexCount - 3) {
                        int j = 0;
                        while (j < 4) {
                            this.fpolygon.vertices[j][3] = polyVertices[i6 + j][3];
                            this.fpolygon.vertices[j][4] = polyVertices[i6 + j][4];
                            this.fpolygon.vertices[j][5] = polyVertices[i6 + j][5];
                            this.fpolygon.vertices[j][6] = polyVertices[i6 + j][6];
                            this.fpolygon.vertices[j][0] = polyVertices[i6 + j][0];
                            this.fpolygon.vertices[j][1] = polyVertices[i6 + j][1];
                            this.fpolygon.vertices[j][2] = polyVertices[i6 + j][2];
                            if (this.polygon.interpUV) {
                                this.fpolygon.vertices[j][7] = polyVertices[i6 + j][7];
                                this.fpolygon.vertices[j][8] = polyVertices[i6 + j][8];
                            }
                            ++j;
                        }
                        this.fpolygon.render();
                        i6 += increment;
                    }
                }
                if (!this.stroke) break;
                if (this.shape == 129) {
                    this.draw_lines(polyVertices, polyVertexCount - 1, 1, 1, 0);
                } else {
                    this.draw_lines(polyVertices, polyVertexCount, 1, 1, 4);
                }
                this.draw_lines(polyVertices, polyVertexCount - 2, 3, increment, 0);
                break;
            }
            case 256: {
                if (this.isConvex()) {
                    if (this.fill) {
                        this.polygon.render();
                        if (this.stroke) {
                            this.polygon.unexpand();
                        }
                    }
                    if (!this.stroke) break;
                    this.draw_lines(polyVertices, polyVertexCount - 1, 1, 1, 0);
                    this.svertices[0] = polyVertices[polyVertexCount - 1];
                    this.svertices[1] = polyVertices[0];
                    this.draw_lines(this.svertices, 1, 1, 1, 0);
                    break;
                }
                if (this.fill) {
                    boolean smoov = this.smooth;
                    if (this.stroke) {
                        this.smooth = false;
                    }
                    this.concaveRender();
                    if (this.stroke) {
                        this.smooth = smoov;
                    }
                }
                if (!this.stroke) break;
                this.draw_lines(polyVertices, polyVertexCount - 1, 1, 1, 0);
                this.svertices[0] = polyVertices[polyVertexCount - 1];
                this.svertices[1] = polyVertices[0];
                this.draw_lines(this.svertices, 1, 1, 1, 0);
            }
        }
        this.shape = 0;
    }

    private boolean isConvex() {
        float[][] v = this.polygon.vertices;
        int n = this.polygon.vertexCount;
        int flag = 0;
        if (n < 3) {
            return true;
        }
        int i = 0;
        while (i < n) {
            int j = (i + 1) % n;
            int k = (i + 2) % n;
            float z = (v[j][0] - v[i][0]) * (v[k][1] - v[j][1]);
            if ((z -= (v[j][1] - v[i][1]) * (v[k][0] - v[j][0])) < 0.0f) {
                flag |= 1;
            } else if (z > 0.0f) {
                flag |= 2;
            }
            if (flag == 3) {
                return false;
            }
            ++i;
        }
        if (flag != 0) {
            return true;
        }
        return true;
    }

    private void concaveRender() {
        float[][] polyVertices = this.polygon.vertices;
        if (this.tpolygon == null) {
            this.tpolygon = new PPolygon(this);
            this.tpolygon_vertex_order = new int[this.TPOLYGON_MAX_VERTICES];
        }
        this.tpolygon.reset(3);
        if (this.textureImage != null) {
            this.tpolygon.texture(this.textureImage);
        }
        this.tpolygon.interpX = this.polygon.interpX;
        this.tpolygon.interpZ = this.polygon.interpZ;
        this.tpolygon.interpUV = this.polygon.interpUV;
        this.tpolygon.interpARGB = this.polygon.interpARGB;
        boolean ccw = false;
        int n = this.polygon.vertexCount;
        float[] min = new float[]{polyVertices[0][0], polyVertices[0][1]};
        int mm = 0;
        int i = 0;
        while (i < n) {
            if (polyVertices[i][1] < min[1] || polyVertices[i][1] == min[1] && polyVertices[i][0] > min[0]) {
                mm = i;
                min[0] = polyVertices[mm][0];
                min[1] = polyVertices[mm][1];
            }
            ++i;
        }
        float[] a = new float[2];
        float[] b = new float[2];
        float[] c = new float[2];
        int mm1 = (mm + (n - 1)) % n;
        int i2 = 0;
        while (i2 < 2) {
            a[i2] = polyVertices[mm1][i2];
            b[i2] = polyVertices[mm][i2];
            c[i2] = polyVertices[(mm + 1) % n][i2];
            ++i2;
        }
        float cp = a[0] * b[1] - a[1] * b[0] + a[1] * c[0] - a[0] * c[1] + b[0] * c[1] - c[0] * b[1];
        ccw = cp > 0.0f;
        if (!ccw) {
            i2 = 0;
            while (i2 < n) {
                this.tpolygon_vertex_order[i2] = i2;
                ++i2;
            }
        } else {
            i2 = 0;
            while (i2 < n) {
                this.tpolygon_vertex_order[i2] = n - 1 - i2;
                ++i2;
            }
        }
        int vc = n;
        int count = 2 * vc;
        int m = 0;
        int v = vc - 1;
        while (vc > 2) {
            float Cx;
            float By;
            float Ay;
            float Cy;
            float Ax;
            float Bx;
            int w;
            boolean snip = true;
            if (count-- <= 0) break;
            int u = v;
            if (vc <= u) {
                u = 0;
            }
            if (vc <= (v = u + 1)) {
                v = 0;
            }
            if (vc <= (w = v + 1)) {
                w = 0;
            }
            if (1.0E-4f > ((Bx = -polyVertices[this.tpolygon_vertex_order[v]][0]) - (Ax = -polyVertices[this.tpolygon_vertex_order[u]][0])) * ((Cy = polyVertices[this.tpolygon_vertex_order[w]][1]) - (Ay = polyVertices[this.tpolygon_vertex_order[u]][1])) - ((By = polyVertices[this.tpolygon_vertex_order[v]][1]) - Ay) * ((Cx = -polyVertices[this.tpolygon_vertex_order[w]][0]) - Ax)) continue;
            int p = 0;
            while (p < vc) {
                if (p != u && p != v && p != w) {
                    float Px = -polyVertices[this.tpolygon_vertex_order[p]][0];
                    float Py = polyVertices[this.tpolygon_vertex_order[p]][1];
                    float ax = Cx - Bx;
                    float ay = Cy - By;
                    float bx = Ax - Cx;
                    float by = Ay - Cy;
                    float cx = Bx - Ax;
                    float cy = By - Ay;
                    float apx = Px - Ax;
                    float apy = Py - Ay;
                    float bpx = Px - Bx;
                    float bpy = Py - By;
                    float cpx = Px - Cx;
                    float cpy = Py - Cy;
                    float aCROSSbp = ax * bpy - ay * bpx;
                    float cCROSSap = cx * apy - cy * apx;
                    float bCROSScp = bx * cpy - by * cpx;
                    if (aCROSSbp >= 0.0f && bCROSScp >= 0.0f && cCROSSap >= 0.0f) {
                        snip = false;
                    }
                }
                ++p;
            }
            if (!snip) continue;
            int[] triangle_vertices = new int[]{this.tpolygon_vertex_order[u], this.tpolygon_vertex_order[v], this.tpolygon_vertex_order[w]};
            int i3 = 0;
            while (i3 < 3) {
                float[] src = this.polygon.vertices[triangle_vertices[i3]];
                float[] dest = this.tpolygon.vertices[i3];
                int k = 0;
                while (k < 36) {
                    dest[k] = src[k];
                    ++k;
                }
                ++i3;
            }
            this.tpolygon.render();
            ++m;
            int s = v;
            int t = v + 1;
            while (t < vc) {
                this.tpolygon_vertex_order[s] = this.tpolygon_vertex_order[t];
                ++s;
                ++t;
            }
            count = 2 * --vc;
        }
    }

    protected void rectImpl(float x1f, float y1f, float x2f, float y2f) {
        if (this.untransformed() && !this.fillAlpha) {
            int x1 = (int)x1f;
            int y1 = (int)y1f;
            int x2 = (int)x2f;
            int y2 = (int)y2f;
            this.rectImplFillUntranSolidRGB(x1, y1, x2, y2);
            if (this.stroke) {
                if (this.strokeWeight == 1.0f) {
                    this.thin_flat_line(x1, y1, x2, y1);
                    this.thin_flat_line(x2, y1, x2, y2);
                    this.thin_flat_line(x2, y2, x1, y2);
                    this.thin_flat_line(x1, y2, x1, y1);
                } else {
                    this.thick_flat_line(x1, y1, this.fillR, this.fillG, this.fillB, this.fillA, x2, y1, this.fillR, this.fillG, this.fillB, this.fillA);
                    this.thick_flat_line(x2, y1, this.fillR, this.fillG, this.fillB, this.fillA, x2, y2, this.fillR, this.fillG, this.fillB, this.fillA);
                    this.thick_flat_line(x2, y2, this.fillR, this.fillG, this.fillB, this.fillA, x1, y2, this.fillR, this.fillG, this.fillB, this.fillA);
                    this.thick_flat_line(x1, y2, this.fillR, this.fillG, this.fillB, this.fillA, x1, y1, this.fillR, this.fillG, this.fillB, this.fillA);
                }
            }
        } else {
            this.beginShape(128);
            this.vertex(x1f, y1f);
            this.vertex(x2f, y1f);
            this.vertex(x2f, y2f);
            this.vertex(x1f, y2f);
            this.endShape();
        }
    }

    private void rectImplFillUntranSolidRGB(int x1, int y1, int x2, int y2) {
        int temp;
        if (y2 < y1) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        if (x2 < x1) {
            temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if (x1 > this.width1 || x2 < 0 || y1 > this.height1 || y2 < 0) {
            return;
        }
        int fx1 = x1;
        int fy1 = y1;
        int fx2 = x2;
        int fy2 = y2;
        if (fx1 < 0) {
            fx1 = 0;
        }
        if (fx2 > this.width) {
            fx2 = this.width;
        }
        if (fy1 < 0) {
            fy1 = 0;
        }
        if (fy2 > this.height) {
            fy2 = this.height;
        }
        int ww = fx2 - fx1;
        int hh = fy2 - fy1;
        int[] row = new int[ww];
        int i = 0;
        while (i < ww) {
            row[i] = this.fillColor;
            ++i;
        }
        int idx = fy1 * this.width + fx1;
        int y = 0;
        while (y < hh) {
            System.arraycopy(row, 0, this.pixels, idx, ww);
            idx += this.width;
            ++y;
        }
        row = null;
    }

    public void ellipseImpl(float x1, float y1, float w, float h) {
        if (!this.smooth && this.strokeWeight == 1.0f && !this.fillAlpha && !this.strokeAlpha && this.untransformed()) {
            float hradius = w / 2.0f;
            float vradius = h / 2.0f;
            int centerX = (int)(x1 + hradius);
            int centerY = (int)(y1 + vradius);
            if (hradius == vradius) {
                this.flat_circle(centerX, centerY, (int)hradius);
            } else {
                this.flat_ellipse(centerX, centerY, (int)hradius, (int)vradius);
            }
        } else {
            super.ellipseImpl(x1, y1, w, h);
        }
    }

    private void flat_circle(int centerX, int centerY, int radius) {
        if (this.unwarped()) {
            float x = this.m00 * (float)centerX + this.m01 * (float)centerY + this.m02;
            float y = this.m10 * (float)centerX + this.m11 * (float)centerY + this.m12;
            centerX = (int)x;
            centerY = (int)y;
        }
        if (this.fill) {
            this.flat_circle_fill(centerX, centerY, radius);
        }
        if (this.stroke) {
            this.flat_circle_stroke(centerX, centerY, radius);
        }
    }

    private void flat_circle_stroke(int xC, int yC, int r) {
        int x = 0;
        int y = r;
        int u = 1;
        int v = 2 * r - 1;
        int E = 0;
        while (x < y) {
            this.thin_point(xC + x, yC + y, 0.0f, this.strokeColor);
            this.thin_point(xC + y, yC - x, 0.0f, this.strokeColor);
            this.thin_point(xC - x, yC - y, 0.0f, this.strokeColor);
            this.thin_point(xC - y, yC + x, 0.0f, this.strokeColor);
            ++x;
            if (v < 2 * (E += (u += 2))) {
                --y;
                E -= v;
                v -= 2;
            }
            if (x > y) break;
            this.thin_point(xC + y, yC + x, 0.0f, this.strokeColor);
            this.thin_point(xC + x, yC - y, 0.0f, this.strokeColor);
            this.thin_point(xC - y, yC - x, 0.0f, this.strokeColor);
            this.thin_point(xC - x, yC + y, 0.0f, this.strokeColor);
        }
    }

    private void flat_circle_fill(int xc, int yc, int r) {
        int x = 0;
        int y = r;
        int u = 1;
        int v = 2 * r - 1;
        int E = 0;
        while (x < y) {
            int xx = xc;
            while (xx < xc + x) {
                this.thin_point(xx, yc + y, 0.0f, this.fillColor);
                ++xx;
            }
            xx = xc;
            while (xx < xc + y) {
                this.thin_point(xx, yc - x, 0.0f, this.fillColor);
                ++xx;
            }
            xx = xc - x;
            while (xx < xc) {
                this.thin_point(xx, yc - y, 0.0f, this.fillColor);
                ++xx;
            }
            xx = xc - y;
            while (xx < xc) {
                this.thin_point(xx, yc + x, 0.0f, this.fillColor);
                ++xx;
            }
            ++x;
            if (v < 2 * (E += (u += 2))) {
                --y;
                E -= v;
                v -= 2;
            }
            if (x > y) break;
            xx = xc;
            while (xx < xc + y) {
                this.thin_point(xx, yc + x, 0.0f, this.fillColor);
                ++xx;
            }
            xx = xc;
            while (xx < xc + x) {
                this.thin_point(xx, yc - y, 0.0f, this.fillColor);
                ++xx;
            }
            xx = xc - y;
            while (xx < xc) {
                this.thin_point(xx, yc - x, 0.0f, this.fillColor);
                ++xx;
            }
            xx = xc - x;
            while (xx < xc) {
                this.thin_point(xx, yc + y, 0.0f, this.fillColor);
                ++xx;
            }
        }
    }

    private final void flat_ellipse_symmetry(int centerX, int centerY, int ellipseX, int ellipseY, boolean filling) {
        if (filling) {
            int i = centerX - ellipseX + 1;
            while (i < centerX + ellipseX) {
                this.thin_point(i, centerY - ellipseY, 0.0f, this.fillColor);
                this.thin_point(i, centerY + ellipseY, 0.0f, this.fillColor);
                ++i;
            }
        } else {
            this.thin_point(centerX - ellipseX, centerY + ellipseY, 0.0f, this.strokeColor);
            this.thin_point(centerX + ellipseX, centerY + ellipseY, 0.0f, this.strokeColor);
            this.thin_point(centerX - ellipseX, centerY - ellipseY, 0.0f, this.strokeColor);
            this.thin_point(centerX + ellipseX, centerY - ellipseY, 0.0f, this.strokeColor);
        }
    }

    private void flat_ellipse_internal(int centerX, int centerY, int a, int b, boolean filling) {
        int a2 = a * a;
        int b2 = b * b;
        int x = 0;
        int y = b;
        int s = a2 * (1 - 2 * b) + 2 * b2;
        int t = b2 - 2 * a2 * (2 * b - 1);
        this.flat_ellipse_symmetry(centerX, centerY, x, y, filling);
        do {
            if (s < 0) {
                s += 2 * b2 * (2 * x + 3);
                t += 4 * b2 * (x + 1);
                ++x;
            } else if (t < 0) {
                s += 2 * b2 * (2 * x + 3) - 4 * a2 * (y - 1);
                t += 4 * b2 * (x + 1) - 2 * a2 * (2 * y - 3);
                ++x;
                --y;
            } else {
                s -= 4 * a2 * (y - 1);
                t -= 2 * a2 * (2 * y - 3);
                --y;
            }
            this.flat_ellipse_symmetry(centerX, centerY, x, y, filling);
        } while (y > 0);
    }

    private void flat_ellipse(int centerX, int centerY, int a, int b) {
        if (this.unwarped()) {
            float x = this.m00 * (float)centerX + this.m01 * (float)centerY + this.m02;
            float y = this.m10 * (float)centerX + this.m11 * (float)centerY + this.m12;
            centerX = (int)x;
            centerY = (int)y;
        }
        if (this.fill) {
            this.flat_ellipse_internal(centerX, centerY, a, b, true);
        }
        if (this.stroke) {
            this.flat_ellipse_internal(centerX, centerY, a, b, false);
        }
    }

    public void bezier(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        this.depthErrorXYZ("bezier");
    }

    public void curve(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        this.depthErrorXYZ("curve");
    }

    protected void imageImpl(PImage image, float x1, float y1, float x2, float y2, int u1, int v1, int u2, int v2) {
        if (x2 - x1 == (float)image.width && y2 - y1 == (float)image.height && !this.tint && this.unwarped()) {
            this.flat_image(image, (int)(x1 + this.m02), (int)(y1 + this.m12), u1, v1, u2, v2);
        } else {
            super.imageImpl(image, x1, y1, x2, y2, u1, v1, u2, v2);
        }
    }

    private void flat_image(PImage image, int sx1, int sy1, int ix1, int iy1, int ix2, int iy2) {
        block12: {
            int target;
            int source;
            int sy2;
            int sx2;
            block13: {
                block11: {
                    if (this.imageMode == 3) {
                        sx1 -= image.width / 2;
                        sy1 -= image.height / 2;
                    }
                    sx2 = sx1 + image.width;
                    sy2 = sy1 + image.height;
                    if (sx1 > this.width1 || sx2 < 0 || sy1 > this.height1 || sy2 < 0) {
                        return;
                    }
                    if (sx1 < 0) {
                        ix1 -= sx1;
                        sx1 = 0;
                    }
                    if (sy1 < 0) {
                        iy1 -= sy1;
                        sy1 = 0;
                    }
                    if (sx2 > this.width) {
                        ix2 -= sx2 - this.width;
                        sx2 = this.width;
                    }
                    if (sy2 > this.height) {
                        iy2 -= sy2 - this.height;
                        sy2 = this.height;
                    }
                    source = iy1 * image.width + ix1;
                    target = sy1 * this.width;
                    if (image.format != 2) break block11;
                    int y = sy1;
                    while (y < sy2) {
                        int tx = 0;
                        int x = sx1;
                        while (x < sx2) {
                            this.pixels[target + x] = PGraphics2D._blend(this.pixels[target + x], image.pixels[source + tx], image.pixels[source + tx++] >>> 24);
                            ++x;
                        }
                        source += image.width;
                        target += this.width;
                        ++y;
                    }
                    break block12;
                }
                if (image.format != 4) break block13;
                int y = sy1;
                while (y < sy2) {
                    int tx = 0;
                    int x = sx1;
                    while (x < sx2) {
                        this.pixels[target + x] = PGraphics2D._blend(this.pixels[target + x], this.fillColor, image.pixels[source + tx++]);
                        ++x;
                    }
                    source += image.width;
                    target += this.width;
                    ++y;
                }
                break block12;
            }
            if (image.format != 1) break block12;
            target += sx1;
            int tw = sx2 - sx1;
            int y = sy1;
            while (y < sy2) {
                System.arraycopy(image.pixels, source, this.pixels, target, tw);
                source += image.width;
                target += this.width;
                ++y;
            }
        }
    }

    private void thin_pointAt(int x, int y, float z, int color) {
        int index = y * this.width + x;
        this.pixels[index] = color;
        this.zbuffer[index] = z;
    }

    private void thin_pointAtIndex(int offset, float z, int color) {
        this.pixels[offset] = color;
        this.zbuffer[offset] = z;
    }

    private void thick_point(float x, float y, float z, float r, float g, float b, float a) {
        this.spolygon.reset(4);
        this.spolygon.interpARGB = false;
        float strokeWidth2 = this.strokeWeight / 2.0f;
        float[] svertex = this.spolygon.vertices[0];
        svertex[0] = x - strokeWidth2;
        svertex[1] = y - strokeWidth2;
        svertex[2] = z;
        svertex[3] = r;
        svertex[4] = g;
        svertex[5] = b;
        svertex[6] = a;
        svertex = this.spolygon.vertices[1];
        svertex[0] = x + strokeWidth2;
        svertex[1] = y - strokeWidth2;
        svertex[2] = z;
        svertex = this.spolygon.vertices[2];
        svertex[0] = x + strokeWidth2;
        svertex[1] = y + strokeWidth2;
        svertex[2] = z;
        svertex = this.spolygon.vertices[3];
        svertex[0] = x - strokeWidth2;
        svertex[1] = y + strokeWidth2;
        svertex[2] = z;
        this.spolygon.render();
    }

    private void thin_flat_line(int x1, int y1, int x2, int y2) {
        int j;
        int offset;
        int ny2;
        int nx2;
        int ny1;
        int nx1;
        int code2;
        int code1 = this.thin_flat_lineClipCode(x1, y1);
        if ((code1 & (code2 = this.thin_flat_lineClipCode(x2, y2))) != 0) {
            return;
        }
        int dip = code1 | code2;
        if (dip != 0) {
            float a1 = 0.0f;
            float a2 = 1.0f;
            float a = 0.0f;
            int i = 0;
            while (i < 4) {
                if ((dip >> i) % 2 == 1) {
                    a = this.thin_flat_lineSlope(x1, y1, x2, y2, i + 1);
                    if ((code1 >> i) % 2 == 1) {
                        a1 = Math.max(a, a1);
                    } else {
                        a2 = Math.min(a, a2);
                    }
                }
                ++i;
            }
            if (a1 > a2) {
                return;
            }
            nx1 = (int)((float)x1 + a1 * (float)(x2 - x1));
            ny1 = (int)((float)y1 + a1 * (float)(y2 - y1));
            nx2 = (int)((float)x1 + a2 * (float)(x2 - x1));
            ny2 = (int)((float)y1 + a2 * (float)(y2 - y1));
        } else {
            nx1 = x1;
            nx2 = x2;
            ny1 = y1;
            ny2 = y2;
        }
        boolean yLonger = false;
        int shortLen = ny2 - ny1;
        int longLen = nx2 - nx1;
        if (Math.abs(shortLen) > Math.abs(longLen)) {
            int swap = shortLen;
            shortLen = longLen;
            longLen = swap;
            yLonger = true;
        }
        int decInc = longLen == 0 ? 0 : (shortLen << 16) / longLen;
        if (nx1 == nx2) {
            if (ny1 > ny2) {
                int ty = ny1;
                ny1 = ny2;
                ny2 = ty;
            }
            offset = ny1 * this.width + nx1;
            int j2 = ny1;
            while (j2 <= ny2) {
                this.thin_pointAtIndex(offset, 0.0f, this.strokeColor);
                offset += this.width;
                ++j2;
            }
            return;
        }
        if (ny1 == ny2) {
            if (nx1 > nx2) {
                int tx = nx1;
                nx1 = nx2;
                nx2 = tx;
            }
            offset = ny1 * this.width + nx1;
            int j3 = nx1;
            while (j3 <= nx2) {
                this.thin_pointAtIndex(offset++, 0.0f, this.strokeColor);
                ++j3;
            }
            return;
        }
        if (yLonger) {
            if (longLen > 0) {
                longLen += ny1;
                j = 32768 + (nx1 << 16);
                while (ny1 <= longLen) {
                    this.thin_pointAt(j >> 16, ny1, 0.0f, this.strokeColor);
                    j += decInc;
                    ++ny1;
                }
                return;
            }
            longLen += ny1;
            j = 32768 + (nx1 << 16);
            while (ny1 >= longLen) {
                this.thin_pointAt(j >> 16, ny1, 0.0f, this.strokeColor);
                j -= decInc;
                --ny1;
            }
            return;
        }
        if (longLen > 0) {
            longLen += nx1;
            j = 32768 + (ny1 << 16);
            while (nx1 <= longLen) {
                this.thin_pointAt(nx1, j >> 16, 0.0f, this.strokeColor);
                j += decInc;
                ++nx1;
            }
            return;
        }
        longLen += nx1;
        j = 32768 + (ny1 << 16);
        while (nx1 >= longLen) {
            this.thin_pointAt(nx1, j >> 16, 0.0f, this.strokeColor);
            j -= decInc;
            --nx1;
        }
    }

    private int thin_flat_lineClipCode(float x, float y) {
        return (y < 0.0f ? 8 : 0) | (y > (float)this.height1 ? 4 : 0) | (x < 0.0f ? 2 : 0) | (x > (float)this.width1 ? 1 : 0);
    }

    private float thin_flat_lineSlope(float x1, float y1, float x2, float y2, int border) {
        switch (border) {
            case 4: {
                return -y1 / (y2 - y1);
            }
            case 3: {
                return ((float)this.height1 - y1) / (y2 - y1);
            }
            case 2: {
                return -x1 / (x2 - x1);
            }
            case 1: {
                return ((float)this.width1 - x1) / (x2 - x1);
            }
        }
        return -1.0f;
    }

    private boolean flat_line_retribution(float x1, float y1, float x2, float y2, float r1, float g1, float b1) {
        return false;
    }

    private void thick_flat_line(float ox1, float oy1, float r1, float g1, float b1, float a1, float ox2, float oy2, float r2, float g2, float b2, float a2) {
        this.spolygon.interpARGB = r1 != r2 || g1 != g2 || b1 != b2 || a1 != a2;
        this.spolygon.interpZ = false;
        if (!this.spolygon.interpARGB && this.flat_line_retribution(ox1, oy1, ox2, oy2, r1, g1, b1)) {
            return;
        }
        float dX = ox2 - ox1 + 1.0E-4f;
        float dY = oy2 - oy1 + 1.0E-4f;
        float len = PGraphics2D.sqrt(dX * dX + dY * dY);
        float rh = this.strokeWeight / len;
        float dx0 = rh * dY;
        float dy0 = rh * dX;
        float dx1 = rh * dY;
        float dy1 = rh * dX;
        this.spolygon.reset(4);
        float[] svertex = this.spolygon.vertices[0];
        svertex[0] = ox1 + dx0;
        svertex[1] = oy1 - dy0;
        svertex[3] = r1;
        svertex[4] = g1;
        svertex[5] = b1;
        svertex[6] = a1;
        svertex = this.spolygon.vertices[1];
        svertex[0] = ox1 - dx0;
        svertex[1] = oy1 + dy0;
        svertex[3] = r1;
        svertex[4] = g1;
        svertex[5] = b1;
        svertex[6] = a1;
        svertex = this.spolygon.vertices[2];
        svertex[0] = ox2 - dx1;
        svertex[1] = oy2 + dy1;
        svertex[3] = r2;
        svertex[4] = g2;
        svertex[5] = b2;
        svertex[6] = a2;
        svertex = this.spolygon.vertices[3];
        svertex[0] = ox2 + dx1;
        svertex[1] = oy2 - dy1;
        svertex[3] = r2;
        svertex[4] = g2;
        svertex[5] = b2;
        svertex[6] = a2;
        this.spolygon.render();
    }

    private void draw_lines(float[][] vertices, int max, int offset, int increment, int skip) {
        if (this.strokeWeight < 2.0f) {
            int i = 0;
            while (i < max) {
                if (skip == 0 || (i + offset) % skip != 0) {
                    float[] a = vertices[i];
                    float[] b = vertices[i + offset];
                    if (this.line == null) {
                        this.line = new PLine(this);
                    }
                    this.line.reset();
                    this.line.setIntensities(a[12], a[13], a[14], a[15], b[12], b[13], b[14], b[15]);
                    this.line.setVertices(a[0], a[1], a[2], b[0], b[1], b[2]);
                    this.line.draw();
                }
                i += increment;
            }
        } else if (this.strokeWeight < 2.0f && !this.strokeChanged) {
            int i = 0;
            while (i < max) {
                if (skip == 0 || (i + offset) % skip != 0) {
                    this.thin_flat_line((int)vertices[i][0], (int)vertices[i][1], (int)vertices[i + offset][0], (int)vertices[i + offset][1]);
                }
                i += increment;
            }
        } else {
            int i = 0;
            while (i < max) {
                if (skip == 0 || (i + offset) % skip != 0) {
                    float[] v1 = vertices[i];
                    float[] v2 = vertices[i + offset];
                    this.thick_flat_line(v1[0], v1[1], v1[12], v1[13], v1[14], v1[15], v2[0], v2[1], v2[12], v2[13], v2[14], v2[15]);
                }
                i += increment;
            }
        }
    }

    private void thin_point(int x, int y, float z, int color) {
        if (x < 0 || x > this.width1 || y < 0 || y > this.height1) {
            return;
        }
        int index = y * this.width + x;
        if ((color & 0xFF000000) == -16777216) {
            this.pixels[index] = color;
        } else {
            int a2 = color >> 24 & 0xFF;
            int a1 = a2 ^ 0xFF;
            int p2 = this.strokeColor;
            int p1 = this.pixels[index];
            int r = a1 * (p1 >> 16 & 0xFF) + a2 * (p2 >> 16 & 0xFF) & 0xFF00;
            int g = a1 * (p1 >> 8 & 0xFF) + a2 * (p2 >> 8 & 0xFF) & 0xFF00;
            int b = a1 * (p1 & 0xFF) + a2 * (p2 & 0xFF) >> 8;
            this.pixels[index] = 0xFF000000 | r << 8 | g | b;
        }
        this.zbuffer[index] = z;
    }

    protected void clear() {
        int i = 0;
        while (i < this.pixelCount) {
            this.pixels[i] = this.backgroundColor;
            ++i;
        }
    }

    private boolean untransformed() {
        return this.m00 == 1.0f && this.m01 == 0.0f && this.m02 == 0.0f && this.m10 == 0.0f && this.m11 == 1.0f && this.m12 == 0.0f;
    }

    private boolean unwarped() {
        return this.m00 == 1.0f && this.m01 == 0.0f && this.m10 == 0.0f && this.m11 == 1.0f;
    }

    private void calc_lighting(float r, float g, float b, float ix, float iy, float iz, float nx, float ny, float nz, float[] target, int toffset) {
        target[toffset + 0] = r;
        target[toffset + 1] = g;
        target[toffset + 2] = b;
    }

    private static final int float_color(float r, float g, float b) {
        return 0xFF000000 | (int)(255.0f * r) << 16 | (int)(255.0f * g) << 8 | (int)(255.0f * b);
    }

    public static final int _blend(int p1, int p2, int a2) {
        a2 = a2 * (p2 >>> 24) >> 8;
        int a1 = a2 ^ 0xFF;
        int r = a1 * (p1 >> 16 & 0xFF) + a2 * (p2 >> 16 & 0xFF) & 0xFF00;
        int g = a1 * (p1 >> 8 & 0xFF) + a2 * (p2 >> 8 & 0xFF) & 0xFF00;
        int b = a1 * (p1 & 0xFF) + a2 * (p2 & 0xFF) >> 8;
        return 0xFF000000 | r << 8 | g | b;
    }
}

