/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PFont;
import processing.core.PImage;
import processing.core.PMatrix;

public abstract class PGraphics
extends PImage
implements PConstants {
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public static final int R = 3;
    public static final int G = 4;
    public static final int B = 5;
    public static final int A = 6;
    public static final int U = 7;
    public static final int V = 8;
    public static final int MX = 9;
    public static final int MY = 10;
    public static final int MZ = 11;
    public static final int SR = 12;
    public static final int SG = 13;
    public static final int SB = 14;
    public static final int SA = 15;
    public static final int SW = 16;
    public static final int NX = 17;
    public static final int NY = 18;
    public static final int NZ = 19;
    public static final int VX = 20;
    public static final int VY = 21;
    public static final int VZ = 22;
    public static final int VW = 23;
    public static final int AR = 24;
    public static final int AG = 25;
    public static final int AB = 26;
    public static final int DR = 3;
    public static final int DG = 4;
    public static final int DB = 5;
    public static final int DA = 6;
    public static final int SPR = 27;
    public static final int SPG = 28;
    public static final int SPB = 29;
    public static final int SPA = 30;
    public static final int SHINE = 31;
    public static final int ER = 32;
    public static final int EG = 33;
    public static final int EB = 34;
    public static final int BEEN_LIT = 35;
    static final int VERTEX_FIELD_COUNT = 36;
    public static final int INDEX = 0;
    public static final int VERTEX1 = 1;
    public static final int VERTEX2 = 2;
    public static final int VERTEX3 = 3;
    public static final int TEXTURE_INDEX = 4;
    public static final int STROKE_MODE = 3;
    public static final int STROKE_WEIGHT = 4;
    public static final int LINE_FIELD_COUNT = 5;
    public static final int TRIANGLE_FIELD_COUNT = 5;
    public static final int TRI_DIFFUSE_R = 0;
    public static final int TRI_DIFFUSE_G = 1;
    public static final int TRI_DIFFUSE_B = 2;
    public static final int TRI_DIFFUSE_A = 3;
    public static final int TRI_SPECULAR_R = 4;
    public static final int TRI_SPECULAR_G = 5;
    public static final int TRI_SPECULAR_B = 6;
    public static final int TRI_SPECULAR_A = 7;
    public static final int TRIANGLE_COLOR_COUNT = 8;
    public static final int AUTO_NORMAL = 0;
    public static final int MANUAL_SHAPE_NORMAL = 1;
    public static final int MANUAL_VERTEX_NORMAL = 2;
    public int width1;
    public int height1;
    public int pixelCount;
    protected boolean defaultsInited;
    protected boolean insideDraw;
    boolean insideResize;
    protected boolean mainDrawingSurface;
    DirectColorModel cm;
    MemoryImageSource mis;
    public Image image;
    public PGraphics raw;
    protected boolean[] hints = new boolean[10];
    public int colorMode;
    public float colorModeX;
    public float colorModeY;
    public float colorModeZ;
    public float colorModeA;
    boolean colorScale;
    boolean colorRgb255;
    public boolean tint;
    public int tintColor;
    protected boolean tintAlpha;
    protected float tintR;
    protected float tintG;
    protected float tintB;
    protected float tintA;
    protected int tintRi;
    protected int tintGi;
    protected int tintBi;
    protected int tintAi;
    public boolean fill;
    public int fillColor = -1;
    protected boolean fillAlpha;
    protected float fillR;
    protected float fillG;
    protected float fillB;
    protected float fillA;
    protected int fillRi;
    protected int fillGi;
    protected int fillBi;
    protected int fillAi;
    public boolean stroke;
    public int strokeColor = -16777216;
    protected boolean strokeAlpha;
    protected float strokeR;
    protected float strokeG;
    protected float strokeB;
    protected float strokeA;
    protected int strokeRi;
    protected int strokeGi;
    protected int strokeBi;
    protected int strokeAi;
    public int backgroundColor = -3355444;
    protected boolean backgroundAlpha;
    protected float backgroundR;
    protected float backgroundG;
    protected float backgroundB;
    protected float backgroundA;
    protected int backgroundRi;
    protected int backgroundGi;
    protected int backgroundBi;
    protected int backgroundAi;
    protected float calcR;
    protected float calcG;
    protected float calcB;
    protected float calcA;
    int calcRi;
    int calcGi;
    int calcBi;
    int calcAi;
    int calcColor;
    boolean calcAlpha;
    int cacheHsbKey;
    float[] cacheHsbValue = new float[3];
    public float strokeWeight = 1.0f;
    public int strokeJoin = 8;
    public int strokeCap = 2;
    public float m00;
    public float m01;
    public float m02;
    public float m03;
    public float m10;
    public float m11;
    public float m12;
    public float m13;
    public float m20;
    public float m21;
    public float m22;
    public float m23;
    public float m30;
    public float m31;
    public float m32;
    public float m33;
    static final int MATRIX_STACK_DEPTH = 32;
    float[][] matrixStack = new float[32][16];
    int matrixStackDepth;
    protected int shape;
    static final int DEFAULT_VERTICES = 512;
    protected float[][] vertices = new float[512][36];
    protected int vertexCount;
    protected boolean bezierInited = false;
    public int bezierDetail = 20;
    protected float[][] bezier_basis = new float[][]{{-1.0f, 3.0f, -3.0f, 1.0f}, {3.0f, -6.0f, 3.0f, 0.0f}, {-3.0f, 3.0f, 0.0f, 0.0f}, {1.0f, 0.0f, 0.0f, 0.0f}};
    protected PMatrix bezierBasis = new PMatrix(-1.0f, 3.0f, -3.0f, 1.0f, 3.0f, -6.0f, 3.0f, 0.0f, -3.0f, 3.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f);
    protected float[][] bezierForwardMatrix;
    protected float[][] bezierDrawMatrix;
    protected boolean curve_inited = false;
    protected int curveDetail = 20;
    public float curveTightness = 0.0f;
    protected float[][] curve_basis;
    protected float[][] curve_forward;
    protected float[][] curve_draw;
    protected PMatrix bezierBasisInverse;
    protected PMatrix curveToBezierMatrix;
    static final int DEFAULT_SPLINE_VERTICES = 128;
    protected float[][] splineVertices;
    protected int splineVertexCount;
    protected static final float[] sinLUT = new float[720];
    protected static final float[] cosLUT = new float[720];
    protected static final float SINCOS_PRECISION = 0.5f;
    protected static final int SINCOS_LENGTH = 720;
    public int rectMode;
    public int ellipseMode;
    public PFont textFont;
    public Font textFontNative;
    public FontMetrics textFontNativeMetrics;
    public int textAlign;
    public int textAlignY;
    public int textMode;
    public float textSize;
    public float textLeading;
    public float textX;
    public float textY;
    public float textZ;
    protected char[] textBuffer = new char[8192];
    protected char[] textWidthBuffer = new char[8192];
    public PMatrix modelview;
    public PMatrix modelviewInv;
    public PMatrix camera;
    public PMatrix cameraInv;
    public float ambientR;
    public float ambientG;
    public float ambientB;
    public float specularR;
    public float specularG;
    public float specularB;
    public float specularA;
    public float emissiveR;
    public float emissiveG;
    public float emissiveB;
    public float shininess;
    public float cameraFOV;
    public float cameraX;
    public float cameraY;
    public float cameraZ;
    public float cameraNear;
    public float cameraFar;
    public float cameraAspect;
    public PMatrix projection;
    public int[] stencil;
    public float[] zbuffer;
    public static final int MAX_LIGHTS = 8;
    public int lightCount = 0;
    public int[] lightType;
    public float[][] lightPosition;
    public float[][] lightNormal;
    public float[] lightFalloffConstant;
    public float[] lightFalloffLinear;
    public float[] lightFalloffQuadratic;
    public float[] lightSpotAngle;
    public float[] lightSpotAngleCos;
    public float[] lightSpotConcentration;
    public float[][] lightDiffuse;
    public float[][] lightSpecular;
    public float[] currentLightSpecular;
    public float currentLightFalloffConstant;
    public float currentLightFalloffLinear;
    public float currentLightFalloffQuadratic;
    public int textureMode;
    public float textureU;
    public float textureV;
    public PImage textureImage;
    public float normalX;
    public float normalY;
    public float normalZ;
    public int normalMode;
    public int normalCount;
    public int sphereDetail = 0;
    static float[] lerpColorHSB1;
    static float[] lerpColorHSB2;

    static {
        int i = 0;
        while (i < 720) {
            PGraphics.sinLUT[i] = (float)Math.sin((float)i * ((float)Math.PI / 180) * 0.5f);
            PGraphics.cosLUT[i] = (float)Math.cos((float)i * ((float)Math.PI / 180) * 0.5f);
            ++i;
        }
    }

    public PGraphics(int iwidth, int iheight, PApplet parent) {
        this.parent = parent;
        if (parent != null) {
            this.setMainDrawingSurface();
        }
        this.resize(iwidth, iheight);
    }

    public void setMainDrawingSurface() {
        this.mainDrawingSurface = true;
        this.format = 1;
        this.parent.addListeners();
    }

    public void resize(int iwidth, int iheight) {
        this.insideDrawWait();
        this.insideResize = true;
        this.width = iwidth;
        this.height = iheight;
        this.width1 = this.width - 1;
        this.height1 = this.height - 1;
        this.allocate();
        this.insideResize = false;
    }

    public void requestDisplay(PApplet pa) {
        pa.handleDisplay();
    }

    protected abstract void allocate();

    protected void insideResizeWait() {
    }

    protected void insideDrawWait() {
    }

    public abstract void beginDraw();

    public abstract void endDraw();

    public void defaults() {
        this.colorMode(1, 255.0f);
        this.fill(255);
        this.stroke(0);
        this.shape = 0;
        this.matrixStackDepth = 0;
        this.rectMode(0);
        this.ellipseMode(3);
        this.textFont = null;
        this.textSize = 12.0f;
        this.textLeading = 14.0f;
        this.textAlign = 37;
        this.textMode = 4;
        if (this.mainDrawingSurface) {
            this.background(this.backgroundColor);
        }
        this.defaultsInited = true;
    }

    protected void flush() {
    }

    public void hint(int which) {
        this.hints[which] = true;
    }

    public void noHint(int which) {
        this.hints[which] = false;
    }

    public void beginShape() {
        this.beginShape(256);
    }

    public abstract void beginShape(int var1);

    public void normal(float nx, float ny, float nz) {
    }

    public void textureMode(int mode) {
        this.textureMode = mode;
    }

    public void texture(PImage image) {
        this.textureImage = image;
    }

    protected void textureVertex(float u, float v) {
        if (this.textureImage == null) {
            throw new RuntimeException("need to set an image with texture() before using u and v coordinates");
        }
        if (this.textureMode == 2) {
            u /= (float)this.textureImage.width;
            v /= (float)this.textureImage.height;
        }
        this.textureU = u;
        this.textureV = v;
        if (this.textureU < 0.0f) {
            this.textureU = 0.0f;
        } else if (this.textureU > 1.0f) {
            this.textureU = 1.0f;
        }
        if (this.textureV < 0.0f) {
            this.textureV = 0.0f;
        } else if (this.textureV > 1.0f) {
            this.textureV = 1.0f;
        }
    }

    public abstract void vertex(float var1, float var2);

    public abstract void vertex(float var1, float var2, float var3);

    public abstract void vertex(float var1, float var2, float var3, float var4);

    public abstract void vertex(float var1, float var2, float var3, float var4, float var5);

    public void bezierVertex(float x2, float y2, float x3, float y3, float x4, float y4) {
        this.bezierVertex(x2, y2, Float.MAX_VALUE, x3, y3, Float.MAX_VALUE, x4, y4, Float.MAX_VALUE);
    }

    public void bezierVertex(float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        if (this.shape != 256) {
            throw new RuntimeException("beginShape() and vertex() must be used before bezierVertex()");
        }
        if (this.splineVertexCount > 0) {
            float[] vertex = this.splineVertices[this.splineVertexCount - 1];
            this.splineVertex(vertex[9], vertex[10], vertex[11], true);
        } else if (this.vertexCount > 0) {
            float[] vertex = this.vertices[this.vertexCount - 1];
            this.splineVertex(vertex[9], vertex[10], vertex[11], true);
        } else {
            throw new RuntimeException("A call to vertex() must be used before bezierVertex()");
        }
        this.splineVertex(x2, y2, z2, true);
        this.splineVertex(x3, y3, z3, true);
        this.splineVertex(x4, y4, z4, true);
    }

    public void curveVertex(float x, float y) {
        this.splineVertex(x, y, Float.MAX_VALUE, false);
    }

    public void curveVertex(float x, float y, float z) {
        this.splineVertex(x, y, z, false);
    }

    protected void splineVertex(float x, float y, float z, boolean bezier) {
        int dimensions;
        if (this.splineVertices == null) {
            this.splineVertices = new float[128][36];
        }
        if (this.splineVertexCount == 128) {
            System.arraycopy(this.splineVertices[125], 0, this.splineVertices[0], 0, 36);
            System.arraycopy(this.splineVertices[126], 0, this.splineVertices[1], 0, 36);
            System.arraycopy(this.splineVertices[127], 0, this.splineVertices[2], 0, 36);
            this.splineVertexCount = 3;
        }
        float[] vertex = this.splineVertices[this.splineVertexCount];
        vertex[9] = x;
        vertex[10] = y;
        if (this.fill) {
            vertex[3] = this.fillR;
            vertex[4] = this.fillG;
            vertex[5] = this.fillB;
            vertex[6] = this.fillA;
        }
        if (this.stroke) {
            vertex[12] = this.strokeR;
            vertex[13] = this.strokeG;
            vertex[14] = this.strokeB;
            vertex[15] = this.strokeA;
            vertex[16] = this.strokeWeight;
        }
        if (this.textureImage != null) {
            vertex[7] = this.textureU;
            vertex[8] = this.textureV;
        }
        int n = dimensions = z == Float.MAX_VALUE ? 2 : 3;
        if (dimensions == 3) {
            vertex[11] = z;
            vertex[17] = this.normalX;
            vertex[18] = this.normalY;
            vertex[19] = this.normalZ;
        }
        ++this.splineVertexCount;
        if (this.splineVertexCount > 3) {
            if (bezier) {
                if (this.splineVertexCount % 4 == 0) {
                    if (!this.bezierInited) {
                        this.bezierInit();
                    }
                    this.splineSegment(this.splineVertexCount - 4, this.splineVertexCount - 4, this.bezierDrawMatrix, dimensions, this.bezierDetail);
                }
            } else {
                if (!this.curve_inited) {
                    this.curve_init();
                }
                this.splineSegment(this.splineVertexCount - 4, this.splineVertexCount - 3, this.curve_draw, dimensions, this.curveDetail);
            }
        }
    }

    public void breakShape() {
    }

    public final void endShape() {
        this.endShape(1);
    }

    public abstract void endShape(int var1);

    public void point(float x, float y) {
        this.beginShape(16);
        this.vertex(x, y);
        this.endShape();
    }

    public void point(float x, float y, float z) {
        this.beginShape(16);
        this.vertex(x, y, z);
        this.endShape();
    }

    public void line(float x1, float y1, float x2, float y2) {
        this.beginShape(32);
        this.vertex(x1, y1);
        this.vertex(x2, y2);
        this.endShape();
    }

    public void line(float x1, float y1, float z1, float x2, float y2, float z2) {
        this.beginShape(32);
        this.vertex(x1, y1, z1);
        this.vertex(x2, y2, z2);
        this.endShape();
    }

    public void triangle(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.beginShape(64);
        this.vertex(x1, y1);
        this.vertex(x2, y2);
        this.vertex(x3, y3);
        this.endShape();
    }

    public void quad(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        this.beginShape(128);
        this.vertex(x1, y1);
        this.vertex(x2, y2);
        this.vertex(x3, y3);
        this.vertex(x4, y4);
        this.endShape();
    }

    public void rectMode(int mode) {
        this.rectMode = mode;
    }

    public void rect(float x1, float y1, float x2, float y2) {
        float temp;
        switch (this.rectMode) {
            case 1: {
                break;
            }
            case 0: {
                x2 += x1;
                y2 += y1;
                break;
            }
            case 2: {
                float hradius = x2;
                float vradius = y2;
                x2 = x1 + hradius;
                y2 = y1 + vradius;
                x1 -= hradius;
                y1 -= vradius;
                break;
            }
            case 3: {
                float hradius = x2 / 2.0f;
                float vradius = y2 / 2.0f;
                x2 = x1 + hradius;
                y2 = y1 + vradius;
                x1 -= hradius;
                y1 -= vradius;
            }
        }
        if (x1 > x2) {
            temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if (y1 > y2) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        this.rectImpl(x1, y1, x2, y2);
    }

    protected void rectImpl(float x1, float y1, float x2, float y2) {
        this.quad(x1, y1, x2, y1, x2, y2, x1, y2);
    }

    public void ellipseMode(int mode) {
        this.ellipseMode = mode;
    }

    public void ellipse(float a, float b, float c, float d) {
        float x = a;
        float y = b;
        float w = c;
        float h = d;
        if (this.ellipseMode == 1) {
            w = c - a;
            h = d - b;
        } else if (this.ellipseMode == 2) {
            x = a - c;
            y = b - d;
            w = c * 2.0f;
            h = d * 2.0f;
        } else if (this.ellipseMode == 3) {
            x = a - c / 2.0f;
            y = b - d / 2.0f;
        }
        if (w < 0.0f) {
            x += w;
            w = -w;
        }
        if (h < 0.0f) {
            y += h;
            h = -h;
        }
        this.ellipseImpl(x, y, w, h);
    }

    protected void ellipseImpl(float x1, float y1, float w, float h) {
        int i;
        float hradius = w / 2.0f;
        float vradius = h / 2.0f;
        float centerX = x1 + hradius;
        float centerY = y1 + vradius;
        int accuracy = (int)(4.0 + Math.sqrt(hradius + vradius) * 3.0);
        float inc = 720.0f / (float)accuracy;
        float val = 0.0f;
        if (this.fill) {
            boolean savedStroke = this.stroke;
            this.stroke = false;
            this.beginShape(66);
            this.normal(0.0f, 0.0f, 1.0f);
            this.vertex(centerX, centerY);
            i = 0;
            while (i < accuracy) {
                this.vertex(centerX + cosLUT[(int)val] * hradius, centerY + sinLUT[(int)val] * vradius);
                val += inc;
                ++i;
            }
            this.vertex(centerX + cosLUT[0] * hradius, centerY + sinLUT[0] * vradius);
            this.endShape();
            this.stroke = savedStroke;
        }
        if (this.stroke) {
            boolean savedFill = this.fill;
            this.fill = false;
            val = 0.0f;
            this.beginShape();
            i = 0;
            while (i < accuracy) {
                this.vertex(centerX + cosLUT[(int)val] * hradius, centerY + sinLUT[(int)val] * vradius);
                val += inc;
                ++i;
            }
            this.endShape(2);
            this.fill = savedFill;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void arc(float a, float b, float c, float d, float start, float stop) {
        x = a;
        y = b;
        w = c;
        h = d;
        if (this.ellipseMode == 1) {
            w = c - a;
            h = d - b;
        } else if (this.ellipseMode == 2) {
            x = a - c;
            y = b - d;
            w = c * 2.0f;
            h = d * 2.0f;
        } else if (this.ellipseMode == 3) {
            x = a - c / 2.0f;
            y = b - d / 2.0f;
        }
        if (!Float.isInfinite(start) && !Float.isInfinite(stop)) ** GOTO lbl21
        return;
lbl-1000:
        // 1 sources

        {
            stop += 6.2831855f;
lbl21:
            // 2 sources

            ** while (stop < start)
        }
lbl22:
        // 1 sources

        this.arcImpl(x, y, w, h, start, stop);
    }

    protected void arcImpl(float x1, float y1, float w, float h, float start, float stop) {
        int ii;
        int i;
        int increment;
        int stopLUT;
        int startLUT;
        float hr = w / 2.0f;
        float vr = h / 2.0f;
        float centerX = x1 + hr;
        float centerY = y1 + vr;
        if (this.fill) {
            boolean savedStroke = this.stroke;
            this.stroke = false;
            startLUT = (int)(0.5f + start / ((float)Math.PI * 2) * 720.0f);
            stopLUT = (int)(0.5f + stop / ((float)Math.PI * 2) * 720.0f);
            this.beginShape(66);
            this.vertex(centerX, centerY);
            increment = 1;
            i = startLUT;
            while (i < stopLUT) {
                ii = i % 720;
                this.vertex(centerX + cosLUT[ii] * hr, centerY + sinLUT[ii] * vr);
                i += increment;
            }
            this.vertex(centerX + cosLUT[stopLUT % 720] * hr, centerY + sinLUT[stopLUT % 720] * vr);
            this.endShape();
            this.stroke = savedStroke;
        }
        if (this.stroke) {
            boolean savedFill = this.fill;
            this.fill = false;
            startLUT = (int)(0.5f + start / ((float)Math.PI * 2) * 720.0f);
            stopLUT = (int)(0.5f + stop / ((float)Math.PI * 2) * 720.0f);
            this.beginShape();
            increment = 1;
            i = startLUT;
            while (i < stopLUT) {
                ii = i % 720;
                this.vertex(centerX + cosLUT[ii] * hr, centerY + sinLUT[ii] * vr);
                i += increment;
            }
            this.vertex(centerX + cosLUT[stopLUT % 720] * hr, centerY + sinLUT[stopLUT % 720] * vr);
            this.endShape();
            this.fill = savedFill;
        }
    }

    public void box(float size) {
        this.depthError("box");
    }

    public void box(float w, float h, float d) {
        this.depthError("box");
    }

    public void sphereDetail(int res) {
        this.depthError("sphereDetail");
    }

    public void sphere(float r) {
        this.depthError("sphere");
    }

    public float bezierPoint(float a, float b, float c, float d, float t) {
        float t1 = 1.0f - t;
        return a * t1 * t1 * t1 + 3.0f * b * t * t1 * t1 + 3.0f * c * t * t * t1 + d * t * t * t;
    }

    public float bezierTangent(float a, float b, float c, float d, float t) {
        float t1 = 1.0f - t;
        return a * 3.0f * t * t + b * 3.0f * t * (2.0f - 3.0f * t) + c * 3.0f * (3.0f * t * t - 4.0f * t + 1.0f) + d * -3.0f * t1 * t1;
    }

    protected void bezierInit() {
        this.bezierDetail(this.bezierDetail);
    }

    public void bezierDetail(int detail) {
        if (this.bezierForwardMatrix == null) {
            this.bezierForwardMatrix = new float[4][4];
            this.bezierDrawMatrix = new float[4][4];
        }
        this.bezierDetail = detail;
        this.bezierInited = true;
        this.setup_spline_forward(detail, this.bezierForwardMatrix);
        this.mult_spline_matrix(this.bezierForwardMatrix, this.bezier_basis, this.bezierDrawMatrix, 4);
    }

    public void bezier(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        this.beginShape();
        this.vertex(x1, y1);
        this.bezierVertex(x2, y2, x3, y3, x4, y4);
        this.endShape();
    }

    public void bezier(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        this.beginShape();
        this.vertex(x1, y1, z1);
        this.bezierVertex(x2, y2, z2, x3, y3, z3, x4, y4, z4);
        this.endShape();
    }

    public float curvePoint(float a, float b, float c, float d, float t) {
        if (!this.curve_inited) {
            this.curve_init();
        }
        float tt = t * t;
        float ttt = t * tt;
        float[][] m = this.curve_basis;
        return a * (ttt * m[0][0] + tt * m[1][0] + t * m[2][0] + m[3][0]) + b * (ttt * m[0][1] + tt * m[1][1] + t * m[2][1] + m[3][1]) + c * (ttt * m[0][2] + tt * m[1][2] + t * m[2][2] + m[3][2]) + d * (ttt * m[0][3] + tt * m[1][3] + t * m[2][3] + m[3][3]);
    }

    public float curveTangent(float a, float b, float c, float d, float t) {
        System.err.println("curveTangent not yet implemented");
        return 0.0f;
    }

    public void curveDetail(int detail) {
        this.curve_mode(detail, this.curveTightness);
    }

    public void curveTightness(float tightness) {
        this.curve_mode(this.curveDetail, tightness);
    }

    protected void curve_init() {
        this.curve_mode(this.curveDetail, this.curveTightness);
    }

    protected void curve_mode(int segments, float s) {
        this.curveDetail = segments;
        if (this.curve_basis == null) {
            this.curve_basis = new float[4][4];
            this.curve_forward = new float[4][4];
            this.curve_draw = new float[4][4];
            this.curve_inited = true;
        }
        float[][] c = this.curve_basis;
        c[0][0] = s - 1.0f;
        c[0][1] = s + 3.0f;
        c[0][2] = -3.0f - s;
        c[0][3] = 1.0f - s;
        c[1][0] = 2.0f * (1.0f - s);
        c[1][1] = -5.0f - s;
        c[1][2] = 2.0f * (s + 2.0f);
        c[1][3] = s - 1.0f;
        c[2][0] = s - 1.0f;
        c[2][1] = 0.0f;
        c[2][2] = 1.0f - s;
        c[2][3] = 0.0f;
        c[3][0] = 0.0f;
        c[3][1] = 2.0f;
        c[3][2] = 0.0f;
        c[3][3] = 0.0f;
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                float[] fArray = c[i];
                int n = j++;
                fArray[n] = fArray[n] / 2.0f;
            }
            ++i;
        }
        this.setup_spline_forward(segments, this.curve_forward);
        if (this.bezierBasisInverse == null) {
            this.bezierBasisInverse = new PMatrix(this.bezierBasis).invert();
        }
        this.curveToBezierMatrix = new PMatrix(c[0][0], c[0][1], c[0][2], c[0][3], c[1][0], c[1][1], c[1][2], c[1][3], c[2][0], c[2][1], c[2][2], c[2][3], c[3][0], c[3][1], c[3][2], c[3][3]);
        this.curveToBezierMatrix.preApply(this.bezierBasisInverse);
        this.mult_spline_matrix(this.curve_forward, this.curve_basis, this.curve_draw, 4);
    }

    public void curve(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        this.beginShape();
        this.curveVertex(x1, y1);
        this.curveVertex(x2, y2);
        this.curveVertex(x3, y3);
        this.curveVertex(x4, y4);
        this.endShape();
    }

    public void curve(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        this.beginShape();
        this.curveVertex(x1, y1, z1);
        this.curveVertex(x2, y2, z2);
        this.curveVertex(x3, y3, z3);
        this.curveVertex(x4, y4, z4);
        this.endShape();
    }

    protected void setup_spline_forward(int segments, float[][] fwd) {
        float f = 1.0f / (float)segments;
        float ff = f * f;
        float fff = ff * f;
        fwd[0][0] = 0.0f;
        fwd[0][1] = 0.0f;
        fwd[0][2] = 0.0f;
        fwd[0][3] = 1.0f;
        fwd[1][0] = fff;
        fwd[1][1] = ff;
        fwd[1][2] = f;
        fwd[1][3] = 0.0f;
        fwd[2][0] = 6.0f * fff;
        fwd[2][1] = 2.0f * ff;
        fwd[2][2] = 0.0f;
        fwd[2][3] = 0.0f;
        fwd[3][0] = 6.0f * fff;
        fwd[3][1] = 0.0f;
        fwd[3][2] = 0.0f;
        fwd[3][3] = 0.0f;
    }

    protected void mult_spline_matrix(float[][] m, float[][] g, float[][] mg, int dimensions) {
        int j;
        int i = 0;
        while (i < 4) {
            j = 0;
            while (j < dimensions) {
                mg[i][j] = 0.0f;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 4) {
            j = 0;
            while (j < dimensions) {
                int k = 0;
                while (k < 4) {
                    mg[i][j] = mg[i][j] + m[i][k] * g[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    protected void splineSegment(int offset, int start, float[][] m, int dimensions, int segments) {
        float x1 = this.splineVertices[offset + 0][9];
        float x2 = this.splineVertices[offset + 1][9];
        float x3 = this.splineVertices[offset + 2][9];
        float x4 = this.splineVertices[offset + 3][9];
        float x0 = this.splineVertices[start][9];
        float y1 = this.splineVertices[offset + 0][10];
        float y2 = this.splineVertices[offset + 1][10];
        float y3 = this.splineVertices[offset + 2][10];
        float y4 = this.splineVertices[offset + 3][10];
        float y0 = this.splineVertices[start][10];
        float xplot1 = m[1][0] * x1 + m[1][1] * x2 + m[1][2] * x3 + m[1][3] * x4;
        float xplot2 = m[2][0] * x1 + m[2][1] * x2 + m[2][2] * x3 + m[2][3] * x4;
        float xplot3 = m[3][0] * x1 + m[3][1] * x2 + m[3][2] * x3 + m[3][3] * x4;
        float yplot1 = m[1][0] * y1 + m[1][1] * y2 + m[1][2] * y3 + m[1][3] * y4;
        float yplot2 = m[2][0] * y1 + m[2][1] * y2 + m[2][2] * y3 + m[2][3] * y4;
        float yplot3 = m[3][0] * y1 + m[3][1] * y2 + m[3][2] * y3 + m[3][3] * y4;
        int cvertexSaved = this.splineVertexCount;
        if (dimensions == 3) {
            float z1 = this.splineVertices[offset + 0][11];
            float z2 = this.splineVertices[offset + 1][11];
            float z3 = this.splineVertices[offset + 2][11];
            float z4 = this.splineVertices[offset + 3][11];
            float z0 = this.splineVertices[start][11];
            float zplot1 = m[1][0] * z1 + m[1][1] * z2 + m[1][2] * z3 + m[1][3] * z4;
            float zplot2 = m[2][0] * z1 + m[2][1] * z2 + m[2][2] * z3 + m[2][3] * z4;
            float zplot3 = m[3][0] * z1 + m[3][1] * z2 + m[3][2] * z3 + m[3][3] * z4;
            this.vertex(x0, y0, z0);
            int j = 0;
            while (j < segments) {
                x0 += xplot1;
                xplot1 += xplot2;
                xplot2 += xplot3;
                yplot1 += yplot2;
                yplot2 += yplot3;
                zplot2 += zplot3;
                this.vertex(x0, y0 += yplot1, z0 += (zplot1 += zplot2));
                ++j;
            }
        } else {
            this.vertex(x0, y0);
            int j = 0;
            while (j < segments) {
                xplot1 += xplot2;
                xplot2 += xplot3;
                yplot2 += yplot3;
                this.vertex(x0 += xplot1, y0 += (yplot1 += yplot2));
                ++j;
            }
        }
        this.splineVertexCount = cvertexSaved;
    }

    public void image(PImage image, float x, float y) {
        this.imageImpl(image, x, y, x + (float)image.width, y + (float)image.height, 0, 0, image.width, image.height);
    }

    public void image(PImage image, float x, float y, float c, float d) {
        this.image(image, x, y, c, d, 0, 0, image.width, image.height);
    }

    public void image(PImage image, float a, float b, float c, float d, int u1, int v1, int u2, int v2) {
        if (this.imageMode == 0) {
            if (c < 0.0f) {
                a += c;
                c = -c;
            }
            if (d < 0.0f) {
                b += d;
                d = -d;
            }
            this.imageImpl(image, a, b, a + c, b + d, u1, v1, u2, v2);
        } else if (this.imageMode == 1) {
            float temp;
            if (c < a) {
                temp = a;
                a = c;
                c = temp;
            }
            if (d < b) {
                temp = b;
                b = d;
                d = temp;
            }
            this.imageImpl(image, a, b, c, d, u1, v1, u2, v2);
        }
    }

    protected void imageImpl(PImage image, float x1, float y1, float x2, float y2, int u1, int v1, int u2, int v2) {
        boolean savedStroke = this.stroke;
        boolean savedFill = this.fill;
        int savedTextureMode = this.textureMode;
        this.stroke = false;
        this.fill = true;
        this.textureMode = 2;
        float savedFillR = this.fillR;
        float savedFillG = this.fillG;
        float savedFillB = this.fillB;
        float savedFillA = this.fillA;
        if (this.tint) {
            this.fillR = this.tintR;
            this.fillG = this.tintG;
            this.fillB = this.tintB;
            this.fillA = this.tintA;
        } else {
            this.fillR = 1.0f;
            this.fillG = 1.0f;
            this.fillB = 1.0f;
            this.fillA = 1.0f;
        }
        this.beginShape(128);
        this.texture(image);
        this.vertex(x1, y1, u1, v1);
        this.vertex(x1, y2, u1, v2);
        this.vertex(x2, y2, u2, v2);
        this.vertex(x2, y1, u2, v1);
        this.endShape();
        this.stroke = savedStroke;
        this.fill = savedFill;
        this.textureMode = savedTextureMode;
        this.fillR = savedFillR;
        this.fillG = savedFillG;
        this.fillB = savedFillB;
        this.fillA = savedFillA;
    }

    public void textAlign(int align) {
        this.textAlign(align, 0);
    }

    public void textAlign(int alignX, int alignY) {
        this.textAlign = alignX;
        this.textAlignY = alignY;
    }

    public float textAscent() {
        if (this.textFont == null) {
            throw new RuntimeException("use textFont() before textAscent()");
        }
        return this.textFont.ascent() * (this.textMode == 256 ? (float)this.textFont.size : this.textSize);
    }

    public float textDescent() {
        if (this.textFont != null) {
            return this.textFont.descent() * (this.textMode == 256 ? (float)this.textFont.size : this.textSize);
        }
        throw new RuntimeException("use textFont() before textDescent()");
    }

    public void textFont(PFont which) {
        if (which != null) {
            this.textFont = which;
            if (this.hints[2] && which.font == null) {
                which.findFont();
            }
            this.textFontNative = which.font;
            if (this.textFontNative != null) {
                this.textFontNativeMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.textFontNative);
            }
        } else {
            throw new RuntimeException("a null PFont was passed to textFont()");
        }
        this.textSize(which.size);
    }

    public void textFont(PFont which, float size) {
        this.textFont(which);
        this.textSize(size);
    }

    public void textLeading(float leading) {
        this.textLeading = leading;
    }

    public void textMode(int mode) {
        if (mode == 37 || mode == 39) {
            throw new RuntimeException("textMode() is now textAlign() in Processing beta");
        }
        if (mode != 256 && mode != 4) {
            throw new RuntimeException("Only textMode(SCREEN) and textMode(MODEL) are available with this renderer.");
        }
        this.textMode = mode;
    }

    public void textSize(float size) {
        if (this.textFont != null) {
            if (this.textMode == 256 && size != (float)this.textFont.size) {
                throw new RuntimeException("textSize() cannot be used with textMode(SCREEN)");
            }
        } else {
            throw new RuntimeException("Use textFont() before textSize()");
        }
        this.textSize = size;
        this.textLeading = (this.textAscent() + this.textDescent()) * 1.275f;
    }

    public float textWidth(char c) {
        this.textBuffer[0] = c;
        return this.textWidthImpl(this.textBuffer, 0, 1);
    }

    public float textWidth(String str) {
        if (this.textFont == null) {
            throw new RuntimeException("use textFont() before textWidth()");
        }
        int length = str.length();
        if (length > this.textWidthBuffer.length) {
            this.textWidthBuffer = new char[length + 10];
        }
        str.getChars(0, length, this.textWidthBuffer, 0);
        float wide = 0.0f;
        int index = 0;
        int start = 0;
        while (index < length) {
            if (this.textWidthBuffer[index] == '\n') {
                wide = Math.max(wide, this.textWidthImpl(this.textWidthBuffer, start, index));
                start = index + 1;
            }
            ++index;
        }
        if (start < length) {
            wide = Math.max(wide, this.textWidthImpl(this.textWidthBuffer, start, index));
        }
        return wide;
    }

    protected float textWidthImpl(char[] buffer, int start, int stop) {
        float wide = 0.0f;
        int i = start;
        while (i < stop) {
            wide += this.textFont.width(buffer[i]) * this.textSize;
            ++i;
        }
        return wide;
    }

    public void text(char c) {
        this.text(c, this.textX, this.textY, this.textZ);
    }

    public void text(char c, float x, float y) {
        if (this.textFont == null) {
            throw new RuntimeException("use textFont() before text()");
        }
        if (this.textMode == 256) {
            this.loadPixels();
        }
        this.textBuffer[0] = c;
        this.textLineImpl(this.textBuffer, 0, 1, x, y);
        if (this.textMode == 256) {
            this.updatePixels();
        }
    }

    public void text(char c, float x, float y, float z) {
        if (z != 0.0f && this.textMode == 256) {
            String msg = "textMode(SCREEN) cannot have a z coordinate";
            throw new RuntimeException(msg);
        }
        if (z != 0.0f) {
            this.translate(0.0f, 0.0f, z);
        }
        this.text(c, x, y);
        this.textZ = z;
        if (z != 0.0f) {
            this.translate(0.0f, 0.0f, -z);
        }
    }

    public void text(String str) {
        this.text(str, this.textX, this.textY, this.textZ);
    }

    public void text(String str, float x, float y) {
        int length;
        if (this.textFont == null) {
            throw new RuntimeException("use textFont() before text()");
        }
        if (this.textMode == 256) {
            this.loadPixels();
        }
        if ((length = str.length()) > this.textBuffer.length) {
            this.textBuffer = new char[length + 10];
        }
        str.getChars(0, length, this.textBuffer, 0);
        float high = 0.0f;
        int i = 0;
        while (i < length) {
            if (this.textBuffer[i] == '\n') {
                high += this.textLeading;
            }
            ++i;
        }
        if (this.textAlignY == 3) {
            y += (this.textAscent() - high) / 2.0f;
        } else if (this.textAlignY == 101) {
            y += this.textAscent();
        } else if (this.textAlignY == 102) {
            y -= high;
        }
        int start = 0;
        int index = 0;
        while (index < length) {
            if (this.textBuffer[index] == '\n') {
                this.textLineImpl(this.textBuffer, start, index, x, y);
                start = index + 1;
                y += this.textLeading;
            }
            ++index;
        }
        if (start < length) {
            this.textLineImpl(this.textBuffer, start, index, x, y);
        }
        if (this.textMode == 256) {
            this.updatePixels();
        }
    }

    public void text(String str, float x, float y, float z) {
        if (z != 0.0f && this.textMode == 256) {
            String msg = "textMode(SCREEN) cannot have a z coordinate";
            throw new RuntimeException(msg);
        }
        if (z != 0.0f) {
            this.translate(0.0f, 0.0f, z);
        }
        this.text(str, x, y);
        this.textZ = z;
        if (z != 0.0f) {
            this.translate(0.0f, 0.0f, -z);
        }
    }

    protected void textLineImpl(char[] buffer, int start, int stop, float x, float y) {
        if (this.textAlign == 3) {
            x -= this.textWidthImpl(buffer, start, stop) / 2.0f;
        } else if (this.textAlign == 39) {
            x -= this.textWidthImpl(buffer, start, stop);
        }
        this.textLinePlacedImpl(buffer, start, stop, x, y);
    }

    protected void textLinePlacedImpl(char[] buffer, int start, int stop, float x, float y) {
        int index = start;
        while (index < stop) {
            this.textCharImpl(buffer[index], x, y);
            x += this.textWidth(buffer[index]);
            ++index;
        }
        this.textX = x;
        this.textY = y;
        this.textZ = 0.0f;
    }

    public void text(String str, float x1, float y1, float x2, float y2) {
        float temp;
        if (this.textFont == null) {
            throw new RuntimeException("use textFont() before text()");
        }
        if (this.textMode == 256) {
            this.loadPixels();
        }
        switch (this.rectMode) {
            case 0: {
                x2 += x1;
                y2 += y1;
                break;
            }
            case 2: {
                float hradius = x2;
                float vradius = y2;
                x2 = x1 + hradius;
                y2 = y1 + vradius;
                x1 -= hradius;
                y1 -= vradius;
                break;
            }
            case 3: {
                float hradius = x2 / 2.0f;
                float vradius = y2 / 2.0f;
                x2 = x1 + hradius;
                y2 = y1 + vradius;
                x1 -= hradius;
                y1 -= vradius;
            }
        }
        if (x2 < x1) {
            temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if (y2 < y1) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        float spaceWidth = this.textWidth(' ');
        float runningX = x1;
        float currentY = y1;
        float boxWidth = x2 - x1;
        float lineX = x1;
        if (this.textAlign == 3) {
            lineX += boxWidth / 2.0f;
        } else if (this.textAlign == 39) {
            lineX = x2;
        }
        currentY += this.textAscent();
        if (currentY > y2) {
            return;
        }
        int length = str.length();
        if (length > this.textBuffer.length) {
            this.textBuffer = new char[length + 10];
        }
        str.getChars(0, length, this.textBuffer, 0);
        int wordStart = 0;
        int wordStop = 0;
        int lineStart = 0;
        int index = 0;
        while (index < length) {
            if (this.textBuffer[index] == ' ' || index == length - 1) {
                float wordWidth = this.textWidthImpl(this.textBuffer, wordStart, index);
                if (runningX + wordWidth > x2) {
                    if (runningX == x1) {
                        do {
                            if (--index != wordStart) continue;
                            return;
                        } while ((wordWidth = this.textWidthImpl(this.textBuffer, wordStart, index)) > boxWidth);
                        this.textLineImpl(this.textBuffer, lineStart, index, lineX, currentY);
                    } else {
                        this.textLineImpl(this.textBuffer, lineStart, wordStop, lineX, currentY);
                        index = wordStop;
                        while (index < length && this.textBuffer[index] == ' ') {
                            ++index;
                        }
                    }
                    lineStart = index;
                    wordStart = index;
                    wordStop = index;
                    runningX = x1;
                    currentY += this.textLeading;
                    if (currentY > y2) {
                        return;
                    }
                } else {
                    runningX += wordWidth + spaceWidth;
                    wordStop = index;
                    wordStart = index + 1;
                }
            } else if (this.textBuffer[index] == '\n') {
                if (lineStart != index) {
                    this.textLineImpl(this.textBuffer, lineStart, index, lineX, currentY);
                }
                wordStart = lineStart = index + 1;
                runningX = x1;
                if ((currentY += this.textLeading) > y2) {
                    return;
                }
            }
            ++index;
        }
        if (lineStart < length && lineStart != index) {
            this.textLineImpl(this.textBuffer, lineStart, index, lineX, currentY);
        }
        if (this.textMode == 256) {
            this.updatePixels();
        }
    }

    public void text(String s, float x1, float y1, float x2, float y2, float z) {
        if (z != 0.0f && this.textMode == 256) {
            String msg = "textMode(SCREEN) cannot have a z coordinate";
            throw new RuntimeException(msg);
        }
        if (z != 0.0f) {
            this.translate(0.0f, 0.0f, z);
        }
        this.text(s, x1, y1, x2, y2);
        this.textZ = z;
        if (z != 0.0f) {
            this.translate(0.0f, 0.0f, -z);
        }
    }

    public void text(int num, float x, float y) {
        this.text(String.valueOf(num), x, y);
    }

    public void text(int num, float x, float y, float z) {
        this.text(String.valueOf(num), x, y, z);
    }

    public void text(float num, float x, float y) {
        this.text(PApplet.nfs(num, 0, 3), x, y);
    }

    public void text(float num, float x, float y, float z) {
        this.text(PApplet.nfs(num, 0, 3), x, y, z);
    }

    protected void textCharImpl(char ch, float x, float y) {
        int index = this.textFont.index(ch);
        if (index == -1) {
            return;
        }
        PImage glyph = this.textFont.images[index];
        if (this.textMode == 4) {
            float high = (float)this.textFont.height[index] / this.textFont.fheight;
            float bwidth = (float)this.textFont.width[index] / this.textFont.fwidth;
            float lextent = (float)this.textFont.leftExtent[index] / this.textFont.fwidth;
            float textent = (float)this.textFont.topExtent[index] / this.textFont.fheight;
            float x1 = x + lextent * this.textSize;
            float y1 = y - textent * this.textSize;
            float x2 = x1 + bwidth * this.textSize;
            float y2 = y1 + high * this.textSize;
            this.textCharModelImpl(glyph, x1, y1, x2, y2, this.textFont.width[index], this.textFont.height[index]);
        } else if (this.textMode == 256) {
            int xx = (int)x + this.textFont.leftExtent[index];
            int yy = (int)y - this.textFont.topExtent[index];
            int w0 = this.textFont.width[index];
            int h0 = this.textFont.height[index];
            this.textCharScreenImpl(glyph, xx, yy, w0, h0);
        }
    }

    protected void textCharModelImpl(PImage glyph, float x1, float y1, float x2, float y2, int u2, int v2) {
        boolean savedTint = this.tint;
        int savedTintColor = this.tintColor;
        float savedTintR = this.tintR;
        float savedTintG = this.tintG;
        float savedTintB = this.tintB;
        float savedTintA = this.tintA;
        boolean savedTintAlpha = this.tintAlpha;
        this.tint = true;
        this.tintColor = this.fillColor;
        this.tintR = this.fillR;
        this.tintG = this.fillG;
        this.tintB = this.fillB;
        this.tintA = this.fillA;
        this.tintAlpha = this.fillAlpha;
        this.imageImpl(glyph, x1, y1, x2, y2, 0, 0, u2, v2);
        this.tint = savedTint;
        this.tintColor = savedTintColor;
        this.tintR = savedTintR;
        this.tintG = savedTintG;
        this.tintB = savedTintB;
        this.tintA = savedTintA;
        this.tintAlpha = savedTintAlpha;
    }

    protected void textCharScreenImpl(PImage glyph, int xx, int yy, int w0, int h0) {
        int x0 = 0;
        int y0 = 0;
        if (xx >= this.width || yy >= this.height || xx + w0 < 0 || yy + h0 < 0) {
            return;
        }
        if (xx < 0) {
            x0 -= xx;
            w0 += xx;
            xx = 0;
        }
        if (yy < 0) {
            y0 -= yy;
            h0 += yy;
            yy = 0;
        }
        if (xx + w0 > this.width) {
            w0 -= xx + w0 - this.width;
        }
        if (yy + h0 > this.height) {
            h0 -= yy + h0 - this.height;
        }
        int fr = this.fillRi;
        int fg = this.fillGi;
        int fb = this.fillBi;
        int fa = this.fillAi;
        int[] pixels1 = glyph.pixels;
        int row = y0;
        while (row < y0 + h0) {
            int col = x0;
            while (col < x0 + w0) {
                int a1 = fa * pixels1[row * this.textFont.twidth + col] >> 8;
                int a2 = a1 ^ 0xFF;
                int p2 = this.pixels[(yy + row - y0) * this.width + (xx + col - x0)];
                this.pixels[(yy + row - y0) * this.width + xx + col - x0] = 0xFF000000 | (a1 * fr + a2 * (p2 >> 16 & 0xFF) & 0xFF00) << 8 | a1 * fg + a2 * (p2 >> 8 & 0xFF) & 0xFF00 | a1 * fb + a2 * (p2 & 0xFF) >> 8;
                ++col;
            }
            ++row;
        }
    }

    public void translate(float tx, float ty) {
        this.m02 += tx * this.m00 + ty * this.m01 + this.m02;
        this.m12 += tx * this.m10 + ty * this.m11 + this.m12;
    }

    public void translate(float tx, float ty, float tz) {
        this.depthErrorXYZ("translate");
    }

    public void rotate(float angle) {
        float c = (float)Math.cos(angle);
        float s = (float)Math.sin(angle);
        this.applyMatrix(c, -s, 0.0f, s, c, 0.0f);
    }

    public void rotateX(float angle) {
        this.depthError("rotateX");
    }

    public void rotateY(float angle) {
        this.depthError("rotateY");
    }

    public void rotateZ(float angle) {
        this.depthError("rotateZ");
    }

    public void rotate(float angle, float vx, float vy, float vz) {
        throw new RuntimeException("rotate(angle, x, y, z) can only be used with P3D or OPENGL");
    }

    public void scale(float s) {
        this.applyMatrix(s, 0.0f, 0.0f, 0.0f, s, 0.0f);
    }

    public void scale(float sx, float sy) {
        this.applyMatrix(sx, 0.0f, 0.0f, 0.0f, sy, 0.0f);
    }

    public void scale(float x, float y, float z) {
        this.depthErrorXYZ("scale");
    }

    public void pushMatrix() {
        if (this.matrixStackDepth + 1 == 32) {
            throw new RuntimeException("too many calls to pushMatrix()");
        }
        float[] mat = this.matrixStack[this.matrixStackDepth];
        mat[0] = this.m00;
        mat[1] = this.m01;
        mat[2] = this.m02;
        mat[3] = this.m10;
        mat[4] = this.m11;
        mat[5] = this.m12;
        ++this.matrixStackDepth;
    }

    public void popMatrix() {
        if (this.matrixStackDepth == 0) {
            throw new RuntimeException("too many calls to popMatrix() (and not enough to pushMatrix)");
        }
        --this.matrixStackDepth;
        float[] mat = this.matrixStack[this.matrixStackDepth];
        this.m00 = mat[0];
        this.m01 = mat[1];
        this.m02 = mat[2];
        this.m10 = mat[3];
        this.m11 = mat[4];
        this.m12 = mat[5];
    }

    public void resetMatrix() {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
    }

    public void applyMatrix(float n00, float n01, float n02, float n10, float n11, float n12) {
        float r00 = this.m00 * n00 + this.m01 * n10;
        float r01 = this.m00 * n01 + this.m01 * n11;
        float r02 = this.m00 * n02 + this.m01 * n12 + this.m02;
        float r10 = this.m10 * n00 + this.m11 * n10;
        float r11 = this.m10 * n01 + this.m11 * n11;
        float r12 = this.m10 * n02 + this.m11 * n12 + this.m12;
        this.m00 = r00;
        this.m01 = r01;
        this.m02 = r02;
        this.m10 = r10;
        this.m11 = r11;
        this.m12 = r12;
    }

    public void applyMatrix(float n00, float n01, float n02, float n03, float n10, float n11, float n12, float n13, float n20, float n21, float n22, float n23, float n30, float n31, float n32, float n33) {
        throw new RuntimeException("applyMatrix() with a 4x4 matrix can only be used with OPENGL or P3D");
    }

    public void loadMatrix() {
    }

    public void printMatrix() {
        this.loadMatrix();
        float big = Math.abs(this.m00);
        if (Math.abs(this.m01) > big) {
            big = Math.abs(this.m01);
        }
        if (Math.abs(this.m02) > big) {
            big = Math.abs(this.m02);
        }
        if (Math.abs(this.m10) > big) {
            big = Math.abs(this.m10);
        }
        if (Math.abs(this.m11) > big) {
            big = Math.abs(this.m11);
        }
        if (Math.abs(this.m12) > big) {
            big = Math.abs(this.m12);
        }
        if (Float.isNaN(big) || Float.isInfinite(big)) {
            big = 1000000.0f;
        }
        int d = 1;
        int bigi = (int)big;
        while ((bigi /= 10) != 0) {
            ++d;
        }
        System.out.println(String.valueOf(PApplet.nfs(this.m00, d, 4)) + " " + PApplet.nfs(this.m01, d, 4) + " " + PApplet.nfs(this.m02, d, 4));
        System.out.println(String.valueOf(PApplet.nfs(this.m10, d, 4)) + " " + PApplet.nfs(this.m11, d, 4) + " " + PApplet.nfs(this.m12, d, 4));
        System.out.println();
    }

    public void beginCamera() {
        this.depthError("beginCamera");
    }

    public void endCamera() {
        this.depthError("endCamera");
    }

    public void camera() {
        this.depthError("camera");
    }

    public void camera(float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ) {
        this.depthError("camera");
    }

    public void printCamera() {
        this.depthError("printCamera");
    }

    public void ortho() {
        this.depthError("ortho");
    }

    public void ortho(float left, float right, float bottom, float top, float near, float far) {
        this.depthError("ortho");
    }

    public void perspective() {
        this.depthError("perspective");
    }

    public void perspective(float fovy, float aspect, float zNear, float zFar) {
        this.depthError("perspective");
    }

    public void frustum(float left, float right, float bottom, float top, float znear, float zfar) {
        this.depthError("frustum");
    }

    public void printProjection() {
        this.depthError("printCamera");
    }

    public float screenX(float x, float y) {
        return this.m00 * x + this.m01 * y + this.m02;
    }

    public float screenY(float x, float y) {
        return this.m10 * x + this.m11 * y + this.m12;
    }

    public float screenX(float x, float y, float z) {
        this.depthErrorXYZ("screenX");
        return 0.0f;
    }

    public float screenY(float x, float y, float z) {
        this.depthErrorXYZ("screenY");
        return 0.0f;
    }

    public float screenZ(float x, float y, float z) {
        this.depthErrorXYZ("screenZ");
        return 0.0f;
    }

    public float modelX(float x, float y, float z) {
        this.depthError("modelX");
        return 0.0f;
    }

    public float modelY(float x, float y, float z) {
        this.depthError("modelY");
        return 0.0f;
    }

    public float modelZ(float x, float y, float z) {
        this.depthError("modelZ");
        return 0.0f;
    }

    public void colorMode(int mode) {
        this.colorMode(mode, this.colorModeX, this.colorModeY, this.colorModeZ, this.colorModeA);
    }

    public void colorMode(int mode, float max) {
        this.colorMode(mode, max, max, max, max);
    }

    public void colorMode(int mode, float maxX, float maxY, float maxZ) {
        this.colorMode(mode, maxX, maxY, maxZ, this.colorModeA);
    }

    public void colorMode(int mode, float maxX, float maxY, float maxZ, float maxA) {
        this.colorMode = mode;
        this.colorModeX = maxX;
        this.colorModeY = maxY;
        this.colorModeZ = maxZ;
        this.colorModeA = maxA;
        this.colorScale = maxA != 1.0f || maxX != maxY || maxY != maxZ || maxZ != maxA;
        this.colorRgb255 = this.colorMode == 1 && this.colorModeA == 255.0f && this.colorModeX == 255.0f && this.colorModeY == 255.0f && this.colorModeZ == 255.0f;
    }

    protected void colorCalc(float gray) {
        this.colorCalc(gray, this.colorModeA);
    }

    protected void colorCalc(float gray, float alpha) {
        if (gray > this.colorModeX) {
            gray = this.colorModeX;
        }
        if (alpha > this.colorModeA) {
            alpha = this.colorModeA;
        }
        if (gray < 0.0f) {
            gray = 0.0f;
        }
        if (alpha < 0.0f) {
            alpha = 0.0f;
        }
        this.calcG = this.calcR = this.colorScale ? gray / this.colorModeX : gray;
        this.calcB = this.calcR;
        this.calcA = this.colorScale ? alpha / this.colorModeA : alpha;
        this.calcRi = (int)(this.calcR * 255.0f);
        this.calcGi = (int)(this.calcG * 255.0f);
        this.calcBi = (int)(this.calcB * 255.0f);
        this.calcAi = (int)(this.calcA * 255.0f);
        this.calcColor = this.calcAi << 24 | this.calcRi << 16 | this.calcGi << 8 | this.calcBi;
        this.calcAlpha = this.calcAi != 255;
    }

    protected void colorCalc(float x, float y, float z) {
        this.colorCalc(x, y, z, this.colorModeA);
    }

    protected void colorCalc(float x, float y, float z, float a) {
        if (x > this.colorModeX) {
            x = this.colorModeX;
        }
        if (y > this.colorModeY) {
            y = this.colorModeY;
        }
        if (z > this.colorModeZ) {
            z = this.colorModeZ;
        }
        if (a > this.colorModeA) {
            a = this.colorModeA;
        }
        if (x < 0.0f) {
            x = 0.0f;
        }
        if (y < 0.0f) {
            y = 0.0f;
        }
        if (z < 0.0f) {
            z = 0.0f;
        }
        if (a < 0.0f) {
            a = 0.0f;
        }
        block0 : switch (this.colorMode) {
            case 1: {
                if (this.colorScale) {
                    this.calcR = x / this.colorModeX;
                    this.calcG = y / this.colorModeY;
                    this.calcB = z / this.colorModeZ;
                    this.calcA = a / this.colorModeA;
                    break;
                }
                this.calcR = x;
                this.calcG = y;
                this.calcB = z;
                this.calcA = a;
                break;
            }
            case 3: {
                x /= this.colorModeX;
                z /= this.colorModeZ;
                float f = this.calcA = this.colorScale ? a / this.colorModeA : a;
                if ((y /= this.colorModeY) == 0.0f) {
                    this.calcG = this.calcB = z;
                    this.calcR = this.calcB;
                    break;
                }
                float which = (x - (float)((int)x)) * 6.0f;
                float f2 = which - (float)((int)which);
                float p = z * (1.0f - y);
                float q = z * (1.0f - y * f2);
                float t = z * (1.0f - y * (1.0f - f2));
                switch ((int)which) {
                    case 0: {
                        this.calcR = z;
                        this.calcG = t;
                        this.calcB = p;
                        break block0;
                    }
                    case 1: {
                        this.calcR = q;
                        this.calcG = z;
                        this.calcB = p;
                        break block0;
                    }
                    case 2: {
                        this.calcR = p;
                        this.calcG = z;
                        this.calcB = t;
                        break block0;
                    }
                    case 3: {
                        this.calcR = p;
                        this.calcG = q;
                        this.calcB = z;
                        break block0;
                    }
                    case 4: {
                        this.calcR = t;
                        this.calcG = p;
                        this.calcB = z;
                        break block0;
                    }
                    case 5: {
                        this.calcR = z;
                        this.calcG = p;
                        this.calcB = q;
                    }
                }
            }
        }
        this.calcRi = (int)(255.0f * this.calcR);
        this.calcGi = (int)(255.0f * this.calcG);
        this.calcBi = (int)(255.0f * this.calcB);
        this.calcAi = (int)(255.0f * this.calcA);
        this.calcColor = this.calcAi << 24 | this.calcRi << 16 | this.calcGi << 8 | this.calcBi;
        this.calcAlpha = this.calcAi != 255;
    }

    protected void colorCalcARGB(int argb, float alpha) {
        if (alpha == this.colorModeA) {
            this.calcAi = argb >> 24 & 0xFF;
            this.calcColor = argb;
        } else {
            this.calcAi = (int)((float)(argb >> 24 & 0xFF) * (alpha / this.colorModeA));
            this.calcColor = this.calcAi << 24 | argb & 0xFFFFFF;
        }
        this.calcRi = argb >> 16 & 0xFF;
        this.calcGi = argb >> 8 & 0xFF;
        this.calcBi = argb & 0xFF;
        this.calcA = (float)this.calcAi / 255.0f;
        this.calcR = (float)this.calcRi / 255.0f;
        this.calcG = (float)this.calcGi / 255.0f;
        this.calcB = (float)this.calcBi / 255.0f;
        this.calcAlpha = this.calcAi != 255;
    }

    public void strokeWeight(float weight) {
        this.strokeWeight = weight;
    }

    public void strokeJoin(int join) {
        this.strokeJoin = join;
    }

    public void strokeCap(int cap) {
        this.strokeCap = cap;
    }

    public void noStroke() {
        this.stroke = false;
    }

    public void stroke(int rgb) {
        if ((rgb & 0xFF000000) == 0 && (float)rgb <= this.colorModeX) {
            this.stroke((float)rgb);
        } else {
            this.colorCalcARGB(rgb, this.colorModeA);
            this.strokeFromCalc();
        }
    }

    public void stroke(int rgb, float alpha) {
        if ((rgb & 0xFF000000) == 0 && (float)rgb <= this.colorModeX) {
            this.stroke((float)rgb, alpha);
        } else {
            this.colorCalcARGB(rgb, alpha);
            this.strokeFromCalc();
        }
    }

    public void stroke(float gray) {
        this.colorCalc(gray);
        this.strokeFromCalc();
    }

    public void stroke(float gray, float alpha) {
        this.colorCalc(gray, alpha);
        this.strokeFromCalc();
    }

    public void stroke(float x, float y, float z) {
        this.colorCalc(x, y, z);
        this.strokeFromCalc();
    }

    public void stroke(float x, float y, float z, float a) {
        this.colorCalc(x, y, z, a);
        this.strokeFromCalc();
    }

    protected void strokeFromCalc() {
        this.stroke = true;
        this.strokeR = this.calcR;
        this.strokeG = this.calcG;
        this.strokeB = this.calcB;
        this.strokeA = this.calcA;
        this.strokeRi = this.calcRi;
        this.strokeGi = this.calcGi;
        this.strokeBi = this.calcBi;
        this.strokeAi = this.calcAi;
        this.strokeColor = this.calcColor;
        this.strokeAlpha = this.calcAlpha;
    }

    public void noTint() {
        this.tint = false;
    }

    public void tint(int rgb) {
        if ((rgb & 0xFF000000) == 0 && (float)rgb <= this.colorModeX) {
            this.tint((float)rgb);
        } else {
            this.colorCalcARGB(rgb, this.colorModeA);
            this.tintFromCalc();
        }
    }

    public void tint(int rgb, float alpha) {
        if ((rgb & 0xFF000000) == 0 && (float)rgb <= this.colorModeX) {
            this.tint((float)rgb, alpha);
        } else {
            this.colorCalcARGB(rgb, alpha);
            this.tintFromCalc();
        }
    }

    public void tint(float gray) {
        this.colorCalc(gray);
        this.tintFromCalc();
    }

    public void tint(float gray, float alpha) {
        this.colorCalc(gray, alpha);
        this.tintFromCalc();
    }

    public void tint(float x, float y, float z) {
        this.colorCalc(x, y, z);
        this.tintFromCalc();
    }

    public void tint(float x, float y, float z, float a) {
        this.colorCalc(x, y, z, a);
        this.tintFromCalc();
    }

    protected void tintFromCalc() {
        this.tint = true;
        this.tintR = this.calcR;
        this.tintG = this.calcG;
        this.tintB = this.calcB;
        this.tintA = this.calcA;
        this.tintRi = this.calcRi;
        this.tintGi = this.calcGi;
        this.tintBi = this.calcBi;
        this.tintAi = this.calcAi;
        this.tintColor = this.calcColor;
        this.tintAlpha = this.calcAlpha;
    }

    public void noFill() {
        this.fill = false;
    }

    public void fill(int rgb) {
        if ((rgb & 0xFF000000) == 0 && (float)rgb <= this.colorModeX) {
            this.fill((float)rgb);
        } else {
            this.colorCalcARGB(rgb, this.colorModeA);
            this.fillFromCalc();
        }
    }

    public void fill(int rgb, float alpha) {
        if ((rgb & 0xFF000000) == 0 && (float)rgb <= this.colorModeX) {
            this.fill((float)rgb, alpha);
        } else {
            this.colorCalcARGB(rgb, alpha);
            this.fillFromCalc();
        }
    }

    public void fill(float gray) {
        this.colorCalc(gray);
        this.fillFromCalc();
    }

    public void fill(float gray, float alpha) {
        this.colorCalc(gray, alpha);
        this.fillFromCalc();
    }

    public void fill(float x, float y, float z) {
        this.colorCalc(x, y, z);
        this.fillFromCalc();
    }

    public void fill(float x, float y, float z, float a) {
        this.colorCalc(x, y, z, a);
        this.fillFromCalc();
    }

    protected void fillFromCalc() {
        this.fill = true;
        this.fillR = this.calcR;
        this.fillG = this.calcG;
        this.fillB = this.calcB;
        this.fillA = this.calcA;
        this.fillRi = this.calcRi;
        this.fillGi = this.calcGi;
        this.fillBi = this.calcBi;
        this.fillAi = this.calcAi;
        this.fillColor = this.calcColor;
        this.fillAlpha = this.calcAlpha;
    }

    public void ambient(int rgb) {
        this.depthError("ambient");
    }

    public void ambient(float gray) {
        this.depthError("ambient");
    }

    public void ambient(float x, float y, float z) {
        this.depthError("ambient");
    }

    public void specular(int rgb) {
        this.depthError("specular");
    }

    public void specular(float gray) {
        this.depthError("specular");
    }

    public void specular(float gray, float alpha) {
        this.depthError("specular");
    }

    public void specular(float x, float y, float z) {
        this.depthError("specular");
    }

    public void specular(float x, float y, float z, float a) {
        this.depthError("specular");
    }

    public void shininess(float shine) {
        this.depthError("shininess");
    }

    public void emissive(int rgb) {
        this.depthError("emissive");
    }

    public void emissive(float gray) {
        this.depthError("emissive");
    }

    public void emissive(float x, float y, float z) {
        this.depthError("emissive");
    }

    public void lights() {
        this.depthError("lights");
    }

    public void ambientLight(float red, float green, float blue) {
        this.depthError("ambientLight");
    }

    public void ambientLight(float red, float green, float blue, float x, float y, float z) {
        this.depthError("ambientLight");
    }

    public void directionalLight(float red, float green, float blue, float nx, float ny, float nz) {
        this.depthError("directionalLight");
    }

    public void pointLight(float red, float green, float blue, float x, float y, float z) {
        this.depthError("pointLight");
    }

    public void spotLight(float red, float green, float blue, float x, float y, float z, float nx, float ny, float nz, float angle, float concentration) {
        this.depthError("spotLight");
    }

    public void lightFalloff(float constant, float linear, float quadratic) {
        this.depthError("lightFalloff");
    }

    public void lightSpecular(float x, float y, float z) {
        this.depthError("lightSpecular");
    }

    public void background(int rgb) {
        if ((rgb & 0xFF000000) == 0 && (float)rgb <= this.colorModeX) {
            this.background((float)rgb);
        } else {
            this.colorCalcARGB(rgb, this.colorModeA);
            this.backgroundFromCalc();
        }
        this.clear();
    }

    public void background(int rgb, float alpha) {
        if (this.mainDrawingSurface) {
            this.background(rgb);
        } else if ((rgb & 0xFF000000) == 0 && (float)rgb <= this.colorModeX) {
            this.background((float)rgb, alpha);
        } else {
            this.colorCalcARGB(rgb, alpha);
            this.backgroundFromCalc();
            this.clear();
        }
    }

    public void background(float gray) {
        this.colorCalc(gray);
        this.backgroundFromCalc();
        this.clear();
    }

    public void background(float gray, float alpha) {
        if (this.mainDrawingSurface) {
            this.background(gray);
        } else {
            this.colorCalc(gray, alpha);
            this.backgroundFromCalc();
            this.clear();
        }
    }

    public void background(float x, float y, float z) {
        this.colorCalc(x, y, z);
        this.backgroundFromCalc();
        this.clear();
    }

    public void background(float x, float y, float z, float a) {
        if (this.mainDrawingSurface) {
            this.background(x, y, z);
        } else {
            this.colorCalc(x, y, z, a);
            this.backgroundFromCalc();
            this.clear();
        }
    }

    protected void backgroundFromCalc() {
        this.backgroundR = this.calcR;
        this.backgroundG = this.calcG;
        this.backgroundB = this.calcB;
        this.backgroundA = this.calcA;
        this.backgroundRi = this.calcRi;
        this.backgroundGi = this.calcGi;
        this.backgroundBi = this.calcBi;
        this.backgroundAi = this.calcAi;
        this.backgroundAlpha = this.calcAlpha;
        this.backgroundColor = this.calcColor;
    }

    public void background(PImage image) {
        if (image.width != this.width || image.height != this.height) {
            throw new RuntimeException("background image must be the same size as your application");
        }
        if (image.format != 1 && image.format != 2) {
            throw new RuntimeException("background images should be RGB or ARGB");
        }
        this.backgroundColor = 0;
        System.arraycopy(image.pixels, 0, this.pixels, 0, this.pixels.length);
    }

    protected abstract void clear();

    protected void depthError(String method) {
        throw new RuntimeException(String.valueOf(method) + "() can only be used " + "with P3D or OPENGL.");
    }

    protected void depthErrorXYZ(String method) {
        throw new RuntimeException(String.valueOf(method) + "(x, y, z) can only be used with " + "OPENGL or P3D, use " + method + "(x, y) instead.");
    }

    protected void unavailableError(String methodStr) {
        throw new RuntimeException(String.valueOf(methodStr) + " is not available with this renderer");
    }

    public final int color(int gray) {
        if ((gray & 0xFF000000) == 0 && (float)gray <= this.colorModeX) {
            if (this.colorRgb255) {
                if (gray > 255) {
                    gray = 255;
                } else if (gray < 0) {
                    gray = 0;
                }
                return 0xFF000000 | gray << 16 | gray << 8 | gray;
            }
            this.colorCalc(gray);
        } else {
            this.colorCalcARGB(gray, this.colorModeA);
        }
        return this.calcColor;
    }

    public final int color(float gray) {
        this.colorCalc(gray);
        return this.calcColor;
    }

    public final int color(int gray, int alpha) {
        if (this.colorRgb255) {
            if (gray > 255) {
                gray = 255;
            } else if (gray < 0) {
                gray = 0;
            }
            if (alpha > 255) {
                alpha = 255;
            } else if (alpha < 0) {
                alpha = 0;
            }
            return (alpha & 0xFF) << 24 | gray << 16 | gray << 8 | gray;
        }
        this.colorCalc(gray, alpha);
        return this.calcColor;
    }

    public final int color(int rgb, float alpha) {
        if ((rgb & 0xFF000000) == 0 && (float)rgb <= this.colorModeX) {
            this.colorCalc(rgb, alpha);
        } else {
            this.colorCalcARGB(rgb, alpha);
        }
        return this.calcColor;
    }

    public final int color(float gray, float alpha) {
        this.colorCalc(gray, alpha);
        return this.calcColor;
    }

    public final int color(int x, int y, int z) {
        if (this.colorRgb255) {
            if (x > 255) {
                x = 255;
            } else if (x < 0) {
                x = 0;
            }
            if (y > 255) {
                y = 255;
            } else if (y < 0) {
                y = 0;
            }
            if (z > 255) {
                z = 255;
            } else if (z < 0) {
                z = 0;
            }
            return 0xFF000000 | x << 16 | y << 8 | z;
        }
        this.colorCalc(x, y, z);
        return this.calcColor;
    }

    public final int color(float x, float y, float z) {
        this.colorCalc(x, y, z);
        return this.calcColor;
    }

    public final int color(int x, int y, int z, int a) {
        if (this.colorRgb255) {
            if (a > 255) {
                a = 255;
            } else if (a < 0) {
                a = 0;
            }
            if (x > 255) {
                x = 255;
            } else if (x < 0) {
                x = 0;
            }
            if (y > 255) {
                y = 255;
            } else if (y < 0) {
                y = 0;
            }
            if (z > 255) {
                z = 255;
            } else if (z < 0) {
                z = 0;
            }
            return a << 24 | x << 16 | y << 8 | z;
        }
        this.colorCalc(x, y, z, a);
        return this.calcColor;
    }

    public final int color(float x, float y, float z, float a) {
        this.colorCalc(x, y, z, a);
        return this.calcColor;
    }

    public final float alpha(int what) {
        float c = what >> 24 & 0xFF;
        if (this.colorModeA == 255.0f) {
            return c;
        }
        return c / 255.0f * this.colorModeA;
    }

    public final float red(int what) {
        float c = what >> 16 & 0xFF;
        if (this.colorRgb255) {
            return c;
        }
        return c / 255.0f * this.colorModeX;
    }

    public final float green(int what) {
        float c = what >> 8 & 0xFF;
        if (this.colorRgb255) {
            return c;
        }
        return c / 255.0f * this.colorModeY;
    }

    public final float blue(int what) {
        float c = what & 0xFF;
        if (this.colorRgb255) {
            return c;
        }
        return c / 255.0f * this.colorModeZ;
    }

    public final float hue(int what) {
        if (what != this.cacheHsbKey) {
            Color.RGBtoHSB(what >> 16 & 0xFF, what >> 8 & 0xFF, what & 0xFF, this.cacheHsbValue);
            this.cacheHsbKey = what;
        }
        return this.cacheHsbValue[0] * this.colorModeX;
    }

    public final float saturation(int what) {
        if (what != this.cacheHsbKey) {
            Color.RGBtoHSB(what >> 16 & 0xFF, what >> 8 & 0xFF, what & 0xFF, this.cacheHsbValue);
            this.cacheHsbKey = what;
        }
        return this.cacheHsbValue[1] * this.colorModeY;
    }

    public final float brightness(int what) {
        if (what != this.cacheHsbKey) {
            Color.RGBtoHSB(what >> 16 & 0xFF, what >> 8 & 0xFF, what & 0xFF, this.cacheHsbValue);
            this.cacheHsbKey = what;
        }
        return this.cacheHsbValue[2] * this.colorModeZ;
    }

    public int lerpColor(int c1, int c2, float amt) {
        return PGraphics.lerpColor(c1, c2, amt, this.colorMode);
    }

    public static int lerpColor(int c1, int c2, float amt, int mode) {
        if (mode == 1) {
            float a1 = c1 >> 24 & 0xFF;
            float r1 = c1 >> 16 & 0xFF;
            float g1 = c1 >> 8 & 0xFF;
            float b1 = c1 & 0xFF;
            float a2 = c2 >> 24 & 0xFF;
            float r2 = c2 >> 16 & 0xFF;
            float g2 = c2 >> 8 & 0xFF;
            float b2 = c2 & 0xFF;
            return (int)(a1 + (a2 - a1) * amt) << 24 | (int)(r1 + (r2 - r1) * amt) << 16 | (int)(g1 + (g2 - g1) * amt) << 8 | (int)(b1 + (b2 - b1) * amt);
        }
        if (mode == 3) {
            if (lerpColorHSB1 == null) {
                lerpColorHSB1 = new float[3];
                lerpColorHSB2 = new float[3];
            }
            float a1 = c1 >> 24 & 0xFF;
            float a2 = c2 >> 24 & 0xFF;
            int alfa = (int)(a1 + (a2 - a1) * amt) << 24;
            Color.RGBtoHSB(c1 >> 16 & 0xFF, c1 >> 8 & 0xFF, c1 & 0xFF, lerpColorHSB1);
            Color.RGBtoHSB(c2 >> 16 & 0xFF, c2 >> 8 & 0xFF, c2 & 0xFF, lerpColorHSB2);
            float h1 = lerpColorHSB1[0];
            float h2 = lerpColorHSB2[0];
            if (Math.abs(h1 - h2) > 0.5f) {
                if (h1 > h2) {
                    h2 += 1.0f;
                } else {
                    h1 += 1.0f;
                }
            }
            float ho = PApplet.lerp(lerpColorHSB1[0], lerpColorHSB2[0], amt) % 1.0f;
            float so = PApplet.lerp(lerpColorHSB1[1], lerpColorHSB2[1], amt);
            float bo = PApplet.lerp(lerpColorHSB1[2], lerpColorHSB2[2], amt);
            return alfa | Color.HSBtoRGB(ho, so, bo) & 0xFFFFFF;
        }
        return 0;
    }

    static final float sqrt(float a) {
        return (float)Math.sqrt(a);
    }

    public void mask(int[] alpha) {
        super.mask(alpha);
    }

    public void mask(PImage alpha) {
        super.mask(alpha);
    }

    public void beginRaw(PGraphics rawGraphics) {
        this.raw = rawGraphics;
        rawGraphics.beginDraw();
    }

    public void endRaw() {
        if (this.raw != null) {
            this.raw.flush();
            this.raw.endDraw();
            this.raw.dispose();
            this.raw = null;
        }
    }

    public void dispose() {
    }

    public boolean displayable() {
        return true;
    }
}

