/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PImage;

public class PFont
implements PConstants {
    public int charCount;
    public PImage[] images;
    public Font font;
    public String name;
    public String psname;
    public int size;
    public boolean smooth;
    public int mbox2;
    protected float fwidth;
    protected float fheight;
    public int twidth;
    public int theight;
    public int[] value;
    public int[] height;
    public int[] width;
    public int[] setWidth;
    public int[] topExtent;
    public int[] leftExtent;
    public int ascent;
    public int descent;
    protected int[] ascii;
    static final char[] EXTRA_CHARS = new char[]{'\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\u0085', '\u0086', '\u0087', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u008d', '\u008e', '\u008f', '\u0090', '\u0091', '\u0092', '\u0093', '\u0094', '\u0095', '\u0096', '\u0097', '\u0098', '\u0099', '\u009a', '\u009b', '\u009c', '\u009d', '\u009e', '\u009f', '\u00a0', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00ba', '\u00bb', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00ff', '\u0102', '\u0103', '\u0104', '\u0105', '\u0106', '\u0107', '\u010c', '\u010d', '\u010e', '\u010f', '\u0110', '\u0111', '\u0118', '\u0119', '\u011a', '\u011b', '\u0131', '\u0139', '\u013a', '\u013d', '\u013e', '\u0141', '\u0142', '\u0143', '\u0144', '\u0147', '\u0148', '\u0150', '\u0151', '\u0152', '\u0153', '\u0154', '\u0155', '\u0158', '\u0159', '\u015a', '\u015b', '\u015e', '\u015f', '\u0160', '\u0161', '\u0162', '\u0163', '\u0164', '\u0165', '\u016e', '\u016f', '\u0170', '\u0171', '\u0178', '\u0179', '\u017a', '\u017b', '\u017c', '\u017d', '\u017e', '\u0192', '\u02c6', '\u02c7', '\u02d8', '\u02d9', '\u02da', '\u02db', '\u02dc', '\u02dd', '\u03a9', '\u03c0', '\u2013', '\u2014', '\u2018', '\u2019', '\u201a', '\u201c', '\u201d', '\u201e', '\u2020', '\u2021', '\u2022', '\u2026', '\u2030', '\u2039', '\u203a', '\u2044', '\u20ac', '\u2122', '\u2202', '\u2206', '\u220f', '\u2211', '\u221a', '\u221e', '\u222b', '\u2248', '\u2260', '\u2264', '\u2265', '\u25ca', '\uf8ff', '\ufb01', '\ufb02'};
    public static char[] DEFAULT_CHARSET = new char[94 + EXTRA_CHARS.length];
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        int index = 0;
        int i = 33;
        while (i <= 126) {
            PFont.DEFAULT_CHARSET[index++] = (char)i;
            ++i;
        }
        i = 0;
        while (i < EXTRA_CHARS.length) {
            PFont.DEFAULT_CHARSET[index++] = EXTRA_CHARS[i];
            ++i;
        }
    }

    public PFont() {
    }

    public PFont(InputStream input) throws IOException {
        DataInputStream is = new DataInputStream(input);
        this.charCount = is.readInt();
        int version = is.readInt();
        this.size = is.readInt();
        this.mbox2 = is.readInt();
        this.fwidth = this.size;
        this.fheight = this.size;
        this.twidth = this.theight = (this.mbox2 = (int)Math.pow(2.0, Math.ceil(Math.log(this.mbox2) / Math.log(2.0))));
        this.ascent = is.readInt();
        this.descent = is.readInt();
        this.value = new int[this.charCount];
        this.height = new int[this.charCount];
        this.width = new int[this.charCount];
        this.setWidth = new int[this.charCount];
        this.topExtent = new int[this.charCount];
        this.leftExtent = new int[this.charCount];
        this.ascii = new int[128];
        int i = 0;
        while (i < 128) {
            this.ascii[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.charCount) {
            this.value[i] = is.readInt();
            this.height[i] = is.readInt();
            this.width[i] = is.readInt();
            this.setWidth[i] = is.readInt();
            this.topExtent[i] = is.readInt();
            this.leftExtent[i] = is.readInt();
            is.readInt();
            if (this.value[i] < 128) {
                this.ascii[this.value[i]] = i;
            }
            if (this.value[i] == 100 && this.ascent == 0) {
                this.ascent = this.topExtent[i];
            }
            if (this.value[i] == 112 && this.descent == 0) {
                this.descent = -this.topExtent[i] + this.height[i];
            }
            ++i;
        }
        if (this.ascent == 0 && this.descent == 0) {
            throw new RuntimeException("Please use \"Create Font\" to re-create this font.");
        }
        this.images = new PImage[this.charCount];
        i = 0;
        while (i < this.charCount) {
            this.images[i] = new PImage(this.twidth, this.theight, 4);
            int bitmapSize = this.height[i] * this.width[i];
            byte[] temp = new byte[bitmapSize];
            is.readFully(temp);
            int w = this.width[i];
            int h = this.height[i];
            int y = 0;
            while (y < h) {
                int x = 0;
                while (x < w) {
                    int valu;
                    this.images[i].pixels[y * this.twidth + x] = valu = temp[y * w + x] & 0xFF;
                    ++x;
                }
                ++y;
            }
            ++i;
        }
        if (version >= 10) {
            this.name = is.readUTF();
            this.psname = is.readUTF();
        }
        if (version == 11) {
            this.smooth = is.readBoolean();
        }
    }

    protected Font findFont() {
        this.font = new Font(this.name, 0, this.size);
        if (!this.font.getPSName().equals(this.psname)) {
            this.font = new Font(this.psname, 0, this.size);
        }
        if (!this.font.getPSName().equals(this.psname)) {
            this.font = null;
        }
        return this.font;
    }

    public void save(OutputStream output) throws IOException {
        DataOutputStream os = new DataOutputStream(output);
        os.writeInt(this.charCount);
        if (this.name == null || this.psname == null) {
            this.name = "";
            this.psname = "";
        }
        os.writeInt(11);
        os.writeInt(this.size);
        os.writeInt(this.mbox2);
        os.writeInt(this.ascent);
        os.writeInt(this.descent);
        int i = 0;
        while (i < this.charCount) {
            os.writeInt(this.value[i]);
            os.writeInt(this.height[i]);
            os.writeInt(this.width[i]);
            os.writeInt(this.setWidth[i]);
            os.writeInt(this.topExtent[i]);
            os.writeInt(this.leftExtent[i]);
            os.writeInt(0);
            ++i;
        }
        i = 0;
        while (i < this.charCount) {
            int y = 0;
            while (y < this.height[i]) {
                int x = 0;
                while (x < this.width[i]) {
                    os.write(this.images[i].pixels[y * this.mbox2 + x] & 0xFF);
                    ++x;
                }
                ++y;
            }
            ++i;
        }
        os.writeUTF(this.name);
        os.writeUTF(this.psname);
        os.writeBoolean(this.smooth);
        os.flush();
    }

    public int index(char c) {
        if (this.charCount == 0) {
            return -1;
        }
        if (c < '\u0080') {
            return this.ascii[c];
        }
        return this.indexHunt(c, 0, this.charCount - 1);
    }

    protected int indexHunt(int c, int start, int stop) {
        int pivot = (start + stop) / 2;
        if (c == this.value[pivot]) {
            return pivot;
        }
        if (start >= stop) {
            return -1;
        }
        if (c < this.value[pivot]) {
            return this.indexHunt(c, start, pivot - 1);
        }
        return this.indexHunt(c, pivot + 1, stop);
    }

    public float kern(char a, char b) {
        return 0.0f;
    }

    public float ascent() {
        return (float)this.ascent / this.fheight;
    }

    public float descent() {
        return (float)this.descent / this.fheight;
    }

    public float width(char c) {
        if (c == ' ') {
            return this.width('i');
        }
        int cc = this.index(c);
        if (cc == -1) {
            return 0.0f;
        }
        return (float)this.setWidth[cc] / this.fwidth;
    }

    public PFont(Font font, boolean smooth, char[] charset) {
        if (PApplet.javaVersion < 1.3f) {
            throw new RuntimeException("Can only create fonts with Java 1.3 or higher");
        }
        this.font = font;
        this.smooth = smooth;
        this.name = font.getName();
        this.psname = font.getPSName();
        try {
            if (charset != null) {
                Class<?> arraysClass = Class.forName("java.util.Arrays");
                Method sortMethod = arraysClass.getMethod("sort", charset.getClass());
                sortMethod.invoke(null, new Object[]{charset});
            }
            this.charCount = charset == null ? 65536 : charset.length;
            this.size = font.getSize();
            this.fwidth = this.fheight = (float)this.size;
            PImage[] bitmaps = new PImage[this.charCount];
            this.value = new int[this.charCount];
            this.height = new int[this.charCount];
            this.width = new int[this.charCount];
            this.setWidth = new int[this.charCount];
            this.topExtent = new int[this.charCount];
            this.leftExtent = new int[this.charCount];
            this.ascii = new int[128];
            int i = 0;
            while (i < 128) {
                this.ascii[i] = -1;
                ++i;
            }
            int mbox3 = this.size * 3;
            Class<?> bufferedImageClass = Class.forName("java.awt.image.BufferedImage");
            Constructor<?> bufferedImageConstructor = bufferedImageClass.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
            Field typeIntRgbField = bufferedImageClass.getField("TYPE_INT_RGB");
            int typeIntRgb = typeIntRgbField.getInt(typeIntRgbField);
            Object playground = bufferedImageConstructor.newInstance(new Integer(mbox3), new Integer(mbox3), new Integer(typeIntRgb));
            Class<?> graphicsClass = Class.forName("java.awt.Graphics2D");
            Method getGraphicsMethod = bufferedImageClass.getMethod("getGraphics", new Class[0]);
            Graphics g = (Graphics)getGraphicsMethod.invoke(playground, new Object[0]);
            Class<?> renderingHintsClass = Class.forName("java.awt.RenderingHints");
            Class<?> renderingHintsKeyClass = Class.forName("java.awt.RenderingHints$Key");
            Field antialiasingKeyField = renderingHintsClass.getField("KEY_TEXT_ANTIALIASING");
            Object antialiasingKey = antialiasingKeyField.get(renderingHintsClass);
            Field antialiasField = smooth ? renderingHintsClass.getField("VALUE_TEXT_ANTIALIAS_ON") : renderingHintsClass.getField("VALUE_TEXT_ANTIALIAS_OFF");
            Object antialiasState = antialiasField.get(renderingHintsClass);
            Class[] classArray = new Class[2];
            classArray[0] = renderingHintsKeyClass;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz;
            Method setRenderingHintMethod = graphicsClass.getMethod("setRenderingHint", classArray);
            setRenderingHintMethod.invoke((Object)g, antialiasingKey, antialiasState);
            g.setFont(font);
            FontMetrics metrics = g.getFontMetrics();
            Method canDisplayMethod = null;
            Method getDataMethod = null;
            Method getSamplesMethod = null;
            int[] samples = new int[mbox3 * mbox3];
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.awt.Font");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            canDisplayMethod = clazz2.getMethod("canDisplay", Character.TYPE);
            getDataMethod = bufferedImageClass.getMethod("getData", new Class[0]);
            Class<?> rasterClass = Class.forName("java.awt.image.Raster");
            getSamplesMethod = rasterClass.getMethod("getSamples", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, samples.getClass());
            int maxWidthHeight = 0;
            int index = 0;
            int i2 = 0;
            while (i2 < this.charCount) {
                block39: {
                    int x;
                    char c;
                    block38: {
                        c = charset == null ? (char)i2 : charset[i2];
                        try {
                            Character ch = new Character(c);
                            Boolean canDisplay = (Boolean)canDisplayMethod.invoke((Object)font, ch);
                            if (canDisplay.booleanValue()) break block38;
                            break block39;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return;
                        }
                    }
                    g.setColor(Color.white);
                    g.fillRect(0, 0, mbox3, mbox3);
                    g.setColor(Color.black);
                    g.drawString(String.valueOf(c), this.size, this.size * 2);
                    Object raster = getDataMethod.invoke(playground, new Object[0]);
                    getSamplesMethod.invoke(raster, new Integer(0), new Integer(0), new Integer(mbox3), new Integer(mbox3), new Integer(0), samples);
                    int minX = 1000;
                    int maxX = 0;
                    int minY = 1000;
                    int maxY = 0;
                    boolean pixelFound = false;
                    int y = 0;
                    while (y < mbox3) {
                        x = 0;
                        while (x < mbox3) {
                            int sample = samples[y * mbox3 + x] & 0xFF;
                            if (sample != 255) {
                                if (x < minX) {
                                    minX = x;
                                }
                                if (y < minY) {
                                    minY = y;
                                }
                                if (x > maxX) {
                                    maxX = x;
                                }
                                if (y > maxY) {
                                    maxY = y;
                                }
                                pixelFound = true;
                            }
                            ++x;
                        }
                        ++y;
                    }
                    if (!pixelFound) {
                        minY = 0;
                        minX = 0;
                        maxY = 0;
                        maxX = 0;
                    }
                    this.value[index] = c;
                    this.height[index] = maxY - minY + 1;
                    this.width[index] = maxX - minX + 1;
                    this.setWidth[index] = metrics.charWidth(c);
                    if (c < '\u0080') {
                        this.ascii[c] = index;
                    }
                    this.topExtent[index] = this.size * 2 - minY;
                    this.leftExtent[index] = minX - this.size;
                    if (c == 'd') {
                        this.ascent = this.topExtent[index];
                    }
                    if (c == 'p') {
                        this.descent = -this.topExtent[index] + this.height[index];
                    }
                    if (this.width[index] > maxWidthHeight) {
                        maxWidthHeight = this.width[index];
                    }
                    if (this.height[index] > maxWidthHeight) {
                        maxWidthHeight = this.height[index];
                    }
                    bitmaps[index] = new PImage(this.width[index], this.height[index], 4);
                    y = minY;
                    while (y <= maxY) {
                        x = minX;
                        while (x <= maxX) {
                            int val = 255 - (samples[y * mbox3 + x] & 0xFF);
                            int pindex = (y - minY) * this.width[index] + (x - minX);
                            bitmaps[index].pixels[pindex] = val;
                            ++x;
                        }
                        ++y;
                    }
                    ++index;
                }
                ++i2;
            }
            this.charCount = index;
            if (this.ascent == 0 && this.descent == 0) {
                i2 = 0;
                while (i2 < this.charCount) {
                    char cc = (char)this.value[i2];
                    if (!Character.isWhitespace(cc) && cc != '\u00a0' && cc != '\u2007' && cc != '\u202f') {
                        int d;
                        if (this.topExtent[i2] > this.ascent) {
                            this.ascent = this.topExtent[i2];
                        }
                        if ((d = -this.topExtent[i2] + this.height[i2]) > this.descent) {
                            this.descent = d;
                        }
                    }
                    ++i2;
                }
            }
            this.twidth = this.theight = (this.mbox2 = (int)Math.pow(2.0, Math.ceil(Math.log(maxWidthHeight) / Math.log(2.0))));
            this.images = new PImage[this.charCount];
            i2 = 0;
            while (i2 < this.charCount) {
                this.images[i2] = new PImage(this.mbox2, this.mbox2, 4);
                int y = 0;
                while (y < this.height[i2]) {
                    System.arraycopy(bitmaps[i2].pixels, y * this.width[i2], this.images[i2].pixels, y * this.mbox2, this.width[i2]);
                    ++y;
                }
                bitmaps[i2] = null;
                ++i2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public static String[] list() {
        if (PApplet.javaVersion < 1.3f) {
            try {
                Toolkit tk = Toolkit.getDefaultToolkit();
                Method getFontListMethod = tk.getClass().getMethod("getFontList", null);
                return (String[])getFontListMethod.invoke((Object)tk, null);
            }
            catch (Exception e) {
                e.printStackTrace();
                return new String[0];
            }
        }
        try {
            Class<?> geClass = Class.forName("java.awt.GraphicsEnvironment");
            Method glgeMethod = geClass.getMethod("getLocalGraphicsEnvironment", null);
            Object ge = glgeMethod.invoke(null, null);
            Method gafMethod = geClass.getMethod("getAllFonts", null);
            Font[] fonts = (Font[])gafMethod.invoke(ge, null);
            String[] list = new String[fonts.length];
            int i = 0;
            while (i < list.length) {
                list[i] = fonts[i].getName();
                ++i;
            }
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error inside PFont.list()");
        }
    }
}

