/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import processing.core.PConstants;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;

public class PApplet
extends Applet
implements PConstants,
Runnable,
MouseListener,
MouseMotionListener,
KeyListener,
FocusListener {
    public static final String javaVersionName = System.getProperty("java.version");
    public static final float javaVersion = new Float(javaVersionName.substring(0, 3)).floatValue();
    public static int platform;
    public static String platformName;
    public PGraphics g;
    public Frame frame;
    static final String NEW_RENDERER = "new renderer";
    public Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
    public PGraphics recorder;
    public String[] args;
    public String sketchPath;
    static final boolean THREAD_DEBUG = false;
    private Object blocker = new Object();
    public static final int DEFAULT_WIDTH = 100;
    public static final int DEFAULT_HEIGHT = 100;
    public static final int MIN_WINDOW_WIDTH = 128;
    public static final int MIN_WINDOW_HEIGHT = 128;
    public boolean defaultSize;
    public int[] pixels;
    public int width;
    public int height;
    public int mouseX;
    public int mouseY;
    public int pmouseX;
    public int pmouseY;
    protected int dmouseX;
    protected int dmouseY;
    protected int emouseX;
    protected int emouseY;
    public boolean firstMouse;
    public int mouseButton;
    public boolean mousePressed;
    public MouseEvent mouseEvent;
    public char key;
    public int keyCode;
    public boolean keyPressed;
    public KeyEvent keyEvent;
    public boolean focused = false;
    public boolean online = false;
    long millisOffset;
    public float frameRate = 10.0f;
    protected long frameRateLastMillis = 0L;
    protected long frameRateLastDelayTime = 0L;
    protected float frameRateTarget = 60.0f;
    protected boolean looping;
    protected boolean redraw;
    public int frameCount;
    public boolean finished;
    protected boolean exit;
    Thread thread;
    public Exception exception;
    protected RegisteredMethods sizeMethods;
    protected RegisteredMethods preMethods;
    protected RegisteredMethods drawMethods;
    protected RegisteredMethods postMethods;
    protected RegisteredMethods mouseEventMethods;
    protected RegisteredMethods keyEventMethods;
    protected RegisteredMethods disposeMethods;
    public static final String LEECH_WAKEUP = "Error while running applet.";
    public PrintStream leechErr;
    public static final String ARGS_EDITOR_LOCATION = "--editor-location";
    public static final String ARGS_EXTERNAL = "--external";
    public static final String ARGS_LOCATION = "--location";
    public static final String ARGS_DISPLAY = "--display";
    public static final String ARGS_BGCOLOR = "--bgcolor";
    public static final String ARGS_PRESENT = "--present";
    public static final String ARGS_STOP_COLOR = "--stop-color";
    public static final String ARGS_HIDE_STOP = "--hide-stop";
    public static final String ARGS_SKETCH_FOLDER = "--sketch-path";
    public static final char EXTERNAL_STOP = 's';
    public static final String EXTERNAL_QUIT = "__QUIT__";
    public static final String EXTERNAL_MOVE = "__MOVE__";
    static final boolean CRUSTY_THREADS = false;
    protected boolean listenersAdded;
    MouseEvent[] mouseEventQueue = new MouseEvent[10];
    int mouseEventCount;
    KeyEvent[] keyEventQueue = new KeyEvent[10];
    int keyEventCount;
    static String openLauncher;
    int cursorType = 0;
    boolean cursorVisible = true;
    PImage invisibleCursor;
    Random internalRandom;
    static final int PERLIN_YWRAPB = 4;
    static final int PERLIN_YWRAP = 16;
    static final int PERLIN_ZWRAPB = 8;
    static final int PERLIN_ZWRAP = 256;
    static final int PERLIN_SIZE = 4095;
    int perlin_octaves = 4;
    float perlin_amp_falloff = 0.5f;
    int perlin_TWOPI;
    int perlin_PI;
    float[] perlin_cosTable;
    float[] perlin;
    Random perlinRandom;
    protected String[] loadImageFormats;
    int sort_mode;
    static final int BYTES = 1;
    static final int CHARS = 2;
    static final int INTS = 3;
    static final int FLOATS = 4;
    static final int STRINGS = 5;
    static final int OBJECTS = 6;
    byte[] sort_bytes;
    char[] sort_chars;
    int[] sort_ints;
    float[] sort_floats;
    String[] sort_strings;
    Object sortObject;
    Method swapMethod;
    Method compareMethod;
    private static NumberFormat int_nf;
    private static int int_nf_digits;
    private static boolean int_nf_commas;
    private static NumberFormat float_nf;
    private static int float_nf_left;
    private static int float_nf_right;
    private static boolean float_nf_commas;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;

    static {
        platformName = System.getProperty("os.name");
        if (platformName.toLowerCase().indexOf("mac") != -1) {
            if (System.getProperty("mrj.version") != null) {
                platform = platformName.equals("Mac OS X") ? 3 : 2;
            }
        } else {
            String osname = System.getProperty("os.name");
            platform = osname.indexOf("Windows") != -1 ? 1 : (osname.equals("Linux") ? 4 : 0);
        }
    }

    public void init() {
        Dimension initialSize;
        block13: {
            initialSize = this.getSize();
            try {
                if (!(javaVersion >= 1.4f)) break block13;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.awt.Component");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Method defocus = clazz.getMethod("setFocusTraversalKeysEnabled", Boolean.TYPE);
                defocus.invoke((Object)this, Boolean.FALSE);
            }
            catch (Exception defocus) {
                // empty catch block
            }
        }
        this.millisOffset = System.currentTimeMillis();
        this.finished = false;
        this.looping = true;
        this.redraw = true;
        this.firstMouse = true;
        this.sizeMethods = new RegisteredMethods();
        this.preMethods = new RegisteredMethods();
        this.drawMethods = new RegisteredMethods();
        this.postMethods = new RegisteredMethods();
        this.mouseEventMethods = new RegisteredMethods();
        this.keyEventMethods = new RegisteredMethods();
        this.disposeMethods = new RegisteredMethods();
        try {
            this.getAppletContext();
            this.online = true;
        }
        catch (NullPointerException e) {
            this.online = false;
        }
        if (javaVersion < 1.3f) {
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    PApplet.this.link("http://java.com/");
                }
            });
            return;
        }
        try {
            if (this.sketchPath == null) {
                this.sketchPath = System.getProperty("user.dir");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (initialSize.width != 0 && initialSize.height != 0) {
            this.size(initialSize.width, initialSize.height);
        } else {
            this.size(100, 100);
            this.defaultSize = true;
        }
        this.start();
    }

    public void start() {
        if (javaVersion < 1.3f) {
            return;
        }
        if (this.thread != null) {
            return;
        }
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() {
        this.finished = true;
        if (this.thread == null) {
            return;
        }
        this.thread = null;
        if (this.g != null) {
            this.g.dispose();
        }
        this.disposeMethods.handle();
    }

    public void destroy() {
        this.stop();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public void registerSize(Object o) {
        Class[] methodArgs = new Class[]{Integer.TYPE, Integer.TYPE};
        this.registerWithArgs(this.sizeMethods, "size", o, methodArgs);
    }

    public void registerPre(Object o) {
        this.registerNoArgs(this.preMethods, "pre", o);
    }

    public void registerDraw(Object o) {
        this.registerNoArgs(this.drawMethods, "draw", o);
    }

    public void registerPost(Object o) {
        this.registerNoArgs(this.postMethods, "post", o);
    }

    public void registerMouseEvent(Object o) {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.awt.event.MouseEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] methodArgs = classArray;
        this.registerWithArgs(this.mouseEventMethods, "mouseEvent", o, methodArgs);
    }

    public void registerKeyEvent(Object o) {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.awt.event.KeyEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] methodArgs = classArray;
        this.registerWithArgs(this.keyEventMethods, "keyEvent", o, methodArgs);
    }

    public void registerDispose(Object o) {
        this.registerNoArgs(this.disposeMethods, "dispose", o);
    }

    protected void registerNoArgs(RegisteredMethods meth, String name, Object o) {
        Class<?> c = o.getClass();
        try {
            Method method = c.getMethod(name, new Class[0]);
            meth.add(o, method);
        }
        catch (Exception e) {
            this.die("Could not register " + name + " + () for " + o, e);
        }
    }

    protected void registerWithArgs(RegisteredMethods meth, String name, Object o, Class[] cargs) {
        Class<?> c = o.getClass();
        try {
            Method method = c.getMethod(name, cargs);
            meth.add(o, method);
        }
        catch (Exception e) {
            this.die("Could not register " + name + " + () for " + o, e);
        }
    }

    public void setup() {
    }

    public void draw() {
        this.finished = true;
    }

    public void size(int iwidth, int iheight) {
        if (this.g != null) {
            this.size(iwidth, iheight, this.g.getClass().getName());
        } else {
            this.size(iwidth, iheight, "processing.core.PGraphicsJava2D");
        }
    }

    public void size(int iwidth, int iheight, String irenderer) {
        this.size(iwidth, iheight, irenderer, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void size(int iwidth, int iheight, String irenderer, String ipath) {
        String currentRenderer;
        String string = currentRenderer = this.g == null ? null : this.g.getClass().getName();
        if (ipath != null) {
            ipath = this.savePath(ipath);
        }
        if (currentRenderer == null) {
            this.g = PApplet.createGraphics(iwidth, iheight, irenderer, ipath, this);
            this.updateSize(iwidth, iheight);
            return;
        }
        if (currentRenderer.equals(irenderer)) {
            if (iwidth == this.g.width) {
                if (iheight == this.g.height) return;
            }
            this.g.resize(iwidth, iheight);
            this.updateSize(iwidth, iheight);
            this.redraw();
            return;
        }
        if (this.frameCount > 0) {
            throw new RuntimeException("size() cannot be called to change the renderer outside of setup()");
        }
        this.g = PApplet.createGraphics(iwidth, iheight, irenderer, ipath, this);
        this.updateSize(iwidth, iheight);
        throw new RuntimeException(NEW_RENDERER);
    }

    protected void updateSize(int iwidth, int iheight) {
        this.width = iwidth;
        this.height = iheight;
        this.defaultSize = false;
        this.setSize(this.width, this.height);
        Object[] methodArgs = new Object[]{new Integer(this.width), new Integer(this.height)};
        this.sizeMethods.handle(methodArgs);
    }

    public PGraphics createGraphics(int iwidth, int iheight, String irenderer) {
        PGraphics pg = PApplet.createGraphics(iwidth, iheight, irenderer, null, null);
        pg.parent = this;
        return pg;
    }

    public PGraphics createGraphics(int iwidth, int iheight, String irenderer, String ipath) {
        if (ipath != null) {
            ipath = this.savePath(ipath);
        }
        PGraphics pg = PApplet.createGraphics(iwidth, iheight, irenderer, ipath, null);
        pg.parent = this;
        return pg;
    }

    protected static PGraphics createGraphics(int iwidth, int iheight, String irenderer, String ipath, PApplet applet) {
        String s;
        if (irenderer.equals("processing.opengl.PGraphicsOpenGL") && platform == 1 && (s = System.getProperty("java.version")) != null && s.equals("1.5.0_10")) {
            System.err.println("OpenGL support is broken with Java 1.5.0_10");
            System.err.println("See http://dev.processing.org/bugs/show_bug.cgi?id=513 for more info.");
            throw new RuntimeException("Please update your Java installation (see bug #513)");
        }
        String openglError = "Before using OpenGL, first select Import Library > opengl from the Sketch menu.";
        try {
            Class<?> rendererClass = Class.forName(irenderer);
            Class[] constructorParams = null;
            Object[] constructorValues = null;
            if (ipath == null) {
                Class[] classArray = new Class[3];
                classArray[0] = Integer.TYPE;
                classArray[1] = Integer.TYPE;
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("processing.core.PApplet");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[2] = clazz;
                constructorParams = classArray;
                constructorValues = new Object[]{new Integer(iwidth), new Integer(iheight), applet};
            } else {
                Class[] classArray = new Class[4];
                classArray[0] = Integer.TYPE;
                classArray[1] = Integer.TYPE;
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("processing.core.PApplet");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[2] = clazz;
                Class<?> clazz2 = class$4;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$4 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[3] = clazz2;
                constructorParams = classArray;
                constructorValues = new Object[]{new Integer(iwidth), new Integer(iheight), applet, ipath};
            }
            Constructor<?> constructor = rendererClass.getConstructor(constructorParams);
            PGraphics pg = (PGraphics)constructor.newInstance(constructorValues);
            return pg;
        }
        catch (InvocationTargetException ite) {
            String msg = ite.getTargetException().getMessage();
            if (msg != null && msg.indexOf("no jogl in java.library.path") != -1) {
                throw new RuntimeException(openglError);
            }
            ite.getTargetException().printStackTrace();
            Throwable target = ite.getTargetException();
            if (platform == 3) {
                target.printStackTrace(System.out);
            }
            throw new RuntimeException(target.getMessage());
        }
        catch (ClassNotFoundException cnfe) {
            if (cnfe.getMessage().indexOf("processing.opengl.PGraphicsGL") != -1) {
                throw new RuntimeException(openglError);
            }
            throw new RuntimeException("You need to use \"Import Library\" to add " + irenderer + " to your sketch.");
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException || e instanceof NoSuchMethodException || e instanceof IllegalAccessException) {
                String msg = "public " + irenderer.substring(irenderer.lastIndexOf(46) + 1) + "(int width, int height, PApplet parent" + (ipath == null ? "" : ", String filename") + ") does not exist.";
                throw new RuntimeException(msg);
            }
            if (platform == 3) {
                e.printStackTrace(System.out);
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    public PImage createImage(int wide, int high, int format) {
        PImage image = new PImage(wide, high, format);
        image.parent = this;
        return image;
    }

    public void update(Graphics screen) {
        this.paint(screen);
    }

    public synchronized void paint(Graphics screen) {
        if (javaVersion < 1.3f) {
            screen.setColor(new Color(64, 64, 64));
            Dimension size = this.getSize();
            screen.fillRect(0, 0, size.width, size.height);
            screen.setColor(Color.white);
            screen.setFont(new Font("Dialog", 0, 9));
            screen.drawString("You need to install", 3, 15);
            screen.drawString("Java 1.3 or later", 3, 28);
            screen.drawString("to view this content.", 3, 41);
            screen.drawString("Click here to visit", 3, 59);
            screen.drawString("java.com and install.", 3, 72);
            return;
        }
        if (this.frameCount == 0) {
            return;
        }
        if (this.g != null && this.g.image != null) {
            screen.drawImage(this.g.image, 0, 0, null);
        }
    }

    public synchronized void handleDisplay() {
        if (this.looping || this.redraw) {
            this.g.beginDraw();
            if (this.frameCount == 0) {
                try {
                    this.setup();
                }
                catch (RuntimeException e) {
                    String msg = e.getMessage();
                    if (msg != null && e.getMessage().indexOf(NEW_RENDERER) != -1) {
                        return;
                    }
                    throw e;
                }
                this.width = this.g.width;
                this.height = this.g.height;
                this.defaultSize = false;
            } else {
                float elapsed;
                if (this.frameRateLastMillis != 0L && (elapsed = (float)(System.currentTimeMillis() - this.frameRateLastMillis)) != 0.0f) {
                    this.frameRate = this.frameRate * 0.9f + 1.0f / (elapsed / 1000.0f) * 0.1f;
                }
                this.frameRateLastMillis = System.currentTimeMillis();
                this.preMethods.handle();
                this.pmouseX = this.dmouseX;
                this.pmouseY = this.dmouseY;
                this.draw();
                this.dmouseX = this.mouseX;
                this.dmouseY = this.mouseY;
                this.dequeueMouseEvents();
                this.dequeueKeyEvents();
                this.drawMethods.handle();
                this.redraw = false;
            }
            this.g.endDraw();
            ++this.frameCount;
            this.repaint();
            this.getToolkit().sync();
            this.postMethods.handle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (Thread.currentThread() == this.thread && !this.finished) {
                this.g.requestDisplay(this);
                try {
                    int nap;
                    int n = nap = this.looping || this.finished ? 1 : 10000;
                    if (this.frameCount == 1) {
                        nap = 1;
                    } else if (this.finished) {
                        nap = 0;
                    } else if (this.looping) {
                        if (this.frameRateTarget != 0.0f) {
                            long now;
                            long timeToLeave;
                            this.frameRateLastDelayTime = this.frameRateLastDelayTime == 0L ? System.currentTimeMillis() : ((nap = (int)((timeToLeave = this.frameRateLastDelayTime + (long)(1000.0f / this.frameRateTarget)) - (now = System.currentTimeMillis()))) > 0 ? timeToLeave : now);
                        } else {
                            nap = 1;
                        }
                    }
                    Object object = this.blocker;
                    synchronized (object) {
                        if (nap > 0) {
                            this.blocker.wait(nap);
                        }
                    }
                }
                catch (InterruptedException nap) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            this.finished = true;
            if (e instanceof InvocationTargetException) {
                e = (Exception)((InvocationTargetException)e).getTargetException();
            }
            this.exception = e;
            if (this.leechErr != null) {
                this.leechErr.println(LEECH_WAKEUP);
                e.printStackTrace(this.leechErr);
                e.printStackTrace(System.out);
            }
            System.err.println(LEECH_WAKEUP);
            e.printStackTrace();
            e.printStackTrace(System.out);
        }
        this.stop();
        if (this.exit && this.leechErr == null && !this.online) {
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void redraw() {
        if (!this.looping) {
            this.redraw = true;
            if (this.thread != null) {
                Object object = this.blocker;
                synchronized (object) {
                    this.blocker.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loop() {
        if (!this.looping) {
            this.looping = true;
            if (this.thread != null) {
                Object object = this.blocker;
                synchronized (object) {
                    this.blocker.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void noLoop() {
        if (this.looping) {
            this.looping = false;
            this.frameRateLastDelayTime = 0L;
            this.frameRateLastMillis = 0L;
            if (this.thread != null) {
                Object object = this.blocker;
                synchronized (object) {
                    this.blocker.notifyAll();
                }
            }
        }
    }

    public void addListeners() {
        if (!this.listenersAdded) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addKeyListener(this);
            this.addFocusListener(this);
            this.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    Component c = e.getComponent();
                    Rectangle bounds = c.getBounds();
                    PApplet.this.size(bounds.width, bounds.height);
                }
            });
            this.listenersAdded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueueMouseEvent(MouseEvent e) {
        MouseEvent[] mouseEventArray = this.mouseEventQueue;
        synchronized (this.mouseEventQueue) {
            if (this.mouseEventCount == this.mouseEventQueue.length) {
                MouseEvent[] temp = new MouseEvent[this.mouseEventCount << 1];
                System.arraycopy(this.mouseEventQueue, 0, temp, 0, this.mouseEventCount);
                this.mouseEventQueue = temp;
            }
            this.mouseEventQueue[this.mouseEventCount++] = e;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dequeueMouseEvents() {
        MouseEvent[] mouseEventArray = this.mouseEventQueue;
        synchronized (this.mouseEventQueue) {
            int i = 0;
            while (i < this.mouseEventCount) {
                this.mouseEvent = this.mouseEventQueue[i];
                this.handleMouseEvent(this.mouseEvent);
                ++i;
            }
            this.mouseEventCount = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void handleMouseEvent(MouseEvent event) {
        int id = event.getID();
        if (id == 506 || id == 503) {
            this.pmouseX = this.emouseX;
            this.pmouseY = this.emouseY;
            this.mouseX = event.getX();
            this.mouseY = event.getY();
        }
        this.mouseEvent = event;
        int modifiers = event.getModifiers();
        if ((modifiers & 0x10) != 0) {
            this.mouseButton = 37;
        } else if ((modifiers & 8) != 0) {
            this.mouseButton = 3;
        } else if ((modifiers & 4) != 0) {
            this.mouseButton = 39;
        }
        if ((platform == 3 || platform == 2) && this.mouseEvent.isPopupTrigger()) {
            this.mouseButton = 39;
        }
        this.mouseEventMethods.handle(new Object[]{event});
        if (this.firstMouse) {
            this.pmouseX = this.mouseX;
            this.pmouseY = this.mouseY;
            this.dmouseX = this.mouseX;
            this.dmouseY = this.mouseY;
            this.firstMouse = false;
        }
        switch (id) {
            case 501: {
                this.mousePressed = true;
                this.mousePressed();
                break;
            }
            case 502: {
                this.mousePressed = false;
                this.mouseReleased();
                break;
            }
            case 500: {
                this.mouseClicked();
                break;
            }
            case 506: {
                this.mouseDragged();
                break;
            }
            case 503: {
                this.mouseMoved();
            }
        }
        if (id == 506 || id == 503) {
            this.emouseX = this.mouseX;
            this.emouseY = this.mouseY;
        }
    }

    protected void checkMouseEvent(MouseEvent event) {
        if (this.looping) {
            this.enqueueMouseEvent(event);
        } else {
            this.handleMouseEvent(event);
        }
    }

    public void mousePressed(MouseEvent e) {
        this.checkMouseEvent(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.checkMouseEvent(e);
    }

    public void mouseClicked(MouseEvent e) {
        this.checkMouseEvent(e);
    }

    public void mouseEntered(MouseEvent e) {
        this.checkMouseEvent(e);
    }

    public void mouseExited(MouseEvent e) {
        this.checkMouseEvent(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.checkMouseEvent(e);
    }

    public void mouseMoved(MouseEvent e) {
        this.checkMouseEvent(e);
    }

    public void mousePressed() {
    }

    public void mouseReleased() {
    }

    public void mouseClicked() {
    }

    public void mouseDragged() {
    }

    public void mouseMoved() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueueKeyEvent(KeyEvent e) {
        KeyEvent[] keyEventArray = this.keyEventQueue;
        synchronized (this.keyEventQueue) {
            if (this.keyEventCount == this.keyEventQueue.length) {
                KeyEvent[] temp = new KeyEvent[this.keyEventCount << 1];
                System.arraycopy(this.keyEventQueue, 0, temp, 0, this.keyEventCount);
                this.keyEventQueue = temp;
            }
            this.keyEventQueue[this.keyEventCount++] = e;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dequeueKeyEvents() {
        KeyEvent[] keyEventArray = this.keyEventQueue;
        synchronized (this.keyEventQueue) {
            int i = 0;
            while (i < this.keyEventCount) {
                this.keyEvent = this.keyEventQueue[i];
                this.handleKeyEvent(this.keyEvent);
                ++i;
            }
            this.keyEventCount = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void handleKeyEvent(KeyEvent event) {
        this.keyEvent = event;
        this.key = event.getKeyChar();
        this.keyCode = event.getKeyCode();
        this.keyEventMethods.handle(new Object[]{event});
        switch (event.getID()) {
            case 401: {
                this.keyPressed = true;
                this.keyPressed();
                break;
            }
            case 402: {
                this.keyPressed = false;
                this.keyReleased();
                break;
            }
            case 400: {
                this.keyTyped();
            }
        }
        if (event.getID() == 401 && this.key == '\u001b') {
            this.exit();
        }
    }

    protected void checkKeyEvent(KeyEvent event) {
        if (this.looping) {
            this.enqueueKeyEvent(event);
        } else {
            this.handleKeyEvent(event);
        }
    }

    public void keyPressed(KeyEvent e) {
        this.checkKeyEvent(e);
    }

    public void keyReleased(KeyEvent e) {
        this.checkKeyEvent(e);
    }

    public void keyTyped(KeyEvent e) {
        this.checkKeyEvent(e);
    }

    public void keyPressed() {
    }

    public void keyReleased() {
    }

    public void keyTyped() {
    }

    public void focusGained() {
    }

    public void focusGained(FocusEvent e) {
        this.focused = true;
        this.focusGained();
    }

    public void focusLost() {
    }

    public void focusLost(FocusEvent e) {
        this.focused = false;
        this.focusLost();
    }

    public int millis() {
        return (int)(System.currentTimeMillis() - this.millisOffset);
    }

    public static int second() {
        return Calendar.getInstance().get(13);
    }

    public static int minute() {
        return Calendar.getInstance().get(12);
    }

    public static int hour() {
        return Calendar.getInstance().get(11);
    }

    public static int day() {
        return Calendar.getInstance().get(5);
    }

    public static int month() {
        return Calendar.getInstance().get(2) + 1;
    }

    public static int year() {
        return Calendar.getInstance().get(1);
    }

    public void delay(int napTime) {
        if (this.frameCount == 0) {
            return;
        }
        if (napTime > 0) {
            try {
                this.wait(napTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void frameRate(float newRateTarget) {
        this.frameRateTarget = newRateTarget;
    }

    public String param(String what) {
        if (this.online) {
            return this.getParameter(what);
        }
        System.err.println("param() only works inside a web browser");
        return null;
    }

    public void status(String what) {
        if (this.online) {
            this.showStatus(what);
        } else {
            System.out.println(what);
        }
    }

    public void link(String here) {
        this.link(here, null);
    }

    public void link(String url, String frameTitle) {
        block14: {
            if (this.online) {
                try {
                    if (frameTitle == null) {
                        this.getAppletContext().showDocument(new URL(url));
                    }
                    this.getAppletContext().showDocument(new URL(url), frameTitle);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("Could not open " + url);
                }
            } else {
                try {
                    if (platform == 1) {
                        url = url.replaceAll("&", "^&");
                        Runtime.getRuntime().exec("cmd /c start " + url);
                        break block14;
                    }
                    if (platform == 3 || platform == 2) {
                        try {
                            Class<?> mrjFileUtils = Class.forName("com.apple.mrj.MRJFileUtils");
                            Class[] classArray = new Class[1];
                            Class<?> clazz = class$4;
                            if (clazz == null) {
                                try {
                                    clazz = class$4 = Class.forName("java.lang.String");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            classArray[0] = clazz;
                            Method openMethod = mrjFileUtils.getMethod("openURL", classArray);
                            openMethod.invoke(null, url);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break block14;
                    }
                    this.open(url);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException("Could not open " + url);
                }
            }
        }
    }

    public void open(String filename) {
        PApplet.open(new String[]{filename});
    }

    public static Process open(String[] argv) {
        String[] params = null;
        if (platform == 1) {
            params = new String[]{"cmd", "/c"};
        } else if (platform == 3) {
            params = new String[]{"open"};
        } else if (platform == 4) {
            Process p2;
            if (openLauncher == null) {
                try {
                    p2 = Runtime.getRuntime().exec(new String[]{"gnome-open"});
                    p2.waitFor();
                    openLauncher = "gnome-open";
                }
                catch (Exception p2) {
                    // empty catch block
                }
            }
            if (openLauncher == null) {
                try {
                    p2 = Runtime.getRuntime().exec(new String[]{"kde-open"});
                    p2.waitFor();
                    openLauncher = "kde-open";
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (openLauncher == null) {
                System.err.println("Could not find gnome-open or kde-open, the open() command may not work.");
            }
            if (openLauncher != null) {
                params = new String[]{openLauncher};
            }
        }
        if (params != null) {
            if (params[0].equals(argv[0])) {
                return PApplet.exec(argv);
            }
            params = PApplet.concat(params, argv);
            return PApplet.exec(params);
        }
        return PApplet.exec(argv);
    }

    public static Process exec(String[] argv) {
        try {
            return Runtime.getRuntime().exec(argv);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Could not open " + PApplet.join(argv, ' '));
        }
    }

    public void die(String what) {
        this.stop();
        throw new RuntimeException(what);
    }

    public void die(String what, Exception e) {
        if (e != null) {
            e.printStackTrace();
        }
        this.die(what);
    }

    public void exit() {
        if (this.thread == null) {
            if (this.leechErr == null && !this.online) {
                System.exit(0);
            }
        } else {
            this.finished = true;
            this.exit = true;
        }
    }

    public void save(String filename) {
        this.g.save(this.savePath(filename));
    }

    public void saveFrame() {
        if (this.online) {
            System.err.println("Can't use saveFrame() when running in a browser.");
            return;
        }
        this.g.save(this.savePath("screen-" + PApplet.nf(this.frameCount, 4) + ".tif"));
    }

    public void saveFrame(String what) {
        if (this.online) {
            System.err.println("Can't use saveFrame() when running in a browser.");
            return;
        }
        this.g.save(this.savePath(this.insertFrame(what)));
    }

    public void cursor(int _cursor_type) {
        this.setCursor(Cursor.getPredefinedCursor(_cursor_type));
        this.cursorVisible = true;
        this.cursorType = _cursor_type;
    }

    public void cursor(PImage image) {
        this.cursor(image, image.width / 2, image.height / 2);
    }

    public void cursor(PImage image, int hotspotX, int hotspotY) {
        if (javaVersion < 1.2f) {
            System.err.println("Java 1.2 or higher is required to use cursor()");
            System.err.println("(You're using version " + javaVersionName + ")");
            return;
        }
        Image jimage = this.createImage(new MemoryImageSource(image.width, image.height, image.pixels, 0, image.width));
        Point hotspot = new Point(hotspotX, hotspotY);
        try {
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("java.awt.Toolkit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class[] classArray = new Class[3];
            Class<?> clazz2 = class$6;
            if (clazz2 == null) {
                try {
                    clazz2 = class$6 = Class.forName("java.awt.Image");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Class<?> clazz3 = class$7;
            if (clazz3 == null) {
                try {
                    clazz3 = class$7 = Class.forName("java.awt.Point");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz3;
            Class<?> clazz4 = class$4;
            if (clazz4 == null) {
                try {
                    clazz4 = class$4 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[2] = clazz4;
            Method mCustomCursor = clazz.getMethod("createCustomCursor", classArray);
            Cursor cursor = (Cursor)mCustomCursor.invoke((Object)Toolkit.getDefaultToolkit(), jimage, hotspot, "no cursor");
            this.setCursor(cursor);
            this.cursorVisible = true;
        }
        catch (NoSuchMethodError e) {
            System.err.println("cursor() is not available when using Java " + javaVersionName);
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("cursor() error: the hotspot " + hotspot + " is out of bounds for the given image.");
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void cursor() {
        if (!this.cursorVisible) {
            this.cursorVisible = true;
            this.setCursor(Cursor.getPredefinedCursor(this.cursorType));
        }
    }

    public void noCursor() {
        if (!this.cursorVisible) {
            return;
        }
        if (this.invisibleCursor == null) {
            this.invisibleCursor = new PImage(16, 16, 2);
        }
        this.cursor(this.invisibleCursor, 0, 0);
        this.cursorVisible = false;
    }

    public static void print(byte what) {
        System.out.print(what);
        System.out.flush();
    }

    public static void print(boolean what) {
        System.out.print(what);
        System.out.flush();
    }

    public static void print(char what) {
        System.out.print(what);
        System.out.flush();
    }

    public static void print(int what) {
        System.out.print(what);
        System.out.flush();
    }

    public static void print(float what) {
        System.out.print(what);
        System.out.flush();
    }

    public static void print(String what) {
        System.out.print(what);
        System.out.flush();
    }

    public static void print(Object what) {
        if (what == null) {
            System.out.print("null");
        } else {
            System.out.println(what.toString());
        }
    }

    public static void println() {
        System.out.println();
    }

    public static void println(byte what) {
        PApplet.print(what);
        System.out.println();
    }

    public static void println(boolean what) {
        PApplet.print(what);
        System.out.println();
    }

    public static void println(char what) {
        PApplet.print(what);
        System.out.println();
    }

    public static void println(int what) {
        PApplet.print(what);
        System.out.println();
    }

    public static void println(float what) {
        PApplet.print(what);
        System.out.println();
    }

    public static void println(String what) {
        PApplet.print(what);
        System.out.println();
    }

    public static void println(Object what) {
        block18: {
            block19: {
                block17: {
                    if (what != null) break block17;
                    System.out.println("null");
                    break block18;
                }
                String name = what.getClass().getName();
                if (name.charAt(0) != '[') break block19;
                switch (name.charAt(1)) {
                    case '[': {
                        System.out.println(what);
                        break;
                    }
                    case 'L': {
                        Object[] poo = (Object[])what;
                        int i = 0;
                        while (i < poo.length) {
                            if (poo[i] instanceof String) {
                                System.out.println("[" + i + "] \"" + poo[i] + "\"");
                            } else {
                                System.out.println("[" + i + "] " + poo[i]);
                            }
                            ++i;
                        }
                        break block18;
                    }
                    case 'Z': {
                        boolean[] zz = (boolean[])what;
                        int i = 0;
                        while (i < zz.length) {
                            System.out.println("[" + i + "] " + zz[i]);
                            ++i;
                        }
                        break block18;
                    }
                    case 'B': {
                        byte[] bb = (byte[])what;
                        int i = 0;
                        while (i < bb.length) {
                            System.out.println("[" + i + "] " + bb[i]);
                            ++i;
                        }
                        break block18;
                    }
                    case 'C': {
                        char[] cc = (char[])what;
                        int i = 0;
                        while (i < cc.length) {
                            System.out.println("[" + i + "] '" + cc[i] + "'");
                            ++i;
                        }
                        break block18;
                    }
                    case 'I': {
                        int[] ii = (int[])what;
                        int i = 0;
                        while (i < ii.length) {
                            System.out.println("[" + i + "] " + ii[i]);
                            ++i;
                        }
                        break block18;
                    }
                    case 'F': {
                        float[] ff = (float[])what;
                        int i = 0;
                        while (i < ff.length) {
                            System.out.println("[" + i + "] " + ff[i]);
                            ++i;
                        }
                        break block18;
                    }
                    default: {
                        System.out.println(what);
                        break;
                    }
                }
                break block18;
            }
            System.out.println(what);
        }
    }

    public static final float abs(float n) {
        return n < 0.0f ? -n : n;
    }

    public static final int abs(int n) {
        return n < 0 ? -n : n;
    }

    public static final float sq(float a) {
        return a * a;
    }

    public static final float sqrt(float a) {
        return (float)Math.sqrt(a);
    }

    public static final float log(float a) {
        return (float)Math.log(a);
    }

    public static final float exp(float a) {
        return (float)Math.exp(a);
    }

    public static final float pow(float a, float b) {
        return (float)Math.pow(a, b);
    }

    public static final int max(int a, int b) {
        return a > b ? a : b;
    }

    public static final float max(float a, float b) {
        return a > b ? a : b;
    }

    public static final int max(int a, int b, int c) {
        return a > b ? (a > c ? a : c) : (b > c ? b : c);
    }

    public static final float max(float a, float b, float c) {
        return a > b ? (a > c ? a : c) : (b > c ? b : c);
    }

    public static final int max(int[] list) {
        if (list.length == 0) {
            return 0;
        }
        int max = list[0];
        int i = 1;
        while (i < list.length) {
            if (list[i] > max) {
                max = list[i];
            }
            ++i;
        }
        return max;
    }

    public static final float max(float[] list) {
        if (list.length == 0) {
            return Float.NaN;
        }
        float max = list[0];
        int i = 1;
        while (i < list.length) {
            if (list[i] > max) {
                max = list[i];
            }
            ++i;
        }
        return max;
    }

    public static final int min(int a, int b) {
        return a < b ? a : b;
    }

    public static final float min(float a, float b) {
        return a < b ? a : b;
    }

    public static final int min(int a, int b, int c) {
        return a < b ? (a < c ? a : c) : (b < c ? b : c);
    }

    public static final float min(float a, float b, float c) {
        return a < b ? (a < c ? a : c) : (b < c ? b : c);
    }

    public static final int min(int[] list) {
        if (list.length == 0) {
            return 0;
        }
        int min = list[0];
        int i = 1;
        while (i < list.length) {
            if (list[i] < min) {
                min = list[i];
            }
            ++i;
        }
        return min;
    }

    public static final float min(float[] list) {
        if (list.length == 0) {
            return Float.NaN;
        }
        float min = list[0];
        int i = 1;
        while (i < list.length) {
            if (list[i] < min) {
                min = list[i];
            }
            ++i;
        }
        return min;
    }

    public static final int constrain(int amt, int low, int high) {
        return amt < low ? low : (amt > high ? high : amt);
    }

    public static final float constrain(float amt, float low, float high) {
        return amt < low ? low : (amt > high ? high : amt);
    }

    public static final float sin(float angle) {
        return (float)Math.sin(angle);
    }

    public static final float cos(float angle) {
        return (float)Math.cos(angle);
    }

    public static final float tan(float angle) {
        return (float)Math.tan(angle);
    }

    public static final float asin(float value) {
        return (float)Math.asin(value);
    }

    public static final float acos(float value) {
        return (float)Math.acos(value);
    }

    public static final float atan(float value) {
        return (float)Math.atan(value);
    }

    public static final float atan2(float a, float b) {
        return (float)Math.atan2(a, b);
    }

    public static final float degrees(float radians) {
        return radians * 57.295776f;
    }

    public static final float radians(float degrees) {
        return degrees * ((float)Math.PI / 180);
    }

    public static final int ceil(float what) {
        return (int)Math.ceil(what);
    }

    public static final int floor(float what) {
        return (int)Math.floor(what);
    }

    public static final int round(float what) {
        return Math.round(what);
    }

    public static final float mag(float a, float b) {
        return (float)Math.sqrt(a * a + b * b);
    }

    public static final float mag(float a, float b, float c) {
        return (float)Math.sqrt(a * a + b * b + c * c);
    }

    public static final float dist(float x1, float y1, float x2, float y2) {
        return PApplet.sqrt(PApplet.sq(x2 - x1) + PApplet.sq(y2 - y1));
    }

    public static final float dist(float x1, float y1, float z1, float x2, float y2, float z2) {
        return PApplet.sqrt(PApplet.sq(x2 - x1) + PApplet.sq(y2 - y1) + PApplet.sq(z2 - z1));
    }

    public static final float lerp(float start, float stop, float amt) {
        return start + (stop - start) * amt;
    }

    public static final float norm(float value, float start, float stop) {
        return (value - start) / (stop - start);
    }

    public static final float map(float value, float istart, float istop, float ostart, float ostop) {
        return ostart + (ostop - ostart) * ((value - istart) / (istop - istart));
    }

    public final float random(float howbig) {
        if (howbig == 0.0f) {
            return 0.0f;
        }
        if (this.internalRandom == null) {
            this.internalRandom = new Random();
        }
        float value = 0.0f;
        while ((value = this.internalRandom.nextFloat() * howbig) == howbig) {
        }
        return value;
    }

    public final float random(float howsmall, float howbig) {
        if (howsmall >= howbig) {
            return howsmall;
        }
        float diff = howbig - howsmall;
        return this.random(diff) + howsmall;
    }

    public final void randomSeed(long what) {
        if (this.internalRandom == null) {
            this.internalRandom = new Random();
        }
        this.internalRandom.setSeed(what);
    }

    public float noise(float x) {
        return this.noise(x, 0.0f, 0.0f);
    }

    public float noise(float x, float y) {
        return this.noise(x, y, 0.0f);
    }

    public float noise(float x, float y, float z) {
        if (this.perlin == null) {
            if (this.perlinRandom == null) {
                this.perlinRandom = new Random();
            }
            this.perlin = new float[4096];
            int i = 0;
            while (i < 4096) {
                this.perlin[i] = this.perlinRandom.nextFloat();
                ++i;
            }
            this.perlin_cosTable = PGraphics.cosLUT;
            this.perlin_PI = 720;
            this.perlin_TWOPI = 720;
            this.perlin_PI >>= 1;
        }
        if (x < 0.0f) {
            x = -x;
        }
        if (y < 0.0f) {
            y = -y;
        }
        if (z < 0.0f) {
            z = -z;
        }
        int xi = (int)x;
        int yi = (int)y;
        int zi = (int)z;
        float xf = x - (float)xi;
        float yf = y - (float)yi;
        float zf = z - (float)zi;
        float r = 0.0f;
        float ampl = 0.5f;
        int i = 0;
        while (i < this.perlin_octaves) {
            int of = xi + (yi << 4) + (zi << 8);
            float rxf = this.noise_fsc(xf);
            float ryf = this.noise_fsc(yf);
            float n1 = this.perlin[of & 0xFFF];
            n1 += rxf * (this.perlin[of + 1 & 0xFFF] - n1);
            float n2 = this.perlin[of + 16 & 0xFFF];
            n2 += rxf * (this.perlin[of + 16 + 1 & 0xFFF] - n2);
            n1 += ryf * (n2 - n1);
            n2 = this.perlin[(of += 256) & 0xFFF];
            n2 += rxf * (this.perlin[of + 1 & 0xFFF] - n2);
            float n3 = this.perlin[of + 16 & 0xFFF];
            n3 += rxf * (this.perlin[of + 16 + 1 & 0xFFF] - n3);
            n2 += ryf * (n3 - n2);
            n1 += this.noise_fsc(zf) * (n2 - n1);
            r += n1 * ampl;
            ampl *= this.perlin_amp_falloff;
            xi <<= 1;
            xf *= 2.0f;
            yi <<= 1;
            yf *= 2.0f;
            zi <<= 1;
            zf *= 2.0f;
            if (xf >= 1.0f) {
                ++xi;
                xf -= 1.0f;
            }
            if (yf >= 1.0f) {
                ++yi;
                yf -= 1.0f;
            }
            if (zf >= 1.0f) {
                ++zi;
                zf -= 1.0f;
            }
            ++i;
        }
        return r;
    }

    private float noise_fsc(float i) {
        return 0.5f * (1.0f - this.perlin_cosTable[(int)(i * (float)this.perlin_PI) % this.perlin_TWOPI]);
    }

    public void noiseDetail(int lod) {
        if (lod > 0) {
            this.perlin_octaves = lod;
        }
    }

    public void noiseDetail(int lod, float falloff) {
        if (lod > 0) {
            this.perlin_octaves = lod;
        }
        if (falloff > 0.0f) {
            this.perlin_amp_falloff = falloff;
        }
    }

    public void noiseSeed(long what) {
        if (this.perlinRandom == null) {
            this.perlinRandom = new Random();
        }
        this.perlinRandom.setSeed(what);
        this.perlin = null;
    }

    public PImage loadImage(String filename) {
        String lower = filename.toLowerCase();
        int dot = filename.lastIndexOf(46);
        if (dot == -1) {
            return this.loadImage(filename, "unknown");
        }
        String extension = lower.substring(dot + 1);
        int question = extension.indexOf(63);
        if (question != -1) {
            extension = extension.substring(0, question);
        }
        return this.loadImage(filename, extension);
    }

    public PImage loadImage(String filename, String extension) {
        block16: {
            byte[] bytes;
            block17: {
                if ((extension = extension.toLowerCase()).equals("tga")) {
                    try {
                        return this.loadImageTGA(filename);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
                if (extension.equals("tif") || extension.equals("tiff")) {
                    byte[] bytes2 = this.loadBytes(filename);
                    return bytes2 == null ? null : PImage.loadTIFF(bytes2);
                }
                if (extension.equals("png") && javaVersion < 1.3f) {
                    System.err.println("PNG images can only be loaded when using Java 1.3 and later.");
                    return null;
                }
                if (!extension.equals("jpg") && !extension.equals("jpeg") && !extension.equals("gif") && !extension.equals("png") && !extension.equals("unknown")) break block16;
                bytes = this.loadBytes(filename);
                if (bytes != null) break block17;
                return null;
            }
            try {
                Image awtImage = Toolkit.getDefaultToolkit().createImage(bytes);
                PImage image = this.loadImageSync(awtImage);
                if (extension.equals("gif") || extension.equals("png")) {
                    image.checkAlpha();
                }
                return image;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (javaVersion >= 1.4f) {
            if (this.loadImageFormats == null) {
                try {
                    Class<?> ioClass = Class.forName("javax.imageio.ImageIO");
                    Method getFormatNamesMethod = ioClass.getMethod("getReaderFormatNames", null);
                    this.loadImageFormats = (String[])getFormatNamesMethod.invoke(null, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.loadImageFormats != null) {
                int i = 0;
                while (i < this.loadImageFormats.length) {
                    if (extension.equals(this.loadImageFormats[i])) {
                        return this.loadImageIO(filename);
                    }
                    ++i;
                }
            }
        }
        System.err.println("Could not find a method to load " + filename);
        return null;
    }

    public PImage loadImageSync(Image awtImage) {
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(awtImage, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        PImage image = new PImage(awtImage);
        image.parent = this;
        return image;
    }

    protected PImage loadImageIO(String filename) {
        InputStream stream = this.openStream(filename);
        if (stream == null) {
            System.err.println("The image " + filename + " could not be found.");
            return null;
        }
        try {
            Class<?> ioClass = Class.forName("javax.imageio.ImageIO");
            Class[] classArray = new Class[1];
            Class<?> clazz = class$8;
            if (clazz == null) {
                try {
                    clazz = class$8 = Class.forName("java.io.InputStream");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Method readMethod = ioClass.getMethod("read", classArray);
            Object bimage = readMethod.invoke(null, stream);
            Class<?> biClass = Class.forName("java.awt.image.BufferedImage");
            Method getHeightMethod = biClass.getMethod("getHeight", null);
            Integer hi = (Integer)getHeightMethod.invoke(bimage, null);
            Method getWidthMethod = biClass.getMethod("getWidth", null);
            Integer wi = (Integer)getWidthMethod.invoke(bimage, null);
            PImage outgoing = new PImage(wi, hi);
            outgoing.parent = this;
            Method getRgbMethod = biClass.getMethod("getRGB", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, outgoing.pixels.getClass(), Integer.TYPE, Integer.TYPE);
            getRgbMethod.invoke(bimage, new Integer(0), new Integer(0), new Integer(outgoing.width), new Integer(outgoing.height), outgoing.pixels, new Integer(0), new Integer(outgoing.width));
            outgoing.checkAlpha();
            return outgoing;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected PImage loadImageTGA(String filename) throws IOException {
        PImage outgoing;
        block47: {
            boolean reversed;
            int h;
            int w;
            int format;
            InputStream is;
            block45: {
                block46: {
                    int count;
                    is = this.openStream(filename);
                    if (is == null) {
                        return null;
                    }
                    byte[] header = new byte[18];
                    int offset = 0;
                    do {
                        if ((count = is.read(header, offset, header.length - offset)) != -1) continue;
                        return null;
                    } while ((offset += count) < 18);
                    format = 0;
                    if (!(header[2] != 3 && header[2] != 11 || header[16] != 8 || header[17] != 8 && header[17] != 40)) {
                        format = 4;
                    } else if (!(header[2] != 2 && header[2] != 10 || header[16] != 24 || header[17] != 32 && header[17] != 0)) {
                        format = 1;
                    } else if (!(header[2] != 2 && header[2] != 10 || header[16] != 32 || header[17] != 8 && header[17] != 40)) {
                        format = 2;
                    }
                    if (format == 0) {
                        System.err.println("Unknown .tga file format for " + filename);
                        return null;
                    }
                    w = ((header[13] & 0xFF) << 8) + (header[12] & 0xFF);
                    h = ((header[15] & 0xFF) << 8) + (header[14] & 0xFF);
                    outgoing = this.createImage(w, h, format);
                    boolean bl = reversed = (header[17] & 0x20) != 0;
                    if (header[2] != 2 && header[2] != 3) break block45;
                    if (!reversed) break block46;
                    int index = (h - 1) * w;
                    switch (format) {
                        case 4: {
                            int y = h - 1;
                            while (y >= 0) {
                                int x = 0;
                                while (x < w) {
                                    outgoing.pixels[index + x] = is.read();
                                    ++x;
                                }
                                index -= w;
                                --y;
                            }
                            break block47;
                        }
                        case 1: {
                            int y = h - 1;
                            while (y >= 0) {
                                int x = 0;
                                while (x < w) {
                                    outgoing.pixels[index + x] = is.read() | is.read() << 8 | is.read() << 16 | 0xFF000000;
                                    ++x;
                                }
                                index -= w;
                                --y;
                            }
                            break block47;
                        }
                        case 2: {
                            int y = h - 1;
                            while (y >= 0) {
                                int x = 0;
                                while (x < w) {
                                    outgoing.pixels[index + x] = is.read() | is.read() << 8 | is.read() << 16 | is.read() << 24;
                                    ++x;
                                }
                                index -= w;
                                --y;
                            }
                            break block0;
                        }
                    }
                    break block47;
                }
                int count = w * h;
                switch (format) {
                    case 4: {
                        int i = 0;
                        while (i < count) {
                            outgoing.pixels[i] = is.read();
                            ++i;
                        }
                        break block47;
                    }
                    case 1: {
                        int i = 0;
                        while (i < count) {
                            outgoing.pixels[i] = is.read() | is.read() << 8 | is.read() << 16 | 0xFF000000;
                            ++i;
                        }
                        break block47;
                    }
                    case 2: {
                        int i = 0;
                        while (i < count) {
                            outgoing.pixels[i] = is.read() | is.read() << 8 | is.read() << 16 | is.read() << 24;
                            ++i;
                        }
                        break block5;
                    }
                }
                break block47;
            }
            int index = 0;
            int[] px = outgoing.pixels;
            block30: while (index < px.length) {
                boolean isRLE;
                int num = is.read();
                boolean bl = isRLE = (num & 0x80) != 0;
                if (isRLE) {
                    num -= 127;
                    int pixel = 0;
                    switch (format) {
                        case 4: {
                            pixel = is.read();
                            break;
                        }
                        case 1: {
                            pixel = 0xFF000000 | is.read() | is.read() << 8 | is.read() << 16;
                            break;
                        }
                        case 2: {
                            pixel = is.read() | is.read() << 8 | is.read() << 16 | is.read() << 24;
                        }
                    }
                    int i = 0;
                    while (i < num) {
                        px[index++] = pixel;
                        if (index == px.length) continue block30;
                        ++i;
                    }
                    continue;
                }
                ++num;
                switch (format) {
                    case 4: {
                        int i = 0;
                        while (i < num) {
                            px[index++] = is.read();
                            ++i;
                        }
                        continue block30;
                    }
                    case 1: {
                        int i = 0;
                        while (i < num) {
                            px[index++] = 0xFF000000 | is.read() | is.read() << 8 | is.read() << 16;
                            ++i;
                        }
                        continue block30;
                    }
                    case 2: {
                        int i = 0;
                        while (i < num) {
                            px[index++] = is.read() | is.read() << 8 | is.read() << 16 | is.read() << 24;
                            ++i;
                        }
                        continue block30;
                    }
                }
            }
            if (reversed) {
                int[] temp = new int[w];
                int y = 0;
                while (y < h / 2) {
                    int z = h - 1 - y;
                    System.arraycopy(px, y * w, temp, 0, w);
                    System.arraycopy(px, z * w, px, y * w, w);
                    System.arraycopy(temp, 0, px, z * w, w);
                    ++y;
                }
            }
        }
        return outgoing;
    }

    public PFont loadFont(String filename) {
        try {
            String lower = filename.toLowerCase();
            InputStream input = this.openStream(filename);
            if (lower.endsWith(".vlw.gz")) {
                input = new GZIPInputStream(input);
            } else if (!lower.endsWith(".vlw")) {
                throw new IOException("I don't know how to load a font named " + filename);
            }
            return new PFont(input);
        }
        catch (Exception e) {
            this.die("Could not load font " + filename + ". " + "Make sure that the font has been copied " + "to the data folder of your sketch.", e);
            return null;
        }
    }

    public PFont createFont(String name, float size) {
        return this.createFont(name, size, true, PFont.DEFAULT_CHARSET);
    }

    public PFont createFont(String name, float size, boolean smooth) {
        return this.createFont(name, size, smooth, PFont.DEFAULT_CHARSET);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PFont createFont(String name, float size, boolean smooth, char[] charset) {
        if (javaVersion < 1.3f) {
            throw new RuntimeException("Can only create fonts with Java 1.3 or higher");
        }
        String lowerName = name.toLowerCase();
        Font font = null;
        try {
            Class<?> clazz = class$9;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("java.awt.Font");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$9 = clazz2;
            }
            Method deriveFontMethod = clazz.getMethod("deriveFont", Float.TYPE);
            Float floatSize = new Float(size);
            if (!lowerName.endsWith(".otf") && !lowerName.endsWith(".ttf")) {
                Font baseFont = new Font(name, 0, 1);
                font = (Font)deriveFontMethod.invoke((Object)baseFont, floatSize);
                return new PFont(font, smooth, charset);
            }
            InputStream stream = this.openStream(name);
            if (stream == null) {
                System.err.println("The font \"" + name + "\" " + "is missing or inaccessible, make sure " + "the URL is valid or that the file has been " + "added to your sketch and is readable.");
                return null;
            }
            Class<?> clazz3 = class$9;
            if (clazz3 == null) {
                Class<?> clazz4;
                try {
                    clazz4 = Class.forName("java.awt.Font");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz3 = class$9 = clazz4;
            }
            Class[] classArray = new Class[2];
            classArray[0] = Integer.TYPE;
            Class<?> clazz5 = class$8;
            if (clazz5 == null) {
                Class<?> clazz6;
                try {
                    clazz6 = Class.forName("java.io.InputStream");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz5 = class$8 = clazz6;
            }
            classArray[1] = clazz5;
            Method createFontMethod = clazz3.getMethod("createFont", classArray);
            Class<?> clazz7 = class$9;
            if (clazz7 == null) {
                Class<?> clazz8;
                try {
                    clazz8 = Class.forName("java.awt.Font");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz7 = class$9 = clazz8;
            }
            Field ttf = clazz7.getField("TRUETYPE_FONT");
            Integer ttfInteger = new Integer(ttf.getInt(ttf));
            Font baseFont = (Font)createFontMethod.invoke((Object)name, ttfInteger, this.openStream(name));
            font = (Font)deriveFontMethod.invoke((Object)baseFont, floatSize);
            return new PFont(font, smooth, charset);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Problem using createFont() with the file " + name);
        }
    }

    public File inputFile() {
        return this.inputFile("Select a file...");
    }

    public File inputFile(String prompt) {
        Frame parentFrame = null;
        Container comp = this.getParent();
        while (comp != null) {
            if (comp instanceof Frame) {
                parentFrame = (Frame)comp;
                break;
            }
            comp = comp.getParent();
        }
        return PApplet.inputFile(prompt, parentFrame);
    }

    public static File inputFile(Frame parent) {
        return PApplet.inputFile("Select a file...", parent);
    }

    public static File inputFile(String prompt, Frame parentFrame) {
        if (parentFrame == null) {
            parentFrame = new Frame();
        }
        FileDialog fd = new FileDialog(parentFrame, prompt, 0);
        fd.setVisible(true);
        String directory = fd.getDirectory();
        String filename = fd.getFile();
        if (filename == null) {
            return null;
        }
        return new File(directory, filename);
    }

    public File outputFile() {
        return this.outputFile("Save as...");
    }

    public File outputFile(String prompt) {
        Frame parentFrame = null;
        Container comp = this.getParent();
        while (comp != null) {
            if (comp instanceof Frame) {
                parentFrame = (Frame)comp;
                break;
            }
            comp = comp.getParent();
        }
        return PApplet.outputFile(prompt, parentFrame);
    }

    public static File outputFile(Frame parentFrame) {
        return PApplet.outputFile("Save as...", parentFrame);
    }

    public static File outputFile(String prompt, Frame parentFrame) {
        if (parentFrame == null) {
            parentFrame = new Frame();
        }
        FileDialog fd = new FileDialog(parentFrame, prompt, 1);
        fd.setVisible(true);
        String directory = fd.getDirectory();
        String filename = fd.getFile();
        if (filename == null) {
            return null;
        }
        return new File(directory, filename);
    }

    public BufferedReader createReader(String filename) {
        InputStream is;
        block5: {
            try {
                is = this.openStream(filename);
                if (is != null) break block5;
                System.err.println(String.valueOf(filename) + " does not exist or could not be read");
                return null;
            }
            catch (Exception e) {
                if (filename == null) {
                    System.err.println("Filename passed to reader() was null");
                } else {
                    System.err.println("Couldn't create a reader for " + filename);
                }
                return null;
            }
        }
        return PApplet.createReader(is);
    }

    public static BufferedReader createReader(File file) {
        try {
            return PApplet.createReader(new FileInputStream(file));
        }
        catch (Exception e) {
            if (file == null) {
                throw new RuntimeException("File passed to reader() was null");
            }
            e.printStackTrace();
            throw new RuntimeException("Couldn't create a reader for " + file.getAbsolutePath());
        }
    }

    public static BufferedReader createReader(InputStream input) {
        InputStreamReader isr = new InputStreamReader(input);
        return new BufferedReader(isr);
    }

    public static InputStream gzipInput(InputStream input) {
        try {
            return new GZIPInputStream(input);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Problem with gzip input");
        }
    }

    public static OutputStream gzipOutput(OutputStream output) {
        try {
            return new GZIPOutputStream(output);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Problem with gzip output");
        }
    }

    public PrintWriter createWriter(String filename) {
        try {
            return PApplet.createWriter(new FileOutputStream(this.savePath(filename)));
        }
        catch (Exception e) {
            if (filename == null) {
                this.die("Filename passed to writer() was null", e);
            } else {
                this.die("Couldn't create a writer for " + filename, e);
            }
            return null;
        }
    }

    public static PrintWriter createWriter(File file) {
        try {
            return PApplet.createWriter(new FileOutputStream(file));
        }
        catch (Exception e) {
            if (file == null) {
                throw new RuntimeException("File passed to writer() was null");
            }
            e.printStackTrace();
            throw new RuntimeException("Couldn't create a writer for " + file.getAbsolutePath());
        }
    }

    public static PrintWriter createWriter(OutputStream output) {
        OutputStreamWriter osw = new OutputStreamWriter(output);
        return new PrintWriter(osw);
    }

    public InputStream openStream(String filename) {
        String cn;
        InputStream stream = null;
        if (filename == null) {
            return null;
        }
        if (filename.length() == 0) {
            return null;
        }
        try {
            URL url = new URL(filename);
            stream = url.openStream();
            return stream;
        }
        catch (MalformedURLException url) {
        }
        catch (FileNotFoundException url) {
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        ClassLoader cl = this.getClass().getClassLoader();
        stream = cl.getResourceAsStream("data/" + filename);
        if (stream != null && !(cn = stream.getClass().getName()).equals("sun.plugin.cache.EmptyInputStream")) {
            return stream;
        }
        stream = cl.getResourceAsStream(filename);
        if (stream != null && !(cn = stream.getClass().getName()).equals("sun.plugin.cache.EmptyInputStream")) {
            return stream;
        }
        if (!this.online) {
            try {
                File file = new File(this.dataPath(filename));
                if (!file.exists()) {
                    file = new File(this.sketchPath, filename);
                }
                if (file.exists()) {
                    try {
                        String filePath = file.getCanonicalPath();
                        String filenameActual = new File(filePath).getName();
                        String filenameShort = new File(filename).getName();
                        if (!filenameActual.equals(filenameShort)) {
                            throw new RuntimeException("This file is named " + filenameActual + " not " + filename + ". Re-name it " + "or change your code.");
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if ((stream = new FileInputStream(file)) != null) {
                    return stream;
                }
            }
            catch (IOException file) {
            }
            catch (SecurityException file) {
                // empty catch block
            }
        }
        try {
            try {
                try {
                    stream = new FileInputStream(this.dataPath(filename));
                    if (stream != null) {
                        return stream;
                    }
                }
                catch (IOException file) {
                    // empty catch block
                }
                try {
                    stream = new FileInputStream(this.sketchPath(filename));
                    if (stream != null) {
                        return stream;
                    }
                }
                catch (Exception file) {
                    // empty catch block
                }
                try {
                    stream = new FileInputStream(filename);
                    if (stream != null) {
                        return stream;
                    }
                }
                catch (IOException file) {
                }
            }
            catch (SecurityException file) {}
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static InputStream openStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (IOException e) {
            if (file == null) {
                throw new RuntimeException("File passed to openStream() was null");
            }
            e.printStackTrace();
            throw new RuntimeException("Couldn't openStream() for " + file.getAbsolutePath());
        }
    }

    public InputStream openStreamGZ(String filename) {
        try {
            return new GZIPInputStream(this.openStream(filename));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Couldn't openStreamGZ() for " + filename);
        }
    }

    public static InputStream openStreamGZ(File file) {
        try {
            return new GZIPInputStream(PApplet.openStream(file));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Couldn't openStreamGZ() for " + file.getAbsolutePath());
        }
    }

    public byte[] loadBytes(String filename) {
        InputStream is = this.openStream(filename);
        if (is != null) {
            return PApplet.loadBytes(is);
        }
        System.err.println("The file \"" + filename + "\" " + "is missing or inaccessible, make sure " + "the URL is valid or that the file has been " + "added to your sketch and is readable.");
        return null;
    }

    public static byte[] loadBytes(InputStream input) {
        try {
            BufferedInputStream bis = new BufferedInputStream(input);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int c = bis.read();
            while (c != -1) {
                out.write(c);
                c = bis.read();
            }
            return out.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String[] loadStrings(File file) {
        InputStream is = PApplet.openStream(file);
        if (is != null) {
            return PApplet.loadStrings(is);
        }
        return null;
    }

    public String[] loadStrings(String filename) {
        InputStream is = this.openStream(filename);
        if (is != null) {
            return PApplet.loadStrings(is);
        }
        System.err.println("The file \"" + filename + "\" " + "is missing or inaccessible, make sure " + "the URL is valid or that the file has been " + "added to your sketch and is readable.");
        return null;
    }

    public static String[] loadStrings(InputStream input) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            String[] lines = new String[100];
            int lineCount = 0;
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (lineCount == lines.length) {
                    String[] temp = new String[lineCount << 1];
                    System.arraycopy(lines, 0, temp, 0, lineCount);
                    lines = temp;
                }
                lines[lineCount++] = line;
            }
            reader.close();
            if (lineCount == lines.length) {
                return lines;
            }
            String[] output = new String[lineCount];
            System.arraycopy(lines, 0, output, 0, lineCount);
            return output;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void saveStream(String filename, String stream) {
        this.saveBytes(filename, this.loadBytes(stream));
    }

    public void saveStream(File file, String stream) {
        PApplet.saveBytes(file, this.loadBytes(stream));
    }

    public void saveBytes(String filename, byte[] buffer) {
        try {
            String location = this.savePath(filename);
            FileOutputStream fos = new FileOutputStream(location);
            PApplet.saveBytes(fos, buffer);
            fos.close();
        }
        catch (IOException e) {
            System.err.println("error saving bytes to " + filename);
            e.printStackTrace();
        }
    }

    public static void saveBytes(File file, byte[] buffer) {
        try {
            String filename = file.getAbsolutePath();
            PApplet.createPath(filename);
            FileOutputStream fos = new FileOutputStream(file);
            PApplet.saveBytes(fos, buffer);
            fos.close();
        }
        catch (IOException e) {
            System.err.println("error saving bytes to " + file);
            e.printStackTrace();
        }
    }

    public static void saveBytes(OutputStream output, byte[] buffer) {
        try {
            output.write(buffer);
            output.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Couldn't save bytes");
        }
    }

    public void saveStrings(String filename, String[] strings) {
        try {
            String location = this.savePath(filename);
            FileOutputStream fos = new FileOutputStream(location);
            PApplet.saveStrings(fos, strings);
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("saveStrings() failed: " + e.getMessage());
        }
    }

    public static void saveStrings(File file, String[] strings) {
        try {
            String location = file.getAbsolutePath();
            PApplet.createPath(location);
            FileOutputStream fos = new FileOutputStream(location);
            PApplet.saveStrings(fos, strings);
            fos.close();
        }
        catch (IOException e) {
            System.err.println("error while saving strings");
            e.printStackTrace();
        }
    }

    public static void saveStrings(OutputStream output, String[] strings) {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(output));
        int i = 0;
        while (i < strings.length) {
            writer.println(strings[i]);
            ++i;
        }
        writer.flush();
    }

    public String sketchPath(String where) {
        if (this.sketchPath == null) {
            throw new RuntimeException("The applet was not inited properly, or security restrictions prevented it from determining its path.");
        }
        try {
            if (new File(where).isAbsolute()) {
                return where;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.valueOf(this.sketchPath) + File.separator + where;
    }

    public String savePath(String where) {
        String filename = this.sketchPath(where);
        PApplet.createPath(filename);
        return filename;
    }

    public String dataPath(String where) {
        if (new File(where).isAbsolute()) {
            return where;
        }
        return String.valueOf(this.sketchPath) + File.separator + "data" + File.separator + where;
    }

    public static void createPath(String filename) {
        File unit;
        File file = new File(filename);
        String parent = file.getParent();
        if (parent != null && !(unit = new File(parent)).exists()) {
            unit.mkdirs();
        }
    }

    public byte[] sort(byte[] what) {
        return this.sort(what, what.length);
    }

    public char[] sort(char[] what) {
        return this.sort(what, what.length);
    }

    public int[] sort(int[] what) {
        return this.sort(what, what.length);
    }

    public float[] sort(float[] what) {
        return this.sort(what, what.length);
    }

    public String[] sort(String[] what) {
        return this.sort(what, what.length);
    }

    public byte[] sort(byte[] what, int count) {
        if (count == 0) {
            return null;
        }
        this.sort_mode = 1;
        this.sort_bytes = new byte[count];
        System.arraycopy(what, 0, this.sort_bytes, 0, count);
        this.sort_internal(0, count - 1);
        return this.sort_bytes;
    }

    public char[] sort(char[] what, int count) {
        if (count == 0) {
            return null;
        }
        this.sort_mode = 2;
        this.sort_chars = new char[count];
        System.arraycopy(what, 0, this.sort_chars, 0, count);
        this.sort_internal(0, count - 1);
        return this.sort_chars;
    }

    public int[] sort(int[] what, int count) {
        if (count == 0) {
            return null;
        }
        this.sort_mode = 3;
        this.sort_ints = new int[count];
        System.arraycopy(what, 0, this.sort_ints, 0, count);
        this.sort_internal(0, count - 1);
        return this.sort_ints;
    }

    public float[] sort(float[] what, int count) {
        if (count == 0) {
            return null;
        }
        this.sort_mode = 4;
        this.sort_floats = new float[count];
        System.arraycopy(what, 0, this.sort_floats, 0, count);
        this.sort_internal(0, count - 1);
        return this.sort_floats;
    }

    public String[] sort(String[] what, int count) {
        if (count == 0) {
            return null;
        }
        this.sort_mode = 5;
        this.sort_strings = new String[count];
        System.arraycopy(what, 0, this.sort_strings, 0, count);
        this.sort_internal(0, count - 1);
        return this.sort_strings;
    }

    protected void sort_internal(int i, int j) {
        int pivotIndex = (i + j) / 2;
        this.sort_swap(pivotIndex, j);
        int k = this.sort_partition(i - 1, j);
        this.sort_swap(k, j);
        if (k - i > 1) {
            this.sort_internal(i, k - 1);
        }
        if (j - k > 1) {
            this.sort_internal(k + 1, j);
        }
    }

    protected int sort_partition(int left, int right) {
        int pivot = right;
        while (true) {
            if (this.sort_compare(++left, pivot) < 0.0f) {
                continue;
            }
            while (right != 0 && this.sort_compare(--right, pivot) > 0.0f) {
            }
            this.sort_swap(left, right);
            if (left >= right) break;
        }
        this.sort_swap(left, right);
        return left;
    }

    protected void sort_swap(int a, int b) {
        switch (this.sort_mode) {
            case 1: {
                byte btemp = this.sort_bytes[a];
                this.sort_bytes[a] = this.sort_bytes[b];
                this.sort_bytes[b] = btemp;
                break;
            }
            case 2: {
                char ctemp = this.sort_chars[a];
                this.sort_chars[a] = this.sort_chars[b];
                this.sort_chars[b] = ctemp;
                break;
            }
            case 3: {
                int itemp = this.sort_ints[a];
                this.sort_ints[a] = this.sort_ints[b];
                this.sort_ints[b] = itemp;
                break;
            }
            case 4: {
                float ftemp = this.sort_floats[a];
                this.sort_floats[a] = this.sort_floats[b];
                this.sort_floats[b] = ftemp;
                break;
            }
            case 5: {
                String stemp = this.sort_strings[a];
                this.sort_strings[a] = this.sort_strings[b];
                this.sort_strings[b] = stemp;
                break;
            }
            case 6: {
                try {
                    Object[] params = new Object[]{new Integer(a), new Integer(b)};
                    this.swapMethod.invoke(this.sortObject, params);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected float sort_compare(int a, int b) {
        switch (this.sort_mode) {
            case 1: {
                return this.sort_bytes[a] - this.sort_bytes[b];
            }
            case 2: {
                return this.sort_chars[a] - this.sort_chars[b];
            }
            case 3: {
                return this.sort_ints[a] - this.sort_ints[b];
            }
            case 4: {
                return this.sort_floats[a] - this.sort_floats[b];
            }
            case 5: {
                return this.sort_strings[a].compareTo(this.sort_strings[b]);
            }
            case 6: {
                try {
                    Object[] params = new Object[]{new Integer(a), new Integer(b)};
                    Float output = (Float)this.compareMethod.invoke(this.sortObject, params);
                    return output.floatValue();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return 0.0f;
    }

    public void sort(Object o, int count) {
        Class<?> c = o.getClass();
        try {
            Class[] params = new Class[]{Integer.TYPE, Integer.TYPE};
            this.compareMethod = c.getMethod("sortCompare", params);
            this.swapMethod = c.getMethod("sortSwap", params);
            this.sortObject = o;
            this.sort_mode = 6;
            this.sort_internal(0, count - 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void arraycopy(Object src, int srcPosition, Object dst, int dstPosition, int length) {
        System.arraycopy(src, srcPosition, dst, dstPosition, length);
    }

    public static void arraycopy(Object src, Object dst, int length) {
        System.arraycopy(src, 0, dst, 0, length);
    }

    public static void arraycopy(Object src, Object dst) {
        System.arraycopy(src, 0, dst, 0, Array.getLength(src));
    }

    public static boolean[] expand(boolean[] list) {
        return PApplet.expand(list, list.length << 1);
    }

    public static boolean[] expand(boolean[] list, int newSize) {
        boolean[] temp = new boolean[newSize];
        System.arraycopy(list, 0, temp, 0, Math.min(newSize, list.length));
        return temp;
    }

    public static byte[] expand(byte[] list) {
        return PApplet.expand(list, list.length << 1);
    }

    public static byte[] expand(byte[] list, int newSize) {
        byte[] temp = new byte[newSize];
        System.arraycopy(list, 0, temp, 0, Math.min(newSize, list.length));
        return temp;
    }

    public static char[] expand(char[] list) {
        return PApplet.expand(list, list.length << 1);
    }

    public static char[] expand(char[] list, int newSize) {
        char[] temp = new char[newSize];
        System.arraycopy(list, 0, temp, 0, Math.min(newSize, list.length));
        return temp;
    }

    public static int[] expand(int[] list) {
        return PApplet.expand(list, list.length << 1);
    }

    public static int[] expand(int[] list, int newSize) {
        int[] temp = new int[newSize];
        System.arraycopy(list, 0, temp, 0, Math.min(newSize, list.length));
        return temp;
    }

    public static float[] expand(float[] list) {
        return PApplet.expand(list, list.length << 1);
    }

    public static float[] expand(float[] list, int newSize) {
        float[] temp = new float[newSize];
        System.arraycopy(list, 0, temp, 0, Math.min(newSize, list.length));
        return temp;
    }

    public static String[] expand(String[] list) {
        return PApplet.expand(list, list.length << 1);
    }

    public static String[] expand(String[] list, int newSize) {
        String[] temp = new String[newSize];
        System.arraycopy(list, 0, temp, 0, Math.min(newSize, list.length));
        return temp;
    }

    public static Object expand(Object array) {
        return PApplet.expand(array, Array.getLength(array) << 1);
    }

    public static Object expand(Object list, int newSize) {
        Class<?> type = list.getClass().getComponentType();
        Object temp = Array.newInstance(type, newSize);
        System.arraycopy(list, 0, temp, 0, Math.min(Array.getLength(list), newSize));
        return temp;
    }

    public static byte[] append(byte[] b, byte value) {
        b = PApplet.expand(b, b.length + 1);
        b[b.length - 1] = value;
        return b;
    }

    public static char[] append(char[] b, char value) {
        b = PApplet.expand(b, b.length + 1);
        b[b.length - 1] = value;
        return b;
    }

    public static int[] append(int[] b, int value) {
        b = PApplet.expand(b, b.length + 1);
        b[b.length - 1] = value;
        return b;
    }

    public static float[] append(float[] b, float value) {
        b = PApplet.expand(b, b.length + 1);
        b[b.length - 1] = value;
        return b;
    }

    public static String[] append(String[] b, String value) {
        b = PApplet.expand(b, b.length + 1);
        b[b.length - 1] = value;
        return b;
    }

    public static Object append(Object b, Object value) {
        int length = Array.getLength(b);
        b = PApplet.expand(b, length + 1);
        Array.set(b, length, value);
        return b;
    }

    public static boolean[] shorten(boolean[] list) {
        return PApplet.subset(list, 0, list.length - 1);
    }

    public static byte[] shorten(byte[] list) {
        return PApplet.subset(list, 0, list.length - 1);
    }

    public static char[] shorten(char[] list) {
        return PApplet.subset(list, 0, list.length - 1);
    }

    public static int[] shorten(int[] list) {
        return PApplet.subset(list, 0, list.length - 1);
    }

    public static float[] shorten(float[] list) {
        return PApplet.subset(list, 0, list.length - 1);
    }

    public static String[] shorten(String[] list) {
        return PApplet.subset(list, 0, list.length - 1);
    }

    public static Object shorten(Object list) {
        int length = Array.getLength(list);
        return PApplet.subset(list, 0, length - 1);
    }

    public static final boolean[] splice(boolean[] list, boolean v, int index) {
        boolean[] outgoing = new boolean[list.length + 1];
        System.arraycopy(list, 0, outgoing, 0, index);
        outgoing[index] = v;
        System.arraycopy(list, index, outgoing, index + 1, list.length - index);
        return outgoing;
    }

    public static final boolean[] splice(boolean[] list, boolean[] v, int index) {
        boolean[] outgoing = new boolean[list.length + v.length];
        System.arraycopy(list, 0, outgoing, 0, index);
        System.arraycopy(v, 0, outgoing, index, v.length);
        System.arraycopy(list, index, outgoing, index + v.length, list.length - index);
        return outgoing;
    }

    public static final byte[] splice(byte[] list, byte v, int index) {
        byte[] outgoing = new byte[list.length + 1];
        System.arraycopy(list, 0, outgoing, 0, index);
        outgoing[index] = v;
        System.arraycopy(list, index, outgoing, index + 1, list.length - index);
        return outgoing;
    }

    public static final byte[] splice(byte[] list, byte[] v, int index) {
        byte[] outgoing = new byte[list.length + v.length];
        System.arraycopy(list, 0, outgoing, 0, index);
        System.arraycopy(v, 0, outgoing, index, v.length);
        System.arraycopy(list, index, outgoing, index + v.length, list.length - index);
        return outgoing;
    }

    public static final char[] splice(char[] list, char v, int index) {
        char[] outgoing = new char[list.length + 1];
        System.arraycopy(list, 0, outgoing, 0, index);
        outgoing[index] = v;
        System.arraycopy(list, index, outgoing, index + 1, list.length - index);
        return outgoing;
    }

    public static final char[] splice(char[] list, char[] v, int index) {
        char[] outgoing = new char[list.length + v.length];
        System.arraycopy(list, 0, outgoing, 0, index);
        System.arraycopy(v, 0, outgoing, index, v.length);
        System.arraycopy(list, index, outgoing, index + v.length, list.length - index);
        return outgoing;
    }

    public static final int[] splice(int[] list, int v, int index) {
        int[] outgoing = new int[list.length + 1];
        System.arraycopy(list, 0, outgoing, 0, index);
        outgoing[index] = v;
        System.arraycopy(list, index, outgoing, index + 1, list.length - index);
        return outgoing;
    }

    public static final int[] splice(int[] list, int[] v, int index) {
        int[] outgoing = new int[list.length + v.length];
        System.arraycopy(list, 0, outgoing, 0, index);
        System.arraycopy(v, 0, outgoing, index, v.length);
        System.arraycopy(list, index, outgoing, index + v.length, list.length - index);
        return outgoing;
    }

    public static final float[] splice(float[] list, float v, int index) {
        float[] outgoing = new float[list.length + 1];
        System.arraycopy(list, 0, outgoing, 0, index);
        outgoing[index] = v;
        System.arraycopy(list, index, outgoing, index + 1, list.length - index);
        return outgoing;
    }

    public static final float[] splice(float[] list, float[] v, int index) {
        float[] outgoing = new float[list.length + v.length];
        System.arraycopy(list, 0, outgoing, 0, index);
        System.arraycopy(v, 0, outgoing, index, v.length);
        System.arraycopy(list, index, outgoing, index + v.length, list.length - index);
        return outgoing;
    }

    public static final String[] splice(String[] list, String v, int index) {
        String[] outgoing = new String[list.length + 1];
        System.arraycopy(list, 0, outgoing, 0, index);
        outgoing[index] = v;
        System.arraycopy(list, index, outgoing, index + 1, list.length - index);
        return outgoing;
    }

    public static final String[] splice(String[] list, String[] v, int index) {
        String[] outgoing = new String[list.length + v.length];
        System.arraycopy(list, 0, outgoing, 0, index);
        System.arraycopy(v, 0, outgoing, index, v.length);
        System.arraycopy(list, index, outgoing, index + v.length, list.length - index);
        return outgoing;
    }

    public static final Object splice(Object list, Object v, int index) {
        Object[] outgoing = null;
        int length = Array.getLength(list);
        if (list.getClass().getName().charAt(0) == '[') {
            int vlength = Array.getLength(v);
            outgoing = new Object[length + vlength];
            System.arraycopy(list, 0, outgoing, 0, index);
            System.arraycopy(v, 0, outgoing, index, vlength);
            System.arraycopy(list, index, outgoing, index + vlength, length - index);
        } else {
            outgoing = new Object[length + 1];
            System.arraycopy(list, 0, outgoing, 0, index);
            Array.set(outgoing, index, v);
            System.arraycopy(list, index, outgoing, index + 1, length - index);
        }
        return outgoing;
    }

    public static boolean[] subset(boolean[] list, int start) {
        return PApplet.subset(list, start, list.length - start);
    }

    public static boolean[] subset(boolean[] list, int start, int count) {
        boolean[] output = new boolean[count];
        System.arraycopy(list, start, output, 0, count);
        return output;
    }

    public static byte[] subset(byte[] list, int start) {
        return PApplet.subset(list, start, list.length - start);
    }

    public static byte[] subset(byte[] list, int start, int count) {
        byte[] output = new byte[count];
        System.arraycopy(list, start, output, 0, count);
        return output;
    }

    public static char[] subset(char[] list, int start) {
        return PApplet.subset(list, start, list.length - start);
    }

    public static char[] subset(char[] list, int start, int count) {
        char[] output = new char[count];
        System.arraycopy(list, start, output, 0, count);
        return output;
    }

    public static int[] subset(int[] list, int start) {
        return PApplet.subset(list, start, list.length - start);
    }

    public static int[] subset(int[] list, int start, int count) {
        int[] output = new int[count];
        System.arraycopy(list, start, output, 0, count);
        return output;
    }

    public static float[] subset(float[] list, int start) {
        return PApplet.subset(list, start, list.length - start);
    }

    public static float[] subset(float[] list, int start, int count) {
        float[] output = new float[count];
        System.arraycopy(list, start, output, 0, count);
        return output;
    }

    public static String[] subset(String[] list, int start) {
        return PApplet.subset(list, start, list.length - start);
    }

    public static String[] subset(String[] list, int start, int count) {
        String[] output = new String[count];
        System.arraycopy(list, start, output, 0, count);
        return output;
    }

    public static Object subset(Object list, int start) {
        int length = Array.getLength(list);
        int count = length - start;
        Class<?> type = list.getClass().getComponentType();
        Object outgoing = Array.newInstance(type, count);
        System.arraycopy(list, 0, outgoing, 0, count);
        return outgoing;
    }

    public static Object subset(Object list, int start, int count) {
        Class<?> type = list.getClass().getComponentType();
        Object outgoing = Array.newInstance(type, count);
        System.arraycopy(list, start, outgoing, 0, count);
        return outgoing;
    }

    public static boolean[] concat(boolean[] a, boolean[] b) {
        boolean[] c = new boolean[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static byte[] concat(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static char[] concat(char[] a, char[] b) {
        char[] c = new char[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static int[] concat(int[] a, int[] b) {
        int[] c = new int[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static float[] concat(float[] a, float[] b) {
        float[] c = new float[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static String[] concat(String[] a, String[] b) {
        String[] c = new String[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static Object concat(Object a, Object b) {
        Class<?> type = a.getClass().getComponentType();
        int alength = Array.getLength(a);
        int blength = Array.getLength(b);
        Object outgoing = Array.newInstance(type, alength + blength);
        System.arraycopy(a, 0, outgoing, 0, alength);
        System.arraycopy(b, 0, outgoing, alength, blength);
        return outgoing;
    }

    public static boolean[] reverse(boolean[] list) {
        boolean[] outgoing = new boolean[list.length];
        int length1 = list.length - 1;
        int i = 0;
        while (i < list.length) {
            outgoing[i] = list[length1 - i];
            ++i;
        }
        return outgoing;
    }

    public static byte[] reverse(byte[] list) {
        byte[] outgoing = new byte[list.length];
        int length1 = list.length - 1;
        int i = 0;
        while (i < list.length) {
            outgoing[i] = list[length1 - i];
            ++i;
        }
        return outgoing;
    }

    public static char[] reverse(char[] list) {
        char[] outgoing = new char[list.length];
        int length1 = list.length - 1;
        int i = 0;
        while (i < list.length) {
            outgoing[i] = list[length1 - i];
            ++i;
        }
        return outgoing;
    }

    public static int[] reverse(int[] list) {
        int[] outgoing = new int[list.length];
        int length1 = list.length - 1;
        int i = 0;
        while (i < list.length) {
            outgoing[i] = list[length1 - i];
            ++i;
        }
        return outgoing;
    }

    public static float[] reverse(float[] list) {
        float[] outgoing = new float[list.length];
        int length1 = list.length - 1;
        int i = 0;
        while (i < list.length) {
            outgoing[i] = list[length1 - i];
            ++i;
        }
        return outgoing;
    }

    public static String[] reverse(String[] list) {
        String[] outgoing = new String[list.length];
        int length1 = list.length - 1;
        int i = 0;
        while (i < list.length) {
            outgoing[i] = list[length1 - i];
            ++i;
        }
        return outgoing;
    }

    public static Object reverse(Object list) {
        Class<?> type = list.getClass().getComponentType();
        int length = Array.getLength(list);
        Object outgoing = Array.newInstance(type, length);
        int i = 0;
        while (i < length) {
            Array.set(outgoing, i, Array.get(list, length - 1 - i));
            ++i;
        }
        return outgoing;
    }

    public static String trim(String str) {
        return str.replace('\u00a0', ' ').trim();
    }

    public static String[] trim(String[] array) {
        String[] outgoing = new String[array.length];
        int i = 0;
        while (i < array.length) {
            outgoing[i] = array[i].replace('\u00a0', ' ').trim();
            ++i;
        }
        return outgoing;
    }

    public static String join(String[] str, char separator) {
        return PApplet.join(str, String.valueOf(separator));
    }

    public static String join(String[] str, String separator) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < str.length) {
            if (i != 0) {
                buffer.append(separator);
            }
            buffer.append(str[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static String[] splitTokens(String what) {
        return PApplet.splitTokens(what, " \t\n\r\f\u00a0");
    }

    public static String[] splitTokens(String what, String delim) {
        StringTokenizer toker = new StringTokenizer(what, delim);
        String[] pieces = new String[toker.countTokens()];
        int index = 0;
        while (toker.hasMoreTokens()) {
            pieces[index++] = toker.nextToken();
        }
        return pieces;
    }

    public static String[] split(String what, char delim) {
        if (what == null) {
            return null;
        }
        char[] chars = what.toCharArray();
        int splitCount = 0;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == delim) {
                ++splitCount;
            }
            ++i;
        }
        if (splitCount == 0) {
            String[] splits = new String[]{new String(what)};
            return splits;
        }
        String[] splits = new String[splitCount + 1];
        int splitIndex = 0;
        int startIndex = 0;
        int i2 = 0;
        while (i2 < chars.length) {
            if (chars[i2] == delim) {
                splits[splitIndex++] = new String(chars, startIndex, i2 - startIndex);
                startIndex = i2 + 1;
            }
            ++i2;
        }
        splits[splitIndex] = new String(chars, startIndex, chars.length - startIndex);
        return splits;
    }

    public static String[] split(String what, String delim) {
        return what.split(delim);
    }

    public static final boolean parseBoolean(int what) {
        return what != 0;
    }

    public static final boolean parseBoolean(String what) {
        return new Boolean(what);
    }

    public static final boolean[] parseBoolean(byte[] what) {
        boolean[] outgoing = new boolean[what.length];
        int i = 0;
        while (i < what.length) {
            outgoing[i] = what[i] != 0;
            ++i;
        }
        return outgoing;
    }

    public static final boolean[] parseBoolean(int[] what) {
        boolean[] outgoing = new boolean[what.length];
        int i = 0;
        while (i < what.length) {
            outgoing[i] = what[i] != 0;
            ++i;
        }
        return outgoing;
    }

    public static final boolean[] parseBoolean(String[] what) {
        boolean[] outgoing = new boolean[what.length];
        int i = 0;
        while (i < what.length) {
            outgoing[i] = new Boolean(what[i]);
            ++i;
        }
        return outgoing;
    }

    public static final byte parseByte(boolean what) {
        return what ? (byte)1 : 0;
    }

    public static final byte parseByte(char what) {
        return (byte)what;
    }

    public static final byte parseByte(int what) {
        return (byte)what;
    }

    public static final byte parseByte(float what) {
        return (byte)what;
    }

    public static final byte[] parseByte(boolean[] what) {
        byte[] outgoing = new byte[what.length];
        int i = 0;
        while (i < what.length) {
            outgoing[i] = what[i] ? (byte)1 : 0;
            ++i;
        }
        return outgoing;
    }

    public static final byte[] parseByte(char[] what) {
        byte[] outgoing = new byte[what.length];
        int i = 0;
        while (i < what.length) {
            outgoing[i] = (byte)what[i];
            ++i;
        }
        return outgoing;
    }

    public static final byte[] parseByte(int[] what) {
        byte[] outgoing = new byte[what.length];
        int i = 0;
        while (i < what.length) {
            outgoing[i] = (byte)what[i];
            ++i;
        }
        return outgoing;
    }

    public static final byte[] parseByte(float[] what) {
        byte[] outgoing = new byte[what.length];
        int i = 0;
        while (i < what.length) {
            outgoing[i] = (byte)what[i];
            ++i;
        }
        return outgoing;
    }

    public static final char parseChar(byte what) {
        return (char)(what & 0xFF);
    }

    public static final char parseChar(int what) {
        return (char)what;
    }

    public static final char[] parseChar(byte[] what) {
        char[] outgoing = new char[what.length];
        int i = 0;
        while (i < what.length) {
            outgoing[i] = (char)(what[i] & 0xFF);
            ++i;
        }
        return outgoing;
    }

    public static final char[] parseChar(int[] what) {
        char[] outgoing = new char[what.length];
        int i = 0;
        while (i < what.length) {
            outgoing[i] = (char)what[i];
            ++i;
        }
        return outgoing;
    }

    public static final int parseInt(boolean what) {
        return what ? 1 : 0;
    }

    public static final int parseInt(byte what) {
        return what & 0xFF;
    }

    public static final int parseInt(char what) {
        return what;
    }

    public static final int parseInt(float what) {
        return (int)what;
    }

    public static final int parseInt(String what) {
        return PApplet.parseInt(what, 0);
    }

    public static final int parseInt(String what, int otherwise) {
        try {
            int offset = what.indexOf(46);
            if (offset == -1) {
                return Integer.parseInt(what);
            }
            return Integer.parseInt(what.substring(0, offset));
        }
        catch (NumberFormatException numberFormatException) {
            return otherwise;
        }
    }

    public static final int[] parseInt(boolean[] what) {
        int[] list = new int[what.length];
        int i = 0;
        while (i < what.length) {
            list[i] = what[i] ? 1 : 0;
            ++i;
        }
        return list;
    }

    public static final int[] parseInt(byte[] what) {
        int[] list = new int[what.length];
        int i = 0;
        while (i < what.length) {
            list[i] = what[i] & 0xFF;
            ++i;
        }
        return list;
    }

    public static final int[] parseInt(char[] what) {
        int[] list = new int[what.length];
        int i = 0;
        while (i < what.length) {
            list[i] = what[i];
            ++i;
        }
        return list;
    }

    public static int[] parseInt(float[] what) {
        int[] inties = new int[what.length];
        int i = 0;
        while (i < what.length) {
            inties[i] = (int)what[i];
            ++i;
        }
        return inties;
    }

    public static int[] parseInt(String[] what) {
        return PApplet.parseInt(what, 0);
    }

    public static int[] parseInt(String[] what, int missing) {
        int[] output = new int[what.length];
        int i = 0;
        while (i < what.length) {
            try {
                output[i] = Integer.parseInt(what[i]);
            }
            catch (NumberFormatException e) {
                output[i] = missing;
            }
            ++i;
        }
        return output;
    }

    public static final float parseFloat(int what) {
        return what;
    }

    public static final float parseFloat(String what) {
        return PApplet.parseFloat(what, Float.NaN);
    }

    public static final float parseFloat(String what, float otherwise) {
        try {
            return new Float(what).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            return otherwise;
        }
    }

    public static final float[] parseByte(byte[] what) {
        float[] floaties = new float[what.length];
        int i = 0;
        while (i < what.length) {
            floaties[i] = what[i];
            ++i;
        }
        return floaties;
    }

    public static final float[] parseFloat(int[] what) {
        float[] floaties = new float[what.length];
        int i = 0;
        while (i < what.length) {
            floaties[i] = what[i];
            ++i;
        }
        return floaties;
    }

    public static final float[] parseFloat(String[] what) {
        return PApplet.parseFloat(what, 0.0f);
    }

    public static final float[] parseFloat(String[] what, float missing) {
        float[] output = new float[what.length];
        int i = 0;
        while (i < what.length) {
            try {
                output[i] = new Float(what[i]).floatValue();
            }
            catch (NumberFormatException e) {
                output[i] = missing;
            }
            ++i;
        }
        return output;
    }

    public static final String str(boolean x) {
        return String.valueOf(x);
    }

    public static final String str(byte x) {
        return String.valueOf(x);
    }

    public static final String str(char x) {
        return String.valueOf(x);
    }

    public static final String str(int x) {
        return String.valueOf(x);
    }

    public static final String str(float x) {
        return String.valueOf(x);
    }

    public static final String[] str(boolean[] x) {
        String[] s = new String[x.length];
        int i = 0;
        while (i < x.length) {
            s[i] = String.valueOf(x);
            ++i;
        }
        return s;
    }

    public static final String[] str(byte[] x) {
        String[] s = new String[x.length];
        int i = 0;
        while (i < x.length) {
            s[i] = String.valueOf(x);
            ++i;
        }
        return s;
    }

    public static final String[] str(char[] x) {
        String[] s = new String[x.length];
        int i = 0;
        while (i < x.length) {
            s[i] = String.valueOf(x);
            ++i;
        }
        return s;
    }

    public static final String[] str(int[] x) {
        String[] s = new String[x.length];
        int i = 0;
        while (i < x.length) {
            s[i] = String.valueOf(x);
            ++i;
        }
        return s;
    }

    public static final String[] str(float[] x) {
        String[] s = new String[x.length];
        int i = 0;
        while (i < x.length) {
            s[i] = String.valueOf(x);
            ++i;
        }
        return s;
    }

    public static String[] nf(int[] num, int digits) {
        String[] formatted = new String[num.length];
        int i = 0;
        while (i < formatted.length) {
            formatted[i] = PApplet.nf(num[i], digits);
            ++i;
        }
        return formatted;
    }

    public static String nf(int num, int digits) {
        if (int_nf != null && int_nf_digits == digits && !int_nf_commas) {
            return int_nf.format(num);
        }
        int_nf = NumberFormat.getInstance();
        int_nf.setGroupingUsed(false);
        int_nf_commas = false;
        int_nf.setMinimumIntegerDigits(digits);
        int_nf_digits = digits;
        return int_nf.format(num);
    }

    public static String[] nfc(int[] num) {
        String[] formatted = new String[num.length];
        int i = 0;
        while (i < formatted.length) {
            formatted[i] = PApplet.nfc(num[i]);
            ++i;
        }
        return formatted;
    }

    public static String nfc(int num) {
        if (int_nf != null && int_nf_digits == 0 && int_nf_commas) {
            return int_nf.format(num);
        }
        int_nf = NumberFormat.getInstance();
        int_nf.setGroupingUsed(true);
        int_nf_commas = true;
        int_nf.setMinimumIntegerDigits(0);
        int_nf_digits = 0;
        return int_nf.format(num);
    }

    public static String nfs(int num, int digits) {
        return num < 0 ? PApplet.nf(num, digits) : String.valueOf(' ') + PApplet.nf(num, digits);
    }

    public static String[] nfs(int[] num, int digits) {
        String[] formatted = new String[num.length];
        int i = 0;
        while (i < formatted.length) {
            formatted[i] = PApplet.nfs(num[i], digits);
            ++i;
        }
        return formatted;
    }

    public static String nfp(int num, int digits) {
        return num < 0 ? PApplet.nf(num, digits) : String.valueOf('+') + PApplet.nf(num, digits);
    }

    public static String[] nfp(int[] num, int digits) {
        String[] formatted = new String[num.length];
        int i = 0;
        while (i < formatted.length) {
            formatted[i] = PApplet.nfp(num[i], digits);
            ++i;
        }
        return formatted;
    }

    public static String[] nf(float[] num, int left, int right) {
        String[] formatted = new String[num.length];
        int i = 0;
        while (i < formatted.length) {
            formatted[i] = PApplet.nf(num[i], left, right);
            ++i;
        }
        return formatted;
    }

    public static String nf(float num, int left, int right) {
        if (float_nf != null && float_nf_left == left && float_nf_right == right && !float_nf_commas) {
            return float_nf.format(num);
        }
        float_nf = NumberFormat.getInstance();
        float_nf.setGroupingUsed(false);
        float_nf_commas = false;
        if (left != 0) {
            float_nf.setMinimumIntegerDigits(left);
        }
        if (right != 0) {
            float_nf.setMinimumFractionDigits(right);
            float_nf.setMaximumFractionDigits(right);
        }
        float_nf_left = left;
        float_nf_right = right;
        return float_nf.format(num);
    }

    public static String[] nfc(float[] num, int right) {
        String[] formatted = new String[num.length];
        int i = 0;
        while (i < formatted.length) {
            formatted[i] = PApplet.nfc(num[i], right);
            ++i;
        }
        return formatted;
    }

    public static String nfc(float num, int right) {
        if (float_nf != null && float_nf_left == 0 && float_nf_right == right && float_nf_commas) {
            return float_nf.format(num);
        }
        float_nf = NumberFormat.getInstance();
        float_nf.setGroupingUsed(true);
        float_nf_commas = true;
        if (right != 0) {
            float_nf.setMinimumFractionDigits(right);
            float_nf.setMaximumFractionDigits(right);
        }
        float_nf_left = 0;
        float_nf_right = right;
        return float_nf.format(num);
    }

    public static String[] nfs(float[] num, int left, int right) {
        String[] formatted = new String[num.length];
        int i = 0;
        while (i < formatted.length) {
            formatted[i] = PApplet.nfs(num[i], left, right);
            ++i;
        }
        return formatted;
    }

    public static String nfs(float num, int left, int right) {
        return num < 0.0f ? PApplet.nf(num, left, right) : String.valueOf(' ') + PApplet.nf(num, left, right);
    }

    public static String[] nfp(float[] num, int left, int right) {
        String[] formatted = new String[num.length];
        int i = 0;
        while (i < formatted.length) {
            formatted[i] = PApplet.nfp(num[i], left, right);
            ++i;
        }
        return formatted;
    }

    public static String nfp(float num, int left, int right) {
        return num < 0.0f ? PApplet.nf(num, left, right) : String.valueOf('+') + PApplet.nf(num, left, right);
    }

    public static final String hex(byte what) {
        return PApplet.hex(what, 2);
    }

    public static final String hex(char what) {
        return PApplet.hex(what, 4);
    }

    public static final String hex(int what) {
        return PApplet.hex(what, 8);
    }

    public static final String hex(int what, int digits) {
        String stuff = Integer.toHexString(what).toUpperCase();
        int length = stuff.length();
        if (length > digits) {
            return stuff.substring(length - digits);
        }
        if (length < digits) {
            return String.valueOf("00000000".substring(8 - (digits - length))) + stuff;
        }
        return stuff;
    }

    public static final int unhex(String what) {
        return (int)Long.parseLong(what, 16);
    }

    public static final String binary(byte what) {
        return PApplet.binary(what, 8);
    }

    public static final String binary(char what) {
        return PApplet.binary(what, 16);
    }

    public static final String binary(int what) {
        return Integer.toBinaryString(what);
    }

    public static final String binary(int what, int digits) {
        String stuff = Integer.toBinaryString(what);
        int length = stuff.length();
        if (length > digits) {
            return stuff.substring(length - digits);
        }
        if (length < digits) {
            int offset = 32 - (digits - length);
            return String.valueOf("00000000000000000000000000000000".substring(offset)) + stuff;
        }
        return stuff;
    }

    public static final int unbinary(String what) {
        return Integer.parseInt(what, 2);
    }

    public final int color(int gray) {
        if (this.g == null) {
            if (gray > 255) {
                gray = 255;
            } else if (gray < 0) {
                gray = 0;
            }
            return 0xFF000000 | gray << 16 | gray << 8 | gray;
        }
        return this.g.color(gray);
    }

    public final int color(float fgray) {
        if (this.g == null) {
            int gray = (int)fgray;
            if (gray > 255) {
                gray = 255;
            } else if (gray < 0) {
                gray = 0;
            }
            return 0xFF000000 | gray << 16 | gray << 8 | gray;
        }
        return this.g.color(fgray);
    }

    public final int color(int gray, int alpha) {
        if (this.g == null) {
            if (alpha > 255) {
                alpha = 255;
            } else if (alpha < 0) {
                alpha = 0;
            }
            if (gray > 255) {
                return alpha << 24 | gray & 0xFFFFFF;
            }
            return alpha << 24 | gray << 16 | gray << 8 | gray;
        }
        return this.g.color(gray, alpha);
    }

    public final int color(float fgray, float falpha) {
        if (this.g == null) {
            int gray = (int)fgray;
            int alpha = (int)falpha;
            if (gray > 255) {
                gray = 255;
            } else if (gray < 0) {
                gray = 0;
            }
            if (alpha > 255) {
                alpha = 255;
            } else if (alpha < 0) {
                alpha = 0;
            }
            return 0xFF000000 | gray << 16 | gray << 8 | gray;
        }
        return this.g.color(fgray, falpha);
    }

    public final int color(int x, int y, int z) {
        if (this.g == null) {
            if (x > 255) {
                x = 255;
            } else if (x < 0) {
                x = 0;
            }
            if (y > 255) {
                y = 255;
            } else if (y < 0) {
                y = 0;
            }
            if (z > 255) {
                z = 255;
            } else if (z < 0) {
                z = 0;
            }
            return 0xFF000000 | x << 16 | y << 8 | z;
        }
        return this.g.color(x, y, z);
    }

    public final int color(float x, float y, float z) {
        if (this.g == null) {
            if (x > 255.0f) {
                x = 255.0f;
            } else if (x < 0.0f) {
                x = 0.0f;
            }
            if (y > 255.0f) {
                y = 255.0f;
            } else if (y < 0.0f) {
                y = 0.0f;
            }
            if (z > 255.0f) {
                z = 255.0f;
            } else if (z < 0.0f) {
                z = 0.0f;
            }
            return 0xFF000000 | (int)x << 16 | (int)y << 8 | (int)z;
        }
        return this.g.color(x, y, z);
    }

    public final int color(int x, int y, int z, int a) {
        if (this.g == null) {
            if (a > 255) {
                a = 255;
            } else if (a < 0) {
                a = 0;
            }
            if (x > 255) {
                x = 255;
            } else if (x < 0) {
                x = 0;
            }
            if (y > 255) {
                y = 255;
            } else if (y < 0) {
                y = 0;
            }
            if (z > 255) {
                z = 255;
            } else if (z < 0) {
                z = 0;
            }
            return a << 24 | x << 16 | y << 8 | z;
        }
        return this.g.color(x, y, z, a);
    }

    public final int color(float x, float y, float z, float a) {
        if (this.g == null) {
            if (a > 255.0f) {
                a = 255.0f;
            } else if (a < 0.0f) {
                a = 0.0f;
            }
            if (x > 255.0f) {
                x = 255.0f;
            } else if (x < 0.0f) {
                x = 0.0f;
            }
            if (y > 255.0f) {
                y = 255.0f;
            } else if (y < 0.0f) {
                y = 0.0f;
            }
            if (z > 255.0f) {
                z = 255.0f;
            } else if (z < 0.0f) {
                z = 0.0f;
            }
            return (int)a << 24 | (int)x << 16 | (int)y << 8 | (int)z;
        }
        return this.g.color(x, y, z, a);
    }

    public void setupExternalMessages() {
        this.frame.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent e) {
                Point where = ((Frame)e.getSource()).getLocation();
                System.err.println("__MOVE__ " + where.x + " " + where.y);
                System.err.flush();
            }
        });
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.err.println(PApplet.EXTERNAL_QUIT);
                System.err.flush();
                System.exit(0);
            }
        });
    }

    public void setupFrameResizeListener() {
        this.frame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                Frame farm;
                if (PApplet.this.frame.isResizable() && (farm = (Frame)e.getComponent()).isVisible()) {
                    Insets insets = farm.getInsets();
                    Dimension windowSize = farm.getSize();
                    int usableW = windowSize.width - insets.left - insets.right;
                    int usableH = windowSize.height - insets.top - insets.bottom;
                    PApplet.this.setBounds(insets.left, insets.top, usableW, usableH);
                }
            }
        });
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: PApplet <appletname>");
            System.err.println("For additional options, see the javadoc for PApplet");
            System.exit(1);
        }
        try {
            boolean external = false;
            int[] location = null;
            int[] editorLocation = null;
            String name = null;
            boolean present = false;
            Color backgroundColor = Color.black;
            Color stopColor = Color.gray;
            GraphicsDevice displayDevice = null;
            boolean hideStop = false;
            String param = null;
            String value = null;
            String folder = null;
            try {
                folder = System.getProperty("user.dir");
            }
            catch (Exception exception) {
                // empty catch block
            }
            int argIndex = 0;
            while (argIndex < args.length) {
                block37: {
                    block35: {
                        block41: {
                            block40: {
                                block39: {
                                    block38: {
                                        block36: {
                                            int equals = args[argIndex].indexOf(61);
                                            if (equals == -1) break block35;
                                            param = args[argIndex].substring(0, equals);
                                            value = args[argIndex].substring(equals + 1);
                                            if (!param.equals(ARGS_EDITOR_LOCATION)) break block36;
                                            external = true;
                                            editorLocation = PApplet.parseInt(PApplet.split(value, ','));
                                            break block37;
                                        }
                                        if (!param.equals(ARGS_DISPLAY)) break block38;
                                        int deviceIndex = Integer.parseInt(value) - 1;
                                        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                                        GraphicsDevice[] devices = environment.getScreenDevices();
                                        if (deviceIndex >= 0 && deviceIndex < devices.length) {
                                            displayDevice = devices[deviceIndex];
                                        } else {
                                            System.err.println("Display " + value + " does not exist, " + "using the default display instead.");
                                        }
                                        break block37;
                                    }
                                    if (!param.equals(ARGS_BGCOLOR)) break block39;
                                    if (value.charAt(0) == '#') {
                                        value = value.substring(1);
                                    }
                                    backgroundColor = new Color(Integer.parseInt(value, 16));
                                    break block37;
                                }
                                if (!param.equals(ARGS_STOP_COLOR)) break block40;
                                if (value.charAt(0) == '#') {
                                    value = value.substring(1);
                                }
                                stopColor = new Color(Integer.parseInt(value, 16));
                                break block37;
                            }
                            if (!param.equals(ARGS_SKETCH_FOLDER)) break block41;
                            folder = value;
                            break block37;
                        }
                        if (!param.equals(ARGS_LOCATION)) break block37;
                        location = PApplet.parseInt(PApplet.split(value, ','));
                        break block37;
                    }
                    if (args[argIndex].equals(ARGS_PRESENT)) {
                        present = true;
                    } else if (args[argIndex].equals(ARGS_HIDE_STOP)) {
                        hideStop = true;
                    } else if (args[argIndex].equals(ARGS_EXTERNAL)) {
                        external = true;
                    } else {
                        name = args[argIndex];
                        break;
                    }
                }
                ++argIndex;
            }
            if (displayDevice == null) {
                GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                displayDevice = environment.getDefaultScreenDevice();
            }
            Frame frame = new Frame(displayDevice.getDefaultConfiguration());
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            frame.setResizable(false);
            Class<?> c = Class.forName(name);
            PApplet applet = (PApplet)c.newInstance();
            applet.frame = frame;
            applet.sketchPath = folder;
            applet.args = PApplet.subset(args, 1);
            applet.init();
            while (applet.defaultSize && !applet.finished) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (present) {
                frame.setUndecorated(true);
                frame.setBackground(backgroundColor);
                displayDevice.setFullScreenWindow(frame);
                frame.add(applet);
                Dimension fullscreen = frame.getSize();
                applet.setBounds((fullscreen.width - applet.width) / 2, (fullscreen.height - applet.height) / 2, applet.width, applet.height);
                if (!hideStop) {
                    Label label = new Label("stop");
                    label.setForeground(stopColor);
                    label.addMouseListener(new MouseAdapter(){

                        public void mousePressed(MouseEvent e) {
                            System.exit(0);
                        }
                    });
                    frame.add(label);
                    Dimension labelSize = label.getPreferredSize();
                    labelSize = new Dimension(100, labelSize.height);
                    label.setSize(labelSize);
                    label.setLocation(20, fullscreen.height - labelSize.height - 20);
                }
                if (external) {
                    applet.setupExternalMessages();
                }
            } else {
                frame.pack();
                Insets insets = frame.getInsets();
                int windowW = Math.max(applet.width, 128) + insets.left + insets.right;
                int windowH = Math.max(applet.height, 128) + insets.top + insets.bottom;
                frame.setSize(windowW, windowH);
                if (location != null) {
                    frame.setLocation(location[0], location[1]);
                } else if (external) {
                    int locationX = editorLocation[0] - 20;
                    int locationY = editorLocation[1];
                    if (locationX - windowW > 10) {
                        frame.setLocation(locationX - windowW, locationY);
                    } else {
                        locationX = editorLocation[0] + 66;
                        locationY = editorLocation[1] + 66;
                        if (locationX + windowW > screen.width - 33 || locationY + windowH > screen.height - 33) {
                            locationX = (screen.width - windowW) / 2;
                            locationY = (screen.height - windowH) / 2;
                        }
                        frame.setLocation(locationX, locationY);
                    }
                } else {
                    frame.setLocation((screen.width - applet.width) / 2, (screen.height - applet.height) / 2);
                }
                frame.setLayout(null);
                frame.add(applet);
                if (backgroundColor == Color.black) {
                    backgroundColor = SystemColor.control;
                }
                frame.setBackground(backgroundColor);
                int usableWindowH = windowH - insets.top - insets.bottom;
                applet.setBounds((windowW - applet.width) / 2, insets.top + (usableWindowH - applet.height) / 2, applet.width, applet.height);
                if (external) {
                    applet.setupExternalMessages();
                } else {
                    frame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent e) {
                            System.exit(0);
                        }
                    });
                }
                applet.setupFrameResizeListener();
                if (applet.displayable()) {
                    frame.setVisible(true);
                }
            }
            applet.requestFocus();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public PGraphics beginRecord(String renderer, String filename) {
        filename = this.insertFrame(filename);
        PGraphics rec = this.createGraphics(this.width, this.height, renderer, filename);
        this.beginRecord(rec);
        return rec;
    }

    public void beginRecord(PGraphics recorder) {
        this.recorder = recorder;
        recorder.beginDraw();
    }

    public void endRecord() {
        if (this.recorder != null) {
            this.recorder.endDraw();
            this.recorder.dispose();
            this.recorder = null;
        }
    }

    public PGraphics beginRaw(String renderer, String filename) {
        filename = this.insertFrame(filename);
        PGraphics rec = this.createGraphics(this.width, this.height, renderer, filename);
        this.g.beginRaw(rec);
        return rec;
    }

    public String insertFrame(String what) {
        int first = what.indexOf(35);
        int last = what.lastIndexOf(35);
        if (first != -1 && last - first > 0) {
            String prefix = what.substring(0, first);
            int count = last - first + 1;
            String suffix = what.substring(last + 1);
            return String.valueOf(prefix) + PApplet.nf(this.frameCount, count) + suffix;
        }
        return what;
    }

    public void loadPixels() {
        this.g.loadPixels();
        this.pixels = this.g.pixels;
    }

    public void imageMode(int mode) {
        if (this.recorder != null) {
            this.recorder.imageMode(mode);
        }
        this.g.imageMode(mode);
    }

    public void smooth() {
        if (this.recorder != null) {
            this.recorder.smooth();
        }
        this.g.smooth();
    }

    public void noSmooth() {
        if (this.recorder != null) {
            this.recorder.noSmooth();
        }
        this.g.noSmooth();
    }

    public void updatePixels() {
        if (this.recorder != null) {
            this.recorder.updatePixels();
        }
        this.g.updatePixels();
    }

    public void updatePixels(int x1, int y1, int x2, int y2) {
        if (this.recorder != null) {
            this.recorder.updatePixels(x1, y1, x2, y2);
        }
        this.g.updatePixels(x1, y1, x2, y2);
    }

    public int get(int x, int y) {
        return this.g.get(x, y);
    }

    public PImage get(int x, int y, int w, int h) {
        return this.g.get(x, y, w, h);
    }

    public PImage get() {
        return this.g.get();
    }

    public void set(int x, int y, int c) {
        if (this.recorder != null) {
            this.recorder.set(x, y, c);
        }
        this.g.set(x, y, c);
    }

    public void set(int dx, int dy, PImage src) {
        if (this.recorder != null) {
            this.recorder.set(dx, dy, src);
        }
        this.g.set(dx, dy, src);
    }

    public void mask(int[] alpha) {
        if (this.recorder != null) {
            this.recorder.mask(alpha);
        }
        this.g.mask(alpha);
    }

    public void mask(PImage alpha) {
        if (this.recorder != null) {
            this.recorder.mask(alpha);
        }
        this.g.mask(alpha);
    }

    public void filter(int kind) {
        if (this.recorder != null) {
            this.recorder.filter(kind);
        }
        this.g.filter(kind);
    }

    public void filter(int kind, float param) {
        if (this.recorder != null) {
            this.recorder.filter(kind, param);
        }
        this.g.filter(kind, param);
    }

    public void copy(int sx1, int sy1, int sx2, int sy2, int dx1, int dy1, int dx2, int dy2) {
        if (this.recorder != null) {
            this.recorder.copy(sx1, sy1, sx2, sy2, dx1, dy1, dx2, dy2);
        }
        this.g.copy(sx1, sy1, sx2, sy2, dx1, dy1, dx2, dy2);
    }

    public void copy(PImage src, int sx1, int sy1, int sx2, int sy2, int dx1, int dy1, int dx2, int dy2) {
        if (this.recorder != null) {
            this.recorder.copy(src, sx1, sy1, sx2, sy2, dx1, dy1, dx2, dy2);
        }
        this.g.copy(src, sx1, sy1, sx2, sy2, dx1, dy1, dx2, dy2);
    }

    public static int blendColor(int c1, int c2, int mode) {
        return PGraphics.blendColor(c1, c2, mode);
    }

    public void blend(int sx1, int sy1, int sx2, int sy2, int dx1, int dy1, int dx2, int dy2, int mode) {
        if (this.recorder != null) {
            this.recorder.blend(sx1, sy1, sx2, sy2, dx1, dy1, dx2, dy2, mode);
        }
        this.g.blend(sx1, sy1, sx2, sy2, dx1, dy1, dx2, dy2, mode);
    }

    public void blend(PImage src, int sx1, int sy1, int sx2, int sy2, int dx1, int dy1, int dx2, int dy2, int mode) {
        if (this.recorder != null) {
            this.recorder.blend(src, sx1, sy1, sx2, sy2, dx1, dy1, dx2, dy2, mode);
        }
        this.g.blend(src, sx1, sy1, sx2, sy2, dx1, dy1, dx2, dy2, mode);
    }

    public void hint(int which) {
        if (this.recorder != null) {
            this.recorder.hint(which);
        }
        this.g.hint(which);
    }

    public void noHint(int which) {
        if (this.recorder != null) {
            this.recorder.noHint(which);
        }
        this.g.noHint(which);
    }

    public void beginShape() {
        if (this.recorder != null) {
            this.recorder.beginShape();
        }
        this.g.beginShape();
    }

    public void beginShape(int kind) {
        if (this.recorder != null) {
            this.recorder.beginShape(kind);
        }
        this.g.beginShape(kind);
    }

    public void normal(float nx, float ny, float nz) {
        if (this.recorder != null) {
            this.recorder.normal(nx, ny, nz);
        }
        this.g.normal(nx, ny, nz);
    }

    public void textureMode(int mode) {
        if (this.recorder != null) {
            this.recorder.textureMode(mode);
        }
        this.g.textureMode(mode);
    }

    public void texture(PImage image) {
        if (this.recorder != null) {
            this.recorder.texture(image);
        }
        this.g.texture(image);
    }

    public void vertex(float x, float y) {
        if (this.recorder != null) {
            this.recorder.vertex(x, y);
        }
        this.g.vertex(x, y);
    }

    public void vertex(float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.vertex(x, y, z);
        }
        this.g.vertex(x, y, z);
    }

    public void vertex(float x, float y, float u, float v) {
        if (this.recorder != null) {
            this.recorder.vertex(x, y, u, v);
        }
        this.g.vertex(x, y, u, v);
    }

    public void vertex(float x, float y, float z, float u, float v) {
        if (this.recorder != null) {
            this.recorder.vertex(x, y, z, u, v);
        }
        this.g.vertex(x, y, z, u, v);
    }

    public void bezierVertex(float x2, float y2, float x3, float y3, float x4, float y4) {
        if (this.recorder != null) {
            this.recorder.bezierVertex(x2, y2, x3, y3, x4, y4);
        }
        this.g.bezierVertex(x2, y2, x3, y3, x4, y4);
    }

    public void bezierVertex(float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        if (this.recorder != null) {
            this.recorder.bezierVertex(x2, y2, z2, x3, y3, z3, x4, y4, z4);
        }
        this.g.bezierVertex(x2, y2, z2, x3, y3, z3, x4, y4, z4);
    }

    public void curveVertex(float x, float y) {
        if (this.recorder != null) {
            this.recorder.curveVertex(x, y);
        }
        this.g.curveVertex(x, y);
    }

    public void curveVertex(float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.curveVertex(x, y, z);
        }
        this.g.curveVertex(x, y, z);
    }

    public void breakShape() {
        if (this.recorder != null) {
            this.recorder.breakShape();
        }
        this.g.breakShape();
    }

    public final void endShape() {
        if (this.recorder != null) {
            this.recorder.endShape();
        }
        this.g.endShape();
    }

    public void endShape(int mode) {
        if (this.recorder != null) {
            this.recorder.endShape(mode);
        }
        this.g.endShape(mode);
    }

    public void point(float x, float y) {
        if (this.recorder != null) {
            this.recorder.point(x, y);
        }
        this.g.point(x, y);
    }

    public void point(float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.point(x, y, z);
        }
        this.g.point(x, y, z);
    }

    public void line(float x1, float y1, float x2, float y2) {
        if (this.recorder != null) {
            this.recorder.line(x1, y1, x2, y2);
        }
        this.g.line(x1, y1, x2, y2);
    }

    public void line(float x1, float y1, float z1, float x2, float y2, float z2) {
        if (this.recorder != null) {
            this.recorder.line(x1, y1, z1, x2, y2, z2);
        }
        this.g.line(x1, y1, z1, x2, y2, z2);
    }

    public void triangle(float x1, float y1, float x2, float y2, float x3, float y3) {
        if (this.recorder != null) {
            this.recorder.triangle(x1, y1, x2, y2, x3, y3);
        }
        this.g.triangle(x1, y1, x2, y2, x3, y3);
    }

    public void quad(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        if (this.recorder != null) {
            this.recorder.quad(x1, y1, x2, y2, x3, y3, x4, y4);
        }
        this.g.quad(x1, y1, x2, y2, x3, y3, x4, y4);
    }

    public void rectMode(int mode) {
        if (this.recorder != null) {
            this.recorder.rectMode(mode);
        }
        this.g.rectMode(mode);
    }

    public void rect(float x1, float y1, float x2, float y2) {
        if (this.recorder != null) {
            this.recorder.rect(x1, y1, x2, y2);
        }
        this.g.rect(x1, y1, x2, y2);
    }

    public void ellipseMode(int mode) {
        if (this.recorder != null) {
            this.recorder.ellipseMode(mode);
        }
        this.g.ellipseMode(mode);
    }

    public void ellipse(float a, float b, float c, float d) {
        if (this.recorder != null) {
            this.recorder.ellipse(a, b, c, d);
        }
        this.g.ellipse(a, b, c, d);
    }

    public void arc(float a, float b, float c, float d, float start, float stop) {
        if (this.recorder != null) {
            this.recorder.arc(a, b, c, d, start, stop);
        }
        this.g.arc(a, b, c, d, start, stop);
    }

    public void box(float size) {
        if (this.recorder != null) {
            this.recorder.box(size);
        }
        this.g.box(size);
    }

    public void box(float w, float h, float d) {
        if (this.recorder != null) {
            this.recorder.box(w, h, d);
        }
        this.g.box(w, h, d);
    }

    public void sphereDetail(int res) {
        if (this.recorder != null) {
            this.recorder.sphereDetail(res);
        }
        this.g.sphereDetail(res);
    }

    public void sphere(float r) {
        if (this.recorder != null) {
            this.recorder.sphere(r);
        }
        this.g.sphere(r);
    }

    public float bezierPoint(float a, float b, float c, float d, float t) {
        return this.g.bezierPoint(a, b, c, d, t);
    }

    public float bezierTangent(float a, float b, float c, float d, float t) {
        return this.g.bezierTangent(a, b, c, d, t);
    }

    public void bezierDetail(int detail) {
        if (this.recorder != null) {
            this.recorder.bezierDetail(detail);
        }
        this.g.bezierDetail(detail);
    }

    public void bezier(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        if (this.recorder != null) {
            this.recorder.bezier(x1, y1, x2, y2, x3, y3, x4, y4);
        }
        this.g.bezier(x1, y1, x2, y2, x3, y3, x4, y4);
    }

    public void bezier(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        if (this.recorder != null) {
            this.recorder.bezier(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4);
        }
        this.g.bezier(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4);
    }

    public float curvePoint(float a, float b, float c, float d, float t) {
        return this.g.curvePoint(a, b, c, d, t);
    }

    public float curveTangent(float a, float b, float c, float d, float t) {
        return this.g.curveTangent(a, b, c, d, t);
    }

    public void curveDetail(int detail) {
        if (this.recorder != null) {
            this.recorder.curveDetail(detail);
        }
        this.g.curveDetail(detail);
    }

    public void curveTightness(float tightness) {
        if (this.recorder != null) {
            this.recorder.curveTightness(tightness);
        }
        this.g.curveTightness(tightness);
    }

    public void curve(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        if (this.recorder != null) {
            this.recorder.curve(x1, y1, x2, y2, x3, y3, x4, y4);
        }
        this.g.curve(x1, y1, x2, y2, x3, y3, x4, y4);
    }

    public void curve(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        if (this.recorder != null) {
            this.recorder.curve(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4);
        }
        this.g.curve(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4);
    }

    public void image(PImage image, float x, float y) {
        if (this.recorder != null) {
            this.recorder.image(image, x, y);
        }
        this.g.image(image, x, y);
    }

    public void image(PImage image, float x, float y, float c, float d) {
        if (this.recorder != null) {
            this.recorder.image(image, x, y, c, d);
        }
        this.g.image(image, x, y, c, d);
    }

    public void image(PImage image, float a, float b, float c, float d, int u1, int v1, int u2, int v2) {
        if (this.recorder != null) {
            this.recorder.image(image, a, b, c, d, u1, v1, u2, v2);
        }
        this.g.image(image, a, b, c, d, u1, v1, u2, v2);
    }

    public void textAlign(int align) {
        if (this.recorder != null) {
            this.recorder.textAlign(align);
        }
        this.g.textAlign(align);
    }

    public void textAlign(int alignX, int alignY) {
        if (this.recorder != null) {
            this.recorder.textAlign(alignX, alignY);
        }
        this.g.textAlign(alignX, alignY);
    }

    public float textAscent() {
        return this.g.textAscent();
    }

    public float textDescent() {
        return this.g.textDescent();
    }

    public void textFont(PFont which) {
        if (this.recorder != null) {
            this.recorder.textFont(which);
        }
        this.g.textFont(which);
    }

    public void textFont(PFont which, float size) {
        if (this.recorder != null) {
            this.recorder.textFont(which, size);
        }
        this.g.textFont(which, size);
    }

    public void textLeading(float leading) {
        if (this.recorder != null) {
            this.recorder.textLeading(leading);
        }
        this.g.textLeading(leading);
    }

    public void textMode(int mode) {
        if (this.recorder != null) {
            this.recorder.textMode(mode);
        }
        this.g.textMode(mode);
    }

    public void textSize(float size) {
        if (this.recorder != null) {
            this.recorder.textSize(size);
        }
        this.g.textSize(size);
    }

    public float textWidth(char c) {
        return this.g.textWidth(c);
    }

    public float textWidth(String str) {
        return this.g.textWidth(str);
    }

    public void text(char c) {
        if (this.recorder != null) {
            this.recorder.text(c);
        }
        this.g.text(c);
    }

    public void text(char c, float x, float y) {
        if (this.recorder != null) {
            this.recorder.text(c, x, y);
        }
        this.g.text(c, x, y);
    }

    public void text(char c, float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.text(c, x, y, z);
        }
        this.g.text(c, x, y, z);
    }

    public void text(String str) {
        if (this.recorder != null) {
            this.recorder.text(str);
        }
        this.g.text(str);
    }

    public void text(String str, float x, float y) {
        if (this.recorder != null) {
            this.recorder.text(str, x, y);
        }
        this.g.text(str, x, y);
    }

    public void text(String str, float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.text(str, x, y, z);
        }
        this.g.text(str, x, y, z);
    }

    public void text(String str, float x1, float y1, float x2, float y2) {
        if (this.recorder != null) {
            this.recorder.text(str, x1, y1, x2, y2);
        }
        this.g.text(str, x1, y1, x2, y2);
    }

    public void text(String s, float x1, float y1, float x2, float y2, float z) {
        if (this.recorder != null) {
            this.recorder.text(s, x1, y1, x2, y2, z);
        }
        this.g.text(s, x1, y1, x2, y2, z);
    }

    public void text(int num, float x, float y) {
        if (this.recorder != null) {
            this.recorder.text(num, x, y);
        }
        this.g.text(num, x, y);
    }

    public void text(int num, float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.text(num, x, y, z);
        }
        this.g.text(num, x, y, z);
    }

    public void text(float num, float x, float y) {
        if (this.recorder != null) {
            this.recorder.text(num, x, y);
        }
        this.g.text(num, x, y);
    }

    public void text(float num, float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.text(num, x, y, z);
        }
        this.g.text(num, x, y, z);
    }

    public void translate(float tx, float ty) {
        if (this.recorder != null) {
            this.recorder.translate(tx, ty);
        }
        this.g.translate(tx, ty);
    }

    public void translate(float tx, float ty, float tz) {
        if (this.recorder != null) {
            this.recorder.translate(tx, ty, tz);
        }
        this.g.translate(tx, ty, tz);
    }

    public void rotate(float angle) {
        if (this.recorder != null) {
            this.recorder.rotate(angle);
        }
        this.g.rotate(angle);
    }

    public void rotateX(float angle) {
        if (this.recorder != null) {
            this.recorder.rotateX(angle);
        }
        this.g.rotateX(angle);
    }

    public void rotateY(float angle) {
        if (this.recorder != null) {
            this.recorder.rotateY(angle);
        }
        this.g.rotateY(angle);
    }

    public void rotateZ(float angle) {
        if (this.recorder != null) {
            this.recorder.rotateZ(angle);
        }
        this.g.rotateZ(angle);
    }

    public void rotate(float angle, float vx, float vy, float vz) {
        if (this.recorder != null) {
            this.recorder.rotate(angle, vx, vy, vz);
        }
        this.g.rotate(angle, vx, vy, vz);
    }

    public void scale(float s) {
        if (this.recorder != null) {
            this.recorder.scale(s);
        }
        this.g.scale(s);
    }

    public void scale(float sx, float sy) {
        if (this.recorder != null) {
            this.recorder.scale(sx, sy);
        }
        this.g.scale(sx, sy);
    }

    public void scale(float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.scale(x, y, z);
        }
        this.g.scale(x, y, z);
    }

    public void pushMatrix() {
        if (this.recorder != null) {
            this.recorder.pushMatrix();
        }
        this.g.pushMatrix();
    }

    public void popMatrix() {
        if (this.recorder != null) {
            this.recorder.popMatrix();
        }
        this.g.popMatrix();
    }

    public void resetMatrix() {
        if (this.recorder != null) {
            this.recorder.resetMatrix();
        }
        this.g.resetMatrix();
    }

    public void applyMatrix(float n00, float n01, float n02, float n10, float n11, float n12) {
        if (this.recorder != null) {
            this.recorder.applyMatrix(n00, n01, n02, n10, n11, n12);
        }
        this.g.applyMatrix(n00, n01, n02, n10, n11, n12);
    }

    public void applyMatrix(float n00, float n01, float n02, float n03, float n10, float n11, float n12, float n13, float n20, float n21, float n22, float n23, float n30, float n31, float n32, float n33) {
        if (this.recorder != null) {
            this.recorder.applyMatrix(n00, n01, n02, n03, n10, n11, n12, n13, n20, n21, n22, n23, n30, n31, n32, n33);
        }
        this.g.applyMatrix(n00, n01, n02, n03, n10, n11, n12, n13, n20, n21, n22, n23, n30, n31, n32, n33);
    }

    public void loadMatrix() {
        if (this.recorder != null) {
            this.recorder.loadMatrix();
        }
        this.g.loadMatrix();
    }

    public void printMatrix() {
        if (this.recorder != null) {
            this.recorder.printMatrix();
        }
        this.g.printMatrix();
    }

    public void beginCamera() {
        if (this.recorder != null) {
            this.recorder.beginCamera();
        }
        this.g.beginCamera();
    }

    public void endCamera() {
        if (this.recorder != null) {
            this.recorder.endCamera();
        }
        this.g.endCamera();
    }

    public void camera() {
        if (this.recorder != null) {
            this.recorder.camera();
        }
        this.g.camera();
    }

    public void camera(float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ) {
        if (this.recorder != null) {
            this.recorder.camera(eyeX, eyeY, eyeZ, centerX, centerY, centerZ, upX, upY, upZ);
        }
        this.g.camera(eyeX, eyeY, eyeZ, centerX, centerY, centerZ, upX, upY, upZ);
    }

    public void printCamera() {
        if (this.recorder != null) {
            this.recorder.printCamera();
        }
        this.g.printCamera();
    }

    public void ortho() {
        if (this.recorder != null) {
            this.recorder.ortho();
        }
        this.g.ortho();
    }

    public void ortho(float left, float right, float bottom, float top, float near, float far) {
        if (this.recorder != null) {
            this.recorder.ortho(left, right, bottom, top, near, far);
        }
        this.g.ortho(left, right, bottom, top, near, far);
    }

    public void perspective() {
        if (this.recorder != null) {
            this.recorder.perspective();
        }
        this.g.perspective();
    }

    public void perspective(float fovy, float aspect, float zNear, float zFar) {
        if (this.recorder != null) {
            this.recorder.perspective(fovy, aspect, zNear, zFar);
        }
        this.g.perspective(fovy, aspect, zNear, zFar);
    }

    public void frustum(float left, float right, float bottom, float top, float znear, float zfar) {
        if (this.recorder != null) {
            this.recorder.frustum(left, right, bottom, top, znear, zfar);
        }
        this.g.frustum(left, right, bottom, top, znear, zfar);
    }

    public void printProjection() {
        if (this.recorder != null) {
            this.recorder.printProjection();
        }
        this.g.printProjection();
    }

    public float screenX(float x, float y) {
        return this.g.screenX(x, y);
    }

    public float screenY(float x, float y) {
        return this.g.screenY(x, y);
    }

    public float screenX(float x, float y, float z) {
        return this.g.screenX(x, y, z);
    }

    public float screenY(float x, float y, float z) {
        return this.g.screenY(x, y, z);
    }

    public float screenZ(float x, float y, float z) {
        return this.g.screenZ(x, y, z);
    }

    public float modelX(float x, float y, float z) {
        return this.g.modelX(x, y, z);
    }

    public float modelY(float x, float y, float z) {
        return this.g.modelY(x, y, z);
    }

    public float modelZ(float x, float y, float z) {
        return this.g.modelZ(x, y, z);
    }

    public void colorMode(int mode) {
        if (this.recorder != null) {
            this.recorder.colorMode(mode);
        }
        this.g.colorMode(mode);
    }

    public void colorMode(int mode, float max) {
        if (this.recorder != null) {
            this.recorder.colorMode(mode, max);
        }
        this.g.colorMode(mode, max);
    }

    public void colorMode(int mode, float maxX, float maxY, float maxZ) {
        if (this.recorder != null) {
            this.recorder.colorMode(mode, maxX, maxY, maxZ);
        }
        this.g.colorMode(mode, maxX, maxY, maxZ);
    }

    public void colorMode(int mode, float maxX, float maxY, float maxZ, float maxA) {
        if (this.recorder != null) {
            this.recorder.colorMode(mode, maxX, maxY, maxZ, maxA);
        }
        this.g.colorMode(mode, maxX, maxY, maxZ, maxA);
    }

    public void strokeWeight(float weight) {
        if (this.recorder != null) {
            this.recorder.strokeWeight(weight);
        }
        this.g.strokeWeight(weight);
    }

    public void strokeJoin(int join) {
        if (this.recorder != null) {
            this.recorder.strokeJoin(join);
        }
        this.g.strokeJoin(join);
    }

    public void strokeCap(int cap) {
        if (this.recorder != null) {
            this.recorder.strokeCap(cap);
        }
        this.g.strokeCap(cap);
    }

    public void noStroke() {
        if (this.recorder != null) {
            this.recorder.noStroke();
        }
        this.g.noStroke();
    }

    public void stroke(int rgb) {
        if (this.recorder != null) {
            this.recorder.stroke(rgb);
        }
        this.g.stroke(rgb);
    }

    public void stroke(int rgb, float alpha) {
        if (this.recorder != null) {
            this.recorder.stroke(rgb, alpha);
        }
        this.g.stroke(rgb, alpha);
    }

    public void stroke(float gray) {
        if (this.recorder != null) {
            this.recorder.stroke(gray);
        }
        this.g.stroke(gray);
    }

    public void stroke(float gray, float alpha) {
        if (this.recorder != null) {
            this.recorder.stroke(gray, alpha);
        }
        this.g.stroke(gray, alpha);
    }

    public void stroke(float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.stroke(x, y, z);
        }
        this.g.stroke(x, y, z);
    }

    public void stroke(float x, float y, float z, float a) {
        if (this.recorder != null) {
            this.recorder.stroke(x, y, z, a);
        }
        this.g.stroke(x, y, z, a);
    }

    public void noTint() {
        if (this.recorder != null) {
            this.recorder.noTint();
        }
        this.g.noTint();
    }

    public void tint(int rgb) {
        if (this.recorder != null) {
            this.recorder.tint(rgb);
        }
        this.g.tint(rgb);
    }

    public void tint(int rgb, float alpha) {
        if (this.recorder != null) {
            this.recorder.tint(rgb, alpha);
        }
        this.g.tint(rgb, alpha);
    }

    public void tint(float gray) {
        if (this.recorder != null) {
            this.recorder.tint(gray);
        }
        this.g.tint(gray);
    }

    public void tint(float gray, float alpha) {
        if (this.recorder != null) {
            this.recorder.tint(gray, alpha);
        }
        this.g.tint(gray, alpha);
    }

    public void tint(float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.tint(x, y, z);
        }
        this.g.tint(x, y, z);
    }

    public void tint(float x, float y, float z, float a) {
        if (this.recorder != null) {
            this.recorder.tint(x, y, z, a);
        }
        this.g.tint(x, y, z, a);
    }

    public void noFill() {
        if (this.recorder != null) {
            this.recorder.noFill();
        }
        this.g.noFill();
    }

    public void fill(int rgb) {
        if (this.recorder != null) {
            this.recorder.fill(rgb);
        }
        this.g.fill(rgb);
    }

    public void fill(int rgb, float alpha) {
        if (this.recorder != null) {
            this.recorder.fill(rgb, alpha);
        }
        this.g.fill(rgb, alpha);
    }

    public void fill(float gray) {
        if (this.recorder != null) {
            this.recorder.fill(gray);
        }
        this.g.fill(gray);
    }

    public void fill(float gray, float alpha) {
        if (this.recorder != null) {
            this.recorder.fill(gray, alpha);
        }
        this.g.fill(gray, alpha);
    }

    public void fill(float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.fill(x, y, z);
        }
        this.g.fill(x, y, z);
    }

    public void fill(float x, float y, float z, float a) {
        if (this.recorder != null) {
            this.recorder.fill(x, y, z, a);
        }
        this.g.fill(x, y, z, a);
    }

    public void ambient(int rgb) {
        if (this.recorder != null) {
            this.recorder.ambient(rgb);
        }
        this.g.ambient(rgb);
    }

    public void ambient(float gray) {
        if (this.recorder != null) {
            this.recorder.ambient(gray);
        }
        this.g.ambient(gray);
    }

    public void ambient(float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.ambient(x, y, z);
        }
        this.g.ambient(x, y, z);
    }

    public void specular(int rgb) {
        if (this.recorder != null) {
            this.recorder.specular(rgb);
        }
        this.g.specular(rgb);
    }

    public void specular(float gray) {
        if (this.recorder != null) {
            this.recorder.specular(gray);
        }
        this.g.specular(gray);
    }

    public void specular(float gray, float alpha) {
        if (this.recorder != null) {
            this.recorder.specular(gray, alpha);
        }
        this.g.specular(gray, alpha);
    }

    public void specular(float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.specular(x, y, z);
        }
        this.g.specular(x, y, z);
    }

    public void specular(float x, float y, float z, float a) {
        if (this.recorder != null) {
            this.recorder.specular(x, y, z, a);
        }
        this.g.specular(x, y, z, a);
    }

    public void shininess(float shine) {
        if (this.recorder != null) {
            this.recorder.shininess(shine);
        }
        this.g.shininess(shine);
    }

    public void emissive(int rgb) {
        if (this.recorder != null) {
            this.recorder.emissive(rgb);
        }
        this.g.emissive(rgb);
    }

    public void emissive(float gray) {
        if (this.recorder != null) {
            this.recorder.emissive(gray);
        }
        this.g.emissive(gray);
    }

    public void emissive(float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.emissive(x, y, z);
        }
        this.g.emissive(x, y, z);
    }

    public void lights() {
        if (this.recorder != null) {
            this.recorder.lights();
        }
        this.g.lights();
    }

    public void ambientLight(float red, float green, float blue) {
        if (this.recorder != null) {
            this.recorder.ambientLight(red, green, blue);
        }
        this.g.ambientLight(red, green, blue);
    }

    public void ambientLight(float red, float green, float blue, float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.ambientLight(red, green, blue, x, y, z);
        }
        this.g.ambientLight(red, green, blue, x, y, z);
    }

    public void directionalLight(float red, float green, float blue, float nx, float ny, float nz) {
        if (this.recorder != null) {
            this.recorder.directionalLight(red, green, blue, nx, ny, nz);
        }
        this.g.directionalLight(red, green, blue, nx, ny, nz);
    }

    public void pointLight(float red, float green, float blue, float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.pointLight(red, green, blue, x, y, z);
        }
        this.g.pointLight(red, green, blue, x, y, z);
    }

    public void spotLight(float red, float green, float blue, float x, float y, float z, float nx, float ny, float nz, float angle, float concentration) {
        if (this.recorder != null) {
            this.recorder.spotLight(red, green, blue, x, y, z, nx, ny, nz, angle, concentration);
        }
        this.g.spotLight(red, green, blue, x, y, z, nx, ny, nz, angle, concentration);
    }

    public void lightFalloff(float constant, float linear, float quadratic) {
        if (this.recorder != null) {
            this.recorder.lightFalloff(constant, linear, quadratic);
        }
        this.g.lightFalloff(constant, linear, quadratic);
    }

    public void lightSpecular(float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.lightSpecular(x, y, z);
        }
        this.g.lightSpecular(x, y, z);
    }

    public void background(int rgb) {
        if (this.recorder != null) {
            this.recorder.background(rgb);
        }
        this.g.background(rgb);
    }

    public void background(int rgb, float alpha) {
        if (this.recorder != null) {
            this.recorder.background(rgb, alpha);
        }
        this.g.background(rgb, alpha);
    }

    public void background(float gray) {
        if (this.recorder != null) {
            this.recorder.background(gray);
        }
        this.g.background(gray);
    }

    public void background(float gray, float alpha) {
        if (this.recorder != null) {
            this.recorder.background(gray, alpha);
        }
        this.g.background(gray, alpha);
    }

    public void background(float x, float y, float z) {
        if (this.recorder != null) {
            this.recorder.background(x, y, z);
        }
        this.g.background(x, y, z);
    }

    public void background(float x, float y, float z, float a) {
        if (this.recorder != null) {
            this.recorder.background(x, y, z, a);
        }
        this.g.background(x, y, z, a);
    }

    public void background(PImage image) {
        if (this.recorder != null) {
            this.recorder.background(image);
        }
        this.g.background(image);
    }

    public final float alpha(int what) {
        return this.g.alpha(what);
    }

    public final float red(int what) {
        return this.g.red(what);
    }

    public final float green(int what) {
        return this.g.green(what);
    }

    public final float blue(int what) {
        return this.g.blue(what);
    }

    public final float hue(int what) {
        return this.g.hue(what);
    }

    public final float saturation(int what) {
        return this.g.saturation(what);
    }

    public final float brightness(int what) {
        return this.g.brightness(what);
    }

    public int lerpColor(int c1, int c2, float amt) {
        return this.g.lerpColor(c1, c2, amt);
    }

    public static int lerpColor(int c1, int c2, float amt, int mode) {
        return PGraphics.lerpColor(c1, c2, amt, mode);
    }

    public void beginRaw(PGraphics rawGraphics) {
        if (this.recorder != null) {
            this.recorder.beginRaw(rawGraphics);
        }
        this.g.beginRaw(rawGraphics);
    }

    public void endRaw() {
        if (this.recorder != null) {
            this.recorder.endRaw();
        }
        this.g.endRaw();
    }

    public boolean displayable() {
        return this.g.displayable();
    }

    public class RegisteredMethods {
        int count;
        Object[] objects;
        Method[] methods;

        public void handle() {
            this.handle(new Object[0]);
        }

        public void handle(Object[] oargs) {
            int i = 0;
            while (i < this.count) {
                try {
                    this.methods[i].invoke(this.objects[i], oargs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }

        public void add(Object object, Method method) {
            if (this.objects == null) {
                this.objects = new Object[5];
                this.methods = new Method[5];
            }
            if (this.count == this.objects.length) {
                Object[] otemp = new Object[this.count << 1];
                System.arraycopy(this.objects, 0, otemp, 0, this.count);
                this.objects = otemp;
                Method[] mtemp = new Method[this.count << 1];
                System.arraycopy(this.methods, 0, mtemp, 0, this.count);
                this.methods = mtemp;
            }
            this.objects[this.count] = object;
            this.methods[this.count] = method;
            ++this.count;
        }
    }

    class Worker {
        private Object value;
        private WorkerVar workerVar;

        protected synchronized Object getValue() {
            return this.value;
        }

        private synchronized void setValue(Object x) {
            this.value = x;
        }

        public Object construct() {
            try {
                int anything = System.in.read();
                if (anything == 115) {
                    PApplet.this.stop();
                    PApplet.this.finished = true;
                }
            }
            catch (IOException e) {
                PApplet.this.finished = true;
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }

        public void interrupt() {
            Thread t = this.workerVar.get();
            if (t != null) {
                t.interrupt();
            }
            this.workerVar.clear();
        }

        public Object get() {
            Thread t;
            while ((t = this.workerVar.get()) != null) {
                try {
                    t.join();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
            return this.getValue();
        }

        public Worker() {
            Runnable doConstruct = new Runnable(this){
                final /* synthetic */ Worker this$1;
                {
                    this.this$1 = worker;
                }

                public void run() {
                    try {
                        Worker.access$1(this.this$1, this.this$1.construct());
                    }
                    finally {
                        Worker.access$0(this.this$1).clear();
                    }
                }
            };
            Thread t = new Thread(doConstruct);
            this.workerVar = new WorkerVar(t);
        }

        public void start() {
            Thread t = this.workerVar.get();
            if (t != null) {
                t.start();
            }
        }

        static /* synthetic */ WorkerVar access$0(Worker worker) {
            return worker.workerVar;
        }

        static /* synthetic */ void access$1(Worker worker, Object object) {
            worker.setValue(object);
        }
    }

    private static class WorkerVar {
        private Thread thread;

        WorkerVar(Thread t) {
            this.thread = t;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

